/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ProjectBuildOrderUtility
implements IWorkbenchWindowActionDelegate {
    public void optimizeProjectBuildOrder() throws CoreException {
        this.restoreDefaultBuildOrder();
        IProject[] oldBuildOrder = ((Workspace)ResourcesPlugin.getWorkspace()).getBuildOrder();
        if (oldBuildOrder.length > 1) {
            Map projectInfoMap = this.buildProjectInfoMap();
            IProject[] buildOrder = this.doReorderProjects(oldBuildOrder, projectInfoMap);
            IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
            description.setBuildOrder(this.buildStringArray(buildOrder));
            ResourcesPlugin.getWorkspace().setDescription(description);
        }
    }

    private void restoreDefaultBuildOrder() throws CoreException {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setBuildOrder(null);
        ResourcesPlugin.getWorkspace().setDescription(description);
    }

    private String[] buildStringArray(IProject[] buildOrder) {
        String[] projectNames = new String[buildOrder.length];
        int i = 0;
        while (i < projectNames.length) {
            projectNames[i] = buildOrder[i].getName();
            ++i;
        }
        return projectNames;
    }

    private IProject[] doReorderProjects(IProject[] oldBuildOrder, Map projectInfoMap) {
        int startingProjectLocation;
        IProject[] buildOrder = new IProject[oldBuildOrder.length];
        System.arraycopy(oldBuildOrder, 0, buildOrder, 0, oldBuildOrder.length);
        int currentProjectLocation = startingProjectLocation = 1;
        while (startingProjectLocation < buildOrder.length) {
            IProject currentProject = buildOrder[currentProjectLocation];
            int previousProjectLocation = currentProjectLocation - 1;
            IProject previousProject = buildOrder[previousProjectLocation];
            while (this.previousProjectHasLowerReferenceCount(projectInfoMap, currentProject, previousProject) && this.canSwapWithPreviousProject(projectInfoMap, currentProject, previousProject)) {
                this.swapProjects(buildOrder, currentProjectLocation, previousProjectLocation);
                currentProjectLocation = previousProjectLocation--;
                if (currentProjectLocation == 0) break;
                previousProject = buildOrder[previousProjectLocation];
            }
            currentProjectLocation = ++startingProjectLocation;
        }
        return buildOrder;
    }

    private void swapProjects(IProject[] buildOrder, int currentProjectLocation, int previousProjectLocation) {
        IProject temp = buildOrder[previousProjectLocation];
        buildOrder[previousProjectLocation] = buildOrder[currentProjectLocation];
        buildOrder[currentProjectLocation] = temp;
    }

    private boolean canSwapWithPreviousProject(Map projectInfoMap, IProject currentProject, IProject previousProject) {
        return this.projectsAreInACycle(projectInfoMap, currentProject, previousProject) || this.currentProjectDoesNotDependOnPreviousProject(projectInfoMap, currentProject, previousProject);
    }

    private boolean previousProjectHasLowerReferenceCount(Map projectInfoMap, IProject currentProject, IProject previousProject) {
        return ((ProjectInfo)projectInfoMap.get(previousProject)).referenceCount <= ((ProjectInfo)projectInfoMap.get(currentProject)).referenceCount;
    }

    private boolean currentProjectDoesNotDependOnPreviousProject(Map projectInfoMap, IProject currentProject, IProject previousProject) {
        return !((ProjectInfo)projectInfoMap.get(currentProject)).referencedProjects.contains(previousProject);
    }

    private boolean projectsAreInACycle(Map projectInfoMap, IProject currentProject, IProject nextProject) {
        return ((ProjectInfo)projectInfoMap.get(nextProject)).referencedProjects.contains(currentProject) && ((ProjectInfo)projectInfoMap.get(currentProject)).referencedProjects.contains(nextProject);
    }

    private Map buildProjectInfoMap() throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashMap<IProject, ProjectInfo> projectInfoMap = new HashMap<IProject, ProjectInfo>();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen()) {
                ProjectInfo projectInfo = (ProjectInfo)projectInfoMap.get(projects[i]);
                if (projectInfo == null) {
                    projectInfo = new ProjectInfo();
                    projectInfoMap.put(projects[i], projectInfo);
                }
                IProject[] requiredProjects = projects[i].getReferencedProjects();
                int j = 0;
                while (j < requiredProjects.length) {
                    projectInfo.referencedProjects.add(requiredProjects[j]);
                    ProjectInfo requiredProjectInfo = (ProjectInfo)projectInfoMap.get(requiredProjects[j]);
                    if (requiredProjectInfo == null) {
                        requiredProjectInfo = new ProjectInfo();
                        projectInfoMap.put(requiredProjects[j], requiredProjectInfo);
                    }
                    ProjectInfo projectInfo2 = requiredProjectInfo;
                    projectInfo2.referenceCount = projectInfo2.referenceCount + 1;
                    ++j;
                }
            }
            ++i;
        }
        return projectInfoMap;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        try {
            this.optimizeProjectBuildOrder();
        }
        catch (CoreException coreException) {
            IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
            description.setBuildOrder(null);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private static class ProjectInfo {
        private int referenceCount = 0;
        private Set referencedProjects = new HashSet();

        private ProjectInfo() {
        }
    }
}

