/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.utils;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.ICompiler;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectSettingsUtility {
    private static final IGenerator[] EMPTY_GENERATORS = new IGenerator[0];
    private static final String[] EMPTY_GENERATOR_IDS = new String[0];
    public static final String PROPERTY_COMPILER_ID = "compilerId";
    public static final String PROPERTY_GENERATOR_IDS = "generatorIds";
    public static final String PROJECT_KEY = "<project>";

    private ProjectSettingsUtility() {
    }

    public static ICompiler getCompiler(IProject project) {
        String id = ProjectSettingsUtility.getCompilerId(project);
        if (id == null) {
            id = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString(PROPERTY_COMPILER_ID);
        }
        if (id != null) {
            ICompiler[] compilers = EDTCoreIDEPlugin.getPlugin().getCompilers();
            int i = 0;
            while (i < compilers.length) {
                if (compilers[i].getId().equals(id)) {
                    return compilers[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static String getCompilerId(IProject project) {
        Preferences prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node(PROPERTY_COMPILER_ID);
        String setting = ProjectSettingsUtility.findSetting(project.getFullPath(), prefs, false);
        if (setting != null && (setting = setting.trim()).length() != 0) {
            return setting;
        }
        return null;
    }

    public static void setCompiler(IProject project, String id) throws BackingStoreException {
        Preferences prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node(PROPERTY_COMPILER_ID);
        if (id == null || id.length() == 0) {
            prefs.remove(ProjectSettingsUtility.keyFor(project.getFullPath()));
        } else {
            prefs.put(ProjectSettingsUtility.keyFor(project.getFullPath()), id);
        }
        prefs.flush();
    }

    public static IGenerator[] getGenerators(IResource resource) {
        IGenerator[] gens;
        String defaultIDs;
        String[] ids = ProjectSettingsUtility.getGeneratorIds(resource);
        if (ids == null && (defaultIDs = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString(PROPERTY_GENERATOR_IDS)) != null && (defaultIDs = defaultIDs.trim()).length() != 0) {
            ids = defaultIDs.split(",");
        }
        if (ids != null && ids.length != 0 && (gens = EDTCoreIDEPlugin.getPlugin().getGenerators()).length > 0) {
            ArrayList<IGenerator> generators = new ArrayList<IGenerator>(ids.length);
            int i = 0;
            while (i < gens.length) {
                String nextId = gens[i].getId();
                int j = 0;
                while (j < ids.length) {
                    if (nextId.equals(ids[j].trim())) {
                        generators.add(gens[i]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return generators.toArray(new IGenerator[generators.size()]);
        }
        return EMPTY_GENERATORS;
    }

    public static String[] getGeneratorIds(IResource resource) {
        IProject project = resource.getProject();
        Preferences prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node(PROPERTY_GENERATOR_IDS);
        String setting = ProjectSettingsUtility.findSetting(resource.getFullPath(), prefs, true);
        if (setting != null) {
            if ((setting = setting.trim()).length() != 0) {
                String[] ids = setting.split(",");
                int i = 0;
                while (i < ids.length) {
                    ids[i] = ids[i].trim();
                    ++i;
                }
                return ids;
            }
            return EMPTY_GENERATOR_IDS;
        }
        return null;
    }

    public static void setGeneratorIds(IResource resource, String[] ids) throws BackingStoreException {
        IProject project = resource.getProject();
        Preferences prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node(PROPERTY_GENERATOR_IDS);
        if (ids == null) {
            prefs.remove(ProjectSettingsUtility.keyFor(resource.getFullPath()));
        } else if (ids.length == 0) {
            prefs.put(ProjectSettingsUtility.keyFor(resource.getFullPath()), "");
        } else {
            StringBuilder buf = new StringBuilder(100);
            int i = 0;
            while (i < ids.length) {
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(ids[i]);
                ++i;
            }
            prefs.put(ProjectSettingsUtility.keyFor(resource.getFullPath()), buf.toString());
        }
        prefs.flush();
    }

    public static String findSetting(IPath path, Preferences prefs, boolean checkParent) {
        String setting = prefs.get(ProjectSettingsUtility.keyFor(path), null);
        if (checkParent && setting == null && path.segmentCount() > 1) {
            setting = ProjectSettingsUtility.findSetting(path.removeLastSegments(1), prefs, checkParent);
        }
        return setting;
    }

    public static String keyFor(IPath fullPath) {
        return fullPath.segmentCount() > 1 ? fullPath.removeFirstSegments(1).toString() : PROJECT_KEY;
    }

    public static IPath findPathForSetting(IPath path, Preferences prefs) {
        String setting = prefs.get(ProjectSettingsUtility.keyFor(path), null);
        if (setting != null) {
            return path;
        }
        if (path.segmentCount() > 1) {
            return ProjectSettingsUtility.findPathForSetting(path.removeLastSegments(1), prefs);
        }
        return null;
    }

    public static String getGenerationDirectory(IResource resource, IPreferenceStore store, IEclipsePreferences prefs, String propertyID, String preferenceID) {
        Preferences propertyPrefs = prefs.node(propertyID);
        String setting = ProjectSettingsUtility.findSetting(resource.getFullPath(), propertyPrefs, true);
        if (setting != null && setting.length() > 0) {
            return setting;
        }
        if (store != null && preferenceID != null && preferenceID.length() > 0) {
            if (setting == null || setting.length() == 0) {
                setting = store.getString(preferenceID);
            }
            if (setting == null || setting.length() == 0) {
                setting = store.getDefaultString(preferenceID);
            }
        }
        return EclipseUtilities.convertToInternalPath(setting);
    }

    public static void setGenerationDirectory(IResource resource, String value, IEclipsePreferences prefs, String propertyID) throws BackingStoreException {
        Preferences propertyPrefs = prefs.node(propertyID);
        if (value == null || value.length() == 0) {
            propertyPrefs.remove(ProjectSettingsUtility.keyFor(resource.getFullPath()));
        } else {
            propertyPrefs.put(ProjectSettingsUtility.keyFor(resource.getFullPath()), value);
        }
        propertyPrefs.flush();
    }
}

