/*******************************************************************************
 * Copyright © 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.ide.ui;

import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * Preference constants used in the EDT UI preference store. Clients should only read the
 * EDT UI preference store using these values. Clients are not allowed to modify the
 * preference store programmatically.
 * <p>
 * This class it is not intended to be instantiated or subclassed by clients.
 * 
 * @noinstantiate This class is not intended to be instantiated by clients.
 * @noextend This class is not intended to be subclassed by clients.
  */
public class EDTUIPreferenceConstants {

	private EDTUIPreferenceConstants() {
	}
	
	/**
	 * Initializes the given preference store with the default values.
	 * 
	 * @param store the preference store to be initialized
	 */
	public static void initializeDefaultValues(IPreferenceStore store) {
	}

	/**
	 * Returns the EDT UI preference store.
	 * 
	 * @return the EDT UI preference store
	 */
	public static IPreferenceStore getPreferenceStore() {
		return EDTUIPlugin.getDefault().getPreferenceStore();
	}
	
	/**
	 * Returns the value for the given key in the given context.
	 * 
	 * @param key The preference key
	 * @param project The current context or <code>null</code> if no context is available and the
	 * workspace setting should be taken. Note that passing <code>null</code> should
	 * be avoided.
	 * @return Returns the current value for the string.
	 * @since 3.1
	 */
	public static String getPreference(String key, IJavaProject project) {
		String val;
		if (project != null) {
			val= new ProjectScope(project.getProject()).getNode(EDTUIPlugin.PLUGIN_ID).get(key, null);
			if (val != null) {
				return val;
			}
		}
		val= new InstanceScope().getNode(EDTUIPlugin.PLUGIN_ID).get(key, null);
		if (val != null) {
			return val;
		}
		return new DefaultScope().getNode(EDTUIPlugin.PLUGIN_ID).get(key, null);
	}
}

