/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.actions.SelectionDispatchAction;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.util.FileProvidingView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;

public class MoveAction
extends SelectionDispatchAction {
    private org.eclipse.edt.ide.ui.internal.packageexplorer.MoveAction oldAction = new org.eclipse.edt.ide.ui.internal.packageexplorer.MoveAction();
    private EGLEditor fEditor;
    private FileProvidingView fileView;

    public MoveAction(IWorkbenchSite site, FileProvidingView fileView) {
        super(site);
        this.fileView = fileView;
        this.setText(UINlsStrings.Move);
    }

    public MoveAction(IWorkbenchSite site) {
        this(site, (FileProvidingView)null);
    }

    public MoveAction(EGLEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
    }

    private static Node[] getNodes(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return null;
        }
        Node[] nodes = new Node[selection.size()];
        Iterator i = selection.iterator();
        int index = 0;
        while (i.hasNext()) {
            Object sel = i.next();
            if (sel instanceof Node) {
                nodes[index] = (Node)sel;
            }
            ++index;
        }
        return nodes;
    }

    private static IEGLElement[] getEGLElements(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return null;
        }
        IEGLElement[] eglFiles = new IEGLElement[selection.size()];
        int index = 0;
        for (Object sel : selection) {
            if (sel instanceof IEGLFile || sel instanceof IClassFile) {
                eglFiles[index] = (IEGLElement)sel;
                ++index;
                continue;
            }
            return null;
        }
        return eglFiles;
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return;
        }
        Node[] nodes = MoveAction.getNodes(selection);
        if (nodes == null) {
            IEGLElement[] eglFiles = MoveAction.getEGLElements(selection);
            if (eglFiles == null) {
                this.oldAction.selectionChanged(selection);
                if (this.oldAction.isEnabled()) {
                    this.oldAction.run();
                }
                return;
            }
            try {
                this.run(eglFiles);
            }
            catch (CoreException e) {
                EGLLogger.log((Object)this, UINlsStrings.TypeSelectionDialog_errorMessage, e);
            }
        } else {
            try {
                this.run(this.getPartNames(nodes), this.getFile());
            }
            catch (CoreException e) {
                EGLLogger.log((Object)this, UINlsStrings.TypeSelectionDialog_errorMessage, e);
            }
        }
    }

    private IFile getFile() {
        if (this.fileView != null) {
            return this.fileView.getFile();
        }
        return null;
    }

    public boolean willLaunchOldDialog(IStructuredSelection selection) {
        return MoveAction.getEGLElements(selection) == null;
    }

    private String[] getPartNames(Node[] nodes) {
        String[] names = new String[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            if (!(nodes[i] instanceof Part)) {
                return null;
            }
            names[i] = ((Part)nodes[i]).getName().getCanonicalName();
            ++i;
        }
        return names;
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        if (selection.size() == 0) {
            this.setEnabled(false);
            return;
        }
        this.oldAction.selectionChanged(selection);
        this.setEnabled(this.canRun(selection) || this.oldAction.isEnabled());
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            PartNameAndFile nodeAndFile = this.getNodeAndFile();
            if (nodeAndFile != null) {
                this.run(new String[]{nodeAndFile.partName}, nodeAndFile.file);
                return;
            }
        }
        catch (CoreException e) {
            EGLLogger.log((Object)this, UINlsStrings.TypeSelectionDialog_errorMessage, e);
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)UINlsStrings.MoveSupport_dialog_title, (String)UINlsStrings.RenameSupport_not_available);
    }

    public boolean canRun() {
        try {
            PartNameAndFile nodeAndFile = this.getNodeAndFile();
            return nodeAndFile != null;
        }
        catch (EGLModelException e) {
            EDTUIPlugin.log(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canRun(IStructuredSelection selection) {
        try {
            Node[] nodes = MoveAction.getNodes(selection);
            if (nodes != null) {
                return MoveAction.isMoveAvailable(nodes);
            }
            Iterator i = selection.iterator();
            boolean foundFile = false;
            while (true) {
                if (!i.hasNext()) {
                    if (selection.size() <= 0) return false;
                    return true;
                }
                Object sel = i.next();
                if (sel instanceof IEGLProject) return false;
                if (sel instanceof IPackageFragmentRoot) return false;
                if (sel instanceof IPackageFragment) {
                    return false;
                }
                if (sel instanceof IEGLFile) {
                    foundFile = true;
                    continue;
                }
                if (!(sel instanceof IEGLElement)) return false;
                if (foundFile) break;
            }
            return false;
        }
        catch (EGLModelException e) {
            EDTUIPlugin.log(e);
            return false;
        }
        catch (CoreException e) {
            EDTUIPlugin.log(e);
        }
        return false;
    }

    private PartNameAndFile getNodeAndFile() throws EGLModelException {
        Node parent;
        ISelection selection = this.fEditor.getSelectionProvider().getSelection();
        int currentPosition = ((ITextSelection)selection).getOffset();
        IEGLDocument document = (IEGLDocument)this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        IFile file = ((IFileEditorInput)this.fEditor.getEditorInput()).getFile();
        Node node = document.getNewModelNodeAtOffset(currentPosition);
        if (node instanceof SimpleName && (parent = node.getParent()) instanceof Part && ((Part)parent).getName() == node) {
            return new PartNameAndFile(((Part)parent).getName().getCanonicalName(), file);
        }
        return null;
    }

    private void run(String[] partNames, IFile file) throws CoreException {
        IEGLFile eglFile = EGLCore.createEGLFileFrom((IFile)file);
        if (eglFile != null && partNames != null) {
            IPart[] parts = new IPart[partNames.length];
            int i = 0;
            while (i < partNames.length) {
                parts[i] = eglFile.getPart(partNames[i]);
                ++i;
            }
        }
    }

    private void run(IEGLElement[] eglFiles) throws CoreException {
    }

    private static boolean isMoveAvailable(Node[] nodes) throws CoreException {
        int i = 0;
        while (i < nodes.length) {
            if (!(nodes[i] instanceof Part)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private class PartNameAndFile {
        String partName;
        IFile file;

        public PartNameAndFile(String partName, IFile file) {
            this.partName = partName;
            this.file = file;
        }
    }
}

