/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.codemanipulation;

import com.ibm.icu.util.StringTokenizer;
import java.util.Comparator;
import org.eclipse.edt.ide.ui.internal.EGLPreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;

public class ImportComparator
implements Comparator {
    String[] order;

    public ImportComparator() {
        IPreferenceStore store = EGLPreferenceConstants.getPreferenceStore();
        String orderString = store.getString("org.eclipse.egl.ui.importorder");
        this.order = ImportComparator.unpackList(orderString, ";");
    }

    public int compare(Object o1, Object o2) {
        int g2;
        String s1 = (String)o1;
        String s2 = (String)o2;
        int g1 = this.getGroupNumber(s1);
        if (g1 == (g2 = this.getGroupNumber(s2))) {
            return s1.compareTo(s2);
        }
        return g1 - g2;
    }

    private int getGroupNumber(String s) {
        int len = this.order.length;
        int grpNum = -1;
        int i = 0;
        while (i < len) {
            if (s.startsWith(this.order[i])) {
                if (grpNum == -1) {
                    grpNum = i;
                } else if (this.order[i].length() > this.order[grpNum].length()) {
                    grpNum = i;
                }
            }
            ++i;
        }
        if (grpNum == -1) {
            grpNum = len;
        }
        return grpNum;
    }

    private static String[] unpackList(String str, String separator) {
        StringTokenizer tok = new StringTokenizer(str, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < nTokens) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }
}

