/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.codemanipulation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.TopLevelFunctionBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AccumulatingSyntaxErrorMessageRequestor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SyntaxError;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.core.lookup.SystemEnvironmentPackageNames;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfoRequestor;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.IPartNameRequestor;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLPreferenceConstants;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.codemanipulation.ImportComparator;
import org.eclipse.edt.ide.ui.internal.codemanipulation.OrganizeImportsVisitor;
import org.eclipse.edt.ide.ui.internal.editor.DocumentAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class OrganizeImportsOperation
implements IWorkspaceRunnable {
    protected IEGLFile feglfile;
    protected IEGLFile workingCopy = null;
    private boolean needSave;
    protected IChooseImportQuery fChooseImportQuery;
    private int fNumberOfImportsAdded;
    private int fNumberOfImportsRemoved;
    private SyntaxErrorHelper fSyntaxError;
    boolean workingCopyCreationInProgress = false;

    public OrganizeImportsOperation(IEGLFile file, boolean needSave, IChooseImportQuery query) {
        this.feglfile = file;
        this.needSave = needSave;
        this.fNumberOfImportsAdded = 0;
        this.fNumberOfImportsRemoved = 0;
        this.fSyntaxError = null;
    }

    public IEGLFile getEGLFileWorkingCopy() {
        if (this.feglfile != null) {
            try {
                if (this.workingCopy == null && !this.workingCopyCreationInProgress) {
                    this.workingCopyCreationInProgress = true;
                    this.workingCopy = (IEGLFile)this.feglfile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
                    this.workingCopyCreationInProgress = false;
                }
                return this.workingCopy;
            }
            catch (EGLModelException e) {
                e.printStackTrace();
                EDTUIPlugin.log(e);
            }
        }
        return null;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        block6: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                IDocument doc;
                this.fNumberOfImportsAdded = 0;
                this.fNumberOfImportsRemoved = 0;
                monitor.beginTask(MessageFormat.format(UINlsStrings.OrganizeImportsOperation_description, this.feglfile.getElementName()), 5);
                this.workingCopy = this.getEGLFileWorkingCopy();
                IBuffer buf = this.workingCopy.getBuffer();
                if (!(buf instanceof DocumentAdapter) || !((doc = ((DocumentAdapter)buf).getDocument()) instanceof IEGLDocument)) break block6;
                IEGLDocument egldoc = (IEGLDocument)doc;
                File fileAST = egldoc.getNewModelEGLFile();
                AccumulatingSyntaxErrorMessageRequestor syntaxErrorRequestor = new AccumulatingSyntaxErrorMessageRequestor();
                fileAST.accept((ISyntaxErrorRequestor)syntaxErrorRequestor);
                Map syntaxErrMsgs = syntaxErrorRequestor.getSyntaxErrors();
                if (syntaxErrMsgs.isEmpty()) {
                    IPackageFragment packageFrag = (IPackageFragment)this.feglfile.getParent();
                    String packageName = packageFrag.getElementName();
                    OrganizedImportSection resolvedTypes = new OrganizedImportSection(packageName);
                    LinkedHashMap unresolvedTypes = new LinkedHashMap();
                    IEGLProject eglProj = this.feglfile.getEGLProject();
                    IProject proj = eglProj.getProject();
                    Set oldImports = this.getExistingImports(fileAST);
                    this.bindFile(proj, packageName, resolvedTypes, unresolvedTypes, oldImports);
                    monitor.worked(2);
                    this.try2ResolveUnresolvedTypes(resolvedTypes, unresolvedTypes, eglProj, oldImports, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
                    this.writeToFile(resolvedTypes, oldImports, egldoc, fileAST, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    break block6;
                }
                Set keys = syntaxErrMsgs.keySet();
                Iterator it = keys.iterator();
                SyntaxError SyntaxErr = (SyntaxError)it.next();
                String errmsg = (String)syntaxErrMsgs.get(SyntaxErr);
                this.fSyntaxError = new SyntaxErrorHelper(SyntaxErr, errmsg);
                return;
            }
            finally {
                if (this.workingCopy != null) {
                    this.workingCopy.destroy();
                }
                monitor.done();
            }
        }
    }

    protected Set getExistingImports(File fileAST) {
        final LinkedHashSet oldImports = new LinkedHashSet();
        fileAST.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(File file) {
                return true;
            }

            public boolean visit(ImportDeclaration importDeclaration) {
                oldImports.add(importDeclaration);
                return false;
            }
        });
        return oldImports;
    }

    protected void try2ResolveUnresolvedTypes(OrganizedImportSection resolvedTypes, Map unresolvedTypes, IEGLProject eglProj, Set oldImports, IProgressMonitor monitor) throws EGLModelException, OperationCanceledException {
        try {
            Hashtable mapOpenChoices = new Hashtable();
            Set Keys = unresolvedTypes.keySet();
            Iterator unresolvedIt = Keys.iterator();
            IEGLSearchScope projScope = SearchEngine.createEGLSearchScope((IEGLElement[])new IEGLElement[]{eglProj}, (boolean)true);
            while (unresolvedIt.hasNext()) {
                String unresolvedTypeName = (String)unresolvedIt.next();
                ArrayList typeList = new ArrayList();
                new SearchEngine().searchAllPartNames(ResourcesPlugin.getWorkspace(), null, unresolvedTypeName.toCharArray(), 0, false, Short.MAX_VALUE, projScope, (IPartNameRequestor)new PartInfoRequestor(typeList), 3, monitor);
                this.removeTypesInDefaultPackage(typeList);
                this.addSystemTypes(typeList, unresolvedTypeName);
                int foundCnts = typeList.size();
                if (foundCnts == 1) {
                    String packageName = "";
                    String partName = "";
                    Object listElem = typeList.get(0);
                    if (listElem instanceof PartInfo) {
                        PartInfo foundPart = (PartInfo)listElem;
                        packageName = foundPart.getPackageName();
                        partName = foundPart.getPartName();
                    }
                    resolvedTypes.addImport(packageName, partName);
                    continue;
                }
                if (foundCnts <= 1) continue;
                Name unresolvedTypeNameNode = (Name)unresolvedTypes.get(unresolvedTypeName);
                mapOpenChoices.put(unresolvedTypeNameNode, typeList);
            }
            if (!mapOpenChoices.isEmpty() && this.fChooseImportQuery != null) {
                PartInfo[] result = this.fChooseImportQuery.chooseImports(mapOpenChoices);
                if (result == null) {
                    throw new OperationCanceledException();
                }
                int i = 0;
                while (i < result.length) {
                    resolvedTypes.addImport(result[i].getPackageName(), result[i].getPartName());
                    ++i;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void addSystemTypes(List typeList, String unresolvedTypeName) {
        IPartBinding sysPartBinding = SystemEnvironment.getInstance().getPartBinding(null, unresolvedTypeName);
        if (sysPartBinding != null && sysPartBinding != IBinding.NOT_FOUND_BINDING) {
            String[] pkgName = sysPartBinding.getPackageName();
            IPath pkgPath = Util.stringArrayToPath((String[])pkgName);
            String packageName = pkgPath.toString().replace('/', '.');
            String partName = sysPartBinding.getName();
            typeList.add(new SystemPartInfo(packageName, partName));
        }
    }

    private void removeTypesInDefaultPackage(List typeList) {
        Iterator iter = typeList.iterator();
        while (iter.hasNext()) {
            PartInfo pInfo = (PartInfo)iter.next();
            if (pInfo.getPackageName().length() != 0) continue;
            iter.remove();
        }
    }

    private void bindFile(IProject proj, String currPackageName, final OrganizedImportSection resolvedTypes, final Map unresolvedTypes, final Set oldImports) throws EGLModelException {
        IWorkingCopy[] currRegedWCs = EGLCore.getSharedWorkingCopies((IBufferFactory)EGLUI.getBufferFactory());
        IFile file = (IFile)this.feglfile.getCorrespondingResource();
        Path pkgPath = new Path(currPackageName.replace('.', '/'));
        String[] pkgName = Util.pathToStringArray((IPath)pkgPath);
        WorkingCopyCompiler.getInstance().compileAllParts(proj, pkgName, file, currRegedWCs, new IWorkingCopyCompileRequestor(){

            public void acceptResult(WorkingCopyCompilationResult result) {
                Node boundnode = result.getBoundPart();
                if (boundnode instanceof Part) {
                    Part boundPart = (Part)boundnode;
                    IPartBinding boundPartBinding = result.getPartBinding();
                    Boolean isIncludeRefFunc = this.isIncludeReferenceFunction((IBinding)boundPartBinding);
                    Boolean topFuncUseContainerContext = this.isUseContainerContextDependent((IBinding)boundPartBinding);
                    OrganizeImportsVisitor visitor = new OrganizeImportsVisitor(resolvedTypes, unresolvedTypes, oldImports, isIncludeRefFunc);
                    visitor.setCurrentPartName(boundPart.getName());
                    if (topFuncUseContainerContext == null || topFuncUseContainerContext == Boolean.NO) {
                        boundPart.accept((IASTVisitor)visitor);
                    }
                    if (isIncludeRefFunc == Boolean.YES) {
                        TopLevelFunction[] topBoundFuncs = result.getBoundFunctions();
                        int i = 0;
                        while (i < topBoundFuncs.length) {
                            TopLevelFunctionBinding topFuncBinding;
                            Boolean topFuncUseContainerConext1;
                            IBinding funcBinding = topBoundFuncs[i].getName().resolveBinding();
                            if (funcBinding instanceof TopLevelFunctionBinding && (topFuncUseContainerConext1 = this.isUseContainerContextDependent((IBinding)(topFuncBinding = (TopLevelFunctionBinding)funcBinding))) == Boolean.YES) {
                                topBoundFuncs[i].accept((IASTVisitor)visitor);
                            }
                            ++i;
                        }
                    }
                }
            }

            private Boolean isUseContainerContextDependent(IBinding binding) {
                Boolean topFuncUseContainerContext = null;
                IAnnotationBinding containerContextAnnotationBinding = binding.getAnnotation(SystemEnvironmentPackageNames.EGL_CORE, "containerContextDependent");
                topFuncUseContainerContext = containerContextAnnotationBinding != null ? (Boolean)containerContextAnnotationBinding.getValue() : Boolean.NO;
                return topFuncUseContainerContext;
            }

            private Boolean isIncludeReferenceFunction(IBinding binding) {
                Boolean isIncludeRefFunc = null;
                IAnnotationBinding inclRefFuncAnnotationBinding = binding.getAnnotation(SystemEnvironmentPackageNames.EGL_CORE, "includeReferencedFunctions");
                isIncludeRefFunc = inclRefFuncAnnotationBinding != null ? (Boolean)inclRefFuncAnnotationBinding.getValue() : Boolean.NO;
                return isIncludeRefFunc;
            }
        });
    }

    protected void writeToFile(OrganizedImportSection resolvedTypes, Set oldImports, IEGLDocument egldoc, File fileAST, IProgressMonitor monitor) {
        ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
        this.writeToFile(resolvedTypes, oldImports, egldoc, rewrite, fileAST, monitor);
    }

    protected void writeToFile(OrganizedImportSection resolvedTypes, Set oldImports, IEGLDocument egldoc, ASTRewrite rewrite, File fileAST, final IProgressMonitor monitor) {
        try {
            Iterator itOld = oldImports.iterator();
            int firstImportStartOffset = Integer.MAX_VALUE;
            int lastImportEndOffset = 0;
            while (itOld.hasNext()) {
                ImportDeclaration oldImportDecl = (ImportDeclaration)itOld.next();
                int offset = oldImportDecl.getOffset();
                firstImportStartOffset = Math.min(offset, firstImportStartOffset);
                lastImportEndOffset = Math.max(offset + oldImportDecl.getLength(), lastImportEndOffset);
            }
            StringBuffer newImportsSB = new StringBuffer();
            Set newImports = oldImports.isEmpty() ? resolvedTypes.addImportsToASTRewrite(rewrite, fileAST) : resolvedTypes.addImportsToStringBuffer(newImportsSB, fileAST);
            if (!this.determineImportDifferences(oldImports, newImports)) {
                TextEdit astRewriteEdit = rewrite.rewriteAST((IDocument)egldoc);
                MultiTextEdit compositeEdit = new MultiTextEdit();
                compositeEdit.addChild(astRewriteEdit);
                if (!oldImports.isEmpty()) {
                    compositeEdit.addChild((TextEdit)new ReplaceEdit(firstImportStartOffset, lastImportEndOffset - firstImportStartOffset, newImportsSB.toString().trim()));
                }
                compositeEdit.apply((IDocument)egldoc);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Action saveAction = new Action(){

                            public void run() {
                                try {
                                    if (OrganizeImportsOperation.this.needSave) {
                                        (this).OrganizeImportsOperation.this.workingCopy.commit(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    }
                                }
                                catch (EGLModelException e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        saveAction.run();
                    }
                });
            }
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private boolean determineImportDifferences(Set oldImports, Set newImports) {
        int newCnts;
        boolean isSame = true;
        int oldCnts = oldImports.size();
        if (oldCnts != (newCnts = newImports.size())) {
            isSame = false;
        }
        Iterator itOld = oldImports.iterator();
        Iterator itNew = newImports.iterator();
        while (itOld.hasNext()) {
            String newImportName;
            ImportDeclaration oldImport = (ImportDeclaration)itOld.next();
            String oldImportName = oldImport.getName().getCanonicalString();
            if (oldImport.isOnDemand()) {
                if (oldImportName.length() > 0) {
                    oldImportName = String.valueOf(oldImportName) + '.';
                }
                oldImportName = String.valueOf(oldImportName) + '*';
            }
            if (itNew.hasNext() && isSame && !(newImportName = (String)itNew.next()).equals(oldImportName)) {
                isSame = false;
            }
            if (!newImports.contains(oldImportName)) continue;
            --newCnts;
            --oldCnts;
        }
        this.fNumberOfImportsAdded = newCnts;
        this.fNumberOfImportsRemoved = oldCnts;
        return isSame;
    }

    public int getNumberOfImportsAdded() {
        return this.fNumberOfImportsAdded;
    }

    public int getNumberOfImportsRemoved() {
        return this.fNumberOfImportsRemoved;
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public SyntaxErrorHelper getSyntaxError() {
        return this.fSyntaxError;
    }

    public static interface IChooseImportQuery {
        public PartInfo[] chooseImports(Map var1);
    }

    public static class OrganizedImportSection {
        private final Map imports = new TreeMap(new ImportComparator());
        private final Map ignoredImports = new TreeMap(new ImportComparator());
        private String fCurrentPackageName;

        public OrganizedImportSection(String currentPackageName) {
            this.fCurrentPackageName = currentPackageName;
        }

        private static void addImport(String packageName, String partName, String currentPackageName, Map imports) {
            TreeSet<String> parts = null;
            if (!currentPackageName.equals(packageName)) {
                Object obj = imports.get(packageName);
                if (obj != null) {
                    parts = (TreeSet<String>)obj;
                } else {
                    parts = new TreeSet<String>();
                    imports.put(packageName, parts);
                }
                if (!parts.contains("*")) {
                    parts.add(partName);
                }
            }
        }

        public void addImport(String packageName, String partName) {
            Set partsToIgnore = (Set)this.ignoredImports.get(packageName);
            if (partsToIgnore == null || !partsToIgnore.contains("*") && !partsToIgnore.contains(partName)) {
                OrganizedImportSection.addImport(packageName, partName, this.fCurrentPackageName, this.imports);
            }
        }

        public void ignoreImport(String packageName, String partName) {
            OrganizedImportSection.addImport(packageName, partName, this.fCurrentPackageName, this.ignoredImports);
        }

        public boolean isConflict(String packageName, String partName, String[] conflictPkgName) {
            boolean isConflict = false;
            Set keySet = this.imports.keySet();
            Iterator itKeys = keySet.iterator();
            while (itKeys.hasNext() && !isConflict) {
                Set parts;
                String existingPkgName = (String)itKeys.next();
                if (existingPkgName.equals(packageName) || !(parts = (Set)this.imports.get(existingPkgName)).contains(partName)) continue;
                isConflict = true;
                conflictPkgName[0] = existingPkgName;
            }
            return isConflict;
        }

        public Set addImportsToASTRewrite(final ASTRewrite rewrite, File fileAST) {
            return this.addImportsToImportCollector(new ImportCollector(){

                @Override
                public void addImport(File fileAST, String onDemandPkgName, boolean isOnDemand, ImportComparator comparator) {
                    rewrite.addImport(fileAST, onDemandPkgName, isOnDemand, (Comparator)comparator);
                }
            }, fileAST);
        }

        public Set addImportsToStringBuffer(final StringBuffer sb, File fileAST) {
            return this.addImportsToImportCollector(new ImportCollector(){

                @Override
                public void addImport(File fileAST, String onDemandPkgName, boolean isOnDemand, ImportComparator comparator) {
                    sb.append("import");
                    sb.append(" ");
                    sb.append(onDemandPkgName);
                    if (isOnDemand) {
                        sb.append(".*");
                    }
                    sb.append(";");
                    sb.append(System.getProperty("line.separator"));
                }
            }, fileAST);
        }

        private Set addImportsToImportCollector(ImportCollector collector, File fileAST) {
            LinkedHashSet<String> newImports = new LinkedHashSet<String>();
            IPreferenceStore store = EGLPreferenceConstants.getPreferenceStore();
            int onDemandThreshold = store.getInt("org.eclipse.egl.ui.ondemandthreshold");
            Set packages = this.imports.keySet();
            for (String packageName : packages) {
                Object obj = this.imports.get(packageName);
                if (obj == null) continue;
                Set parts = (Set)obj;
                int partCnts = parts.size();
                if (partCnts >= onDemandThreshold && packageName.length() != 0) {
                    String onDemandPkgName = packageName;
                    collector.addImport(fileAST, onDemandPkgName, true, new ImportComparator());
                    onDemandPkgName = this.getFullImportName(onDemandPkgName, "*");
                    newImports.add(onDemandPkgName);
                    continue;
                }
                Iterator itparts = parts.iterator();
                while (itparts.hasNext()) {
                    String importEntry = packageName;
                    String partEntry = (String)itparts.next();
                    if (partEntry.equals("*")) {
                        collector.addImport(fileAST, importEntry, true, new ImportComparator());
                        importEntry = this.getFullImportName(importEntry, partEntry);
                    } else {
                        importEntry = this.getFullImportName(importEntry, partEntry);
                        collector.addImport(fileAST, importEntry, false, new ImportComparator());
                    }
                    newImports.add(importEntry);
                }
            }
            return newImports;
        }

        private String getFullImportName(String pkgName, String partName) {
            String importEntry = pkgName;
            if (importEntry.length() > 0) {
                importEntry = String.valueOf(importEntry) + '.';
            }
            importEntry = String.valueOf(importEntry) + partName;
            return importEntry;
        }

        private static interface ImportCollector {
            public void addImport(File var1, String var2, boolean var3, ImportComparator var4);
        }
    }

    public static class SyntaxErrorHelper {
        public SyntaxError fSynErr;
        public String fErrMsg;

        public SyntaxErrorHelper(SyntaxError synErr, String errMsg) {
            this.fSynErr = synErr;
            this.fErrMsg = errMsg;
        }
    }

    private static class SystemPartInfo
    extends PartInfo {
        public SystemPartInfo(String pkg, String name) {
            super(pkg, name, (char[][])new char[0][]);
        }

        public int getElementType() {
            return 1;
        }

        public String getPath() {
            return "";
        }

        public IPath getPackageFragmentRootPath() {
            return new Path("");
        }

        protected IEGLElement getEGLElement(IEGLSearchScope scope) {
            return null;
        }

        public char getPartType() {
            return '\u0000';
        }
    }
}

