/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.edt.ide.ui.internal.editor.IAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class EGLMarkerAnnotation
extends MarkerAnnotation
implements IAnnotation {
    public static final String ERROR_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.error";
    public static final String WARNING_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.warning";
    private IAnnotation fOverlay;

    public EGLMarkerAnnotation(IMarker marker) {
        super(marker);
    }

    protected void initialize() {
        this.getMarker();
        super.initialize();
    }

    @Override
    public Integer getProblemKind() {
        this.getMarker();
        return 0;
    }

    public void setOverlay(IAnnotation eglAnnotation) {
        if (this.fOverlay != null) {
            this.fOverlay.removeOverlaid(this);
        }
        this.fOverlay = eglAnnotation;
        if (!this.isMarkedDeleted()) {
            this.markDeleted(this.fOverlay != null);
        }
        if (this.fOverlay != null) {
            this.fOverlay.addOverlaid(this);
        }
    }

    @Override
    public void addOverlaid(IAnnotation annotation) {
    }

    @Override
    public Iterator getOverlaidIterator() {
        return null;
    }

    @Override
    public IAnnotation getOverlay() {
        return this.fOverlay;
    }

    @Override
    public boolean hasOverlay() {
        return this.fOverlay != null;
    }

    @Override
    public void removeOverlaid(IAnnotation annotation) {
    }

    @Override
    public boolean isProblem() {
        IMarker marker = this.getMarker();
        if (MarkerUtilities.isMarkerType((IMarker)marker, (String)"org.eclipse.core.resources.problemmarker")) {
            switch (MarkerUtilities.getSeverity((IMarker)marker)) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isEGLMarkerAnnotation() {
        return true;
    }
}

