/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.ResourceBundle;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class FoldingActionGroup
extends ActionGroup {
    private ProjectionViewer fViewer;
    private PreferenceAction fToggle;
    private TextOperationAction fExpand;
    private TextOperationAction fCollapse;
    private TextOperationAction fExpandAll;
    private IProjectionListener fProjectionListener;

    public FoldingActionGroup(final ITextEditor editor, ITextViewer viewer) {
        if (viewer instanceof ProjectionViewer) {
            this.fViewer = (ProjectionViewer)viewer;
            this.fProjectionListener = new IProjectionListener(){

                public void projectionEnabled() {
                    FoldingActionGroup.this.update();
                }

                public void projectionDisabled() {
                    FoldingActionGroup.this.update();
                }
            };
            this.fViewer.addProjectionListener(this.fProjectionListener);
            this.fToggle = new PreferenceAction(UINlsStrings.getResourceBundleForConstructedKeys(), "Projection.Toggle.", 2){

                public void run() {
                    IPreferenceStore store;
                    boolean current = (store = EDTUIPlugin.getDefault().getPreferenceStore()).getBoolean("editor_folding_enabled");
                    store.setValue("editor_folding_enabled", !current);
                }

                @Override
                public void update() {
                    ITextOperationTarget target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
                    boolean isEnabled = target != null && target.canDoOperation(19);
                    this.setEnabled(isEnabled);
                }
            };
            this.fToggle.setChecked(true);
            this.fToggle.setActionDefinitionId("org.eclipse.ui.edit.text.folding.toggle");
            editor.setAction("FoldingToggle", (IAction)this.fToggle);
            this.fExpandAll = new TextOperationAction(UINlsStrings.getResourceBundleForConstructedKeys(), "Projection.ExpandAll.", editor, 20, true);
            this.fExpandAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand_all");
            editor.setAction("FoldingExpandAll", (IAction)this.fExpandAll);
            this.fExpand = new TextOperationAction(UINlsStrings.getResourceBundleForConstructedKeys(), "Projection.Expand.", editor, 17, true);
            this.fExpand.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand");
            editor.setAction("FoldingExpand", (IAction)this.fExpand);
            this.fCollapse = new TextOperationAction(UINlsStrings.getResourceBundleForConstructedKeys(), "Projection.Collapse.", editor, 18, true);
            this.fCollapse.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse");
            editor.setAction("FoldingCollapse", (IAction)this.fCollapse);
        }
    }

    private boolean isEnabled() {
        return this.fViewer != null;
    }

    public void dispose() {
        if (this.isEnabled()) {
            this.fViewer.removeProjectionListener(this.fProjectionListener);
            this.fViewer = null;
        }
        super.dispose();
    }

    protected void update() {
        if (this.isEnabled()) {
            this.fToggle.update();
            this.fToggle.setChecked(this.fViewer.getProjectionAnnotationModel() != null);
            this.fExpand.update();
            this.fExpandAll.update();
            this.fCollapse.update();
        }
    }

    public void updateActionBars() {
        this.update();
    }

    private class PreferenceAction
    extends ResourceAction
    implements IUpdate {
        PreferenceAction(ResourceBundle bundle, String prefix, int style) {
            super(bundle, prefix, style);
        }

        public void update() {
            this.setEnabled(FoldingActionGroup.this.isEnabled() && FoldingActionGroup.this.fViewer.isProjectionMode());
        }
    }
}

