/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting.ui;

import java.net.URL;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.ui.internal.formatting.CodeFormatterConstants;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Category;
import org.eclipse.edt.ide.ui.internal.formatting.profile.ComboControl;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Control;
import org.eclipse.edt.ide.ui.internal.formatting.profile.DefaultProfile;
import org.eclipse.edt.ide.ui.internal.formatting.profile.EGLFormatProfileRoot;
import org.eclipse.edt.ide.ui.internal.formatting.profile.FormatProfiles;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Group;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Preference;
import org.eclipse.edt.ide.ui.internal.formatting.profile.ProfileFactory;
import org.eclipse.edt.ide.ui.internal.formatting.profile.ProfilePackage;
import org.eclipse.edt.ide.ui.internal.formatting.profile.RadioControl;
import org.eclipse.edt.ide.ui.internal.formatting.profile.ReferenceControl;
import org.eclipse.edt.ide.ui.internal.formatting.profile.util.ProfileResourceFactoryImpl;
import org.eclipse.edt.ide.ui.internal.formatting.ui.FormatProfileRootHelper;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class GenConstructedFormattingMessagesNLS {
    private static final char WHITESPACE = ' ';
    private static final char UNDERSCORE = '_';

    public static void main(String[] args) {
        GenConstructedFormattingMessagesNLS genNLSMsgs = new GenConstructedFormattingMessagesNLS();
        URL classUrl = genNLSMsgs.getClass().getResource("/org/eclipse/edt/ide/ui/internal/formatting/ui/GenConstructedFormattingMessagesNLS.class");
        if (classUrl != null && classUrl.getProtocol().equals("file")) {
            String initializerPath = classUrl.getFile();
            Path path = new Path(initializerPath);
            String[] segs = path.segments();
            int i = segs.length - 1;
            while (i >= 0) {
                path = path.removeLastSegments(1);
                if (segs[i].equals("org.eclipse.edt.ide.ui")) break;
                --i;
            }
            path = path.append("org.eclipse.edt.ide.ui");
            path = path.append("builtInPreference/format_builtin.profile");
            genNLSMsgs.readFromBuiltInProfile((IPath)path);
        }
    }

    private void registerEMF() {
        EPackage.Registry.INSTANCE.put((Object)"http://www.ibm.com/xmlns/egl/formatting/1.0", (Object)new EPackage.Descriptor(){

            public EFactory getEFactory() {
                return ProfileFactory.eINSTANCE;
            }

            public EPackage getEPackage() {
                return ProfilePackage.eINSTANCE;
            }
        });
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("profile", new ProfileResourceFactoryImpl());
    }

    public void readFromBuiltInProfile(IPath buildInPath) {
        this.registerEMF();
        EGLFormatProfileRoot root = FormatProfileRootHelper.getEGLFormatProfileModel(buildInPath);
        final boolean[] emfModelChanged = new boolean[1];
        root.eResource().eAdapters().add((Object)new Adapter(){

            public void notifyChanged(Notification notification) {
                emfModelChanged[0] = true;
            }

            public Notifier getTarget() {
                return null;
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }

            public void setTarget(Notifier newTarget) {
            }
        });
        FormatProfiles formatProfiles = root.getFormatProfiles();
        DefaultProfile defaultProfile = formatProfiles.getDefaultProfile();
        if (defaultProfile != null) {
            TreeMap nlsMap = new TreeMap();
            EList categories = defaultProfile.getCategory();
            for (Category category : categories) {
                String categoryDisplay = category.getDisplay();
                String categoryID = category.getId();
                String nlsKeyInProfile = this.populateNLSMap(nlsMap, categoryID, categoryDisplay, ".");
                if (nlsKeyInProfile.length() > 0) {
                    category.setDisplay(nlsKeyInProfile);
                }
                EList groups = category.getGroup();
                for (Group grp : groups) {
                    nlsKeyInProfile = this.populateNLSMap(nlsMap, categoryID, grp.getDisplay(), ".");
                    if (nlsKeyInProfile.length() > 0) {
                        grp.setDisplay(nlsKeyInProfile);
                    }
                    EList prefs = grp.getPref();
                    for (Preference pref : prefs) {
                        String choices;
                        Control control;
                        String prefSettingID = CodeFormatterConstants.getPreferenceSettingKey(categoryID, pref.getId());
                        nlsKeyInProfile = this.populateNLSMap(nlsMap, prefSettingID, pref.getDisplay(), ".");
                        if (nlsKeyInProfile.length() > 0) {
                            pref.setDisplay(nlsKeyInProfile);
                        }
                        if ((nlsKeyInProfile = this.populateNLSMap(nlsMap, prefSettingID, pref.getAltDisplay(), ".")).length() > 0) {
                            pref.setAltDisplay(nlsKeyInProfile);
                        }
                        Control controlInstance = control = pref.getControl();
                        if (control instanceof ReferenceControl) {
                            ReferenceControl refControl = (ReferenceControl)control;
                            controlInstance = FormatProfileRootHelper.getReferencedControl(defaultProfile, refControl);
                        }
                        if (controlInstance instanceof ComboControl) {
                            ComboControl comboControl = (ComboControl)controlInstance;
                            choices = comboControl.getChoices();
                            nlsKeyInProfile = this.populateNLSMap(nlsMap, prefSettingID, choices, ",");
                            if (nlsKeyInProfile.length() <= 0) continue;
                            comboControl.setChoices(nlsKeyInProfile);
                            continue;
                        }
                        if (!(controlInstance instanceof RadioControl)) continue;
                        RadioControl radioControl = (RadioControl)controlInstance;
                        choices = radioControl.getChoices();
                        nlsKeyInProfile = this.populateNLSMap(nlsMap, prefSettingID, choices, ",");
                        radioControl.setChoices(nlsKeyInProfile);
                    }
                }
            }
            System.out.println();
            System.out.println("========the following goes into the .properties file===============");
            for (String key : nlsMap.keySet()) {
                String value = (String)nlsMap.get(key);
                System.out.print(key);
                System.out.print(" = ");
                System.out.println(value);
            }
            if (emfModelChanged[0]) {
                FormatProfileRootHelper.saveEGLFormatProfile(buildInPath, root);
            }
        }
    }

    private String populateNLSMap(SortedMap nlsMap, String settingId, String displayAttributeValue, String deilimiter) {
        StringBuffer nlsKeyInProfile = new StringBuffer();
        if (displayAttributeValue != null && displayAttributeValue.length() > 0) {
            String[] displays = FormatProfileRootHelper.parseTokenizedString(displayAttributeValue, deilimiter);
            int i = 0;
            while (i < displays.length) {
                String display = displays[i];
                if (display.trim().length() > 0) {
                    String nlsKey = display;
                    if (!display.startsWith("%")) {
                        nlsKey = display.replace(' ', '_');
                        StringBuffer strNLSKey = new StringBuffer();
                        int j = 0;
                        while (j < nlsKey.length()) {
                            char c = nlsKey.charAt(j);
                            if (j == 0 && '0' <= c && c <= '9') {
                                System.out.println("**********ERROR********");
                                System.out.println("setting id [" + settingId + "]: display name - [" + display + "] starts with a number!!!");
                                System.out.println("***********************");
                            } else if (c == '_' || '0' <= c && c <= '9' || 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                                strNLSKey.append(c);
                            }
                            ++j;
                        }
                        nlsKey = strNLSKey.toString();
                        if (nlsMap.containsKey(nlsKey)) {
                            String displayInMap = (String)nlsMap.get(nlsKey);
                            if (!displayInMap.equals(display)) {
                                System.out.println("**********ERROR********");
                                System.out.println("setting id [" + settingId + "]: display key - [" + nlsKey + "] existed with - [" + displayInMap + "]");
                                System.out.println("but same key now has another value - [" + display + "]");
                                System.out.println("***********************");
                            }
                        } else {
                            nlsMap.put(nlsKey, display);
                        }
                        nlsKey = "%" + nlsKey;
                    }
                    if (i > 0) {
                        nlsKeyInProfile.append(deilimiter);
                    }
                    nlsKeyInProfile.append(nlsKey);
                }
                ++i;
            }
        }
        return nlsKeyInProfile.toString();
    }
}

