/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class FoldingHandler
extends AbstractHandler
implements IHandler {
    protected IStructuredSelection fSelection;
    protected IWorkbenchSite fSite;
    protected EGLEditor fEditor;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof EGLEditor) {
            IEditorInput editorInput;
            this.fEditor = (EGLEditor)editor;
            if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
                IFile resource = ((IFileEditorInput)editorInput).getFile();
                IEGLElement element = EGLCore.create((IResource)resource);
                this.fSite = editor.getSite();
                this.fSelection = new StructuredSelection((Object)element);
            }
        }
        if (this.fSelection != null) {
            this.run();
        }
        return null;
    }

    public void run() {
        IPreferenceStore store = EDTUIPlugin.getDefault().getPreferenceStore();
        boolean current = store.getBoolean("editor_folding_enabled");
        if (!current) {
            store.setValue("editor_folding_enabled", !current);
        }
        this.addFoldingRegions();
    }

    private void addFoldingRegions() {
        try {
            ProjectionAnnotationModel model = (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
            if (model == null) {
                return;
            }
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            IEGLDocument doc = (IEGLDocument)provider.getDocument((Object)this.fEditor.getEditorInput());
            ISelection sel = this.fEditor.getSelectionProvider().getSelection();
            if (sel instanceof ITextSelection) {
                ITextSelection selText = (ITextSelection)sel;
                int startLine = selText.getStartLine();
                int endLine = selText.getEndLine();
                if (endLine - startLine >= 1) {
                    int start = doc.getLineOffset(startLine);
                    int end = doc.getLineOffset(endLine) + doc.getLineLength(endLine);
                    Position position = new Position(start, end - start);
                    if (!doc.containsPositionCategory("EGL.FOLD.CUSTOM")) {
                        doc.addPositionCategory("EGL.FOLD.CUSTOM");
                    }
                    if (!doc.containsPosition("EGL.FOLD.CUSTOM", position.offset, position.length)) {
                        doc.addPosition("EGL.FOLD.CUSTOM", position);
                        model.modifyAnnotationPosition((Annotation)new ProjectionAnnotation(true), position);
                    } else {
                        Iterator it = model.getAnnotationIterator();
                        while (it.hasNext()) {
                            ProjectionAnnotation annot;
                            Position pos;
                            Object obj = it.next();
                            if (!(obj instanceof ProjectionAnnotation) || !(pos = model.getPosition((Annotation)(annot = (ProjectionAnnotation)obj))).equals((Object)position)) continue;
                            model.collapse((Annotation)annot);
                        }
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (BadPositionCategoryException e) {
            e.printStackTrace();
        }
    }
}

