/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IRegion;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.CodeFormatterUtil;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.actions.WorkbenchRunnableAdapter;
import org.eclipse.edt.ide.ui.internal.codemanipulation.OrganizeImportsOperation;
import org.eclipse.edt.ide.ui.internal.dialogs.OptionalMessageDialog;
import org.eclipse.edt.ide.ui.internal.dialogs.ProblemDialog;
import org.eclipse.edt.ide.ui.internal.editor.DocumentAdapter;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.formatting.FormattingStrategy;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ProfileManager;
import org.eclipse.edt.ide.ui.internal.util.EditorUtility;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.ITextEditor;

public class FormattingHandler
extends AbstractHandler
implements IHandler {
    protected IStructuredSelection fSelection;
    protected IWorkbenchSite fSite;
    protected EGLEditor fEditor;
    private HashMap fileNeedsSave = new HashMap();
    private DocumentRewriteSession fRewriteSession;
    private IRegion fPartialRegion = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor;
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            this.fSite = HandlerUtil.getActiveSite((ExecutionEvent)event);
        }
        if ((editor = HandlerUtil.getActiveEditor((ExecutionEvent)event)) instanceof EGLEditor) {
            IEditorInput editorInput;
            this.fEditor = (EGLEditor)editor;
            if (this.fSelection == null && editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
                IFile resource = ((IFileEditorInput)editorInput).getFile();
                IEGLElement element = EGLCore.create((IResource)resource);
                this.fSite = editor.getSite();
                this.fSelection = new StructuredSelection((Object)element);
            }
        }
        if (this.fSelection != null) {
            int returnCode;
            List eglFiles = this.getEGLFiles(this.fSelection);
            int selCnt = eglFiles.size();
            if (selCnt == 0) {
                return null;
            }
            if (selCnt > 1 && this.fSite != null && (returnCode = OptionalMessageDialog.open("EGLFormat", this.fSite.getShell(), UINlsStrings.FormatTitle, null, UINlsStrings.UndoNotSupportedMsg, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0)) != 1025 && returnCode != 0) {
                return null;
            }
            if (selCnt > 1) {
                this.runOnMultiple(eglFiles, null);
            } else {
                this.runOnSingle((IEGLFile)eglFiles.get(0));
            }
        }
        return null;
    }

    private List getEGLFiles(IStructuredSelection selection) {
        ArrayList result = new ArrayList();
        if (selection != null) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                try {
                    Object element = it.next();
                    if (element instanceof IEGLElement) {
                        IEGLElement eglElem = (IEGLElement)element;
                        this.getEGLElements(eglElem, result);
                        continue;
                    }
                    if (element instanceof IProject) {
                        IEGLProject eglproj = EGLCore.create((IProject)((IProject)element));
                        this.getEGLElements((IEGLElement)eglproj, result);
                        continue;
                    }
                    if (!(element instanceof IResource)) continue;
                    IEGLElement eglResourceElem = EGLCore.create((IResource)((IResource)element));
                    this.getEGLElements(eglResourceElem, result);
                }
                catch (EGLModelException e) {
                    EDTUIPlugin.log(e);
                }
            }
        }
        return result;
    }

    private void runOnMultiple(final List eglfiles, final String formatProfileName) {
        String message = UINlsStrings.FormatComplete;
        final MultiStatus status = new MultiStatus("org.eclipse.edt.ide.ui", 0, message, null);
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            if (eglfiles.size() == 1) {
                Object eglFile = eglfiles.get(0);
                EditorUtility.openInEditor(eglFile);
                this.fileNeedsSave.put(eglFile, EditorUtility.isOpenInEditor(eglFile));
            }
            progressService.run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    FormattingHandler.this.doRunOnMultiple(eglfiles, formatProfileName, status, monitor);
                }
            }));
            if (!status.isOK() && this.fSite != null) {
                String title = UINlsStrings.EGLFormatting;
                ProblemDialog.open(this.fSite.getShell(), title, null, (IStatus)status);
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    private void doRunOnMultiple(List eglfiles, String formatProfileName, MultiStatus status, IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(UINlsStrings.FormattingProgress);
        int size = eglfiles.size();
        monitor.beginTask("", size * 4);
        try {
            int i = 0;
            while (i < size) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IEGLFile eglfile = (IEGLFile)eglfiles.get(i);
                try {
                    OrganizeImportsOperation.SyntaxErrorHelper synErr = this.runFormat(eglfile, formatProfileName, monitor);
                    if (synErr != null) {
                        String msg = UINlsStrings.bind((String)UINlsStrings.SyntaxError, (Object[])new String[]{eglfile.getPath().makeRelative().toString()});
                        status.add((IStatus)new Status(1, "org.eclipse.edt.ide.ui", 4, msg, null));
                    }
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrganizeImportsOperation.SyntaxErrorHelper runFormat(IEGLFile eglfile, String formatProfileName, IProgressMonitor monitor) throws CoreException {
        IPath path = eglfile.getPath();
        OrganizeImportsOperation.SyntaxErrorHelper synErr = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        boolean connectedTextBuffer = false;
        IEGLFile workingCopy = null;
        try {
            Object editorpart = this.fileNeedsSave.get(eglfile);
            boolean needSave = editorpart == null;
            IDocument doc = null;
            if (!needSave && (editorpart instanceof EGLEditor || editorpart instanceof MultiPageEditorPart)) {
                IEGLFile iEGLFile = eglfile;
                synchronized (iEGLFile) {
                    workingCopy = (IEGLFile)eglfile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
                }
                IBuffer buf = workingCopy.getBuffer();
                if (buf instanceof DocumentAdapter) {
                    doc = ((DocumentAdapter)buf).getDocument();
                }
            }
            ITextFileBuffer filebuffer = null;
            if (doc == null) {
                manager.connect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                connectedTextBuffer = true;
                filebuffer = manager.getTextFileBuffer(path);
                doc = filebuffer.getDocument();
            }
            String filePathLocation = path.makeRelative().toString();
            monitor.subTask(filePathLocation);
            synErr = this.formatEGLFile(doc, formatProfileName, needSave);
            if (needSave && filebuffer != null && filebuffer.isDirty()) {
                filebuffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 2), false);
            } else {
                monitor.worked(2);
            }
        }
        finally {
            if (workingCopy != null) {
                workingCopy.destroy();
            }
            if (connectedTextBuffer) {
                manager.disconnect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        return synErr;
    }

    private OrganizeImportsOperation.SyntaxErrorHelper formatEGLFile(final IDocument document, final String formatProfileName, boolean needSave) {
        final OrganizeImportsOperation.SyntaxErrorHelper[] synErr = new OrganizeImportsOperation.SyntaxErrorHelper[1];
        if (!needSave && this.fSite != null) {
            this.fSite.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    synErr[0] = FormattingHandler.this.doFormat(document, formatProfileName);
                }
            });
        } else {
            synErr[0] = this.doFormat(document, formatProfileName);
        }
        return synErr[0];
    }

    private OrganizeImportsOperation.SyntaxErrorHelper doFormat(IDocument document, String formatProfileName) {
        ProfileManager profileMgr = ProfileManager.getInstance();
        EObject originalSelProfile = profileMgr.getSelectedProfile();
        Map options = CodeFormatterUtil.getFormattingOptionMapByProfileName(formatProfileName, profileMgr);
        FormattingContext context = new FormattingContext();
        FormattingStrategy eglFormattingStrategy = new FormattingStrategy();
        try {
            context.setProperty((Object)"formatting.context.preferences", (Object)options);
            if (this.fPartialRegion != null) {
                context.setProperty((Object)"formatting.context.region", (Object)this.fPartialRegion);
                context.setProperty((Object)"formatting.context.document", (Object)Boolean.FALSE);
            } else {
                context.setProperty((Object)"formatting.context.document", (Object)Boolean.TRUE);
            }
            MultiPassContentFormatter formatter = new MultiPassContentFormatter("__dftl_partitioning", "__dftl_partition_content_type");
            formatter.setMasterStrategy((IFormattingStrategy)eglFormattingStrategy);
            try {
                this.startSequentialRewriteMode(document);
                formatter.format(document, (IFormattingContext)context);
            }
            finally {
                this.stopSequentialRewriteMode(document);
            }
        }
        finally {
            context.dispose();
            profileMgr.setSelectedProfile(originalSelProfile);
        }
        OrganizeImportsOperation.SyntaxErrorHelper synErr = eglFormattingStrategy.get1stSyntaxErrorMsg();
        return synErr;
    }

    private void startSequentialRewriteMode(IDocument document) {
        if (document instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)document;
            this.fRewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        } else if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.startSequentialRewrite(false);
        }
    }

    private void stopSequentialRewriteMode(IDocument document) {
        if (document instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)document;
            extension.stopRewriteSession(this.fRewriteSession);
        } else if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.stopSequentialRewrite();
        }
    }

    private void runOnSingle(final IEGLFile eglFile) {
        try {
            IWorkbenchWindow context;
            IEditorPart editor = EditorUtility.openInEditor(eglFile);
            this.fileNeedsSave.put(eglFile, EditorUtility.isOpenInEditor(eglFile));
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            IWorkbenchWindow iWorkbenchWindow = context = this.fSite != null ? this.fSite.getWorkbenchWindow() : null;
            if (context == null) {
                context = progressService;
            }
            final OrganizeImportsOperation.SyntaxErrorHelper[] synErr = new OrganizeImportsOperation.SyntaxErrorHelper[1];
            progressService.run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    synErr[0] = FormattingHandler.this.runFormat(eglFile, null, monitor);
                }
            }));
            this.postRun(synErr[0], editor instanceof ITextEditor ? (ITextEditor)editor : null);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    protected void postRun(OrganizeImportsOperation.SyntaxErrorHelper syntaxErr, ITextEditor editor) {
        if (syntaxErr != null) {
            MessageDialog.openInformation((Shell)this.fSite.getShell(), (String)UINlsStrings.EGLFormatting, (String)syntaxErr.fErrMsg);
            if (editor != null && syntaxErr.fSynErr.startOffset > 0) {
                editor.selectAndReveal(syntaxErr.fSynErr.startOffset, syntaxErr.fSynErr.endOffset - syntaxErr.fSynErr.startOffset + 1);
            }
        }
    }

    private void getEGLElements(IEGLElement eglElem, List result) throws EGLModelException {
        if (eglElem != null) {
            switch (eglElem.getElementType()) {
                case 2: {
                    IPackageFragmentRoot[] pkgRoots = ((IEGLProject)eglElem).getPackageFragmentRoots();
                    int i = 0;
                    while (i < pkgRoots.length) {
                        this.collectEGLFiles(pkgRoots[i], result);
                        ++i;
                    }
                    break;
                }
                case 3: {
                    this.collectEGLFiles((IPackageFragmentRoot)eglElem, result);
                    break;
                }
                case 4: {
                    this.collectEGLFiles((IPackageFragment)eglElem, result);
                    break;
                }
                case 6: {
                    result.add(eglElem);
                    this.fileNeedsSave.put(eglElem, EditorUtility.isOpenInEditor(eglElem));
                }
            }
        }
    }

    private void collectEGLFiles(IPackageFragment pkg, List result) throws EGLModelException {
        IEGLFile[] eglfiles = pkg.getEGLFiles();
        int i = 0;
        while (i < eglfiles.length) {
            result.add(eglfiles[i]);
            this.fileNeedsSave.put(eglfiles[i], EditorUtility.isOpenInEditor(eglfiles[i]));
            ++i;
        }
    }

    private void collectEGLFiles(IPackageFragmentRoot pkgRoot, List result) throws EGLModelException {
        if (pkgRoot.getKind() == 1) {
            IEGLElement[] children = pkgRoot.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectEGLFiles((IPackageFragment)children[i], result);
                ++i;
            }
        }
    }
}

