/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import java.util.ArrayList;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.outline.AbstractOutlineAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class RecordOutlineAdapter
extends AbstractOutlineAdapter {
    public RecordOutlineAdapter(EGLEditor editor) {
        super(editor);
        this.nodeIcon = PluginImages.DESC_OBJS_RECORD;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        Record record = (Record)parentElement;
        final ArrayList structureItems = new ArrayList();
        record.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(StructureItem structureItem) {
                structureItems.add(structureItem);
                return false;
            }
        });
        return structureItems.toArray();
    }

    @Override
    public String getText(Object element) {
        Record record = (Record)element;
        StringBuffer buffer = new StringBuffer();
        buffer.append(record.getName().getCanonicalName());
        String type = "BasicRecord";
        if (record.hasSubType()) {
            type = record.getSubType().getCanonicalString();
        }
        buffer.append(" : ");
        if (type != null) {
            buffer.append(type);
        }
        return buffer.toString();
    }

    @Override
    public IRegion getHighlightRange(Object element) {
        Record node = (Record)element;
        return this.getPartNameHighlightRange((Part)node);
    }

    @Override
    public Image getImage(Object element) {
        Record record = (Record)element;
        this.nodeIcon = PluginImages.DESC_OBJS_RECORD;
        if (record.hasSubType() && record.getSubType().getIdentifier() == InternUtil.intern((String)"ConsoleForm")) {
            this.nodeIcon = PluginImages.DESC_OBJS_CONSOLE_FORM_ELEMENT;
        }
        return super.getImage(element);
    }
}

