/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.packageexplorer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.actions.MoveAction;
import org.eclipse.edt.ide.ui.internal.actions.RenameAction;
import org.eclipse.edt.ide.ui.internal.packageexplorer.CopyAction;
import org.eclipse.edt.ide.ui.internal.packageexplorer.DeleteAction;
import org.eclipse.edt.ide.ui.internal.packageexplorer.PasteAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class EditActionGroup
extends CommonActionProvider {
    private IWorkbenchSite fSite;
    private Clipboard fclipboard;
    private RenameAction fRenameAction;
    private MoveAction fMoveAction;
    private CopyAction fCopyAction;
    private PasteAction fPasteAction;
    private DeleteAction fDeleteAction;
    private SelectionListenerAction[] fActions;
    private Map fActionsToContributionItems = new HashMap();

    public void init(ICommonActionExtensionSite commonActionExtensionSite) {
        ICommonViewerSite commonViewerSite = commonActionExtensionSite.getViewSite();
        if (commonViewerSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite viewSite = (ICommonViewerWorkbenchSite)commonViewerSite;
            this.fSite = viewSite.getSite();
            Shell shell = viewSite.getShell();
            this.fclipboard = new Clipboard(shell.getDisplay());
            this.fPasteAction = new PasteAction(shell, this.fclipboard);
            this.fPasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
            this.fCopyAction = new CopyAction(shell, this.fclipboard, this.fPasteAction);
            this.fCopyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
            this.fDeleteAction = new DeleteAction();
            this.fDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
            this.fActions = new SelectionListenerAction[]{this.fCopyAction, this.fPasteAction, this.fDeleteAction};
            this.registerActionsAsSelectionChangeListeners();
        }
    }

    private void registerActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        int i = 0;
        while (i < this.fActions.length) {
            SelectionListenerAction action = this.fActions[i];
            action.selectionChanged((IStructuredSelection)selection);
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fActions[i]);
            ++i;
        }
    }

    private void deregisterActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        int i = 0;
        while (i < this.fActions.length) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fActions[i]);
            ++i;
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (context != null) {
            ISelection selection = context.getSelection();
            Object structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
            int i = 0;
            while (i < this.fActions.length) {
                this.fActions[i].selectionChanged((IStructuredSelection)structuredSelection);
                ++i;
            }
        }
    }

    public IAction getDeleteAction() {
        return this.fDeleteAction;
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (this.selectionChangedToEGL(selection, this.fDeleteAction)) {
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fDeleteAction);
        }
        if (this.selectionChangedToEGL(selection, this.fCopyAction)) {
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        }
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.fPasteAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.selectionChangedToEGL(selection, this.fDeleteAction);
        menu.appendToGroup("group.reorganize", (IAction)this.fCopyAction);
        menu.appendToGroup("group.reorganize", (IAction)this.fPasteAction);
        menu.appendToGroup("group.reorganize", (IAction)this.fDeleteAction);
        MenuManager submenuRef = new MenuManager(UINlsStrings.Refactor);
        if (submenuRef.getItems().length != 0) {
            menu.appendToGroup("group.reorganize", (IContributionItem)submenuRef);
        }
    }

    private boolean selectionChangedToEGL(IStructuredSelection selection, SelectionListenerAction action) {
        if (selection.size() >= 1) {
            for (Object element : selection) {
                if (element instanceof IEGLElement) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        if (this.fclipboard != null) {
            this.fclipboard.dispose();
            this.fclipboard = null;
        }
        this.deregisterActionsAsSelectionChangeListeners();
    }
}

