/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.preferences;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusUtil;
import org.eclipse.edt.ide.ui.internal.preferences.AbstractPreferencePage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class BasePreferencePage
extends AbstractPreferencePage {
    protected Text sourceFolderName;
    protected Text outputFolderName;
    protected ModifyListener modifyListener;

    public BasePreferencePage() {
        this.setPreferenceStore(EDTUIPlugin.getDefault().getPreferenceStore());
        this.setDescription("Specify general settings for EGL");
        this.setTitle("EGL");
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasePreferencePage.this.controlModified(e.widget);
            }
        };
    }

    protected IPreferenceStore getCorePreferenceStore() {
        return EDTCoreIDEPlugin.getPlugin().getPreferenceStore();
    }

    protected void saveCorePreferenceStore() {
        IEclipsePreferences preferences = new InstanceScope().getNode(EDTCoreIDEPlugin.PLUGIN_ID);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            EDTUIPlugin.log(e);
        }
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        composite.setFont(parent.getFont());
        this.createEGLFoldersGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_BASE_PREFERENCES_CONTEXT);
        return composite;
    }

    protected void createEGLFoldersGroup(Composite parent) {
        Group baseGroup = BasePreferencePage.createGroup(parent, 1);
        baseGroup.setText(UINlsStrings.BasePreferencePage_EGLFolderGroup_label);
        Composite internalComposite = this.createComposite((Composite)baseGroup, 2);
        Label sourceFolderLabel = new Label(internalComposite, 0);
        sourceFolderLabel.setText(UINlsStrings.BasePreferencePage_EGLSourceFolder_label);
        this.sourceFolderName = this.createTextField(internalComposite);
        this.sourceFolderName.addModifyListener(this.modifyListener);
        Label outputFolderLabel = new Label(internalComposite, 0);
        outputFolderLabel.setText(UINlsStrings.BasePreferencePage_EGLOutputFolder_label);
        this.outputFolderName = this.createTextField(internalComposite);
        this.outputFolderName.addModifyListener(this.modifyListener);
    }

    @Override
    protected void performDefaults() {
        this.performDefaultsForEGLFoldersGroup();
        super.performDefaults();
    }

    protected void performDefaultsForEGLFoldersGroup() {
        this.sourceFolderName.setText(EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getDefaultString("eglSourceFolder"));
        this.outputFolderName.setText(EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getDefaultString("eglOutputFolder"));
    }

    @Override
    protected void initializeValues() {
        this.initializeEGLFoldersGroup();
    }

    protected void initializeEGLFoldersGroup() {
        this.sourceFolderName.setText(EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("eglSourceFolder"));
        this.outputFolderName.setText(EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("eglOutputFolder"));
    }

    private void controlModified(Widget widget) {
        if (widget == this.sourceFolderName || widget == this.outputFolderName) {
            this.validateFolders();
        }
    }

    private void validateFolders() {
        IStatus status;
        String srcName = this.sourceFolderName.getText();
        String binName = this.outputFolderName.getText();
        if (srcName.length() == 0) {
            this.updateStatus(new StatusInfo(4, "Enter source folder name."));
            return;
        }
        if (binName.length() == 0) {
            this.updateStatus(new StatusInfo(4, "Enter output folder name."));
            return;
        }
        IWorkspace workspace = EDTUIPlugin.getWorkspace();
        IProject dmy = workspace.getRoot().getProject("project");
        IPath srcPath = dmy.getFullPath().append(srcName);
        if (srcName.length() != 0 && !(status = workspace.validatePath(srcPath.toString(), 2)).isOK()) {
            String message = MessageFormat.format((String)"Invalid source folder name: {0}", (Object[])new Object[]{status.getMessage()});
            this.updateStatus(new StatusInfo(4, message));
            return;
        }
        IPath binPath = dmy.getFullPath().append(binName);
        if (binName.length() != 0 && !(status = workspace.validatePath(binPath.toString(), 2)).isOK()) {
            String message = MessageFormat.format((String)"Invalid output folder name: {0}", (Object[])new Object[]{status.getMessage()});
            this.updateStatus(new StatusInfo(4, message));
            return;
        }
        IEGLPathEntry entry = EGLCore.newSourceEntry((IPath)srcPath);
        status = EGLConventions.validateEGLPath((IEGLProject)EGLCore.create((IProject)dmy), (IEGLPathEntry[])new IEGLPathEntry[]{entry}, (IPath)binPath);
        if (!status.isOK()) {
            String message = "Settings will result in an invalid build path. Check for nested folders.";
            this.updateStatus(new StatusInfo(4, message));
            return;
        }
        this.updateStatus(new StatusInfo());
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    @Override
    protected void storeValues() {
        this.storeEGLFoldersGroup();
    }

    protected void storeEGLFoldersGroup() {
        EDTCoreIDEPlugin.getPlugin().getPreferenceStore().setValue("eglSourceFolder", this.sourceFolderName.getText());
        EDTCoreIDEPlugin.getPlugin().getPreferenceStore().setValue("eglOutputFolder", this.outputFolderName.getText());
    }

    @Override
    public boolean performOk() {
        super.performOk();
        this.saveCorePreferenceStore();
        return true;
    }
}

