/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.preferences;

import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.preferences.AbstractPreferencePage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;

public class EditorPreferencePage
extends AbstractPreferencePage {
    protected Button showLineNumbersButton = null;
    protected Button annotateErrorsButton = null;
    protected Button annotateErrorsInOverviewButton = null;
    protected Button annotateErrorsAsYouTypeButton = null;
    protected Button autoActivationButton = null;

    public EditorPreferencePage() {
        this.setPreferenceStore(this.doGetPreferenceStore());
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return EDTUIPlugin.getDefault().getPreferenceStore();
    }

    protected void doSavePreferenceStore() {
        EDTUIPlugin.getDefault().savePluginPreferences();
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        Composite internalComposite = this.createComposite(composite, 1);
        this.showLineNumbersButton = EditorPreferencePage.createCheckBox(internalComposite, UINlsStrings.ShowLineNumbersLabel);
        this.annotateErrorsButton = EditorPreferencePage.createCheckBox(internalComposite, UINlsStrings.AnnotateErrorsLabel);
        this.annotateErrorsInOverviewButton = EditorPreferencePage.createCheckBox(internalComposite, UINlsStrings.AnnotateErrorsInOverviewLabel);
        this.annotateErrorsAsYouTypeButton = EditorPreferencePage.createCheckBox(internalComposite, UINlsStrings.AnnotateErrorsAsYouTypeLabel);
        Group contentAssistGroup = EditorPreferencePage.createGroup(composite, 1);
        contentAssistGroup.setText(UINlsStrings.ContentAssistLabel);
        Composite contentAssistComposite = this.createComposite((Composite)contentAssistGroup, 1);
        this.autoActivationButton = EditorPreferencePage.createCheckBox(contentAssistComposite, UINlsStrings.AutoActivationLabel);
        this.setSize(composite);
        this.loadPreferences();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IUIHelpConstants.EDITOR_PREFERENCE_CONTEXT);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private IPreferenceStore getEditorUIPreferenceStore() {
        return EditorsUI.getPreferenceStore();
    }

    @Override
    protected void performDefaults() {
        this.showLineNumbersButton.setSelection(this.getEditorUIPreferenceStore().getDefaultBoolean("lineNumberRuler"));
        this.annotateErrorsButton.setSelection(this.getEditorUIPreferenceStore().getDefaultBoolean("errorIndication"));
        this.annotateErrorsInOverviewButton.setSelection(this.getEditorUIPreferenceStore().getDefaultBoolean("errorIndicationInOverviewRuler"));
        this.annotateErrorsAsYouTypeButton.setSelection(this.getPreferenceStore().getDefaultBoolean("handleDynamicProblems"));
        this.autoActivationButton.setSelection(this.getPreferenceStore().getDefaultBoolean("content_assist_autoactivation"));
        super.performDefaults();
    }

    @Override
    protected void initializeValues() {
        this.showLineNumbersButton.setSelection(this.getEditorUIPreferenceStore().getBoolean("lineNumberRuler"));
        this.annotateErrorsButton.setSelection(this.getEditorUIPreferenceStore().getBoolean("errorIndication"));
        this.annotateErrorsInOverviewButton.setSelection(this.getEditorUIPreferenceStore().getBoolean("errorIndicationInOverviewRuler"));
        this.annotateErrorsAsYouTypeButton.setSelection(this.getPreferenceStore().getBoolean("handleDynamicProblems"));
        this.autoActivationButton.setSelection(this.getPreferenceStore().getBoolean("content_assist_autoactivation"));
    }

    @Override
    protected void storeValues() {
        this.getEditorUIPreferenceStore().setValue("lineNumberRuler", this.showLineNumbersButton.getSelection());
        this.getEditorUIPreferenceStore().setValue("errorIndication", this.annotateErrorsButton.getSelection());
        this.getEditorUIPreferenceStore().setValue("errorIndicationInOverviewRuler", this.annotateErrorsInOverviewButton.getSelection());
        this.getPreferenceStore().setValue("handleDynamicProblems", this.annotateErrorsAsYouTypeButton.getSelection());
        this.getPreferenceStore().setValue("content_assist_autoactivation", this.autoActivationButton.getSelection());
    }

    @Override
    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }
}

