/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.preferences;

import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.preferences.FoldingConfigurationBlock;
import org.eclipse.edt.ide.ui.internal.preferences.OverlayPreferenceStore;
import org.eclipse.jdt.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class FoldingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceConfigurationBlock fConfigurationBlock;
    private OverlayPreferenceStore fOverlayStore;

    public FoldingPreferencePage() {
        this.setDescription(UINlsStrings.EditorFoldingPreferencePageDescription);
        this.setPreferenceStore(this.doGetPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), new OverlayPreferenceStore.OverlayKey[0]);
        this.fConfigurationBlock = this.createConfigurationBlock(this.fOverlayStore);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return EDTUIPlugin.getDefault().getPreferenceStore();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IUIHelpConstants.EDITOR_FOLDING_PREFERENCE_CONTEXT);
    }

    protected IPreferenceConfigurationBlock createConfigurationBlock(OverlayPreferenceStore overlayPreferenceStore) {
        return new FoldingConfigurationBlock(overlayPreferenceStore);
    }

    protected Control createContents(Composite parent) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Control content = this.fConfigurationBlock.createControl(parent);
        this.initialize();
        Dialog.applyDialogFont((Control)content);
        return content;
    }

    private void initialize() {
        this.fConfigurationBlock.initialize();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.fConfigurationBlock.performOk();
        this.fOverlayStore.propagate();
        EDTUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    public void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.fConfigurationBlock.performDefaults();
        super.performDefaults();
    }

    public void dispose() {
        this.fConfigurationBlock.dispose();
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }
}

