/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.editor.DocumentProvider;
import org.eclipse.edt.ide.ui.internal.editor.EGLSourceViewerConfiguration;
import org.eclipse.edt.ide.ui.internal.editor.TextTools;
import org.eclipse.edt.ide.ui.internal.preferences.ColorEditor;
import org.eclipse.edt.ide.ui.internal.preferences.OverlayPreferenceStore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class StylePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected TextTools tools;
    private OverlayPreferenceStore fOverlayStore;
    private Map fColorButtons = new HashMap();
    private Map fCheckBoxes = new HashMap();
    private List fStyleColorList;
    private ColorEditor fStyleForegroundColorEditor;
    private ColorEditor fBackgroundColorEditor;
    private Button fBackgroundDefaultRadioButton;
    private Button fBackgroundCustomRadioButton;
    private Button fBackgroundColorButton;
    private Button fBoldCheckBox;
    private SourceViewer fPreviewViewer;
    private Color fBackgroundColor;
    private static final String BOLD = "_bold";
    public final OverlayPreferenceStore.OverlayKey[] fKeys = new OverlayPreferenceStore.OverlayKey[]{new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Foreground"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Foreground.SystemDefault"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Background"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Background.SystemDefault"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "egl_multi_line_comment"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "egl_multi_line_comment_bold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "egl_single_line_comment"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "egl_single_line_comment_bold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "egl_keyword"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "egl_keyword_bold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "egl_string"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "egl_string_bold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "egl_default"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "egl_default_bold")};
    private final String[][] fStyleColorListModel = new String[][]{{UINlsStrings.SourceStyleDefault, "egl_default"}, {UINlsStrings.SourceStyleKeywords, "egl_keyword"}, {UINlsStrings.SourceStyleLiterals, "egl_string"}, {UINlsStrings.SourceStyleSingleComment, "egl_single_line_comment"}, {UINlsStrings.SourceStyleMultiComment, "egl_multi_line_comment"}};

    public StylePreferencePage() {
        this.setDescription(UINlsStrings.SourceStyleDialogTitle);
        this.setPreferenceStore(EDTUIPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.fKeys);
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IUIHelpConstants.SOURCE_STYLES_PREFERENCE_CONTEXT);
    }

    protected Control createContents(Composite parent) {
        this.initializeDefaults();
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Group backgroundComposite = new Group(colorComposite, 16);
        backgroundComposite.setLayout((Layout)new RowLayout());
        backgroundComposite.setText(UINlsStrings.SourceStyleBackgroundColor);
        SelectionListener backgroundSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean custom = StylePreferencePage.this.fBackgroundCustomRadioButton.getSelection();
                StylePreferencePage.this.fBackgroundColorButton.setEnabled(custom);
                StylePreferencePage.this.fOverlayStore.setValue("AbstractTextEditor.Color.Background.SystemDefault", !custom);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fBackgroundDefaultRadioButton = new Button((Composite)backgroundComposite, 16400);
        this.fBackgroundDefaultRadioButton.setText(UINlsStrings.SourceStyleSystemDefault);
        this.fBackgroundDefaultRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundCustomRadioButton = new Button((Composite)backgroundComposite, 16400);
        this.fBackgroundCustomRadioButton.setText(UINlsStrings.SourceStyleCustom);
        this.fBackgroundCustomRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundColorEditor = new ColorEditor((Composite)backgroundComposite);
        this.fBackgroundColorButton = this.fBackgroundColorEditor.getButton();
        Label label = new Label(colorComposite, 16384);
        label.setText(UINlsStrings.SourceStyleForeground);
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fStyleColorList = new List(editorComposite, 2564);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fStyleColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setText(UINlsStrings.SourceStyleColor);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fStyleForegroundColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fStyleForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(UINlsStrings.SourceStyleBold);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText(UINlsStrings.SourceStylePreview);
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fStyleColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StylePreferencePage.this.handleStyleColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = StylePreferencePage.this.fStyleColorList.getSelectionIndex();
                String key = StylePreferencePage.this.fStyleColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)StylePreferencePage.this.fOverlayStore, (String)key, (RGB)StylePreferencePage.this.fStyleForegroundColorEditor.getColorValue());
            }
        });
        this.fBackgroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferenceConverter.setValue((IPreferenceStore)StylePreferencePage.this.fOverlayStore, (String)"AbstractTextEditor.Color.Background", (RGB)StylePreferencePage.this.fBackgroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = StylePreferencePage.this.fStyleColorList.getSelectionIndex();
                String key = StylePreferencePage.this.fStyleColorListModel[i][1];
                StylePreferencePage.this.fOverlayStore.setValue(String.valueOf(key) + StylePreferencePage.BOLD, StylePreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
        this.initialize();
        Dialog.applyDialogFont((Control)colorComposite);
        return colorComposite;
    }

    private Control createPreviewer(Composite parent) {
        this.tools = new TextTools(this.fOverlayStore);
        this.fPreviewViewer = new SourceViewer(parent, null, 2816);
        this.fPreviewViewer.configure((SourceViewerConfiguration)new EGLSourceViewerConfiguration(this.tools, null));
        Font font = JFaceResources.getFont((String)"org.eclipse.edt.ide.ui.editors.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        this.fPreviewViewer.setEditable(false);
        this.initializeViewerColors((ISourceViewer)this.fPreviewViewer);
        String content = this.getSampleText();
        Document document = new Document(content);
        IDocumentPartitioner partitioner = ((DocumentProvider)EGLUI.getDocumentProvider()).createDocumentPartitioner();
        document.setDocumentPartitioner(partitioner);
        partitioner.connect((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        this.fOverlayStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String p = event.getProperty();
                if (p.equals("AbstractTextEditor.Color.Background") || p.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
                    StylePreferencePage.this.initializeViewerColors((ISourceViewer)StylePreferencePage.this.fPreviewViewer);
                }
                StylePreferencePage.this.fPreviewViewer.invalidateTextPresentation();
            }
        });
        return this.fPreviewViewer.getControl();
    }

    private void initializeViewerColors(ISourceViewer viewer) {
        OverlayPreferenceStore store = this.fOverlayStore;
        if (store != null) {
            StyledText styledText = viewer.getTextWidget();
            Color color = store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    private void handleStyleColorListSelection() {
        int i = this.fStyleColorList.getSelectionIndex();
        String key = this.fStyleColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fStyleForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.fOverlayStore.getBoolean(String.valueOf(key) + BOLD));
    }

    public String getSampleText() {
        return StylePreferencePage.internal();
    }

    public static String internal() {
        return "/* This function adds the employee to the SQL\n   table EMPLOYEE. SQL updates are backed out\n   when there is a duplicate key. */\n\nFunction addEmp()\n  try\n    add employee;\n  onException(exception SQLException)\n    if (employee is unique)    // record with duplicate key\n      sysLib.rollback();       // back out SQL add\n      msg = \"Duplicate key\";\n    else                       // database error on add\n      msg = \"Database error\";\n    end\n    setMsg();\n  end\nend";
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        while (i < this.fStyleColorListModel.length) {
            this.fStyleColorList.add(this.fStyleColorListModel[i][0]);
            ++i;
        }
        this.fStyleColorList.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (StylePreferencePage.this.fStyleColorList != null && !StylePreferencePage.this.fStyleColorList.isDisposed()) {
                    StylePreferencePage.this.fStyleColorList.select(0);
                    StylePreferencePage.this.handleStyleColorListSelection();
                }
            }
        });
    }

    private void initializeFields() {
        String key;
        for (ColorEditor c : this.fColorButtons.keySet()) {
            key = (String)this.fColorButtons.get(c);
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
            c.setColorValue(rgb);
        }
        for (Button b : this.fCheckBoxes.keySet()) {
            key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Background");
        this.fBackgroundColorEditor.setColorValue(rgb);
        boolean default_ = this.fOverlayStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        this.fBackgroundDefaultRadioButton.setSelection(default_);
        this.fBackgroundCustomRadioButton.setSelection(!default_);
        this.fBackgroundColorButton.setEnabled(!default_);
    }

    private void initializeDefaults() {
        RGB rgb;
        IPreferenceStore prefs = this.getPreferenceStore();
        if (!prefs.contains("AbstractTextEditor.Color.Background")) {
            rgb = this.getControl().getDisplay().getSystemColor(25).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
        }
        if (!prefs.contains("AbstractTextEditor.Color.Foreground")) {
            rgb = this.getControl().getDisplay().getSystemColor(24).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
        }
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        EDTUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleStyleColorListSelection();
        super.performDefaults();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        if (this.fBackgroundColor != null && !this.fBackgroundColor.isDisposed()) {
            this.fBackgroundColor.dispose();
        }
        if (this.tools != null) {
            this.tools.dispose();
            this.tools = null;
        }
        super.dispose();
    }
}

