/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.project.wizard.fragments;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.project.wizard.fragments.ProjectContentFragment;
import org.eclipse.edt.ide.ui.internal.project.wizard.pages.ProjectWizardTypePage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;

public class SourceProjectContentFragment
extends ProjectContentFragment {
    private final ProjectConfiguration config;
    private StatusInfo locationInfo;
    private String customDirectory = "";

    public SourceProjectContentFragment(Composite renderOn, ProjectWizardTypePage parentPage) {
        super(renderOn, parentPage);
        this.config = parentPage.getModel();
        this.locationInfo = new StatusInfo();
    }

    @Override
    public void dispose() {
    }

    @Override
    protected void handleLocationBrowseButtonPressed() {
        DirectoryDialog dialog = this.openLocationDialog();
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.directory.setText(selectedDirectory);
        }
        this.validateProjectLocation();
    }

    @Override
    protected void hookListeners() {
        this.specifyProjectDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SourceProjectContentFragment.this.config.setUseDefaults(SourceProjectContentFragment.this.specifyProjectDirectory.getSelection());
                boolean useDefaults = SourceProjectContentFragment.this.config.isUseDefaults();
                SourceProjectContentFragment.this.directoryLabel.setEnabled(!useDefaults);
                SourceProjectContentFragment.this.directory.setEnabled(!useDefaults);
                SourceProjectContentFragment.this.browseDirectory.setEnabled(!useDefaults);
                if (useDefaults) {
                    SourceProjectContentFragment.this.customDirectory = SourceProjectContentFragment.this.directory.getText();
                    SourceProjectContentFragment.this.directory.setText(Platform.getLocation().append(SourceProjectContentFragment.this.config.getProjectName()).toOSString());
                } else {
                    SourceProjectContentFragment.this.directory.setText(SourceProjectContentFragment.this.customDirectory);
                }
            }
        });
        this.directory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SourceProjectContentFragment.this.config.setCustomProjectLocation(SourceProjectContentFragment.this.directory.getText());
                SourceProjectContentFragment.this.validateProjectLocation();
            }
        });
        this.browseDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SourceProjectContentFragment.this.handleLocationBrowseButtonPressed();
            }
        });
    }

    @Override
    protected void setInitialValues() {
        this.specifyProjectDirectory.setSelection(true);
        this.specifyProjectDirectory.setEnabled(false);
        this.directoryLabel.setEnabled(false);
        this.directory.setEnabled(false);
        this.directory.setText(Platform.getLocation().append(this.config.getProjectName()).toOSString());
        this.browseDirectory.setEnabled(false);
    }

    private void validateProjectLocation() {
        this.locationInfo.setOK();
        String projectLocation = this.config.getCustomProjectLocation();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (this.config.getCustomProjectLocation().equals("")) {
            this.locationInfo.setError(NewWizardMessages.EGLSourceProjectWizardPage_projectLocationEmpty);
        } else {
            Path path = new Path("");
            if (!path.isValidPath(projectLocation)) {
                this.locationInfo.setError(NewWizardMessages.EGLSourceProjectWizardPage_locationError);
            } else {
                Path projectPath = new Path(projectLocation);
                if (!this.config.isUseDefaults()) {
                    if (Platform.getLocation().isPrefixOf((IPath)projectPath)) {
                        this.locationInfo.setError(NewWizardMessages.EGLSourceProjectWizardPage_defaultLocationError);
                    } else {
                        IProject handle = ResourcesPlugin.getWorkspace().getRoot().getProject(this.config.getProjectName());
                        IStatus currLocationStatus = workspace.validateProjectLocation(handle, (IPath)projectPath);
                        if (!currLocationStatus.isOK()) {
                            this.locationInfo.setError(currLocationStatus.getMessage());
                        }
                    }
                }
            }
        }
        this.getParentPage().setPageComplete(this.locationInfo.isOK());
        this.getParentPage().setErrorMessage(this.locationInfo.getMessage());
    }

    private DirectoryDialog openLocationDialog() {
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.getParentPage().getShell());
        dialog.setMessage(NewWizardMessages.EGLSourceProjectWizardPage_DirectoryDialogTitle);
        String dirName = this.config.getCustomProjectLocation();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        return dialog;
    }
}

