/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.PPListElement;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.util.CoreUtility;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;

public final class EGLProjectUtility {
    public static final String JAVA_DEFAULT_BIN_FOLDER = "bin";
    public static final String JAVA_DEFAULT_SOURCE_FOLDER = "src";

    public static void addEGLNature(IProject project, IProgressMonitor monitor) throws CoreException {
        boolean hasEGLCoreNatureID = project.hasNature(EGLCore.NATURE_ID);
        boolean hasEGLNatureID = project.hasNature("org.eclipse.edt.ide.core.EGLNature");
        if (!hasEGLCoreNatureID || !hasEGLNatureID) {
            if (!hasEGLNatureID) {
                EGLProjectUtility.addNatureToProject(project, "org.eclipse.edt.ide.core.EGLNature", monitor);
            }
            if (!hasEGLCoreNatureID) {
                EGLProjectUtility.addNatureToProject(project, EGLCore.NATURE_ID, monitor);
            }
        } else {
            monitor.worked(1);
        }
    }

    public static void addJavaNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            EGLProjectUtility.addNatureToProject(project, "org.eclipse.jdt.core.javanature", monitor);
        } else {
            monitor.worked(1);
        }
    }

    private static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    public static boolean classpathEntryExists(IJavaProject javaProject, IClasspathEntry entry) throws JavaModelException {
        int jarIndex = -1;
        IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            IClasspathEntry curEntry = oldEntries[i];
            if (curEntry.getPath() != null && curEntry.getPath().toString().equalsIgnoreCase(entry.getPath().toString())) {
                jarIndex = i;
                break;
            }
            ++i;
        }
        return jarIndex >= 0;
    }

    public static void createEGLConfiguration(ProjectConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IPath eglOutputLocation;
        IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = fWorkspaceRoot.getProject(configuration.getProjectName());
        IEGLProject fCurrEProject = EGLCore.create((IProject)project);
        List<PPListElement> eglPathEntries = configuration.getRequiredProjects();
        if (eglPathEntries.size() == 0 && !configuration.getProjectName().equals("")) {
            eglPathEntries = EGLProjectUtility.initializeEGLPathEntries(project);
        }
        if (!fWorkspaceRoot.exists(eglOutputLocation = EGLProjectUtility.getDefaultEGLOutputPath(fCurrEProject))) {
            IFolder folder = fWorkspaceRoot.getFolder(eglOutputLocation);
            CoreUtility.createFolder(folder, true, true, null);
            folder.setDerived(true);
        }
        monitor.worked(2);
        int nEntries = eglPathEntries.size();
        IEGLPathEntry[] classpath = new IEGLPathEntry[nEntries];
        int i = 0;
        while (i < nEntries) {
            IPath folderOutput;
            PPListElement entry = eglPathEntries.get(i);
            IResource res = entry.getResource();
            if (res instanceof IFolder && !res.exists()) {
                CoreUtility.createFolder((IFolder)res, true, true, null);
            }
            if (entry.getEntryKind() == 3 && (folderOutput = (IPath)entry.getAttribute("output")) != null && folderOutput.segmentCount() > 1) {
                IFolder folder = fWorkspaceRoot.getFolder(folderOutput);
                CoreUtility.createFolder(folder, true, true, null);
            }
            classpath[i] = entry.getEGLPathEntry();
            EGLProjectUtility.configureJavaDoc(entry);
            ++i;
        }
        monitor.worked(1);
        fCurrEProject.setRawEGLPath(classpath, eglOutputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
    }

    static IFolder createFolderIfNecessary(IProject project, String folderName, String encoding) throws InvocationTargetException {
        IFolder folder = project.getFolder(folderName);
        if (!folder.exists()) {
            int start = 0;
            int nextSlash = 0;
            nextSlash = folderName.indexOf(47, 0);
            try {
                while (nextSlash != -1) {
                    String subFolderName = folderName.substring(0, nextSlash);
                    IFolder subFolder = project.getFolder(subFolderName);
                    if (!subFolder.exists()) {
                        subFolder.create(false, true, null);
                        subFolder.setDefaultCharset(encoding, null);
                    }
                    start = nextSlash + 1;
                    nextSlash = folderName.indexOf(47, start);
                }
                folder.create(false, true, null);
                folder.setDefaultCharset(encoding, null);
            }
            catch (CoreException ex) {
                throw new InvocationTargetException(ex, ex.getMessage());
            }
        }
        return folder;
    }

    private static IClasspathEntry[] createNewClasspathEntries(IJavaProject javaProject, String folderName, String binFolderName, String encoding, IClasspathEntry[] oldEntries) throws InvocationTargetException {
        IFolder baseFolder = EGLProjectUtility.createFolderIfNecessary(javaProject.getProject(), folderName, encoding);
        IFolder binFolder = EGLProjectUtility.createFolderIfNecessary(javaProject.getProject(), binFolderName, encoding);
        try {
            IPackageFragmentRoot sourceRoot = javaProject.getPackageFragmentRoot((IResource)baseFolder);
            IPackageFragmentRoot binRoot = javaProject.getPackageFragmentRoot((IResource)binFolder);
            IClasspathEntry newEntry = JavaCore.newSourceEntry((IPath)sourceRoot.getPath(), (IPath[])new IPath[0], (IPath)binRoot.getPath());
            if (!EGLProjectUtility.classpathEntryExists(javaProject, newEntry)) {
                IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
                newEntries[0] = newEntry;
                System.arraycopy(oldEntries, 0, newEntries, 1, oldEntries.length);
                return newEntries;
            }
        }
        catch (JavaModelException ex) {
            throw new InvocationTargetException(ex, ex.getMessage());
        }
        return oldEntries;
    }

    private static void configureJavaDoc(PPListElement entry) {
        if (entry.getEntryKind() == 1) {
            URL javadocLocation = (URL)entry.getAttribute("javadoc");
            IPath path = entry.getPath();
            if (entry.getEntryKind() == 4) {
                path = EGLCore.getResolvedVariablePath((IPath)path);
            }
            if (path != null) {
                JavaUI.setLibraryJavadocLocation((IPath)path, (URL)javadocLocation);
            }
        } else if (entry.getEntryKind() == 5) {
            Object[] children = entry.getChildren(false);
            int i = 0;
            while (i < children.length) {
                PPListElement curr = (PPListElement)children[i];
                EGLProjectUtility.configureJavaDoc(curr);
                ++i;
            }
        }
    }

    private static List<PPListElement> initializeEGLPathEntries(IProject project) {
        List<PPListElement> newEGLPath = null;
        IEGLPathEntry[] eglPathEntries = null;
        IEGLProject eglProject = EGLCore.create((IProject)project);
        try {
            boolean projectExists;
            boolean bl = projectExists = project.exists() && project.getFile(".eglPath").exists();
            if (projectExists && eglPathEntries == null) {
                eglPathEntries = eglProject.getRawEGLPath();
            }
            if (eglPathEntries != null) {
                newEGLPath = EGLProjectUtility.getExistingEntries(eglPathEntries, eglProject);
            }
        }
        catch (CoreException e) {
            EDTUIPlugin.log(e);
        }
        if (newEGLPath == null) {
            newEGLPath = EGLProjectUtility.getDefaultClassPath(eglProject);
        }
        ArrayList<PPListElement> exportedEntries = new ArrayList<PPListElement>();
        int i = 0;
        while (i < newEGLPath.size()) {
            PPListElement currEGL = newEGLPath.get(i);
            if (currEGL.isExported() || currEGL.getEntryKind() == 3) {
                exportedEntries.add(currEGL);
            }
            ++i;
        }
        return newEGLPath;
    }

    public static ArrayList<PPListElement> getExistingEntries(IEGLPathEntry[] eglPathEntries, IEGLProject project) {
        ArrayList<PPListElement> newEGLPath = new ArrayList<PPListElement>();
        int i = 0;
        while (i < eglPathEntries.length) {
            IEGLPathEntry curr = eglPathEntries[i];
            newEGLPath.add(PPListElement.createFromExisting((IEGLPathEntry)curr, (IEGLProject)project));
            ++i;
        }
        return newEGLPath;
    }

    public static void createJavaConfiguration(IProject project, IProgressMonitor monitor) throws CoreException {
        EGLProjectUtility.addJavaNature(project, monitor);
        EGLProjectUtility.createJavaBuildPath(project, monitor);
    }

    public static void createJavaBuildPath(IProject project, IProgressMonitor monitor) throws CoreException {
        IPath javaOutputLocation = EGLProjectUtility.getDefaultJavaOutputPath(project);
        List<IClasspathEntry> newJavaClasspathEntry = EGLProjectUtility.getDefaultJavaClassPathEntryList(project);
        IClasspathEntry[] jclasspath = newJavaClasspathEntry.toArray(new IClasspathEntry[newJavaClasspathEntry.size()]);
        JavaCore.create((IProject)project).setRawClasspath(jclasspath, javaOutputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
    }

    public static List<PPListElement> getDefaultClassPath(IEGLProject eproj) {
        ArrayList<PPListElement> list = new ArrayList<PPListElement>();
        String sourceFolderName = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("eglSourceFolder");
        Object srcFolder = sourceFolderName.length() > 0 ? eproj.getProject().getFolder(sourceFolderName) : eproj.getProject();
        list.add(new PPListElement(eproj, 3, srcFolder.getFullPath(), (IResource)srcFolder));
        return list;
    }

    public static IPath getDefaultEGLOutputPath(IEGLProject eproj) {
        String outputLocationName = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("eglOutputFolder");
        return eproj.getProject().getFullPath().append(outputLocationName);
    }

    public static List<IClasspathEntry> getDefaultJavaClassPathEntryList(IProject project) throws CoreException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IPreferenceStore prefs = PreferenceConstants.getPreferenceStore();
        String sourceFolderName = prefs.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects") ? prefs.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName") : JAVA_DEFAULT_SOURCE_FOLDER;
        IFolder srcFolder = project.getFolder(sourceFolderName);
        if (srcFolder instanceof IFolder && !srcFolder.exists()) {
            CoreUtility.createFolder(srcFolder, true, true, null);
        }
        IClasspathEntry javaClasspathEntry = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath(), (IPath[])new Path[0], (IPath[])new Path[0], null);
        list.add(javaClasspathEntry);
        list.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER")));
        return list;
    }

    public static IPath getDefaultJavaOutputPath(IProject project) {
        IPreferenceStore prefs = PreferenceConstants.getPreferenceStore();
        String outputLocationName = prefs.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects") ? prefs.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName") : JAVA_DEFAULT_BIN_FOLDER;
        return project.getFullPath().append(outputLocationName);
    }

    public static boolean classpathEntriesExist(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getPath().segmentCount() > 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean sourceClasspathEntryExists(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 3 && entries[i].getPath().segmentCount() > 1) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

