/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.wizards.EGLFileWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPackageWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLFileOperation;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class EGLFileWizard
extends EGLPackageWizard
implements INewWizard {
    private static final String WIZPAGENAME_EGLFileWizardPage = "WIZPAGENAME_EGLFileWizardPage";
    protected EGLFileConfiguration configuration;
    private boolean openResourceOnFinish;

    public EGLFileWizard() {
        this(true);
    }

    public EGLFileWizard(boolean openResourceOnFinish) {
        this.setDefaultPageImageDescriptor(PluginImages.DESC_WIZBAN_NEWSRCFILE);
        this.setDialogSettings(EDTUIPlugin.getDefault().getDialogSettings());
        this.openResourceOnFinish = openResourceOnFinish;
    }

    public boolean defaultPackageCheckQuestion() {
        if (this.getConfiguration().getFPackage().length() == 0) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)NewWizardMessages.NewEGLPartWizardPackageNameTitle, (String)NewWizardMessages.NewEGLPartWizardDefaultPackageWarning);
        }
        return true;
    }

    @Override
    public boolean performFinish() {
        if (!this.defaultPackageCheckQuestion()) {
            return false;
        }
        EGLFileOperation operation = new EGLFileOperation((EGLFileConfiguration)this.getConfiguration());
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), null, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                EGLLogger.log((Object)this, e);
            }
            return false;
        }
        if (this.openResourceOnFinish) {
            this.openResource(this.configuration.getFile());
        }
        return true;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.getConfiguration().init(workbench, selection);
        this.setWindowTitle(NewWizardMessages.NewEGLPartCreationWizardTitle);
    }

    @Override
    public EGLPackageConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new EGLFileConfiguration();
        }
        return this.configuration;
    }

    @Override
    public void addPages() {
        this.addPage((IWizardPage)new EGLFileWizardPage(WIZPAGENAME_EGLFileWizardPage));
    }

    protected void openResource(final IFile resource) {
        Display display;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        final IWorkbenchPage activePage = window == null ? null : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                    }
                    catch (PartInitException e) {
                        EDTUIPlugin.log(e);
                    }
                }
            });
        }
    }
}

