/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.ProgramWizardPage;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.edt.ide.ui.wizards.PartTemplateException;
import org.eclipse.edt.ide.ui.wizards.ProgramConfiguration;
import org.eclipse.edt.ide.ui.wizards.ProgramOperation;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ProgramWizard
extends EGLPartWizard
implements INewWizard {
    private static final String WIZPAGENAME_ProgramWizardPage = "WIZPAGENAME_ProgramWizardPage";
    ProgramConfiguration configuration;

    public ProgramWizard() {
        this.setDefaultPageImageDescriptor(PluginImages.DESC_WIZBAN_NEWPROGRAM);
    }

    @Override
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        ProgramOperation operation = new ProgramOperation((ProgramConfiguration)this.getConfiguration());
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            boolean dialogResult = false;
            if (e.getMessage().indexOf(58) != -1) {
                PartTemplateException pe = new PartTemplateException(e.getMessage());
                if (pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_NOT_FOUND) == 0) {
                    dialogResult = ((EGLPartWizardPage)this.getPage(WIZPAGENAME_ProgramWizardPage)).handleTemplateError(pe.getPartType(), pe.getPartDescription());
                } else if (pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_DISABLED) != 0 && pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_CORRUPTED) == 0) {
                    dialogResult = ((EGLPartWizardPage)this.getPage(WIZPAGENAME_ProgramWizardPage)).handleTemplateError(pe.getPartType(), pe.getPartDescription());
                }
                if (dialogResult) {
                    return this.performFinish();
                }
                return false;
            }
            EGLLogger.log((Object)this, e);
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), null, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                EGLLogger.log((Object)this, e);
            }
            return false;
        }
        ((ProgramWizardPage)this.getPage(WIZPAGENAME_ProgramWizardPage)).finishPage();
        this.openResourceFile();
        return true;
    }

    protected void openResourceFile() {
        this.openResource(this.configuration.getFile());
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.getConfiguration().init(workbench, selection);
        this.setWindowTitle(NewWizardMessages.NewEGLProgramWizardPageTitle);
    }

    @Override
    public EGLPackageConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new ProgramConfiguration();
        }
        return this.configuration;
    }

    @Override
    public void addPages() {
        this.addPage((IWizardPage)new ProgramWizardPage(WIZPAGENAME_ProgramWizardPage));
    }
}

