/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.ProgramWizard;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.ProgramConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ProgramWizardPage
extends EGLPartWizardPage {
    private int progType = 1;
    private static final String PAGE_NAME = "NewProgramWizardPage";
    private static final String SETTINGS_MAIN_PROGRAM = "program_type";
    private int nColumns = 5;
    private StringDialogField fProgramDialogField;
    private StatusInfo fProgramStatus;
    private Group fProgramTypeGroup;
    private Button fBasicProgramButton;
    private Button fTextProgramButton;
    private Button fVGWebTransProgramButton;
    private Button fCalledProgramButton;
    private Button fUIProgramButton;
    private ProgramFieldAdapter adapter = new ProgramFieldAdapter();

    protected ProgramWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewEGLProgramWizardPageTitle);
        this.setDescription(NewWizardMessages.NewEGLProgramWizardPageDescription);
        this.fProgramStatus = new StatusInfo();
    }

    @Override
    public void init() {
        IDialogSettings section = this.getDialogSettings().getSection(PAGE_NAME);
        if (section != null) {
            try {
                this.progType = section.getInt(SETTINGS_MAIN_PROGRAM);
                this.getConfiguration().setProgramType(this.progType);
            }
            catch (NumberFormatException numberFormatException) {
                this.progType = 1;
                section.put(SETTINGS_MAIN_PROGRAM, this.progType);
            }
        }
    }

    private ProgramConfiguration getConfiguration() {
        return (ProgramConfiguration)((ProgramWizard)this.getWizard()).getConfiguration();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.init();
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_PROGRAM_DEFINITION);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, this.nColumns);
        this.createPackageControls(composite);
        this.createSeparator(composite, this.nColumns);
        this.createEGLFileControls(composite);
        this.createProgramPartControls(composite);
        this.modifyFileListeners();
        this.createProgramTypeControls(composite);
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    private void createProgramPartControls(Composite parent) {
        this.fProgramDialogField = new StringDialogField();
        this.fProgramDialogField.setDialogFieldListener(this.adapter);
        this.fProgramDialogField.setLabelText(NewWizardMessages.NewEGLProgramWizardPagePartlabel);
        this.fProgramDialogField.setText(this.getConfiguration().getProgramName());
        this.fProgramDialogField.setEnabled(false);
        this.fProgramDialogField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fProgramDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fProgramDialogField.getTextControl(null));
    }

    private void modifyFileListeners() {
        this.fEGLFileDialogField.getTextControl(null).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProgramWizardPage.this.fProgramDialogField.setText(ProgramWizardPage.this.fEGLFileDialogField.getText());
            }
        });
    }

    private boolean hasMultipleTypesEnabled() {
        return EGLBasePlugin.isVGUI() || EGLBasePlugin.isTUI();
    }

    private void createProgramTypeControls(Composite parent) {
        Composite programTypeComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.nColumns;
        programTypeComposite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        programTypeComposite.setLayoutData((Object)gd);
        GridLayout groupLayout = new GridLayout();
        layout.numColumns = this.nColumns;
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        this.fProgramTypeGroup = new Group(programTypeComposite, 0);
        this.fProgramTypeGroup.setText(NewWizardMessages.NewEGLProgramWizardPageProgramTypeLabel);
        this.fProgramTypeGroup.setLayout((Layout)groupLayout);
        this.fProgramTypeGroup.setLayoutData((Object)gd);
        this.fBasicProgramButton = new Button((Composite)this.fProgramTypeGroup, 16);
        this.fBasicProgramButton.setText(NewWizardMessages.NewEGLProgramWizardPageProgramTypeBasic);
        this.fBasicProgramButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ProgramWizardPage.this.fCalledProgramButton.isEnabled()) {
                    ProgramWizardPage.this.fCalledProgramButton.setEnabled(true);
                }
                if (ProgramWizardPage.this.fCalledProgramButton.getSelection()) {
                    ProgramWizardPage.this.getConfiguration().setProgramType(0);
                } else {
                    ProgramWizardPage.this.getConfiguration().setProgramType(1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.progType == 1 || this.progType == 0) {
            this.fBasicProgramButton.setSelection(true);
        } else {
            this.fBasicProgramButton.setSelection(false);
        }
        if (!this.hasMultipleTypesEnabled()) {
            this.fBasicProgramButton.setVisible(false);
            this.fProgramTypeGroup.setVisible(false);
        }
        if (EGLBasePlugin.isTUI()) {
            this.fTextProgramButton = new Button((Composite)this.fProgramTypeGroup, 16);
            this.fTextProgramButton.setText(NewWizardMessages.NewEGLProgramWizardPageProgramTypeText);
            this.fTextProgramButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!ProgramWizardPage.this.fCalledProgramButton.isEnabled()) {
                        ProgramWizardPage.this.fCalledProgramButton.setEnabled(true);
                    }
                    if (ProgramWizardPage.this.fCalledProgramButton.getSelection()) {
                        ProgramWizardPage.this.getConfiguration().setProgramType(2);
                    } else {
                        ProgramWizardPage.this.getConfiguration().setProgramType(3);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (this.progType == 3 || this.progType == 2) {
                this.fTextProgramButton.setSelection(true);
            } else {
                this.fTextProgramButton.setSelection(false);
            }
        }
        if (EGLBasePlugin.isVGUI()) {
            this.fVGWebTransProgramButton = new Button((Composite)this.fProgramTypeGroup, 16);
            this.fVGWebTransProgramButton.setText(NewWizardMessages.NewEGLProgramWizardPageProgramTypeVgwebtrans);
            this.fVGWebTransProgramButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (ProgramWizardPage.this.fCalledProgramButton.getSelection()) {
                        ProgramWizardPage.this.fCalledProgramButton.setSelection(false);
                    }
                    if (ProgramWizardPage.this.fCalledProgramButton.isEnabled()) {
                        ProgramWizardPage.this.fCalledProgramButton.setEnabled(false);
                    }
                    ProgramWizardPage.this.getConfiguration().setProgramType(5);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (this.progType == 5) {
                this.fVGWebTransProgramButton.setSelection(true);
            } else {
                this.fVGWebTransProgramButton.setSelection(false);
            }
        }
        this.fUIProgramButton = new Button((Composite)this.fProgramTypeGroup, 16);
        this.fUIProgramButton.setText(NewWizardMessages.NewEGLProgramWizardPageProgramTypeUI);
        this.fUIProgramButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ProgramWizardPage.this.fCalledProgramButton.getSelection()) {
                    ProgramWizardPage.this.fCalledProgramButton.setSelection(false);
                }
                if (ProgramWizardPage.this.fCalledProgramButton.isEnabled()) {
                    ProgramWizardPage.this.fCalledProgramButton.setEnabled(false);
                }
                ProgramWizardPage.this.getConfiguration().setProgramType(6);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.progType == 6) {
            this.fUIProgramButton.setSelection(true);
        } else {
            this.fUIProgramButton.setSelection(false);
        }
        new Label((Composite)this.fProgramTypeGroup, 0);
        this.fCalledProgramButton = new Button(programTypeComposite, 32);
        this.fCalledProgramButton.setText(NewWizardMessages.NewEGLProgramWizardPageProgramTypeCalled);
        this.fCalledProgramButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean calledSelection = ProgramWizardPage.this.fCalledProgramButton.getSelection();
                if (ProgramWizardPage.this.fBasicProgramButton.getSelection() && calledSelection) {
                    ProgramWizardPage.this.getConfiguration().setProgramType(0);
                } else if (ProgramWizardPage.this.fBasicProgramButton.getSelection() && !calledSelection) {
                    ProgramWizardPage.this.getConfiguration().setProgramType(1);
                }
                if (ProgramWizardPage.this.fTextProgramButton.getSelection() && calledSelection) {
                    ProgramWizardPage.this.getConfiguration().setProgramType(2);
                } else if (ProgramWizardPage.this.fTextProgramButton.getSelection() && !calledSelection) {
                    ProgramWizardPage.this.getConfiguration().setProgramType(3);
                }
                ProgramWizardPage.this.progType = ProgramWizardPage.this.getConfiguration().getProgramType();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.progType == 4 || this.progType == 5) {
            this.fCalledProgramButton.setEnabled(false);
        } else {
            this.fCalledProgramButton.setEnabled(true);
        }
        if (this.progType == 2 || this.progType == 0) {
            this.fCalledProgramButton.setSelection(true);
        } else {
            this.fCalledProgramButton.setSelection(false);
        }
    }

    private void handleProgramDialogFieldChanged() {
        this.getConfiguration().setProgramName(this.fProgramDialogField.getText());
        this.validatePage();
    }

    @Override
    protected boolean validatePage() {
        if (super.validatePage()) {
            this.fProgramStatus.setOK();
            String partName = this.getConfiguration().getProgramName();
            if (partName.length() == 0) {
                this.fProgramStatus.setError(NewWizardMessages.NewTypeWizardPageErrorEnterPartName);
            } else if (partName.indexOf(46) != -1) {
                this.fProgramStatus.setError(NewWizardMessages.NewTypeWizardPageErrorQualifiedName);
            } else {
                this.validateEGLName(partName, 2, this.fProgramStatus);
            }
            this.updateStatus(new IStatus[]{this.fProgramStatus});
            return this.fProgramStatus.getSeverity() != 4;
        }
        return false;
    }

    @Override
    public void finishPage() {
        super.finishPage();
        IDialogSettings section = this.getDialogSettings().getSection(PAGE_NAME);
        if (section == null) {
            section = this.getDialogSettings().addNewSection(PAGE_NAME);
        }
        section.put(SETTINGS_MAIN_PROGRAM, this.getConfiguration().getProgramType());
    }

    private class ProgramFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private ProgramFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
        }

        @Override
        public void selectionChanged(ListDialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            ProgramWizardPage.this.handleProgramDialogFieldChanged();
        }

        @Override
        public void doubleClicked(ListDialogField field) {
        }
    }
}

