/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.preferences;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.ICompiler;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.preferences.PropertyAndPreferencePage;
import org.eclipse.edt.ide.ui.internal.util.TabFolderLayout;
import org.eclipse.edt.ide.ui.internal.wizards.IStatusChangeListener;
import org.eclipse.edt.ide.ui.preferences.CompilerAndGeneratorControls;
import org.eclipse.edt.ide.ui.preferences.IGeneratorTabProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.osgi.service.prefs.BackingStoreException;

public class CompilerPropertyAndPreferencePage
extends PropertyAndPreferencePage {
    public static final String PROP_ID = "org.eclipse.edt.ide.ui.projectCompilerPropertyPage";
    public static final String EXTENSIONPOINT_GENERATOR_TABS = "org.eclipse.edt.ide.ui.edtGeneratorTabs";
    public static final String GENERATOR_TAB = "generatorTab";
    public static final String GENERAL_TAB = "generalTab";
    public static final String GENERATOR_TAB_GENERATOR_ID = "generatorId";
    public static final String GENERAL_TAB_NAME = "tabName";
    public static final String GENERAL_TAB_COMPILER_ID = "compilerId";
    public static final String TAB_CLASS = "class";
    private IResource resource;
    private CompilerAndGeneratorControls compilerAndGeneratorControls;
    private String selectedCompiler = new String();
    private List<String> selectedGenerators = new ArrayList<String>();
    protected TabFolder tabFolder;
    protected Composite tabComposite;
    protected List<TabItem> currTabItems = new ArrayList<TabItem>();
    protected List<IGeneratorTabProvider> currTabProviders = new ArrayList<IGeneratorTabProvider>();
    protected List<IGeneratorTabProvider> allTabProviders = new ArrayList<IGeneratorTabProvider>();
    protected String defaultWSCompilerId;
    private IStatusChangeListener statusChangeListener;
    protected StatusInfo latestStatus = new StatusInfo();

    public CompilerPropertyAndPreferencePage() {
        this.statusChangeListener = this.getNewStatusChangedListener();
    }

    protected Composite createPreferenceContent(Composite parent) {
        this.initialize();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData data = new GridData(4);
        data.horizontalIndent = 0;
        data.verticalAlignment = 4;
        composite.setLayoutData((Object)data);
        if (this.resource == null && !this.isValidWorkspaceExtensions()) {
            return composite;
        }
        this.compilerAndGeneratorControls = new CompilerAndGeneratorControls(this);
        if (this.resource == null) {
            if (this.getPreferencePageCompilerId() == "org.eclipse.edt.ide.ui.compiler.selection") {
                this.setSelectedCompiler(this.convertCompilerIdToName(this.defaultWSCompilerId));
                this.createCompilerComposite(composite);
            } else if (this.getPreferencePageCompilerId().length() > 0) {
                ArrayList<String> genNamesInCompiler = new ArrayList<String>();
                List<String> genList = this.getWorkspaceSelectedGenerators();
                for (String genName : genList) {
                    if (!this.isGeneratorForCompiler(this.convertGeneratorNameToId(genName), this.getPreferencePageCompilerId())) continue;
                    genNamesInCompiler.add(genName);
                }
                this.setSelectedGenerators(new ArrayList<String>(genNamesInCompiler));
                this.createGeneratorsComposite(composite);
                this.createGeneratorTabsComposite(composite);
                this.createTabProviders();
                this.addCompilerTabs(this.convertCompilerIdToName(this.getPreferencePageCompilerId()));
            }
        } else {
            IProject project = this.resource.getProject();
            this.setSelectedCompiler(this.getCompilerName(project));
            this.createCompilerComposite(composite);
            this.validateGenerators();
            if (this.latestStatus.isOK()) {
                this.setSelectedGenerators(this.getGeneratorNames());
                this.createGeneratorsComposite(composite);
                this.createGeneratorTabsComposite(composite);
                this.createTabProviders();
                this.addCompilerTabs(this.selectedCompiler);
            }
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected boolean isValidWorkspaceExtensions() {
        String id;
        this.validateCompilers();
        if (!this.latestStatus.isOK()) {
            return false;
        }
        this.defaultWSCompilerId = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString(GENERAL_TAB_COMPILER_ID);
        if (this.defaultWSCompilerId != null & this.defaultWSCompilerId.length() > 0 && !this.validateCompilerExists(this.defaultWSCompilerId)) {
            this.promptForNewCompiler(this.defaultWSCompilerId);
            if (!this.latestStatus.isOK()) {
                return false;
            }
            this.defaultWSCompilerId = this.getFirstValidCompiler();
        }
        if (this.resource == null && (id = this.getPreferencePageCompilerId()) != "org.eclipse.edt.ide.ui.compiler.selection") {
            if (!this.validateCompilerExists(id)) {
                String message = MessageFormat.format((String)UINlsStrings.CompilerPreferencePage_compilerNoLongerExistsError, (Object[])new Object[]{id});
                this.latestStatus.setWarning(message);
                this.statusChangeListener.statusChanged(this.latestStatus);
                return false;
            }
            this.validateGenerators();
            if (!this.latestStatus.isOK()) {
                return false;
            }
            this.validateWSSelectedGeneratorsExist();
            if (!this.latestStatus.isOK()) {
                return false;
            }
        }
        return true;
    }

    protected boolean isValidCompilers() {
        this.validateCompilers();
        return this.latestStatus.isOK();
    }

    protected boolean isValidGenerators() {
        this.validateGenerators();
        return this.latestStatus.isOK();
    }

    protected void validateCompilers() {
        ICompiler[] availableCompilers = EDTCoreIDEPlugin.getPlugin().getCompilers();
        ArrayList<String> compilerIds = new ArrayList<String>();
        ArrayList<String> compilerNames = new ArrayList<String>();
        ICompiler[] iCompilerArray = availableCompilers;
        int n = availableCompilers.length;
        int n2 = 0;
        while (n2 < n) {
            ICompiler comp = iCompilerArray[n2];
            if (compilerNames.contains(comp.getName())) {
                this.latestStatus.setWarning(MessageFormat.format((String)UINlsStrings.CompilerPreferencePage_duplicateCompilerNames, (Object[])new Object[]{comp.getName()}));
                this.statusChangeListener.statusChanged(this.latestStatus);
            } else {
                compilerNames.add(comp.getName());
            }
            if (compilerIds.contains(comp.getId())) {
                this.latestStatus.setWarning(MessageFormat.format((String)UINlsStrings.CompilerPreferencePage_duplicateCompilerIds, (Object[])new Object[]{comp.getId()}));
                this.statusChangeListener.statusChanged(this.latestStatus);
            } else {
                compilerIds.add(comp.getId());
            }
            ++n2;
        }
    }

    protected boolean validateCompilerExists(String id) {
        ICompiler[] availableCompilers;
        ICompiler[] iCompilerArray = availableCompilers = EDTCoreIDEPlugin.getPlugin().getCompilers();
        int n = availableCompilers.length;
        int n2 = 0;
        while (n2 < n) {
            ICompiler comp = iCompilerArray[n2];
            if (comp.getId().equalsIgnoreCase(id)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void validateGenerators() {
        ICompiler[] availableCompilers;
        ICompiler[] iCompilerArray = availableCompilers = EDTCoreIDEPlugin.getPlugin().getCompilers();
        int n = availableCompilers.length;
        int n2 = 0;
        while (n2 < n) {
            ICompiler compiler = iCompilerArray[n2];
            List availableGenerators = compiler.getGenerators();
            ArrayList<String> generatorIds = new ArrayList<String>();
            ArrayList<String> generatorNames = new ArrayList<String>();
            for (IGenerator gen : availableGenerators) {
                if (generatorNames.contains(gen.getName())) {
                    this.latestStatus.setWarning(MessageFormat.format((String)UINlsStrings.CompilerPreferencePage_duplicateGeneratorNames, (Object[])new Object[]{gen.getName()}));
                    this.statusChangeListener.statusChanged(this.latestStatus);
                } else {
                    generatorNames.add(gen.getName());
                }
                if (generatorIds.contains(gen.getId())) {
                    this.latestStatus.setWarning(MessageFormat.format((String)UINlsStrings.CompilerPreferencePage_duplicateGeneratorIds, (Object[])new Object[]{gen.getId()}));
                    this.statusChangeListener.statusChanged(this.latestStatus);
                    continue;
                }
                generatorIds.add(gen.getId());
            }
            ++n2;
        }
    }

    protected boolean validateWSSelectedGeneratorsExist() {
        IGenerator[] availableGens = EDTCoreIDEPlugin.getPlugin().getGenerators();
        List<IGenerator> availableGensList = Arrays.asList(availableGens);
        List<String> selectedGens = this.getWorkspaceSelectedGenerators();
        for (String genName : selectedGens) {
            String id = this.convertGeneratorNameToId(genName);
            IGenerator gen = this.getGeneratorFromId(id);
            if (availableGensList.contains(gen)) continue;
            return false;
        }
        return true;
    }

    protected void promptForNewCompiler(String errorCompilerId) {
        String message = MessageFormat.format((String)UINlsStrings.CompilerPreferencePage_compilerNoLongerAvailable, (Object[])new Object[]{errorCompilerId});
        MessageDialog dialog = new MessageDialog(this.getShell(), UINlsStrings.CompilerPreferencePage_compilerNoLongerAvailable_title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 2){

            protected int getMinimumMessageWidth() {
                return this.convertHorizontalDLUsToPixels(450);
            }

            protected Control createCustomArea(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                composite.setLayout((Layout)layout);
                GridData gridData = new GridData(4, 4, false, false);
                gridData.widthHint = this.getMinimumMessageWidth();
                composite.setLayoutData((Object)gridData);
                return composite;
            }
        };
        int res = dialog.open();
        if (res == 1) {
            this.latestStatus.setWarning(MessageFormat.format((String)UINlsStrings.CompilerPreferencePage_cannotDisplayCompiler, (Object[])new Object[]{errorCompilerId}));
            this.statusChangeListener.statusChanged(this.latestStatus);
        }
    }

    protected void initialize() {
        this.setDescription(UINlsStrings.CompilerPreferencePage_description);
    }

    protected void createCompilerComposite(Composite composite) {
        this.compilerAndGeneratorControls.createCompilersComposite(composite);
    }

    protected void createGeneratorsComposite(Composite composite) {
        this.compilerAndGeneratorControls.createGeneratorsComposite(composite);
    }

    protected void createGeneratorTabsComposite(Composite composite) {
        this.tabComposite = new Composite(composite, 0);
        GridLayout tabLayout = new GridLayout();
        tabLayout.marginWidth = 0;
        tabLayout.numColumns = 1;
        this.tabComposite.setLayout((Layout)tabLayout);
        this.tabComposite.setLayoutData((Object)new GridData(1808));
        this.tabFolder = new TabFolder(this.tabComposite, 0);
        this.tabFolder.setLayout((Layout)new TabFolderLayout());
        this.tabFolder.setLayoutData((Object)new GridData(1808));
    }

    protected List<String> getWorkspaceSelectedGenerators() {
        String genString = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("generatorIds");
        if (genString != null && genString.length() > 0 && (genString = genString.trim()).length() != 0) {
            String[] gens = genString.split(",");
            int i = 0;
            while (i < gens.length) {
                gens[i] = this.convertGeneratorIdToName(gens[i].trim());
                ++i;
            }
            return new ArrayList<String>(Arrays.asList(gens));
        }
        return new ArrayList<String>();
    }

    protected void createTabProviders() {
        IConfigurationElement[] generatorTabContributions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSIONPOINT_GENERATOR_TABS);
        if (generatorTabContributions != null) {
            IConfigurationElement[] iConfigurationElementArray = generatorTabContributions;
            int n = generatorTabContributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement currContribution = iConfigurationElementArray[n2];
                String generatorId = null;
                String compilerId = currContribution.getAttribute(GENERAL_TAB_COMPILER_ID);
                if (compilerId == null) {
                    IGenerator[] gens;
                    generatorId = currContribution.getAttribute(GENERATOR_TAB_GENERATOR_ID);
                    IGenerator[] iGeneratorArray = gens = EDTCoreIDEPlugin.getPlugin().getGenerators();
                    int n3 = gens.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IGenerator gen = iGeneratorArray[n4];
                        if (gen.getId().equalsIgnoreCase(generatorId)) {
                            compilerId = gen.getCompiler().getId();
                            break;
                        }
                        ++n4;
                    }
                }
                try {
                    Object o = currContribution.createExecutableExtension(TAB_CLASS);
                    if (o instanceof IGeneratorTabProvider) {
                        String name;
                        IGeneratorTabProvider newTabProvider = (IGeneratorTabProvider)o;
                        if (this.resource != null) {
                            newTabProvider.setResource(this.resource);
                        }
                        newTabProvider.setStatusChangeListener(this.getNewStatusChangedListener());
                        if (compilerId != null) {
                            newTabProvider.setCompilerId(compilerId);
                        }
                        if (generatorId != null) {
                            newTabProvider.setGeneratorId(generatorId);
                            name = this.convertGeneratorIdToName(generatorId);
                            newTabProvider.setTitle(name);
                        } else {
                            name = currContribution.getAttribute(GENERAL_TAB_NAME);
                            newTabProvider.setTitle(name);
                        }
                        if (!this.allTabProviders.contains(newTabProvider)) {
                            this.allTabProviders.add(newTabProvider);
                        }
                    }
                }
                catch (CoreException ce) {
                    EDTUIPlugin.log(ce);
                }
                ++n2;
            }
        }
    }

    protected void addCompilerTabs(String compilerName) {
        int i = 0;
        while (i < this.allTabProviders.size()) {
            IGeneratorTabProvider tabProvider = this.allTabProviders.get(i);
            String title = tabProvider.getTitle();
            boolean compilerOk = false;
            boolean generalTab = false;
            if (tabProvider.getGeneratorId() == null) {
                if (tabProvider.getCompilerId().equalsIgnoreCase(this.convertCompilerNameToId(compilerName))) {
                    compilerOk = true;
                    generalTab = true;
                }
            } else {
                compilerOk = this.isGeneratorForCompiler(this.convertGeneratorNameToId(title), this.convertCompilerNameToId(compilerName));
            }
            if (compilerOk && (this.selectedGenerators.contains(title) || generalTab)) {
                this.addTabItemForProvider(this.allTabProviders.get(i));
            }
            ++i;
        }
        if (this.currTabItems.size() > 1) {
            this.tabFolder.setSelection(0);
        }
    }

    protected void addGeneratorTab(String genName) {
        IGeneratorTabProvider provider = this.getGenTabProviderForName(genName);
        if (provider != null) {
            this.addTabItemForProvider(provider);
        }
    }

    protected void addTabItemForProvider(IGeneratorTabProvider provider) {
        TabItem item = new TabItem(this.tabFolder, 0);
        int index = this.allTabProviders.indexOf(provider);
        item.setText(this.allTabProviders.get(index).getTitle());
        if (provider.getImage() != null) {
            item.setImage(provider.getImage());
        }
        item.setControl(provider.getTabContent((Composite)this.tabFolder));
        this.currTabItems.add(item);
        this.currTabProviders.add(provider);
        this.tabFolder.setSelection(item);
    }

    protected IGeneratorTabProvider getGenTabProviderForName(String genName) {
        int i = 0;
        while (i < this.allTabProviders.size()) {
            if (this.allTabProviders.get(i).getTitle().equalsIgnoreCase(genName)) {
                return this.allTabProviders.get(i);
            }
            ++i;
        }
        return null;
    }

    protected List<IConfigurationElement> getTabContributionsForSelectedCompiler() {
        ArrayList<IConfigurationElement> tabContrs = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] generatorTabContributions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSIONPOINT_GENERATOR_TABS);
        if (generatorTabContributions != null) {
            IConfigurationElement[] iConfigurationElementArray = generatorTabContributions;
            int n = generatorTabContributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement currContribution = iConfigurationElementArray[n2];
                String compilerId = currContribution.getAttribute(GENERAL_TAB_COMPILER_ID);
                if (compilerId == null) {
                    IGenerator[] gens;
                    String generatorId = currContribution.getAttribute(GENERATOR_TAB_GENERATOR_ID);
                    IGenerator[] iGeneratorArray = gens = EDTCoreIDEPlugin.getPlugin().getGenerators();
                    int n3 = gens.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IGenerator gen = iGeneratorArray[n4];
                        if (gen.getId().equalsIgnoreCase(generatorId)) {
                            compilerId = gen.getCompiler().getId();
                            break;
                        }
                        ++n4;
                    }
                }
                if (this.resource != null) {
                    if (this.convertCompilerNameToId(this.selectedCompiler).equalsIgnoreCase(compilerId)) {
                        tabContrs.add(currContribution);
                    }
                } else if (this.getPreferencePageCompilerId().equalsIgnoreCase(compilerId)) {
                    tabContrs.add(currContribution);
                }
                ++n2;
            }
        }
        return tabContrs;
    }

    protected List<IConfigurationElement> getTabContributions() {
        ArrayList<IConfigurationElement> tabContrs = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] generatorTabContributions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSIONPOINT_GENERATOR_TABS);
        if (generatorTabContributions != null) {
            IConfigurationElement[] iConfigurationElementArray = generatorTabContributions;
            int n = generatorTabContributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement currContribution = iConfigurationElementArray[n2];
                String compilerId = currContribution.getAttribute(GENERAL_TAB_COMPILER_ID);
                if (compilerId == null) {
                    IGenerator[] gens;
                    String generatorId = currContribution.getAttribute(GENERATOR_TAB_GENERATOR_ID);
                    IGenerator[] iGeneratorArray = gens = EDTCoreIDEPlugin.getPlugin().getGenerators();
                    int n3 = gens.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IGenerator gen = iGeneratorArray[n4];
                        if (gen.getId().equalsIgnoreCase(generatorId)) {
                            compilerId = gen.getCompiler().getId();
                            break;
                        }
                        ++n4;
                    }
                }
                tabContrs.add(currContribution);
                ++n2;
            }
        }
        return tabContrs;
    }

    protected void removeCurrentCompilerTabs() {
        for (TabItem currItem : this.currTabItems) {
            currItem.dispose();
        }
        this.currTabProviders.clear();
        this.currTabItems.clear();
    }

    protected void removeGeneratorTab(String genName) {
        int i = 0;
        while (i < this.currTabItems.size()) {
            TabItem currItem = this.currTabItems.get(i);
            if (currItem.getText().equalsIgnoreCase(genName)) {
                currItem.dispose();
                this.currTabItems.remove(i);
                this.currTabProviders.remove(i);
                break;
            }
            ++i;
        }
    }

    @Override
    protected String getPreferencePageID() {
        ICompiler[] compilers;
        String compilerId = this.convertCompilerNameToId(this.selectedCompiler);
        ICompiler[] iCompilerArray = compilers = EDTCoreIDEPlugin.getPlugin().getCompilers();
        int n = compilers.length;
        int n2 = 0;
        while (n2 < n) {
            ICompiler currCompiler = iCompilerArray[n2];
            if (currCompiler.getId().equalsIgnoreCase(compilerId)) {
                return currCompiler.getPreferencePageId();
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected String getPropertyPageID() {
        return PROP_ID;
    }

    protected String getPreferencePageCompilerId() {
        return "";
    }

    @Override
    protected boolean hasProjectSpecificOptions(IProject project) {
        return project == null || !this.useDefaultCompilerAndGenerators(project);
    }

    protected boolean useDefaultCompilerAndGenerators(IProject project) {
        return ProjectSettingsUtility.getCompilerId((IProject)project) == null && ProjectSettingsUtility.getGeneratorIds((IResource)project) == null;
    }

    public void performApply() {
        if (this.resource != null && !this.useProjectSettings()) {
            try {
                ProjectSettingsUtility.setCompiler((IProject)this.getProject(), null);
                ProjectSettingsUtility.setGeneratorIds((IResource)this.getProject(), null);
                for (IGeneratorTabProvider tabProvider : this.allTabProviders) {
                    tabProvider.removePreferencesForAResource();
                }
            }
            catch (BackingStoreException e) {
                EDTUIPlugin.log(e);
            }
            return;
        }
        for (IGeneratorTabProvider currProvider : this.currTabProviders) {
            currProvider.performApply();
        }
        this.storeValues();
        if (this.resource != null) {
            this.removeTabPropertiesFromProjectResources();
        }
    }

    @Override
    public void performDefaults() {
        if (this.resource == null) {
            if (this.getPreferencePageCompilerId() == "org.eclipse.edt.ide.ui.compiler.selection") {
                String defaultCompilerId = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getDefaultString(GENERAL_TAB_COMPILER_ID);
                this.setSelectedCompiler(this.convertCompilerIdToName(defaultCompilerId));
                this.compilerAndGeneratorControls.getCompilerComponent().selectCompiler(this.selectedCompiler);
            } else {
                String genString = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getDefaultString("generatorIds");
                if (genString != null && (genString = genString.trim()).length() != 0) {
                    String[] gens = genString.split(",");
                    int i = 0;
                    while (i < gens.length) {
                        gens[i] = this.convertGeneratorIdToName(gens[i].trim());
                        ++i;
                    }
                    this.clearSelectedGenerators();
                    this.setSelectedGenerators(new ArrayList<String>(Arrays.asList(gens)));
                }
                this.compilerAndGeneratorControls.getCompilerComponent().showCompilerPreferencePageBookPage();
                for (IGeneratorTabProvider currProvider : this.currTabProviders) {
                    currProvider.performDefaults();
                }
            }
        } else {
            if (!this.useProjectSettings()) {
                return;
            }
            boolean useProjectSettings = this.hasProjectSpecificOptions(this.getProject());
            this.enableProjectSpecificSettings(useProjectSettings);
            this.setSelectedCompiler(this.getCompilerName(this.getProject()));
            this.setSelectedGenerators(this.getGeneratorNames());
            this.compilerAndGeneratorControls.getCompilerComponent().showCompilerPropertyPageBookPage(this.selectedCompiler);
            this.removeCurrentCompilerTabs();
            this.addCompilerTabs(this.selectedCompiler);
            for (IGeneratorTabProvider currProvider : this.currTabProviders) {
                currProvider.performDefaults();
            }
        }
    }

    public boolean performCancel() {
        if (this.resource != null && !this.useProjectSettings()) {
            return true;
        }
        boolean retValue = true;
        for (IGeneratorTabProvider currProvider : this.currTabProviders) {
            if (currProvider.performCancel()) continue;
            retValue = false;
        }
        return retValue;
    }

    public boolean performOk() {
        if (this.resource != null && !this.useProjectSettings()) {
            try {
                ProjectSettingsUtility.setCompiler((IProject)this.getProject(), null);
                ProjectSettingsUtility.setGeneratorIds((IResource)this.getProject(), null);
                for (IGeneratorTabProvider tabProvider : this.allTabProviders) {
                    tabProvider.removePreferencesForAResource();
                }
                return true;
            }
            catch (BackingStoreException e) {
                EDTUIPlugin.log(e);
                return false;
            }
        }
        boolean retValue = true;
        for (IGeneratorTabProvider currProvider : this.currTabProviders) {
            if (currProvider.performOk()) continue;
            retValue = false;
        }
        this.storeValues();
        if (this.resource != null) {
            this.removeTabPropertiesFromProjectResources();
        }
        return retValue;
    }

    protected void storeValues() {
        if (this.resource == null) {
            if (this.getPreferencePageCompilerId() == "org.eclipse.edt.ide.ui.compiler.selection") {
                String id;
                if (this.selectedCompiler.length() > 0 && (id = this.convertCompilerNameToId(this.selectedCompiler)).length() > 0) {
                    EDTCoreIDEPlugin.getPlugin().getPreferenceStore().setValue(GENERAL_TAB_COMPILER_ID, id);
                }
            } else {
                String[] genIds = new String[this.selectedGenerators.size()];
                int index = 0;
                StringBuilder buffer = new StringBuilder(100);
                for (String genName : this.selectedGenerators) {
                    genIds[index] = this.convertGeneratorNameToId(genName);
                    if (index != 0) {
                        buffer.append(',');
                    }
                    buffer.append(genIds[index]);
                    ++index;
                }
                this.replaceGeneratorsInPrefStoreForCompiler(this.getPreferencePageCompilerId(), buffer.toString());
            }
        } else {
            try {
                String compilerId = this.convertCompilerNameToId(this.selectedCompiler);
                String previousCompilerId = ProjectSettingsUtility.getCompilerId((IProject)this.getProject());
                if (!compilerId.equalsIgnoreCase(previousCompilerId)) {
                    if (previousCompilerId != null) {
                        IEclipsePreferences prefs = new ProjectScope(this.getProject()).getNode(EDTCoreIDEPlugin.PLUGIN_ID);
                        this.removePreferencesForAllResources(prefs, "generatorIds");
                        for (String genName : this.selectedGenerators) {
                            IGeneratorTabProvider tabProvider = this.getGenTabProviderForName(genName);
                            tabProvider.removePreferencesForAllResources();
                        }
                    }
                    ProjectSettingsUtility.setCompiler((IProject)this.getProject(), (String)compilerId);
                }
                ArrayList<String> genIds = new ArrayList<String>();
                ArrayList<String> newSelectedGens = new ArrayList<String>();
                for (String genName : this.selectedGenerators) {
                    String id = this.convertGeneratorNameToId(genName);
                    IGenerator gen = this.getGeneratorFromId(id);
                    if (this.resource instanceof IProject && !gen.getCompiler().getId().equalsIgnoreCase(compilerId)) continue;
                    genIds.add(this.convertGeneratorNameToId(genName));
                    newSelectedGens.add(genName);
                }
                ProjectSettingsUtility.setGeneratorIds((IResource)this.resource, (String[])genIds.toArray(new String[genIds.size()]));
                this.setSelectedGenerators(newSelectedGens);
            }
            catch (BackingStoreException e) {
                EDTUIPlugin.log(e);
            }
        }
    }

    protected IGenerator getGeneratorFromId(String generatorId) {
        IGenerator[] gens;
        IGenerator[] iGeneratorArray = gens = EDTCoreIDEPlugin.getPlugin().getGenerators();
        int n = gens.length;
        int n2 = 0;
        while (n2 < n) {
            IGenerator gen = iGeneratorArray[n2];
            if (gen.getId().equalsIgnoreCase(generatorId)) {
                return gen;
            }
            ++n2;
        }
        return null;
    }

    protected boolean isSelectedGeneratorsSameAsDefault(List<String> newSelectedGens) {
        String defaultGens = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("generatorIds");
        if (defaultGens != null && defaultGens.length() > 0 && (defaultGens = defaultGens.trim()).length() != 0) {
            String[] gens = defaultGens.split(",");
            if (gens.length != newSelectedGens.size()) {
                return false;
            }
            int i = 0;
            while (i < gens.length) {
                gens[i] = gens[i].trim();
                if (!newSelectedGens.contains(gens[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean isGeneratorForCompiler(String genId, String compilerId) {
        IGenerator gen = this.getGeneratorFromId(genId);
        return gen != null && gen.getCompiler().getId().equalsIgnoreCase(compilerId);
    }

    protected void replaceGeneratorsInPrefStoreForCompiler(String compilerId, String newGens) {
        String genString = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("generatorIds");
        if (genString != null && genString.length() > 0 && (genString = genString.trim()).length() != 0) {
            String[] gens = genString.split(",");
            ArrayList<String> idsToKeep = new ArrayList<String>();
            int i = 0;
            while (i < gens.length) {
                gens[i] = gens[i].trim();
                IGenerator gen = this.getGeneratorFromId(gens[i]);
                if (!gen.getCompiler().getId().equalsIgnoreCase(compilerId)) {
                    idsToKeep.add(gens[i]);
                }
                ++i;
            }
            if (idsToKeep.size() > 0) {
                StringBuilder buf = new StringBuilder(200);
                int i2 = 0;
                while (i2 < idsToKeep.size()) {
                    if (i2 != 0) {
                        buf.append(',');
                    }
                    buf.append((String)idsToKeep.get(i2));
                    ++i2;
                }
                String gensToStore = newGens.length() > 0 ? String.valueOf(buf.toString()) + ',' + newGens : buf.toString();
                EDTCoreIDEPlugin.getPlugin().getPreferenceStore().setValue("generatorIds", gensToStore);
                return;
            }
        }
        EDTCoreIDEPlugin.getPlugin().getPreferenceStore().setValue("generatorIds", newGens);
    }

    protected void removePreferencesForAllResources(IEclipsePreferences prefs, String propertyId) {
        try {
            String[] stringArray = prefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key.indexOf(propertyId) > -1) {
                    prefs.remove(key);
                }
                ++n2;
            }
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            EDTUIPlugin.log(ex);
        }
    }

    protected void removeTabPropertiesFromProjectResources() {
        int i = 0;
        while (i < this.allTabProviders.size()) {
            IGeneratorTabProvider tabProvider = this.allTabProviders.get(i);
            if (!this.selectedGenerators.contains(tabProvider.getTitle())) {
                tabProvider.removePreferencesForAResource();
            }
            ++i;
        }
    }

    protected String convertCompilerIdToName(String id) {
        if (id != null && id.length() > 0) {
            ICompiler[] compilers;
            ICompiler[] iCompilerArray = compilers = EDTCoreIDEPlugin.getPlugin().getCompilers();
            int n = compilers.length;
            int n2 = 0;
            while (n2 < n) {
                ICompiler currentCompiler = iCompilerArray[n2];
                if (currentCompiler.getId().equalsIgnoreCase(id)) {
                    return currentCompiler.getName();
                }
                ++n2;
            }
        }
        return "";
    }

    protected String convertGeneratorIdToName(String id) {
        if (id != null && id.length() > 0) {
            IGenerator[] generators;
            IGenerator[] iGeneratorArray = generators = EDTCoreIDEPlugin.getPlugin().getGenerators();
            int n = generators.length;
            int n2 = 0;
            while (n2 < n) {
                IGenerator currentGenerator = iGeneratorArray[n2];
                if (currentGenerator.getId().equalsIgnoreCase(id)) {
                    return currentGenerator.getName();
                }
                ++n2;
            }
        }
        return "";
    }

    protected String[] convertGeneratorIdsToNames(String[] ids) {
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            names.add(this.convertGeneratorIdToName(id));
            ++n2;
        }
        return names.toArray(new String[names.size()]);
    }

    protected String convertCompilerNameToId(String name) {
        if (name != null && name.length() > 0) {
            ICompiler[] compilers;
            ICompiler[] iCompilerArray = compilers = EDTCoreIDEPlugin.getPlugin().getCompilers();
            int n = compilers.length;
            int n2 = 0;
            while (n2 < n) {
                ICompiler currentCompiler = iCompilerArray[n2];
                if (currentCompiler.getName().equalsIgnoreCase(name)) {
                    return currentCompiler.getId();
                }
                ++n2;
            }
        }
        return "";
    }

    protected String convertGeneratorNameToId(String name) {
        if (name != null && name.length() > 0) {
            IGenerator[] generators;
            IGenerator[] iGeneratorArray = generators = EDTCoreIDEPlugin.getPlugin().getGenerators();
            int n = generators.length;
            int n2 = 0;
            while (n2 < n) {
                IGenerator currentGenerator = iGeneratorArray[n2];
                if (currentGenerator.getName().equalsIgnoreCase(name)) {
                    return currentGenerator.getId();
                }
                ++n2;
            }
        }
        return "";
    }

    @Override
    protected IProject getProject() {
        if (this.resource != null) {
            if (this.resource instanceof IProject) {
                return (IProject)this.resource;
            }
            return this.resource.getProject();
        }
        return null;
    }

    protected IResource getResource() {
        return this.resource;
    }

    @Override
    public IAdaptable getElement() {
        return this.resource;
    }

    @Override
    public void setElement(IAdaptable element) {
        this.resource = (IResource)element.getAdapter(IResource.class);
        super.setElement((IAdaptable)this.getProject());
    }

    protected String getSelectedCompiler() {
        return this.selectedCompiler;
    }

    protected void setSelectedCompiler(String compilerName) {
        this.selectedCompiler = compilerName;
    }

    protected void clearSelectedGenerators() {
        this.selectedGenerators.clear();
    }

    protected List<String> getSelectedGenerators() {
        return this.selectedGenerators;
    }

    protected void setSelectedGenerators(List<String> newList) {
        this.selectedGenerators = newList;
    }

    protected void addSelectedGenerator(String genId) {
        if (!this.selectedGenerators.contains(genId)) {
            this.selectedGenerators.add(genId);
        }
    }

    protected void removeSelectedGenerator(String genId) {
        if (this.selectedGenerators.contains(genId)) {
            this.selectedGenerators.remove(genId);
        }
    }

    protected String getFirstValidCompiler() {
        ICompiler[] availableCompilers = EDTCoreIDEPlugin.getPlugin().getCompilers();
        if (availableCompilers.length > 0) {
            return availableCompilers[0].getId();
        }
        return null;
    }

    protected String getCompilerName(IProject project) {
        String compilerId = ProjectSettingsUtility.getCompilerId((IProject)project);
        if (compilerId == null) {
            compilerId = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString(GENERAL_TAB_COMPILER_ID);
        }
        return this.convertCompilerIdToName(compilerId);
    }

    protected List<String> getGeneratorNames() {
        String[] genNames;
        String[] genIds = ProjectSettingsUtility.getGeneratorIds((IResource)this.resource);
        if (genIds != null) {
            genNames = this.convertGeneratorIdsToNames(genIds);
        } else {
            List<String> genList = this.getWorkspaceSelectedGenerators();
            genNames = genList.toArray(new String[genList.size()]);
        }
        return new ArrayList<String>(Arrays.asList(genNames));
    }

    protected boolean isUsingWorkspaceDefaults() {
        String compilerId = ProjectSettingsUtility.getCompilerId((IProject)this.getProject());
        String[] genIds = ProjectSettingsUtility.getGeneratorIds((IResource)this.resource);
        return compilerId == null && genIds == null;
    }
}

