/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.preferences;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.edt.ide.core.Logger;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.FolderSelectionDialog;
import org.eclipse.edt.ide.ui.internal.wizards.IStatusChangeListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.osgi.service.prefs.BackingStoreException;

public class GenerationSettingsComposite
extends Composite {
    protected final IResource resource;
    protected final IPreferenceStore prefStore;
    protected final IEclipsePreferences projectPrefs;
    protected final String propertyID;
    protected final String preferenceID;
    protected final IStatusChangeListener statusListener;
    protected Button radioOutside;
    protected Button radioInside;
    protected Button browseInside;
    protected Button browseOutside;
    protected Text genInsideDirectory;
    protected Text genOutsideDirectory;
    private StatusInfo latestStatus = new StatusInfo();

    public GenerationSettingsComposite(Composite parent, int style, IResource resource, IPreferenceStore prefStore, IEclipsePreferences projectPrefs, String propertyID, String preferenceID, IStatusChangeListener statusListener) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.resource = resource;
        this.prefStore = prefStore;
        this.projectPrefs = projectPrefs;
        this.propertyID = propertyID;
        this.preferenceID = preferenceID;
        this.statusListener = statusListener;
        this.createContents();
        this.init();
    }

    private void createContents() {
        Group group = new Group((Composite)this, 2048);
        group.setText(UINlsStrings.genSettingsGroupLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setFont(this.getFont());
        GridData data = new GridData(1808);
        data.horizontalIndent = 0;
        group.setLayoutData((Object)data);
        if (this.resource == null) {
            Composite c = new Composite((Composite)group, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            c.setLayout((Layout)layout);
            c.setFont(group.getFont());
            data = new GridData(1808);
            data.horizontalIndent = 0;
            c.setLayoutData((Object)data);
            new Label(c, 16384).setText(UINlsStrings.genDefaultGenDir);
            this.genInsideDirectory = new Text(c, 2048);
            data = new GridData(768);
            this.genInsideDirectory.setLayoutData((Object)data);
            if (this.statusListener != null) {
                this.genInsideDirectory.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        String text = GenerationSettingsComposite.this.genInsideDirectory.getText().trim();
                        if (text.length() == 0) {
                            GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationDefaultBlank);
                            GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                        } else if (!new Path(text).isValidPath(text)) {
                            GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationDefaultInvalid);
                            GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                        } else if (text.charAt(0) == '/') {
                            GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationDefaultRetlative);
                            GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                        } else if (GenerationSettingsComposite.this.latestStatus != null && !GenerationSettingsComposite.this.latestStatus.isOK()) {
                            GenerationSettingsComposite.this.latestStatus.setOK();
                            GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                        }
                    }
                });
            }
        } else {
            this.radioInside = new Button((Composite)group, 16);
            this.radioInside.setText(UINlsStrings.genInsideWorkbench);
            data = new GridData(768);
            this.radioInside.setLayoutData((Object)data);
            Composite cIn = new Composite((Composite)group, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            cIn.setLayout((Layout)layout);
            cIn.setFont(group.getFont());
            data = new GridData(768);
            data.horizontalIndent = 15;
            cIn.setLayoutData((Object)data);
            this.genInsideDirectory = new Text(cIn, 2048);
            data = new GridData(768);
            this.genInsideDirectory.setLayoutData((Object)data);
            this.browseInside = new Button(cIn, 8);
            this.browseInside.setText("...");
            this.radioOutside = new Button((Composite)group, 16);
            this.radioOutside.setText(UINlsStrings.genOutsideWorkbench);
            data = new GridData(768);
            this.radioOutside.setLayoutData((Object)data);
            Composite cOut = new Composite((Composite)group, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            cOut.setLayout((Layout)layout);
            cOut.setFont(group.getFont());
            data = new GridData(768);
            data.horizontalIndent = 15;
            cOut.setLayoutData((Object)data);
            this.genOutsideDirectory = new Text(cOut, 2048);
            data = new GridData(768);
            this.genOutsideDirectory.setLayoutData((Object)data);
            this.browseOutside = new Button(cOut, 8);
            this.browseOutside.setText("...");
            this.browseInside.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object result;
                    IResource initialSelection;
                    FolderSelectionDialog dialog = new FolderSelectionDialog(GenerationSettingsComposite.this.browseInside.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                    dialog.setAllowMultiple(false);
                    String currentValue = GenerationSettingsComposite.this.genInsideDirectory.getText();
                    if (currentValue.length() > 0 && (initialSelection = currentValue.charAt(0) == '/' ? ResourcesPlugin.getWorkspace().getRoot().findMember(currentValue) : GenerationSettingsComposite.this.resource.getProject().findMember(currentValue)) != null) {
                        dialog.setInitialSelection(initialSelection);
                    }
                    dialog.setTitle(UINlsStrings.genDirSelectionTitle);
                    dialog.setMessage(UINlsStrings.genDirSelectionMsg);
                    dialog.setInput(ResourcesPlugin.getWorkspace().getRoot());
                    if (dialog.open() == 0 && (result = dialog.getResult()[0]) instanceof IContainer) {
                        IContainer container = (IContainer)result;
                        if (!(container instanceof IProject) && container.getProject().equals((Object)GenerationSettingsComposite.this.resource.getProject())) {
                            GenerationSettingsComposite.this.genInsideDirectory.setText(container.getProjectRelativePath().toString());
                        } else {
                            GenerationSettingsComposite.this.genInsideDirectory.setText(container.getFullPath().toString());
                        }
                    }
                }
            });
            this.browseOutside.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dialog = new DirectoryDialog(GenerationSettingsComposite.this.browseInside.getShell());
                    dialog.setText(UINlsStrings.genDirSelectionTitle);
                    dialog.setMessage(UINlsStrings.genDirSelectionMsg);
                    dialog.setFilterPath(GenerationSettingsComposite.this.genOutsideDirectory.getText());
                    String result = dialog.open();
                    if (result != null) {
                        GenerationSettingsComposite.this.genOutsideDirectory.setText(result);
                    }
                }
            });
            this.radioInside.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GenerationSettingsComposite.this.enableDisableControls();
                }
            });
            this.radioOutside.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GenerationSettingsComposite.this.enableDisableControls();
                }
            });
            if (this.statusListener != null) {
                this.genInsideDirectory.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (GenerationSettingsComposite.this.radioInside.getSelection()) {
                            String text = GenerationSettingsComposite.this.genInsideDirectory.getText().trim();
                            if (text.length() == 0) {
                                GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationBlank);
                                GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                            } else {
                                Path path = new Path(text);
                                if (!path.isValidPath(text)) {
                                    GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationInvalid);
                                    GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                                } else if (!(text.charAt(0) != '/' || path.segmentCount() >= 1 && ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)).exists())) {
                                    GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationProject);
                                    GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                                } else if (GenerationSettingsComposite.this.latestStatus != null && !GenerationSettingsComposite.this.latestStatus.isOK()) {
                                    GenerationSettingsComposite.this.latestStatus.setOK();
                                    GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                                }
                            }
                        }
                    }
                });
                this.genOutsideDirectory.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (GenerationSettingsComposite.this.radioOutside.getSelection()) {
                            if (GenerationSettingsComposite.this.genOutsideDirectory.getText().trim().length() == 0) {
                                GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationBlank);
                                GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                            } else if (GenerationSettingsComposite.this.latestStatus != null && !GenerationSettingsComposite.this.latestStatus.isOK()) {
                                GenerationSettingsComposite.this.latestStatus.setOK();
                                GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                            }
                        }
                    }
                });
            }
        }
    }

    private void init() {
        if (this.resource == null) {
            this.genInsideDirectory.setText(this.prefStore.getString(this.preferenceID));
        } else {
            String genDir = ProjectSettingsUtility.getGenerationDirectory((IResource)this.resource, (IPreferenceStore)this.prefStore, (IEclipsePreferences)this.projectPrefs, (String)this.propertyID, (String)this.preferenceID);
            if (new Path(genDir).isAbsolute()) {
                this.radioOutside.setSelection(true);
                this.radioInside.setSelection(false);
                this.genInsideDirectory.setText("");
                this.genOutsideDirectory.setText(genDir);
            } else {
                this.radioInside.setSelection(true);
                this.radioOutside.setSelection(false);
                genDir = EclipseUtilities.convertFromInternalPath((String)genDir);
                if (genDir.length() == 0) {
                    genDir = this.resource.getProject().getFullPath().toString();
                }
                this.genOutsideDirectory.setText("");
                this.genInsideDirectory.setText(genDir);
            }
            this.enableDisableControls();
        }
    }

    private void enableDisableControls() {
        if (this.radioInside.getSelection()) {
            this.genOutsideDirectory.setEnabled(false);
            this.browseOutside.setEnabled(false);
            this.genInsideDirectory.setEnabled(true);
            this.browseInside.setEnabled(true);
        } else {
            this.genInsideDirectory.setEnabled(false);
            this.browseInside.setEnabled(false);
            this.genOutsideDirectory.setEnabled(true);
            this.browseOutside.setEnabled(true);
        }
    }

    public void performDefaults() {
        this.latestStatus.setOK();
        this.statusListener.statusChanged(this.latestStatus);
        this.init();
    }

    public boolean performOK() {
        if (this.resource == null) {
            this.prefStore.setValue(this.preferenceID, this.genInsideDirectory.getText());
        } else {
            try {
                String value;
                if (this.radioOutside.getSelection()) {
                    value = this.genOutsideDirectory.getText();
                } else {
                    value = this.genInsideDirectory.getText();
                    if (value.equals(this.resource.getProject().getFullPath().toString())) {
                        value = "";
                    }
                    value = EclipseUtilities.convertToInternalPath((String)value);
                }
                ProjectSettingsUtility.setGenerationDirectory((IResource)this.resource, (String)value, (IEclipsePreferences)this.projectPrefs, (String)this.propertyID);
            }
            catch (BackingStoreException e) {
                Logger.log((Object)"GenerationSettingsComposite.performOk", (String)NLS.bind((String)UINlsStrings.genSettingsSaveError, (Object)this.resource.getFullPath().toString()), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void removePreferencesForAResource() {
        try {
            ProjectSettingsUtility.setGenerationDirectory((IResource)this.resource, null, (IEclipsePreferences)this.projectPrefs, (String)this.propertyID);
        }
        catch (BackingStoreException e) {
            Logger.log((Object)"GenerationSettingsComposite.cleanUpResourcePreferences", (String)NLS.bind((String)UINlsStrings.CompilerPropertyPage_errorCleaningUpPrefStore, (Object)this.resource.getFullPath().toString()), (Throwable)e);
        }
    }

    public void removePreferencesForAllResources() {
        try {
            String[] stringArray = this.projectPrefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key.indexOf(this.propertyID) > -1) {
                    this.projectPrefs.remove(key);
                }
                ++n2;
            }
            this.projectPrefs.flush();
        }
        catch (BackingStoreException e) {
            Logger.log((Object)"GenerationSettingsComposite.removePreferencesForAllResources", (String)NLS.bind((String)UINlsStrings.CompilerPropertyPage_errorCleaningUpPrefStore, (Object)this.resource.getFullPath().toString()), (Throwable)e);
        }
    }
}

