/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.wizards.EGLContainerConfiguration;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class EGLPackageConfiguration
extends EGLContainerConfiguration {
    private String fPackage;

    public EGLPackageConfiguration() {
        this.setDefaultAttributes();
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        if (selection == null || selection.isEmpty()) {
            this.setDefaultAttributes();
            return;
        }
        IEGLElement eelem = null;
        if (selection.getFirstElement() instanceof IFolder) {
            eelem = EGLCore.create((IFolder)((IFolder)selection.getFirstElement()));
        }
        if (eelem == null) {
            eelem = this.getInitialEGLElement(selection);
        }
        this.internalInit(eelem);
        String pName = "";
        if (eelem != null) {
            IPackageFragment pf = null;
            if (eelem.getElementType() == 4) {
                pf = (IPackageFragment)eelem;
            } else if (eelem instanceof IEGLFile && eelem.getParent().getElementType() == 4) {
                pf = (IPackageFragment)eelem.getParent();
            }
            if (pf != null && !pf.isDefaultPackage()) {
                pName = pf.getElementName();
            }
        }
        this.setFPackage(pName);
    }

    public String getFPackage() {
        return this.fPackage;
    }

    public void setFPackage(String fragment) {
        this.fPackage = fragment;
    }

    private void internalInit(IEGLElement elem) {
        IPackageFragmentRoot initRoot = null;
        if (elem != null) {
            IEGLProject eproject;
            initRoot = (IPackageFragmentRoot)elem.getAncestor(3);
            if ((initRoot == null || initRoot.isArchive()) && (eproject = elem.getEGLProject()) != null) {
                block7: {
                    try {
                        initRoot = null;
                        if (!eproject.exists()) break block7;
                        IPackageFragmentRoot[] roots = eproject.getPackageFragmentRoots();
                        int i = 0;
                        while (i < roots.length) {
                            if (roots[i].getKind() == 1) {
                                initRoot = roots[i];
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (EGLModelException e) {
                        EGLLogger.log((Object)this, e);
                    }
                }
                if (initRoot == null) {
                    initRoot = eproject.getPackageFragmentRoot(eproject.getResource());
                }
            }
            this.setSourceFolderName(initRoot.getElementName());
        }
    }

    private void setDefaultAttributes() {
        String sourceFolderPath = "";
        if (!this.getProjectName().equals("") && this.getSourceFolderName().equals("")) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
            IEGLProject eProject = EGLCore.create((IProject)project);
            try {
                IPackageFragmentRoot[] roots = eProject.getAllPackageFragmentRoots();
                if (roots.length > 0) {
                    sourceFolderPath = roots[0].getElementName();
                }
            }
            catch (EGLModelException e) {
                EGLLogger.log((Object)this, e);
            }
        }
        this.setSourceFolderName(sourceFolderPath);
        this.fPackage = "";
    }
}

