/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ImportRUIProjectsOperation
extends WorkspaceModifyOperation {
    private static final String RUI_RESOURCES_FOLDER = "/org.eclipse.edt.ide.ui.rui/";
    private static final String EGL_RESOURCES_FOLDER = "org.eclipse.edt.ide.ui.resources";
    private String widgetsProjectName;
    private String dojoWidgetsProjectName;
    private String dojoRuntimeProjectName;

    public ImportRUIProjectsOperation(ISchedulingRule rule, String widgetProject, String dojoWidgetProject, String dojoRuntimeProjectName) {
        super(rule);
        this.widgetsProjectName = widgetProject;
        this.dojoWidgetsProjectName = dojoWidgetProject;
        this.dojoRuntimeProjectName = dojoRuntimeProjectName;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        if (this.widgetsProjectName != null) {
            this.importWidgetsProject(monitor, this.widgetsProjectName);
        }
        if (this.dojoWidgetsProjectName != null) {
            this.importWidgetsProject(monitor, this.dojoWidgetsProjectName);
        }
        if (this.dojoRuntimeProjectName != null) {
            this.importWidgetsProject(monitor, this.dojoRuntimeProjectName);
        }
    }

    private void importWidgetsProject(IProgressMonitor monitor, String projectName) {
        IProject widgetsProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!widgetsProject.exists()) {
            try {
                this.unzipWidgets(projectName);
                if (!widgetsProject.exists()) {
                    widgetsProject.create(monitor);
                }
                if (!widgetsProject.isOpen()) {
                    widgetsProject.open(monitor);
                }
                EGLCore.create((IProject)widgetsProject);
                widgetsProject.refreshLocal(2, monitor);
                IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
                if (!description.isAutoBuilding()) {
                    widgetsProject.build(6, monitor);
                }
            }
            catch (Exception e) {
                EGLLogger.log((Object)this, e);
            }
        }
    }

    private void unzipWidgets(String projectName) throws IOException {
        URL url = FileLocator.resolve((URL)Platform.getBundle((String)EGL_RESOURCES_FOLDER).getEntry(RUI_RESOURCES_FOLDER + projectName + ".zip"));
        if (url != null) {
            IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            ZipFile sampleSource = new ZipFile(url.getFile());
            try {
                Enumeration<? extends ZipEntry> entries = sampleSource.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(projectName)) continue;
                    if (entry.isDirectory()) {
                        workspaceLocation.append(entry.getName()).toFile().mkdir();
                        continue;
                    }
                    File file = workspaceLocation.append(entry.getName()).toFile();
                    file.getParentFile().mkdirs();
                    BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(file));
                    InputStream inStream = sampleSource.getInputStream(entry);
                    try {
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = inStream.read(buffer)) >= 0) {
                            ((OutputStream)outStream).write(buffer, 0, len);
                        }
                    }
                    finally {
                        ((OutputStream)outStream).close();
                        inStream.close();
                    }
                }
            }
            finally {
                sampleSource.close();
            }
        }
    }
}

