/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.compiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.CancelledException;
import org.eclipse.edt.compiler.internal.core.builder.CircularBuildRequestException;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;

public abstract class AbstractProcessingQueue {
    public static final int LEVEL_THREE = 3;
    public static final int LEVEL_TWO = 2;
    public static final int LEVEL_ONE = 1;
    protected LinkedHashMap pendingUnits = new LinkedHashMap();
    private Stack processingStack = new Stack();
    private HashMap unitsBeingProcessedToCompileLevel = new HashMap();
    private HashSet processedUnits = new HashSet();
    protected ICompilerOptions compilerOptions;
    protected IBuildNotifier notifier;
    protected int unitsCompiled = 0;
    private int compileThreshold = 0;
    protected int compileLoop = 0;
    private float increment = 0.4f;
    public int totalUnitsCompiled = 0;
    public int numRequestsDenied = 0;
    public int numCompilesAborted = 0;
    public long startTime = 0L;
    public int numTopLevelFunctionsCompiled = 0;
    public int numErrorsReported = 0;
    public static final boolean DEBUG = false;

    public AbstractProcessingQueue(IBuildNotifier notifier, ICompilerOptions compilerOptions) {
        this.notifier = notifier;
        this.compilerOptions = compilerOptions;
    }

    public void addPart(String[] packageName, String caseSensitiveInternedPartName) {
        this.pendingUnits.put(new ProcessingUnitKey(packageName, InternUtil.intern((String)caseSensitiveInternedPartName)), new ProcessingUnit(packageName, caseSensitiveInternedPartName));
    }

    public boolean isPending(String[] packageName, String caseInsensitiveInternedPartName) {
        return this.pendingUnits.containsKey(new ProcessingUnitKey(packageName, caseInsensitiveInternedPartName));
    }

    private void initProgress() {
        ++this.compileLoop;
        this.compileThreshold = this.pendingUnits.size();
        this.unitsCompiled = 0;
        if (this.compileThreshold > 0) {
            this.notifier.setProgressPerEGLPart(this.increment / (float)this.compileThreshold);
        }
        this.increment /= 2.0f;
    }

    private void updateProgress() {
        this.notifier.compiled();
        ++this.unitsCompiled;
        if (this.unitsCompiled == this.compileThreshold && !this.pendingUnits.isEmpty()) {
            this.initProgress();
        }
    }

    protected abstract boolean hasExceededMaxLoop();

    public void process() {
        this.initProgress();
        while (!this.pendingUnits.isEmpty()) {
            if (this.hasExceededMaxLoop()) {
                this.notifier.setAborted(true);
                return;
            }
            Iterator iterator = this.pendingUnits.values().iterator();
            ProcessingUnit processingUnit = (ProcessingUnit)iterator.next();
            this.process(processingUnit, 3);
        }
    }

    public IPartBinding process(ProcessingUnit processingUnit, int compileLevel) {
        IPartBinding result = null;
        this.processingStack.add(new ProcessingUnitKey(processingUnit.packageName, InternUtil.intern((String)processingUnit.caseSensitiveInternedPartName)));
        this.unitsBeingProcessedToCompileLevel.put(new ProcessingUnitKey(processingUnit.packageName, InternUtil.intern((String)processingUnit.caseSensitiveInternedPartName)), new Integer(compileLevel));
        try {
            switch (compileLevel) {
                case 3: {
                    this.pendingUnits.remove(new ProcessingUnitKey(processingUnit.packageName, InternUtil.intern((String)processingUnit.caseSensitiveInternedPartName)));
                    result = this.level03Compile(processingUnit.packageName, processingUnit.caseSensitiveInternedPartName);
                    this.updateProgress();
                    this.processedUnits.add(new ProcessingUnitKey(processingUnit.packageName, InternUtil.intern((String)processingUnit.caseSensitiveInternedPartName)));
                    break;
                }
                case 2: {
                    result = this.level02Compile(processingUnit.packageName, processingUnit.caseSensitiveInternedPartName);
                    break;
                }
                case 1: {
                    result = this.level01Compile(processingUnit.packageName, processingUnit.caseSensitiveInternedPartName);
                }
            }
        }
        catch (CircularBuildRequestException e) {
            throw e;
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (BuildException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new BuildException((Throwable)e);
        }
        this.unitsBeingProcessedToCompileLevel.remove(new ProcessingUnitKey(processingUnit.packageName, InternUtil.intern((String)processingUnit.caseSensitiveInternedPartName)));
        this.processingStack.remove(this.processingStack.size() - 1);
        return result;
    }

    protected abstract IPartBinding level03Compile(String[] var1, String var2);

    protected abstract IPartBinding level02Compile(String[] var1, String var2);

    protected abstract IPartBinding level01Compile(String[] var1, String var2);

    protected abstract IPartBinding getPartBindingFromCache(String[] var1, String var2);

    public IPartBinding requestCompilationFor(String[] packageName, String caseInsensitiveInternedPartName, boolean force) {
        if (this.isBeingProcessed(packageName, caseInsensitiveInternedPartName)) {
            if (this.isBeingCompiled(packageName, caseInsensitiveInternedPartName)) {
                return this.getPartBindingFromCache(packageName, caseInsensitiveInternedPartName);
            }
            if (this.getCurrentCompileLevel() == 2) {
                return this.getPartBindingFromCache(packageName, caseInsensitiveInternedPartName);
            }
            throw new CircularBuildRequestException();
        }
        if (this.isPending(packageName, caseInsensitiveInternedPartName)) {
            if (this.processingStack.size() >= 10) {
                ProcessingUnit processingUnit = (ProcessingUnit)this.pendingUnits.get(new ProcessingUnitKey(packageName, caseInsensitiveInternedPartName));
                if (force) {
                    return this.process(processingUnit, 2);
                }
                return this.process(processingUnit, this.getCurrentCompileLevel() - 1);
            }
            try {
                IPartBinding partBindingFromCache = this.getPartBindingFromCache(packageName, caseInsensitiveInternedPartName);
                if (Binding.isValidBinding((IBinding)partBindingFromCache)) {
                    return partBindingFromCache;
                }
                ProcessingUnit processingUnit = (ProcessingUnit)this.pendingUnits.get(new ProcessingUnitKey(packageName, caseInsensitiveInternedPartName));
                return this.process(processingUnit, 3);
            }
            catch (CircularBuildRequestException circularBuildRequestException) {
                this.reschedulePart(packageName, caseInsensitiveInternedPartName);
                ProcessingUnit processingUnit = (ProcessingUnit)this.pendingUnits.get(new ProcessingUnitKey(packageName, caseInsensitiveInternedPartName));
                return this.process(processingUnit, 2);
            }
        }
        return null;
    }

    private boolean isBeingProcessed(String[] packageName, String caseInsensitiveInternedPartName) {
        return this.processingStack.contains(new ProcessingUnitKey(packageName, caseInsensitiveInternedPartName));
    }

    public void reschedulePart(String[] packageName, String caseInsensitiveInternedPartName) {
        this.processingStack.remove(new ProcessingUnitKey(packageName, caseInsensitiveInternedPartName));
        this.unitsBeingProcessedToCompileLevel.remove(new ProcessingUnitKey(packageName, caseInsensitiveInternedPartName));
        this.doAddPart(packageName, caseInsensitiveInternedPartName);
    }

    protected abstract void doAddPart(String[] var1, String var2);

    private int getCurrentCompileLevel() {
        return (Integer)this.unitsBeingProcessedToCompileLevel.get(this.processingStack.get(this.processingStack.size() - 1));
    }

    private boolean isBeingCompiled(String[] packageName, String caseInsensitiveInternedPartName) {
        return this.processingStack.indexOf(new ProcessingUnitKey(packageName, caseInsensitiveInternedPartName)) == this.processingStack.size() - 1;
    }

    public class ProcessingUnit {
        public String[] packageName;
        public String caseSensitiveInternedPartName;

        ProcessingUnit(String[] packageName, String caseSensitiveInternedPartName) {
            this.packageName = packageName;
            this.caseSensitiveInternedPartName = caseSensitiveInternedPartName;
        }
    }

    public class ProcessingUnitKey {
        private String[] packageName;
        private String caseInsensitiveInternedPartName;

        public ProcessingUnitKey(String[] packageName, String caseInsensitiveInternedPartName) {
            this.packageName = packageName;
            this.caseInsensitiveInternedPartName = caseInsensitiveInternedPartName;
        }

        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject instanceof ProcessingUnitKey) {
                ProcessingUnitKey otherPUKey = (ProcessingUnitKey)otherObject;
                return otherPUKey.packageName == this.packageName && otherPUKey.caseInsensitiveInternedPartName == this.caseInsensitiveInternedPartName;
            }
            return false;
        }

        public int hashCode() {
            return this.caseInsensitiveInternedPartName.hashCode();
        }
    }
}

