/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.compiler;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.edt.compiler.ISystemPackageBuildPathEntryFactory;
import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.builder.NullBuildNotifier;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.compiler.internal.sdk.IPartRequestor;
import org.eclipse.edt.compiler.internal.sdk.compile.ASTManager;
import org.eclipse.edt.compiler.internal.sdk.compile.IProcessor;
import org.eclipse.edt.compiler.internal.sdk.compile.ISDKProblemRequestorFactory;
import org.eclipse.edt.compiler.internal.sdk.compile.PartPathEntry;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathEntry;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathInfo;
import org.eclipse.edt.compiler.internal.sdk.utils.Util;
import org.eclipse.edt.compiler.internal.util.NameUtil;
import org.eclipse.edt.compiler.sdk.compile.BuildPathException;
import org.eclipse.edt.mof.egl.compiler.EGL2IRArgumentProcessor;
import org.eclipse.edt.mof.egl.compiler.EGL2IREnvironment;
import org.eclipse.edt.mof.egl.compiler.Processor;
import org.eclipse.edt.mof.egl.compiler.SystemPackageBuildPathEntryFactory;
import org.eclipse.edt.mof.serialization.FileSystemObjectStore;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class EGL2IR {
    public static final String EGLBIN = ".eglbin";
    public static final String EGLXML = ".eglxml";
    public static EGL2IREnvironment eglcEnv;
    public static String SystemLibFolderPath;

    public static void main(String[] args) {
        EGL2IRArgumentProcessor.EGL2IRArguments processedArguments = new EGL2IRArgumentProcessor().processArguments(args);
        if (processedArguments != null) {
            EGL2IR.compile(processedArguments, null, null);
        }
    }

    public static void main(String[] args, IPartRequestor partRequestor, ISDKProblemRequestorFactory problemRequestorFactory) {
        EGL2IRArgumentProcessor.EGL2IRArguments processedArguments = new EGL2IRArgumentProcessor().processArguments(args);
        if (processedArguments != null) {
            EGL2IR.compile(processedArguments, problemRequestorFactory, partRequestor);
        }
    }

    public static void main(String[] args, ISDKProblemRequestorFactory problemRequestorFactory) {
        EGL2IRArgumentProcessor.EGL2IRArguments processedArguments = new EGL2IRArgumentProcessor().processArguments(args);
        SourcePathInfo.getInstance().reset();
        SourcePathEntry.getInstance().reset();
        if (processedArguments != null) {
            EGL2IR.compile(processedArguments, problemRequestorFactory, null);
        }
    }

    public static void compile(EGL2IRArgumentProcessor.EGL2IRArguments processedArgs, ISDKProblemRequestorFactory problemRequestorFactory, IPartRequestor partRequestor) {
        block11: {
            try {
                java.io.File[] files = processedArgs.getPartFiles();
                if (files.length > 0) {
                    boolean result;
                    if (eglcEnv == null) {
                        eglcEnv = new EGL2IREnvironment();
                    }
                    EGL2IR.initializeOutputPath(processedArgs);
                    EGL2IR.initializeSystemRoot(processedArgs);
                    EGL2IR.initializeEGLPath(processedArgs);
                    ASTManager.getInstance().setVAGComaptiblity(processedArgs.isVAGCompatible());
                    Processor processor = new Processor((IBuildNotifier)NullBuildNotifier.getInstance(), new ICompilerOptions(processedArgs){
                        private boolean isVAGCompatible;
                        {
                            this.isVAGCompatible = eGL2IRArguments.isVAGCompatible();
                        }

                        public boolean isVAGCompatible() {
                            return this.isVAGCompatible;
                        }

                        public boolean isAliasJSFNames() {
                            return false;
                        }
                    }, problemRequestorFactory);
                    processor.setEnvironment(eglcEnv);
                    SourcePathInfo.getInstance().setSourceLocations(EGL2IR.resolveSourcePathLocations(processedArgs.getSourcePathEntries(), processedArgs.getIROutputPath()));
                    SourcePathEntry.getInstance().setDeclaringEnvironment((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)eglcEnv);
                    SourcePathEntry.getInstance().setProcessor((IProcessor)processor);
                    SystemPackageBuildPathEntryFactory factory = new SystemPackageBuildPathEntryFactory(eglcEnv, eglcEnv.getConverter());
                    if (SystemLibFolderPath == null) {
                        result = Util.initializeSystemPackages((ISystemPackageBuildPathEntryFactory)new SystemPackageBuildPathEntryFactory(eglcEnv, eglcEnv.getConverter()));
                    } else {
                        SystemEnvironment.getInstance().initializeSystemPackages(SystemLibFolderPath, (ISystemPackageBuildPathEntryFactory)factory);
                        result = true;
                    }
                    if (result) {
                        int j = 0;
                        while (j < files.length) {
                            java.io.File file = files[j];
                            File fileAST = ASTManager.getInstance().getFileAST(file);
                            String[] packageName = EGL2IR.createPackageName(fileAST);
                            processor.addPart(packageName, Util.getCaseSensitiveFilePartName((java.io.File)file));
                            SourcePathInfo.getInstance().addPart(packageName, Util.getFilePartName((java.io.File)file), 16, file, Util.getCaseSensitiveFilePartName((java.io.File)file));
                            for (Part part : fileAST.getParts()) {
                                processor.addPart(packageName, part.getName().getCaseSensitiveIdentifier());
                                EGL2IR.addMessageTable(processor, part, file, processedArgs.getNlsCode(), processedArgs.getMsgTablePrefix());
                                SourcePathInfo.getInstance().addPart(packageName, part.getName().getIdentifier(), Util.getPartType((Node)part), file, part.getName().getCaseSensitiveIdentifier());
                                if (!part.isGeneratable() || partRequestor == null) continue;
                                partRequestor.acceptPart(packageName, part.getName().getCaseSensitiveIdentifier());
                            }
                            ++j;
                        }
                        processor.process();
                        break block11;
                    }
                    System.out.println();
                    System.out.println("cannot find system packages.");
                    throw new RuntimeException("cannot find system packages.");
                }
                throw new RuntimeException("cannot find target file");
            }
            catch (BuildException e) {
                throw e;
            }
            catch (BuildPathException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void addMessageTable(Processor processor, Part part, java.io.File file, String nlsCode, String msgTablePrefix) {
        String msgTableName = EGL2IR.getMsgTableName(part, nlsCode, msgTablePrefix);
        if (msgTableName == null) {
            return;
        }
        msgTableName = InternUtil.intern((String)msgTableName);
        String[][] possibleMsgTablePkgs = EGL2IR.getPossibleMsgTablePkgs(part, msgTableName);
        int i = 0;
        while (i < possibleMsgTablePkgs.length) {
            String[] pkg = InternUtil.intern((String[])possibleMsgTablePkgs[i]);
            java.io.File tblFile = SourcePathInfo.getInstance().getDeclaringFile(pkg, msgTableName);
            if (tblFile != null) {
                processor.addPart(pkg, msgTableName);
            }
            ++i;
        }
    }

    private static String[][] getPossibleMsgTablePkgs(Part part, String msgTableName) {
        String[] parsed = NameUtil.toStringArray((String)msgTableName);
        if (parsed.length == 1) {
            return EGL2IR.getPossibleMsgTablePkgsFromImports(part, msgTableName);
        }
        String[] pkg = new String[parsed.length - 1];
        System.arraycopy(parsed, 0, pkg, 0, parsed.length - 1);
        return new String[][]{pkg};
    }

    private static String[][] getPossibleMsgTablePkgsFromImports(Part part, String msgTableName) {
        Node node = part.getParent();
        if (node instanceof File) {
            final ArrayList onDemand = new ArrayList();
            final ArrayList singleType = new ArrayList();
            node.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(File file) {
                    return true;
                }

                public boolean visit(ImportDeclaration importDeclaration) {
                    if (importDeclaration.isOnDemand()) {
                        onDemand.add(NameUtil.toStringArray((String)importDeclaration.getName().getCanonicalName()));
                    } else {
                        singleType.add(NameUtil.toStringArray((String)importDeclaration.getName().getCanonicalName()));
                    }
                    return false;
                }

                public boolean visit(PackageDeclaration packageDeclaration) {
                    onDemand.add(NameUtil.toStringArray((String)packageDeclaration.getName().getCanonicalName()));
                    return false;
                }
            });
            ArrayList<Object> pkgs = new ArrayList<Object>();
            for (String[] imp : singleType) {
                if (imp.length <= 0 || !msgTableName.equalsIgnoreCase(imp[imp.length - 1])) continue;
                String[] newArr = new String[imp.length - 1];
                if (newArr.length > 0) {
                    System.arraycopy(imp, 0, newArr, 0, newArr.length);
                }
                pkgs.add(newArr);
            }
            pkgs.addAll(onDemand);
            return (String[][])pkgs.toArray((T[])new String[pkgs.size()][]);
        }
        return new String[0][];
    }

    private static String getMsgTableName(Part part, String nlsCode, String msgTablePrefix) {
        final String[] prefix = new String[1];
        final String msgTblPrefixProp = InternUtil.intern((String)"msgTablePrefix");
        part.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(Program program) {
                return true;
            }

            public boolean visit(Library library) {
                return true;
            }

            public boolean visit(SetValuesExpression setValuesExpression) {
                return true;
            }

            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            public boolean visit(Assignment assignment) {
                String id;
                if (assignment.getLeftHandSide() instanceof Name && InternUtil.intern((String)(id = ((Name)assignment.getLeftHandSide()).getIdentifier())) == msgTblPrefixProp && assignment.getRightHandSide() instanceof StringLiteral) {
                    prefix[0] = ((StringLiteral)assignment.getRightHandSide()).getValue();
                }
                return false;
            }
        });
        if (prefix[0] != null) {
            return String.valueOf(prefix[0]) + nlsCode;
        }
        if (msgTablePrefix != null && msgTablePrefix.trim().length() > 0 && EGL2IR.isVGUIRecord(part)) {
            return String.valueOf(msgTablePrefix) + nlsCode;
        }
        return null;
    }

    private static boolean isVGUIRecord(Part part) {
        final boolean[] isRecord = new boolean[1];
        final String vgUIRecProp = InternUtil.intern((String)"VGUIRecord");
        part.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(Record record) {
                String id;
                if (record.hasSubType() && InternUtil.intern((String)(id = record.getSubType().getIdentifier())) == vgUIRecProp) {
                    isRecord[0] = true;
                }
                return !isRecord[0];
            }

            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            public boolean visit(SetValuesExpression setValuesExpression) {
                setValuesExpression.getExpression().accept((IASTVisitor)this);
                return false;
            }

            public boolean visit(AnnotationExpression annotationExpression) {
                if (InternUtil.intern((String)annotationExpression.getName().getIdentifier()) == vgUIRecProp) {
                    isRecord[0] = true;
                }
                return false;
            }
        });
        return isRecord[0];
    }

    private static void deleteIRs(java.io.File path) {
        java.io.File[] files = path.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                EGL2IR.deleteIRs(files[i]);
            } else if (files[i].getName().indexOf(".ir") > 0) {
                files[i].delete();
            }
            ++i;
        }
    }

    private static String[] asStringArray(String[] pkg, String partName) {
        String[] result = new String[pkg.length + 1];
        System.arraycopy(pkg, 0, result, 0, pkg.length);
        result[pkg.length] = partName;
        return result;
    }

    private static void initializeEGLPath(EGL2IRArgumentProcessor.EGL2IRArguments processedArgs) {
        java.io.File[] paths;
        java.io.File[] fileArray = paths = processedArgs.getSourcePathEntries();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            java.io.File path = fileArray[n2];
            if (path.exists()) {
                String outType = processedArgs.xmlOut ? "XML" : "BINARY";
                String fileext = processedArgs.xmlOut ? EGLXML : EGLBIN;
                FileSystemObjectStore store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType, fileext);
                eglcEnv.registerObjectStore("egl", (ObjectStore)store);
                eglcEnv.addRoot(path);
            }
            ++n2;
        }
    }

    private static void initializeOutputPath(EGL2IRArgumentProcessor.EGL2IRArguments processedArgs) {
        java.io.File path;
        block4: {
            block2: {
                block3: {
                    path = processedArgs.getIROutputPath();
                    if (path == null) break block2;
                    if (path.exists()) break block3;
                    path.mkdirs();
                    break block4;
                }
                if (!processedArgs.isClean()) break block4;
                EGL2IR.deleteIRs(path);
                break block4;
            }
            if (processedArgs.isClean()) {
                java.io.File[] sourcelocs = processedArgs.getSourcePathEntries();
                int i = 0;
                while (i < sourcelocs.length) {
                    EGL2IR.deleteIRs(sourcelocs[i]);
                    ++i;
                }
            }
        }
        String outType = processedArgs.getXMLOut() ? "XML" : "BINARY";
        String fileext = processedArgs.xmlOut ? EGLXML : EGLBIN;
        FileSystemObjectStore store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType);
        eglcEnv.registerObjectStore("mof", (ObjectStore)store);
        eglcEnv.setDefaultSerializeStore("mof", (ObjectStore)store);
        store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType, fileext);
        eglcEnv.registerObjectStore("egl", (ObjectStore)store);
        eglcEnv.setDefaultSerializeStore("egl", (ObjectStore)store);
        eglcEnv.addRoot(path);
    }

    private static void initializeSystemRoot(EGL2IRArgumentProcessor.EGL2IRArguments processedArgs) {
        String outType = processedArgs.getXMLOut() ? "XML" : "BINARY";
        java.io.File path = processedArgs.getSystemRoot();
        FileSystemObjectStore store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType);
        eglcEnv.registerObjectStore("mof", (ObjectStore)store);
        String fileext = processedArgs.xmlOut ? EGLXML : EGLBIN;
        store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType, fileext);
        eglcEnv.registerObjectStore("egl", (ObjectStore)store);
        eglcEnv.addRoot(path);
    }

    private static String[] createPackageName(File fileAST) {
        if (fileAST.hasPackageDeclaration()) {
            return fileAST.getPackageDeclaration().getName().getNameComponents();
        }
        return InternUtil.intern((String[])new String[0]);
    }

    private static java.io.File resolveSourcePathLocation(java.io.File sourcePathEntryLocation) {
        try {
            return sourcePathEntryLocation.getCanonicalFile();
        }
        catch (IOException e) {
            System.out.println("Could not find source path location: " + sourcePathEntryLocation);
            throw new RuntimeException(e);
        }
    }

    private static java.io.File[] resolveSourcePathLocations(java.io.File[] sourcePathEntryLocations, java.io.File outpath) throws Exception {
        java.io.File[] canonicalLocations = new java.io.File[sourcePathEntryLocations.length];
        int i = 0;
        while (i < sourcePathEntryLocations.length) {
            canonicalLocations[i] = EGL2IR.resolveSourcePathLocation(sourcePathEntryLocations[i]);
            ++i;
        }
        return canonicalLocations;
    }

    private static PartPathEntry createPartPathEntry(java.io.File partPathEntryLocation, EGL2IREnvironment eglcEnvironment) {
        try {
            PartPathEntry retVal = new PartPathEntry(partPathEntryLocation.getCanonicalFile());
            retVal.setDeclaringEnvironment((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)eglcEnvironment);
            return retVal;
        }
        catch (IOException e) {
            System.out.println("Could not find part path location: " + partPathEntryLocation);
            throw new RuntimeException(e);
        }
    }

    private static PartPathEntry[] createPartPathEntries(java.io.File[] partPathEntryLocations, EGL2IREnvironment eglcEnvironment) {
        PartPathEntry[] partPathEntries = new PartPathEntry[partPathEntryLocations.length];
        int i = 0;
        while (i < partPathEntryLocations.length) {
            partPathEntries[i] = EGL2IR.createPartPathEntry(partPathEntryLocations[i], eglcEnvironment);
            ++i;
        }
        return partPathEntries;
    }
}

