/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.compiler;

import java.io.File;
import org.eclipse.edt.compiler.sdk.compile.EGLCArgumentProcessor;

public class EGL2IRArgumentProcessor
extends EGLCArgumentProcessor {
    private static final String SYSTEMROOT = "-systemRoot";
    private static final String XML_OUT = "-xmlOut";

    public EGL2IRArguments createDefaultArguments() {
        return new EGL2IRArguments();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EGL2IRArguments processArguments(String[] args) {
        EGL2IRArguments arguments = new EGL2IRArguments();
        try {
            int i = 0;
            while (true) {
                if (i >= args.length) {
                    return arguments;
                }
                int newindex = this.processArgument(arguments, args, i);
                if (newindex == -1) {
                    System.out.println("Invalid option: " + args[i]);
                    this.processError();
                    return null;
                }
                i = newindex;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.processError();
            return null;
        }
    }

    private void processError() {
        System.out.println("Usage: eglc -isVAGCompatible -systemRoot <path> -eglPath <path> -clean -irDestination <path> -xmlOut <partFiles>");
    }

    public int processArgument(EGL2IRArguments arguments, String[] args, int index) {
        int newindex = index;
        if (args[newindex].charAt(0) == '-') {
            if (args[newindex].equalsIgnoreCase(SYSTEMROOT)) {
                arguments.setSystemRoot(new File(args[newindex + 1]));
                return newindex += 2;
            }
            if (args[newindex].equalsIgnoreCase(XML_OUT)) {
                arguments.setXMLOut(true);
                return ++newindex;
            }
        }
        newindex = super.processArgument((EGLCArgumentProcessor.EGLCArguments)arguments, args, newindex);
        return newindex;
    }

    public class EGL2IRArguments
    extends EGLCArgumentProcessor.EGLCArguments {
        File systemRoot;
        boolean xmlOut;

        public EGL2IRArguments() {
            super((EGLCArgumentProcessor)EGL2IRArgumentProcessor.this);
            this.systemRoot = null;
            this.xmlOut = false;
        }

        public File getSystemRoot() {
            return this.systemRoot;
        }

        protected void setSystemRoot(File root) {
            this.systemRoot = root;
        }

        public boolean getXMLOut() {
            return this.xmlOut;
        }

        public void setXMLOut(boolean value) {
            this.xmlOut = value;
        }
    }
}

