/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.PackageBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IBindingEnvironment;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.compiler.internal.core.utils.PartBindingCache;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathEntry;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.lookup.EglLookupDelegate;
import org.eclipse.edt.mof.egl.mof2binding.Mof2Binding;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.SerializationException;

public class EGL2IREnvironment
implements IBindingEnvironment,
IEnvironment {
    private static final String[] defaultPackage = InternUtil.intern((String[])new String[0]);
    protected IEnvironment irEnv;
    private List<File> irPathRoots = new ArrayList<File>();
    private Mof2Binding converter = new Mof2Binding(this);
    private PartBindingCache bindingCache = new PartBindingCache();
    private PackageBinding rootPackageBinding = new PackageBinding(defaultPackage, null, (org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this);

    public EGL2IREnvironment() {
        this.irEnv = Environment.INSTANCE;
        this.irEnv.registerLookupDelegate("egl", (IEnvironment.LookupDelegate)new EglLookupDelegate());
    }

    public EGL2IREnvironment(IEnvironment irEnv) {
        irEnv.registerLookupDelegate("egl", (IEnvironment.LookupDelegate)new EglLookupDelegate());
        this.irEnv = irEnv;
    }

    protected boolean rootsContainPackage(String[] packageName) {
        String path = IRUtils.concatWithSeparator(packageName, "/");
        for (File root : this.irPathRoots) {
            File folder = new File(root, path);
            if (!folder.exists()) continue;
            return true;
        }
        return false;
    }

    public void addPartBindingToCache(IPartBinding partBinding) {
        this.bindingCache.put(partBinding.getPackageName(), partBinding.getCaseSensitiveName(), partBinding);
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        IPartBinding result = null;
        if (result == null) {
            result = SourcePathEntry.getInstance().getPartBinding(packageName, partName);
        }
        if (result == null) {
            boolean hasSourcePart = false;
            if (SourcePathEntry.getInstance().hasPart(packageName, partName) != 1) {
                hasSourcePart = true;
            }
            String mofSignature = String.valueOf(IRUtils.concatWithSeparator(packageName, ".")) + "." + partName;
            String eglSignature = "egl:" + mofSignature;
            if (hasSourcePart) {
                long sourceLastModified = SourcePathEntry.getInstance().lastModified(packageName, partName);
                long irLastModified = this.irEnv.lastModified(mofSignature);
                if (irLastModified == -1L) {
                    irLastModified = this.irEnv.lastModified(eglSignature);
                }
                if (irLastModified == -1L || sourceLastModified > irLastModified) {
                    return SourcePathEntry.getInstance().getOrCompilePartBinding(packageName, partName);
                }
            }
            try {
                IPartBinding partBinding;
                EObject irPart = this.findPart(eglSignature);
                if (irPart == null) {
                    irPart = this.findPart(mofSignature);
                }
                if ((partBinding = irPart == null ? SystemEnvironment.getInstance().getPartBinding(packageName, partName) : this.converter.convert(irPart)) != null) {
                    this.bindingCache.put(packageName, partName, partBinding);
                    return partBinding;
                }
                throw new RuntimeException("Part not found: " + mofSignature);
            }
            catch (DeserializationException ex2) {
                throw new RuntimeException(ex2);
            }
        }
        return result;
    }

    private EObject findPart(String mofSignature) throws DeserializationException {
        try {
            return this.irEnv.find(mofSignature);
        }
        catch (MofObjectNotFoundException mofObjectNotFoundException) {
            return null;
        }
    }

    public IPartBinding getNewPartBinding(String[] packageName, String caseSensitiveInternedPartName, int kind) {
        return SourcePathEntry.getInstance().getNewPartBinding(packageName, caseSensitiveInternedPartName, kind);
    }

    public boolean hasPackage(String[] packageName) {
        return SourcePathEntry.getInstance().hasPackage(packageName) || this.rootsContainPackage(packageName) || SystemEnvironment.getInstance().hasPackage(packageName);
    }

    public IPackageBinding getRootPackage() {
        return this.rootPackageBinding;
    }

    public void addRoot(File file) {
        this.irPathRoots.add(file);
    }

    public IPartBinding level01Compile(String[] packageName, String caseSensitiveInternedPartName) {
        String caseInsensitiveInternedPartName = InternUtil.intern((String)caseSensitiveInternedPartName);
        int partType = SourcePathEntry.getInstance().hasPart(packageName, caseInsensitiveInternedPartName);
        if (partType != 1) {
            IPartBinding result = PartBinding.newPartBinding((int)partType, (String[])packageName, (String)caseSensitiveInternedPartName);
            result.setEnvironment((org.eclipse.edt.compiler.internal.core.lookup.IEnvironment)this);
            return result;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    public EObject find(String key) throws MofObjectNotFoundException, DeserializationException {
        return this.irEnv.find(key);
    }

    public EObject find(String key, boolean useProxies) throws MofObjectNotFoundException, DeserializationException {
        return this.irEnv.find(key, useProxies);
    }

    public ObjectStore getDefaultSerializeStore(String keyScheme) {
        return this.irEnv.getDefaultSerializeStore(keyScheme);
    }

    public EObject lookup(String key) throws DeserializationException {
        return this.irEnv.lookup(key);
    }

    public void registerLookupDelegate(String scheme, IEnvironment.LookupDelegate delegate) {
        this.irEnv.registerLookupDelegate(scheme, delegate);
    }

    public void registerObjectStore(String scheme, ObjectStore store) {
        this.irEnv.registerObjectStore(scheme, store);
    }

    public void remove(String key) {
        this.irEnv.remove(key);
    }

    public void save(MofSerializable object) throws SerializationException {
        this.irEnv.save(object);
    }

    public void save(MofSerializable object, boolean serialize) throws SerializationException {
        this.irEnv.save(object, serialize);
    }

    public void save(String key, EObject object) throws SerializationException {
        this.irEnv.save(key, object);
    }

    public void save(String key, EObject object, boolean serialize) throws SerializationException {
        this.irEnv.save(key, object, serialize);
    }

    public void setDefaultSerializeStore(String keyScheme, ObjectStore store) {
        this.irEnv.setDefaultSerializeStore(keyScheme, store);
    }

    public long lastModified(String key) {
        return this.irEnv.lastModified(key);
    }

    public EObject get(String key) {
        return this.irEnv.get(key);
    }

    public IEnvironment.LookupDelegate getLookupDelegateForKey(String key) {
        return this.irEnv.getLookupDelegateForKey(key);
    }

    public Map<String, List<ObjectStore>> getObjectStores() {
        return this.irEnv.getObjectStores();
    }

    public Map<String, IEnvironment.LookupDelegate> getLookupDelegates() {
        return this.irEnv.getLookupDelegates();
    }

    public Mof2Binding getConverter() {
        return this.converter;
    }

    public List<File> getPathRoots() {
        return this.irPathRoots;
    }

    public IPartBinding getPartBindingFromCache(String[] packageName, String partName) {
        return this.bindingCache.get(packageName, partName);
    }

    public IPartBinding getCachedPartBinding(String[] packageName, String partName) {
        IPartBinding binding = this.getPartBindingFromCache(packageName, partName);
        if (Binding.isValidBinding((IBinding)binding)) {
            return binding;
        }
        return SystemEnvironment.getInstance().getCachedPartBinding(packageName, partName);
    }
}

