/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.util.SimpleLineTracker;
import org.eclipse.edt.mof.egl.compiler.Context;

public class SDKContext
extends Context {
    private File file;
    private SimpleLineTracker lineTracker;

    public SDKContext(File file) {
        super(file.getAbsolutePath(), file.getName());
        this.file = file;
    }

    private File getFile() {
        if (this.file == null && this.getAbsolutePath() != null) {
            this.file = new File(this.getAbsolutePath());
        }
        return this.file;
    }

    protected String getFileContents() {
        block6: {
            if (this.getFile() != null) break block6;
            return null;
        }
        try {
            FileReader reader = new FileReader(this.getFile());
            int length = (int)this.getFile().length();
            char[] fileContents = new char[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len < length) {
                readSize = reader.read(fileContents, len += readSize, length - len);
            }
            reader.close();
            if (len != length) {
                char[] cArray = fileContents;
                fileContents = new char[len];
                System.arraycopy(cArray, 0, fileContents, 0, len);
            }
            return new String(fileContents);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private SimpleLineTracker getLineTracker() {
        if (this.lineTracker == null) {
            this.lineTracker = new SimpleLineTracker(this.getFileContents());
        }
        return this.lineTracker;
    }

    @Override
    public int getLineNumber(Node node) {
        int[] lineOffsets = this.getLineTracker().getLineOffsets();
        int i = 0;
        while (i < lineOffsets.length) {
            if (lineOffsets[i] == node.getOffset()) {
                return i;
            }
            if (lineOffsets[i] > node.getOffset()) {
                return i - 1;
            }
            ++i;
        }
        return 0;
    }

    public String getAbsolutePath(String fileName) {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            return fileName;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }
}

