/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.compiler;

import java.util.Map;
import org.eclipse.edt.compiler.ISystemPackageBuildPathEntry;
import org.eclipse.edt.compiler.ISystemPartBindingLoadedRequestor;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.compiler.internal.io.ZipFileBuildPathEntry;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.mof2binding.Mof2Binding;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.IZipFileEntryManager;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class SystemPackageBuildPathEntry
extends ZipFileBuildPathEntry
implements ISystemPackageBuildPathEntry,
IZipFileEntryManager {
    private IEnvironment ienvironment = null;
    private ISystemPartBindingLoadedRequestor requestor = null;
    private ObjectStore store;
    private String fileExtension;
    private Mof2Binding converter;

    public SystemPackageBuildPathEntry(IEnvironment env, String path, ISystemPartBindingLoadedRequestor req, String fileExtension, Mof2Binding converter) {
        super(path);
        this.ienvironment = env;
        this.requestor = req;
        this.fileExtension = fileExtension;
        this.converter = converter;
        this.processEntries();
    }

    protected String getFileExtension() {
        return this.fileExtension;
    }

    protected void setStore(ObjectStore store) {
        this.store = store;
    }

    public void readPartBindings() {
        String[] entries = this.getAllEntries();
        int i = 0;
        while (i < entries.length) {
            IPartBinding partBinding = this.getPartBinding(entries[i]);
            if (this.requestor != null && partBinding != null) {
                partBinding.setEnvironment(this.ienvironment);
                this.requestor.partBindingLoaded(partBinding);
            }
            ++i;
        }
    }

    public IPartBinding getPartBinding(String entry) {
        if (entry == null || entry.length() == 0) {
            return null;
        }
        IPartBinding retVal = null;
        EObject part = this.getPartObject(entry);
        if (part != null && (retVal = this.converter.convert(part)) != null) {
            Map partpackage = this.getPackagePartBinding(InternUtil.intern((String[])retVal.getPackageName()));
            partpackage.put(InternUtil.intern((String)retVal.getName()), retVal);
        }
        return retVal;
    }

    protected EObject getPartObject(String entry) {
        if (entry == null || entry.length() == 0) {
            return null;
        }
        String key = this.convertToStoreKey(entry);
        try {
            return this.store.get(key);
        }
        catch (DeserializationException e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    protected String convertToStoreKey(String entry) {
        String value = entry.substring(0, entry.indexOf("."));
        value = value.replaceAll("/", ".");
        value = "egl:" + value;
        return value;
    }

    public boolean hasEntry(String entry) {
        entry = entry.toUpperCase().toLowerCase();
        String[] entries = this.getAllEntries();
        int i = 0;
        while (i < entries.length) {
            if (entry.equalsIgnoreCase(entries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

