/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.compiler;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.edt.compiler.ISystemPackageBuildPathEntry;
import org.eclipse.edt.compiler.ISystemPackageBuildPathEntryFactory;
import org.eclipse.edt.compiler.ISystemPartBindingLoadedRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.mof.egl.compiler.SystemPackageBuildPathEntry;
import org.eclipse.edt.mof.egl.compiler.SystemPackageMOFPathEntry;
import org.eclipse.edt.mof.egl.mof2binding.Mof2Binding;
import org.eclipse.edt.mof.serialization.IZipFileEntryManager;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.ZipFileObjectStore;

public class SystemPackageBuildPathEntryFactory
implements ISystemPackageBuildPathEntryFactory {
    org.eclipse.edt.mof.serialization.IEnvironment irEnv;
    Mof2Binding converter;

    public SystemPackageBuildPathEntryFactory(org.eclipse.edt.mof.serialization.IEnvironment irEnv, Mof2Binding converter) {
        this.irEnv = irEnv;
        this.converter = converter;
    }

    private SystemPackageBuildPathEntry createEGLEntry(IEnvironment env, String path, ISystemPartBindingLoadedRequestor req) {
        SystemPackageBuildPathEntry entry = new SystemPackageBuildPathEntry(env, path, req, ".eglxml", this.converter);
        ZipFileObjectStore store = new ZipFileObjectStore(new File(path), this.irEnv, "XML", ".eglxml", (IZipFileEntryManager)entry);
        entry.setStore((ObjectStore)store);
        this.irEnv.registerObjectStore("egl", (ObjectStore)store);
        return entry;
    }

    private SystemPackageMOFPathEntry createMOFEntry(IEnvironment env, String path, ISystemPartBindingLoadedRequestor req) {
        SystemPackageMOFPathEntry entry = new SystemPackageMOFPathEntry(env, path, req, ".mofxml", this.converter);
        ZipFileObjectStore store = new ZipFileObjectStore(new File(path), this.irEnv, "XML", ".mofxml", (IZipFileEntryManager)entry);
        entry.setStore((ObjectStore)store);
        this.irEnv.registerObjectStore("mof", (ObjectStore)store);
        return entry;
    }

    public ISystemPackageBuildPathEntry[] createEntries(IEnvironment env, File[] files, ISystemPartBindingLoadedRequestor req) {
        ArrayList<SystemPackageBuildPathEntry> list = new ArrayList<SystemPackageBuildPathEntry>();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isFile()) {
                if (file.getName().endsWith(".eglar")) {
                    list.add(this.createEGLEntry(env, file.getAbsolutePath(), req));
                } else if (file.getName().endsWith(".mofar")) {
                    list.add(this.createMOFEntry(env, file.getAbsolutePath(), req));
                }
            }
            ++i;
        }
        ISystemPackageBuildPathEntry[] result = list.toArray(new SystemPackageBuildPathEntry[list.size()]);
        if (this.converter != null) {
            int i2 = 0;
            while (i2 < result.length) {
                result[i2].readPartBindings();
                ++i2;
            }
        }
        return result;
    }
}

