/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.egl2mof;

import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.compiler.Context;
import org.eclipse.edt.mof.egl.compiler.EGL2IREnvironment;
import org.eclipse.edt.mof.egl.egl2mof.Egl2MofExpression;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.TypeStore;

public class Egl2Mof
extends Egl2MofExpression {
    public Egl2Mof(EGL2IREnvironment env) {
        super(env);
    }

    public Egl2Mof(EGL2IREnvironment env, TypeStore store) {
        this(env);
        env.setDefaultSerializeStore("egl", (ObjectStore)store);
    }

    public EObject convert(Part part, Context context, IProblemRequestor problemRequestor) {
        this.context = context;
        Environment.pushEnv((IEnvironment)this.env);
        EObject mofPart = null;
        try {
            part.accept((IASTVisitor)this);
            mofPart = (EObject)this.stack.pop();
            if (mofPart instanceof EClassifier) {
                EClassifier ePart = (EClassifier)mofPart;
                IPartBinding binding = (IPartBinding)part.getName().resolveBinding();
                if (!binding.getName().equalsIgnoreCase(ePart.getName())) {
                    this.env.save(this.mofSerializationKeyFor((ITypeBinding)binding), (EObject)ePart, false);
                }
            }
            if (problemRequestor != null && part != null && mofPart instanceof Classifier) {
                Classifier irPart = (Classifier)mofPart;
                irPart.setHasCompileErrors(this.hasCompileErrors(problemRequestor, part));
            }
        }
        finally {
            Environment.popEnv();
        }
        return mofPart;
    }

    private boolean hasCompileErrors(IProblemRequestor problemRequestor, Part node) {
        if (problemRequestor != null && problemRequestor.hasError()) {
            return true;
        }
        SyntaxErrorRequestor req = new SyntaxErrorRequestor();
        node.accept((ISyntaxErrorRequestor)req);
        return req.error;
    }

    private static class SyntaxErrorRequestor
    implements ISyntaxErrorRequestor {
        boolean error;

        private SyntaxErrorRequestor() {
        }

        public void incorrectNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
            this.error = true;
        }

        public void incorrectPhrase(int nonTerminalType, int startOffset, int endOffset) {
            this.error = true;
        }

        public void incorrectPreviousNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
            this.error = true;
        }

        public void incorrectPreviousTerminal(int terminalType, int startOffset, int endOffset) {
            this.error = true;
        }

        public void incorrectTerminal(int terminalType, int startOffset, int endOffset) {
            this.error = true;
        }

        public void keywordAsName(int terminalType, int startOffset, int endOffset) {
            this.error = true;
        }

        public void invalidCharacterInHexLiteral(int startOffset, int endOffset) {
            this.error = true;
        }

        public void invalidEscapeSequence(int startOffset, int endOffset) {
            this.error = true;
        }

        public void missingEndForPart(int startOffset, int endOffset) {
            this.error = true;
        }

        public void missingNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
            this.error = true;
        }

        public void missingPreviousNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
            this.error = true;
        }

        public void missingPreviousTerminal(int terminalType, int startOffset, int endOffset) {
            this.error = true;
        }

        public void missingScopeCloser(int terminalType, int startOffset, int endOffset) {
            this.error = true;
        }

        public void missingTerminal(int terminalType, int startOffset, int endOffset) {
            this.error = true;
        }

        public void panicPhrase(int startOffset, int endOffset) {
            this.error = true;
        }

        public void tooManyErrors() {
            this.error = true;
        }

        public void unclosedBlockComment(int startOffset, int endOffset) {
            this.error = true;
        }

        public void unclosedDLI(int startOffset, int endOffset) {
            this.error = true;
        }

        public void unclosedSQL(int startOffset, int endOffset) {
            this.error = true;
        }

        public void unclosedSQLCondition(int startOffset, int endOffset) {
            this.error = true;
        }

        public void unclosedString(int startOffset, int endOffset) {
            this.error = true;
        }

        public void unexpectedPhrase(int startOffset, int endOffset) {
            this.error = true;
        }

        public void unexpectedPreviousTerminal(int startOffset, int endOffset) {
            this.error = true;
        }

        public void unexpectedTerminal(int startOffset, int endOffset) {
            this.error = true;
        }

        public void whitespaceInDLI(int startOffset, int endOffset) {
        }

        public void whitespaceInSQL(int startOffset, int endOffset) {
        }

        public void whitespaceInSQLCondition(int startOffset, int endOffset) {
        }

        public boolean isError() {
            return this.error;
        }
    }
}

