/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.egl2mof;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.DelegateBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionContainerBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.TopLevelFunctionBinding;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Parameter;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EMember;
import org.eclipse.edt.mof.EMemberContainer;
import org.eclipse.edt.mof.EMetadataObject;
import org.eclipse.edt.mof.EMetadataType;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.DataItem;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Form;
import org.eclipse.edt.mof.egl.FormField;
import org.eclipse.edt.mof.egl.FormGroup;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.FunctionPart;
import org.eclipse.edt.mof.egl.Interface;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Program;
import org.eclipse.edt.mof.egl.ProgramParameter;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.Stereotype;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.StructuredRecord;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.compiler.EGL2IREnvironment;
import org.eclipse.edt.mof.egl.egl2mof.Egl2MofBase;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.serialization.ProxyEObject;

abstract class Egl2MofPart
extends Egl2MofBase {
    public MofSerializable currentPart;
    protected FunctionMember currentFunction;
    public List<NestedFunction> functionsToProcess = new ArrayList<NestedFunction>();

    Egl2MofPart(EGL2IREnvironment env) {
        super(env);
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.Record node) {
        MofSerializable part = this.defaultHandleVisitPart((org.eclipse.edt.compiler.core.ast.Part)node);
        this.stack.push(part);
        return false;
    }

    public boolean visit(Enumeration node) {
        MofSerializable part = this.defaultHandleVisitPart((org.eclipse.edt.compiler.core.ast.Part)node);
        this.setElementInformation((Node)node, (EObject)part);
        this.stack.push(part);
        return false;
    }

    public boolean visit(ExternalType node) {
        IPartBinding partBinding = (IPartBinding)node.getName().resolveBinding();
        this.inMofProxyContext = this.isMofProxy(partBinding);
        this.inEMetadataTypeContext = this.isEMetadataType((ITypeBinding)partBinding);
        this.inAnnotationTypeContext = this.isAnnotationType((ITypeBinding)partBinding) || this.isStereotypeType((ITypeBinding)partBinding);
        this.inMofContext = this.isMofReflectType((ITypeBinding)partBinding) || this.inEMetadataTypeContext;
        MofSerializable part = (MofSerializable)this.env.get(this.mofSerializationKeyFor((ITypeBinding)partBinding));
        if (part == null || part instanceof ProxyEObject || this.isTempEClass((EObject)part)) {
            part = this.handleVisitPart((org.eclipse.edt.compiler.core.ast.Part)node);
            this.handleContents((org.eclipse.edt.compiler.core.ast.Part)node, (EObject)part);
            if (part instanceof EClass) {
                ArrayList<EClass> superTypes = new ArrayList<EClass>();
                for (Object name : node.getExtendedTypes()) {
                    IPartBinding superType = (IPartBinding)((Name)name).resolveBinding();
                    superTypes.add((EClass)this.mofTypeFor((ITypeBinding)superType));
                }
                ((EClass)part).addSuperTypes(superTypes);
            } else {
                for (Object name : node.getExtendedTypes()) {
                    IPartBinding superType = (IPartBinding)((Name)name).resolveBinding();
                    ((EGLClass)part).getSuperTypes().add((EGLClass)this.mofTypeFor((ITypeBinding)superType));
                }
            }
            this.handleEndVisitPart((org.eclipse.edt.compiler.core.ast.Part)node, part);
        }
        this.stack.push(part);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.Program node) {
        MofSerializable part = this.defaultHandleVisitPart((org.eclipse.edt.compiler.core.ast.Part)node);
        this.stack.push(part);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.Interface node) {
        MofSerializable part = this.defaultHandleVisitPart((org.eclipse.edt.compiler.core.ast.Part)node);
        this.stack.push(part);
        return false;
    }

    public boolean visit(Handler node) {
        MofSerializable part = this.defaultHandleVisitPart((org.eclipse.edt.compiler.core.ast.Part)node);
        this.stack.push(part);
        return false;
    }

    public boolean visit(Library node) {
        MofSerializable part = this.defaultHandleVisitPart((org.eclipse.edt.compiler.core.ast.Part)node);
        this.stack.push(part);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.DataItem dataItem) {
        DataItem part = this.factory.createDataItem();
        part.setName(dataItem.getName().getCaseSensitiveIdentifier());
        DataItemBinding type = (DataItemBinding)dataItem.getName().resolveBinding();
        part.setBaseType((Type)this.mofTypeFor((ITypeBinding)type.getPrimitiveTypeBinding()));
        part.setPackageName(this.concatWithSeparator(type.getPackageName(), "."));
        this.createAnnotations((IPartBinding)type, part);
        this.stack.push(part);
        return false;
    }

    public boolean visit(DataTable node) {
        MofSerializable part = this.defaultHandleVisitPart((org.eclipse.edt.compiler.core.ast.Part)node);
        this.stack.push(part);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.Delegate delegate) {
        Delegate part = this.factory.createDelegate();
        DelegateBinding binding = (DelegateBinding)delegate.getName().resolveBinding();
        part.setName(binding.getCaseSensitiveName());
        part.setPackageName(this.concatWithSeparator(binding.getPackageName(), "."));
        if (binding.getReturnType() != null) {
            part.setReturnType((Type)this.mofTypeFor(binding.getReturnType()));
            part.setIsNullable(binding.getReturnType().isNullable());
        } else {
            part.setIsNullable(false);
        }
        this.partProcessingStack.push(part);
        for (Parameter parm : delegate.getParameters()) {
            parm.accept((IASTVisitor)this);
            part.addMember((FunctionParameter)this.stack.pop());
        }
        this.setElementInformation((Node)delegate, part);
        this.partProcessingStack.pop();
        this.stack.push(part);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.FormGroup formGroup) {
        FormGroup group = this.factory.createFormGroup();
        group.setName(formGroup.getName().getCaseSensitiveIdentifier());
        FormGroupBinding groupBinding = (FormGroupBinding)formGroup.getName().resolveBinding();
        group.setPackageName(this.concatWithSeparator(groupBinding.getPackageName(), "."));
        this.stack.push(group);
        for (Node node : formGroup.getContents()) {
            if (!(node instanceof NestedForm)) continue;
            NestedForm form = (NestedForm)node;
            form.accept((IASTVisitor)this);
            Form eForm = (Form)this.stack.pop();
            eForm.setContainer(group);
            group.getForms().add(eForm);
        }
        this.createAnnotations((IPartBinding)groupBinding, group);
        this.setElementInformation((Node)formGroup, group);
        return false;
    }

    public boolean visit(NestedForm nestedForm) {
        Form part = this.factory.createForm();
        part.setName(nestedForm.getName().getCaseSensitiveIdentifier());
        FormBinding binding = (FormBinding)nestedForm.getName().resolveBinding();
        this.stack.push(part);
        for (Node field : nestedForm.getContents()) {
            field.accept((IASTVisitor)this);
            FormField f = (FormField)this.stack.pop();
            if (f == null) continue;
            part.addMember(f);
        }
        this.createAnnotations((IPartBinding)binding, part);
        this.setElementInformation((Node)nestedForm, part);
        return false;
    }

    public boolean visit(TopLevelForm topLevelForm) {
        MofSerializable part = this.defaultHandleVisitPart((org.eclipse.edt.compiler.core.ast.Part)topLevelForm);
        this.stack.push(part);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.Service service) {
        Service part = (Service)this.defaultHandleVisitPart((org.eclipse.edt.compiler.core.ast.Part)service);
        for (Node node : service.getImplementedInterfaces()) {
            Interface iface = (Interface)this.mofTypeFor((ITypeBinding)((Name)node).resolveBinding());
            part.getInterfaces().add(iface);
        }
        this.stack.push(part);
        return false;
    }

    public boolean visit(TopLevelFunction node) {
        TopLevelFunctionBinding binding = (TopLevelFunctionBinding)node.getName().resolveBinding();
        FunctionPart part = (FunctionPart)this.env.get(this.mofSerializationKeyFor((ITypeBinding)binding));
        if (part == null) {
            part = (FunctionPart)this.handleVisitPart((org.eclipse.edt.compiler.core.ast.Part)node);
            Function function = this.factory.createFunction();
            this.setElementInformation((Node)node, function);
            part.setFunction(function);
            function.setName(part.getName());
            for (Node parm : node.getFunctionParameters()) {
                parm.accept((IASTVisitor)this);
                function.addMember((FunctionParameter)this.stack.pop());
            }
            if (node.getReturnDeclaration() != null) {
                function.setType((Type)this.mofTypeFor(node.getReturnType().resolveTypeBinding()));
            }
            StatementBlock block = this.factory.createStatementBlock();
            block.setContainer(function);
            function.setStatementBlock(block);
            this.setCurrentFunctionMember(function);
            for (Node stmt : node.getStmts()) {
                stmt.accept((IASTVisitor)this);
                block.getStatements().add((Statement)this.stack.pop());
            }
            this.setCurrentFunctionMember(null);
        }
        this.setElementInformation((Node)node, part);
        this.stack.push(part);
        return false;
    }

    public boolean visit(UseStatement stmt) {
        for (Name name : stmt.getNames()) {
            ITypeBinding partBinding = (ITypeBinding)name.resolveBinding();
            if (IBinding.NOT_FOUND_BINDING.equals(partBinding)) continue;
            Part part = (Part)this.mofTypeFor(partBinding);
            ((LogicAndDataPart)this.currentPart).getUsedParts().add(part);
            if (!(partBinding instanceof FormBinding)) continue;
            Field formField = this.factory.createField();
            formField.setName(partBinding.getCaseSensitiveName());
            formField.setType(part);
            ((LogicAndDataPart)this.currentPart).addMember(formField);
            this.eObjects.put(partBinding, formField);
        }
        this.stack.push(null);
        return false;
    }

    protected MofSerializable defaultHandleVisitPart(org.eclipse.edt.compiler.core.ast.Part node) {
        IBinding binding = node.getName().resolveBinding();
        MofSerializable part = (MofSerializable)this.env.get(this.mofSerializationKeyFor((ITypeBinding)binding));
        if (part == null || part instanceof ProxyEObject) {
            part = this.handleVisitPart(node);
            this.handleContents(node, (EObject)part);
            this.handleParms(node, (EObject)part);
            this.handleEndVisitPart(node, part);
        }
        return part;
    }

    private void handleParms(org.eclipse.edt.compiler.core.ast.Part part, EObject container) {
        if (part instanceof org.eclipse.edt.compiler.core.ast.Program) {
            org.eclipse.edt.compiler.core.ast.Program pgmAst = (org.eclipse.edt.compiler.core.ast.Program)part;
            Program program = (Program)container;
            for (org.eclipse.edt.compiler.core.ast.ProgramParameter parmAst : pgmAst.getParameters()) {
                parmAst.accept((IASTVisitor)this);
                ProgramParameter parm = (ProgramParameter)this.stack.pop();
                parm.setContainer(program);
                program.getParameters().add(parm);
            }
            program.setIsCallable(pgmAst.isCallable());
        }
    }

    protected MofSerializable handleVisitPart(org.eclipse.edt.compiler.core.ast.Part part) {
        IPartBinding partBinding = (IPartBinding)part.getName().resolveBinding();
        MofSerializable obj = (MofSerializable)this.env.get(this.mofSerializationKeyFor((ITypeBinding)partBinding));
        if (obj == null || this.isTempEClass((EObject)obj) || obj instanceof ProxyEObject) {
            this.inMofProxyContext = this.isMofProxy(partBinding);
            this.inEMetadataTypeContext = this.isEMetadataType((ITypeBinding)partBinding);
            this.inAnnotationTypeContext = this.isAnnotationType((ITypeBinding)partBinding) || this.isStereotypeType((ITypeBinding)partBinding);
            this.inMofContext = this.isMofReflectType((ITypeBinding)partBinding) || this.inEMetadataTypeContext;
            EClass typeClass = (EClass)this.getMofSerializable(this.mofPartTypeSignatureFor(part));
            MofSerializable eObj = (MofSerializable)typeClass.newInstance();
            this.partProcessingStack.push(eObj);
            eObj.eSet("name", (Object)partBinding.getCaseSensitiveName());
            eObj.eSet("packageName", (Object)this.concatWithSeparator(partBinding.getPackageName(), "."));
            IAnnotationBinding subtype = partBinding.getSubTypeAnnotationBinding();
            if (!this.inMofProxyContext) {
                this.setReflectTypeValues((EObject)eObj, subtype);
            }
            if (obj instanceof ProxyEObject) {
                ((ProxyEObject)obj).updateReferences((Object)eObj);
            }
            this.env.save(this.mofSerializationKeyFor((ITypeBinding)partBinding), (EObject)eObj, false);
            if (!this.mofSerializationKeyFor((ITypeBinding)partBinding).equals(eObj.getMofSerializationKey())) {
                this.env.save(eObj.getMofSerializationKey(), (EObject)eObj, false);
            }
            if (!this.inMofContext) {
                this.eObjects.put(partBinding, eObj);
                this.currentPart = eObj;
            }
            obj = eObj;
        }
        return obj;
    }

    protected void handleEndVisitPart(org.eclipse.edt.compiler.core.ast.Part astPart, MofSerializable mofPart) {
        MofSerializable part = (MofSerializable)this.partProcessingStack.pop();
        IPartBinding partBinding = (IPartBinding)astPart.getName().resolveBinding();
        IAnnotationBinding subtype = partBinding.getSubTypeAnnotationBinding();
        if (mofPart instanceof EClass) {
            this.createAnnotations(partBinding, (EClass)mofPart);
        } else if (mofPart instanceof Part) {
            this.createAnnotations(partBinding, (Part)mofPart);
            if (mofPart instanceof StructPart) {
                this.setDefaultSuperType((StructPart)mofPart);
            }
            this.setElementInformation((Node)astPart, (Part)mofPart);
        }
        for (NestedFunction nestedFunction : this.functionsToProcess) {
            ITypeBinding binding = nestedFunction.getName().resolveDataBinding().getType();
            FunctionMember irFunc = (FunctionMember)this.getEObjectFor((IBinding)binding);
            this.setCurrentFunctionMember(irFunc);
            for (Node node : nestedFunction.getStmts()) {
                if (!(node instanceof org.eclipse.edt.compiler.core.ast.Statement)) continue;
                node.accept((IASTVisitor)this);
                Statement irStmt = (Statement)this.stack.pop();
                irFunc.getStatements().add(irStmt);
            }
            this.setCurrentFunctionMember(null);
        }
        if (part instanceof LogicAndDataPart) {
            IRUtils.markOverloadedFunctions((LogicAndDataPart)part);
        }
        if (this.inMofProxyContext) {
            EMetadataObject eMetadataObject = (EMetadataObject)this.mofValueFrom(subtype);
            ((EClass)mofPart).getMetadataList().add(eMetadataObject);
        }
        for (Map.Entry entry : this.proxies.entrySet()) {
            EObject real = (EObject)this.eObjects.get(entry.getKey());
            this.updateProxyReferences((IBinding)entry.getKey(), real);
        }
    }

    private void handleImplicits(org.eclipse.edt.compiler.core.ast.Part part, EObject container) {
        NestedFunctionBinding[] implFunctions;
        IDataBinding[] impFields = this.getImplicitFields(part.getName().resolveBinding());
        if (impFields != null) {
            int i = 0;
            while (i < impFields.length) {
                ((Container)container).addMember(this.createImplicitField(impFields[i]));
                ++i;
            }
        }
        if ((implFunctions = this.getImplicitFunctions(part.getName().resolveBinding())) != null) {
            int i = 0;
            while (i < implFunctions.length) {
                ((Container)container).addMember(this.createImplicitFunction(implFunctions[i]));
                ++i;
            }
        }
    }

    private Member createImplicitField(IDataBinding data) {
        EClass fieldClass = this.mofMemberTypeFor(data);
        Field f = (Field)fieldClass.newInstance();
        this.setUpEglTypedElement(f, data);
        if (data instanceof ClassFieldBinding) {
            ClassFieldBinding cfb = (ClassFieldBinding)data;
            f.setIsStatic(cfb.isStatic());
            if (cfb.isPrivate()) {
                f.setAccessKind(AccessKind.ACC_PRIVATE);
            }
        }
        for (IAnnotationBinding ann : data.getAnnotations()) {
            Annotation value = (Annotation)this.mofValueFrom(ann);
            f.getAnnotations().add(value);
        }
        this.eObjects.put(data, f);
        return f;
    }

    private Member createImplicitFunction(NestedFunctionBinding function) {
        FunctionBinding functionBinding = (FunctionBinding)function.getType();
        EClass funcClass = this.mofMemberTypeFor((IDataBinding)function);
        Function func = (Function)funcClass.newInstance();
        this.setUpEglTypedElement(func, (IDataBinding)function);
        StatementBlock stmts = this.factory.createStatementBlock();
        stmts.setContainer(func);
        func.setStatementBlock(stmts);
        for (FunctionParameterBinding parmBinding : functionBinding.getParameters()) {
            FunctionParameter parm = this.factory.createFunctionParameter();
            ParameterKind parmKind = parmBinding.isInput() ? ParameterKind.PARM_IN : (parmBinding.isInputOutput() ? ParameterKind.PARM_INOUT : (parmBinding.isOutput() ? ParameterKind.PARM_OUT : ParameterKind.PARM_INOUT));
            parm.setParameterKind(parmKind);
            this.setUpEglTypedElement(parm, (IDataBinding)parmBinding);
            this.eObjects.put(parmBinding, parm);
            func.addMember(parm);
        }
        if (functionBinding.isPrivate()) {
            func.setAccessKind(AccessKind.ACC_PRIVATE);
        }
        if (functionBinding.isStatic()) {
            func.setIsStatic(true);
        }
        this.eObjects.put(function.getType(), func);
        return func;
    }

    private IDataBinding[] getImplicitFields(IBinding binding) {
        ArrayList<ClassFieldBinding> list;
        if (binding instanceof FunctionContainerBinding) {
            list = new ArrayList<ClassFieldBinding>();
            FunctionContainerBinding fc = (FunctionContainerBinding)binding;
            for (ClassFieldBinding field : fc.getClassFields()) {
                if (!field.isImplicit()) continue;
                list.add(field);
            }
            if (list.size() > 0) {
                return list.toArray(new IDataBinding[list.size()]);
            }
        }
        if (binding instanceof FlexibleRecordBinding) {
            list = new ArrayList();
            FlexibleRecordBinding rec = (FlexibleRecordBinding)binding;
            for (ClassFieldBinding field : rec.getDeclaredFields()) {
                if (!field.isImplicit()) continue;
                list.add(field);
            }
            if (list.size() > 0) {
                return list.toArray(new IDataBinding[list.size()]);
            }
        }
        return null;
    }

    private NestedFunctionBinding[] getImplicitFunctions(IBinding binding) {
        if (binding instanceof FunctionContainerBinding) {
            ArrayList<NestedFunctionBinding> list = new ArrayList<NestedFunctionBinding>();
            FunctionContainerBinding fc = (FunctionContainerBinding)binding;
            for (NestedFunctionBinding function : fc.getDeclaredFunctions()) {
                if (!((FunctionBinding)function.getType()).isImplicit()) continue;
                list.add(function);
            }
            if (list.size() > 0) {
                return list.toArray(new NestedFunctionBinding[list.size()]);
            }
        }
        return null;
    }

    private void handleContents(org.eclipse.edt.compiler.core.ast.Part part, EObject container) {
        if (!this.inMofContext) {
            this.handleImplicits(part, container);
        }
        for (Node n : part.getContents()) {
            n.accept((IASTVisitor)this);
            EObject mofObj = (EObject)this.stack.pop();
            if (mofObj == null) continue;
            if (this.inMofContext) {
                ((EMemberContainer)container).addMember((EMember)mofObj);
                if (!(mofObj instanceof EField) || !(container instanceof AnnotationType) && !(container instanceof EMetadataType)) continue;
                ((EField)mofObj).setContainment(true);
                continue;
            }
            ((Container)container).addMember((Member)mofObj);
        }
    }

    private void setDefaultSuperType(StructPart part) {
        Stereotype stereotype;
        if (part.getSuperTypes().isEmpty() && (stereotype = part.getStereotype()) != null) {
            StructPart superType = (StructPart)((StereotypeType)stereotype.getEClass()).getDefaultSuperType();
            if (superType == null) {
                String typeSignature = "egl:egl.lang.AnyObject";
                if (part instanceof Record) {
                    typeSignature = "egl:egl.lang.AnyRecord";
                } else if (part instanceof StructuredRecord) {
                    typeSignature = "egl:egl.lang.AnyStruct";
                } else if (part instanceof AnnotationType) {
                    typeSignature = "org.eclipse.edt.mof.egl.Annotation";
                } else if (part instanceof StereotypeType) {
                    typeSignature = "org.eclipse.edt.mof.egl.Stereotype";
                }
                superType = (StructPart)this.getMofSerializable(typeSignature);
            }
            if (superType != null) {
                part.getSuperTypes().add(superType);
            }
        }
    }

    protected void setCurrentFunctionMember(FunctionMember function) {
        this.currentFunction = function;
    }

    protected FunctionMember getCurrentFunctionMember() {
        return this.currentFunction;
    }

    @Override
    protected void setElementInformation(Node node, EObject obj) {
        Statement stmt;
        if (obj instanceof Statement && (stmt = (Statement)obj).getContainer() == null && this.currentPart instanceof Container) {
            stmt.setContainer((Container)this.currentPart);
        }
        super.setElementInformation(node, obj);
    }
}

