/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.egl2mof;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.LocalVariableBinding;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.FreeSQLStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocationStatement;
import org.eclipse.edt.compiler.core.ast.GotoStatement;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.OtherwiseClause;
import org.eclipse.edt.compiler.core.ast.WhenClause;
import org.eclipse.edt.mof.egl.AddStatement;
import org.eclipse.edt.mof.egl.AssignmentStatement;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.CallStatement;
import org.eclipse.edt.mof.egl.CloseStatement;
import org.eclipse.edt.mof.egl.ContinueStatement;
import org.eclipse.edt.mof.egl.ConverseStatement;
import org.eclipse.edt.mof.egl.DeclarationExpression;
import org.eclipse.edt.mof.egl.DeleteStatement;
import org.eclipse.edt.mof.egl.DisplayStatement;
import org.eclipse.edt.mof.egl.EmptyStatement;
import org.eclipse.edt.mof.egl.ExceptionBlock;
import org.eclipse.edt.mof.egl.ExecuteStatement;
import org.eclipse.edt.mof.egl.ExitStatement;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.ForEachStatement;
import org.eclipse.edt.mof.egl.ForStatement;
import org.eclipse.edt.mof.egl.ForwardStatement;
import org.eclipse.edt.mof.egl.FreeSqlStatement;
import org.eclipse.edt.mof.egl.FunctionStatement;
import org.eclipse.edt.mof.egl.GetByKeyStatement;
import org.eclipse.edt.mof.egl.GetByPositionStatement;
import org.eclipse.edt.mof.egl.GoToStatement;
import org.eclipse.edt.mof.egl.IfStatement;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.LabelStatement;
import org.eclipse.edt.mof.egl.LocalVariableDeclarationStatement;
import org.eclipse.edt.mof.egl.MoveStatement;
import org.eclipse.edt.mof.egl.OpenStatement;
import org.eclipse.edt.mof.egl.OpenUIStatement;
import org.eclipse.edt.mof.egl.Parameter;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PrepareStatement;
import org.eclipse.edt.mof.egl.PrintStatement;
import org.eclipse.edt.mof.egl.ReplaceStatement;
import org.eclipse.edt.mof.egl.ReturnStatement;
import org.eclipse.edt.mof.egl.SetStatement;
import org.eclipse.edt.mof.egl.SetValuesStatement;
import org.eclipse.edt.mof.egl.ShowStatement;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.ThrowStatement;
import org.eclipse.edt.mof.egl.TransferStatement;
import org.eclipse.edt.mof.egl.TryStatement;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.WhileStatement;
import org.eclipse.edt.mof.egl.compiler.EGL2IREnvironment;
import org.eclipse.edt.mof.egl.egl2mof.DefaultIOStatementGenerator;
import org.eclipse.edt.mof.egl.egl2mof.Egl2MofMember;
import org.eclipse.edt.mof.egl.egl2mof.IOStatementGenerator;
import org.eclipse.edt.mof.egl.egl2mof.sql.SQLIOStatementGenerator;

abstract class Egl2MofStatement
extends Egl2MofMember {
    static {
        IOStatementGenerator.Registry.put("egl.io.sql.SQLRecord", new SQLIOStatementGenerator());
        IOStatementGenerator.Registry.put("egl.lang", new DefaultIOStatementGenerator());
    }

    Egl2MofStatement(EGL2IREnvironment env) {
        super(env);
        for (Map.Entry<String, IOStatementGenerator> entry : IOStatementGenerator.Registry.entrySet()) {
            entry.getValue().setEnvironment(env);
        }
    }

    protected void setElementInformation(Node node, Statement stmt) {
        stmt.setContainer(this.getCurrentFunctionMember());
        super.setElementInformation(node, stmt);
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.AddStatement node) {
        IOStatementGenerator generator = this.getGeneratorFor((org.eclipse.edt.compiler.core.ast.Statement)node);
        AddStatement stmt = generator.genAddStatement(node, this.eObjects);
        this.setElementInformation((Node)node, stmt);
        this.stack.push(stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.CloseStatement node) {
        IOStatementGenerator generator = this.getGeneratorFor((org.eclipse.edt.compiler.core.ast.Statement)node);
        CloseStatement stmt = generator.genCloseStatement(node, this.eObjects);
        this.setElementInformation((Node)node, stmt);
        this.stack.push(stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.AssignmentStatement assignmentStatement) {
        AssignmentStatement stmt = this.factory.createAssignmentStatement();
        assignmentStatement.getAssignment().accept((IASTVisitor)this);
        stmt.setExpr((Expression)this.stack.pop());
        this.setElementInformation((Node)assignmentStatement, stmt);
        this.stack.push(stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.SetValuesStatement setValuesStatement) {
        SetValuesStatement stmt = this.factory.createSetValuesStatement();
        setValuesStatement.getSetValuesExpression().accept((IASTVisitor)this);
        stmt.setExpr((Expression)this.stack.pop());
        this.setElementInformation((Node)setValuesStatement, stmt);
        this.stack.push(stmt);
        return false;
    }

    public boolean visit(FunctionDataDeclaration decl) {
        LocalVariableDeclarationStatement stmt = this.factory.createLocalVariableDeclarationStatement();
        this.stack.push(stmt);
        DeclarationExpression expr = this.factory.createDeclarationExpression();
        for (Name name : decl.getNames()) {
            LocalVariableBinding binding = (LocalVariableBinding)name.resolveDataBinding();
            Field field = this.factory.createField();
            field.setName(binding.getCaseSensitiveName());
            field.setType((Type)this.mofTypeFor(binding.getType()));
            field.setIsNullable(binding.getType().isNullable());
            field.setContainer(this.getCurrentFunctionMember());
            this.addInitializers(decl.getInitializer(), decl.getSettingsBlockOpt(), field, decl.getType());
            expr.getFields().add(field);
            this.setElementInformation((Node)name, field);
            this.eObjects.put(binding, field);
        }
        this.setElementInformation((Node)decl, stmt);
        stmt.setExpression(expr);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.ReturnStatement stmt) {
        ReturnStatement irStmt = this.factory.createReturnStatement();
        this.stack.push(irStmt);
        if (stmt.getParenthesizedExprOpt() != null) {
            stmt.getParenthesizedExprOpt().accept((IASTVisitor)this);
            irStmt.setExpression((Expression)this.stack.pop());
        }
        this.setElementInformation((Node)stmt, irStmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.CallStatement callStatement) {
        CallStatement stmt = this.factory.createCallStatement();
        callStatement.getInvocationTarget().accept((IASTVisitor)this);
        stmt.setInvocationTarget((Expression)this.stack.pop());
        if (callStatement.hasArguments()) {
            for (Node node : callStatement.getArguments()) {
                node.accept((IASTVisitor)this);
                stmt.getArguments().add((Expression)this.stack.pop());
            }
        }
        if (callStatement.getCallbackTarget() != null) {
            callStatement.getCallbackTarget().accept((IASTVisitor)this);
            stmt.setCallback((Expression)this.stack.pop());
        }
        if (callStatement.getErrorCallbackTarget() != null) {
            callStatement.getErrorCallbackTarget().accept((IASTVisitor)this);
            stmt.setErrorCallback((Expression)this.stack.pop());
        }
        this.setElementInformation((Node)callStatement, stmt);
        this.stack.push(stmt);
        if (callStatement.hasSettingsBlock()) {
            this.processSettings(stmt, callStatement.getSettingsBlock());
        }
        return false;
    }

    public boolean visit(CaseStatement caseStatement) {
        IfStatement stmt = null;
        Expression criterion = null;
        if (caseStatement.hasCriterion()) {
            caseStatement.getCriterion().accept((IASTVisitor)this);
            criterion = (Expression)this.stack.pop();
        }
        IfStatement current = null;
        for (Node node : caseStatement.getWhenClauses()) {
            node.accept((IASTVisitor)this);
            IfStatement when = (IfStatement)this.stack.pop();
            if (criterion != null) {
                BinaryExpression condition = this.factory.createBinaryExpression();
                condition.setLHS(criterion);
                condition.setRHS(when.getCondition());
                condition.setOperator("==");
                when.setCondition(condition);
            }
            if (stmt == null) {
                stmt = current = when;
                continue;
            }
            current.setFalseBranch(when);
            current = when;
        }
        if (caseStatement.getDefaultClause() != null) {
            caseStatement.getDefaultClause().accept((IASTVisitor)this);
            current.setFalseBranch((Statement)this.stack.pop());
        }
        this.stack.push(stmt);
        this.setElementInformation((Node)caseStatement, stmt);
        return false;
    }

    public boolean visit(OtherwiseClause otherwiseClause) {
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)otherwiseClause, block);
        this.stack.push(block);
        for (Node node : otherwiseClause.getStatements()) {
            node.accept((IASTVisitor)this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        return false;
    }

    public boolean visit(WhenClause whenClause) {
        IfStatement clause = this.factory.createIfStatement();
        for (Node node : whenClause.getExpr_plus()) {
            node.accept((IASTVisitor)this);
            clause.setCondition((Expression)this.stack.pop());
        }
        StatementBlock block = this.factory.createStatementBlock();
        for (Node node : whenClause.getStmts()) {
            node.accept((IASTVisitor)this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        clause.setTrueBranch(block);
        this.stack.push(clause);
        this.setElementInformation((Node)whenClause, clause);
        this.setElementInformation((Node)whenClause, block);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.ContinueStatement node) {
        ContinueStatement stmt = this.factory.createContinueStatement();
        stmt.setLabel(stmt.getLabel());
        if (node.isContinueFor()) {
            stmt.setContinueType(1);
        } else if (node.isContinueForEach()) {
            stmt.setContinueType(2);
        } else if (node.isContinueOpenUI()) {
            stmt.setContinueType(3);
        } else if (node.isContinueWhile()) {
            stmt.setContinueType(4);
        }
        this.stack.push(stmt);
        this.setElementInformation((Node)node, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.ConverseStatement converseStatement) {
        IOStatementGenerator generator = this.getGeneratorFor((org.eclipse.edt.compiler.core.ast.Statement)converseStatement);
        ConverseStatement stmt = generator.genConverseStatement(converseStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)converseStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.DeleteStatement deleteStatement) {
        IOStatementGenerator generator = this.getGeneratorFor((org.eclipse.edt.compiler.core.ast.Statement)deleteStatement);
        DeleteStatement stmt = generator.genDeleteStatement(deleteStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)deleteStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.DisplayStatement displayStatement) {
        IOStatementGenerator generator = this.getGeneratorFor((org.eclipse.edt.compiler.core.ast.Statement)displayStatement);
        DisplayStatement stmt = generator.genDisplayStatement(displayStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)displayStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.EmptyStatement emptyStatement) {
        EmptyStatement stmt = this.factory.createEmptyStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)emptyStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.ExecuteStatement executeStatement) {
        IOStatementGenerator generator = this.getGeneratorFor((org.eclipse.edt.compiler.core.ast.Statement)executeStatement);
        ExecuteStatement stmt = generator.genExecuteStatement(executeStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)executeStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.ExitStatement node) {
        ExitStatement ext = this.factory.createExitStatement();
        ext.setLabel(node.getLabel());
        if (node.isExitCase()) {
            ext.setExitStatementType(1);
        } else if (node.isExitFor()) {
            ext.setExitStatementType(3);
        } else if (node.isExitForEach()) {
            ext.setExitStatementType(5);
        } else if (node.isExitIf()) {
            ext.setExitStatementType(2);
        } else if (node.isExitOpenUI()) {
            ext.setExitStatementType(6);
        } else if (node.isExitProgram()) {
            ext.setExitStatementType(7);
        } else if (node.isExitRunUnit()) {
            ext.setExitStatementType(9);
        } else if (node.isExitStack()) {
            ext.setExitStatementType(9);
        } else if (node.isExitWhile()) {
            ext.setExitStatementType(4);
        }
        if (node.getReturnCode() != null) {
            node.getReturnCode().accept((IASTVisitor)this);
            ext.setReturnExpr((Expression)this.stack.pop());
        }
        if (node.hasSettingsBlock()) {
            this.processSettings(ext, node.getSettingsBlock());
        }
        this.stack.push(ext);
        this.setElementInformation((Node)node, ext);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.ForEachStatement forEachStatement) {
        IOStatementGenerator generator = this.getGeneratorFor((org.eclipse.edt.compiler.core.ast.Statement)forEachStatement);
        ForEachStatement stmt = generator.genForEachStatement(forEachStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)forEachStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.ForStatement forStatement) {
        ForStatement stmt = this.factory.createForStatement();
        if (forStatement.getCounterVariable() == null) {
            DeclarationExpression decl = this.factory.createDeclarationExpression();
            Field field = this.factory.createField();
            field.setName(forStatement.getVariableDeclarationName().getCanonicalName());
            ITypeBinding type = forStatement.getVariableDeclarationType().resolveTypeBinding();
            field.setType((Type)this.mofTypeFor(type));
            decl.getFields().add(field);
            this.eObjects.put(forStatement.getVariableDeclarationName().resolveDataBinding(), field);
            stmt.setDeclarationExpression(decl);
        } else {
            forStatement.getCounterVariable().accept((IASTVisitor)this);
            stmt.setCounterVariable((Expression)this.stack.pop());
        }
        if (forStatement.getDeltaExpression() != null) {
            forStatement.getDeltaExpression().accept((IASTVisitor)this);
            stmt.setDeltaExpression((Expression)this.stack.pop());
            stmt.setIsIncrement(forStatement.hasPositiveDelta());
        }
        if (forStatement.getFromIndex() != null) {
            forStatement.getFromIndex().accept((IASTVisitor)this);
            stmt.setFromExpression((Expression)this.stack.pop());
        }
        if (forStatement.getEndIndex() != null) {
            forStatement.getEndIndex().accept((IASTVisitor)this);
            stmt.setToExpression((Expression)this.stack.pop());
        }
        StatementBlock block = this.factory.createStatementBlock();
        for (Node node : forStatement.getStmts()) {
            node.accept((IASTVisitor)this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        stmt.setBody(block);
        this.stack.push(stmt);
        this.setElementInformation((Node)forStatement, stmt);
        this.setElementInformation((Node)forStatement, block);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.ForwardStatement forwardStatement) {
        ForwardStatement stmt = this.factory.createForwardStatement();
        if (forwardStatement.hasForwardTarget()) {
            forwardStatement.getForwardTarget().accept((IASTVisitor)this);
            stmt.setForwardToTarget((Expression)this.stack.pop());
        }
        Iterator iterator = forwardStatement.getForwardOptions().iterator();
        while (iterator.hasNext()) {
            Node cfr_ignored_0 = (Node)iterator.next();
        }
        for (Node node : forwardStatement.getArguments()) {
            node.accept((IASTVisitor)this);
            stmt.getArguments().add((Expression)this.stack.pop());
        }
        this.stack.push(stmt);
        this.setElementInformation((Node)forwardStatement, stmt);
        return false;
    }

    public boolean visit(FreeSQLStatement freeSQLStatement) {
        FreeSqlStatement stmt = this.factory.createFreeSqlStatement();
        stmt.setPreparedStatementID(freeSQLStatement.getID());
        this.stack.push(stmt);
        this.setElementInformation((Node)freeSQLStatement, stmt);
        return false;
    }

    public boolean visit(FunctionInvocationStatement functionInvocationStatement) {
        FunctionStatement stmt = this.factory.createFunctionStatement();
        functionInvocationStatement.getFunctionInvocation().accept((IASTVisitor)this);
        stmt.setExpr((Expression)this.stack.pop());
        this.stack.push(stmt);
        this.setElementInformation((Node)functionInvocationStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.GetByPositionStatement getByPositionStatement) {
        IOStatementGenerator generator = this.getGeneratorFor((org.eclipse.edt.compiler.core.ast.Statement)getByPositionStatement);
        GetByPositionStatement stmt = generator.genGetByPositionStatement(getByPositionStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)getByPositionStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.GetByKeyStatement getByKeyStatement) {
        IOStatementGenerator generator = this.getGeneratorFor((org.eclipse.edt.compiler.core.ast.Statement)getByKeyStatement);
        GetByKeyStatement stmt = generator.genGetByKeyStatement(getByKeyStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)getByKeyStatement, stmt);
        return false;
    }

    public boolean visit(GotoStatement gotoStatement) {
        GoToStatement stmt = this.factory.createGoToStatement();
        stmt.setLabel(gotoStatement.getLabel());
        this.stack.push(stmt);
        this.setElementInformation((Node)gotoStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.IfStatement ifStatement) {
        IfStatement stmt = this.factory.createIfStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)ifStatement, stmt);
        ifStatement.getCondition().accept((IASTVisitor)this);
        stmt.setCondition((Expression)this.stack.pop());
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)ifStatement, block);
        stmt.setTrueBranch(block);
        for (Node node : ifStatement.getStmts()) {
            node.accept((IASTVisitor)this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        if (ifStatement.hasElse()) {
            block = this.factory.createStatementBlock();
            this.setElementInformation((Node)ifStatement, block);
            stmt.setFalseBranch(block);
            for (Node node : ifStatement.getElse().getStmts()) {
                node.accept((IASTVisitor)this);
                block.getStatements().add((Statement)this.stack.pop());
            }
        }
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.LabelStatement labelStatement) {
        LabelStatement stmt = this.factory.createLabelStatement();
        stmt.setLabel(labelStatement.getLabel());
        this.stack.push(stmt);
        this.setElementInformation((Node)labelStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.MoveStatement moveStatement) {
        MoveStatement stmt = this.factory.createMoveStatement();
        moveStatement.getSource().accept((IASTVisitor)this);
        stmt.setSourceExpr((Expression)this.stack.pop());
        moveStatement.getTarget().accept((IASTVisitor)this);
        stmt.setTargetExpr((LHSExpr)this.stack.pop());
        this.stack.push(stmt);
        this.setElementInformation((Node)moveStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.OpenStatement openStatement) {
        IOStatementGenerator generator = this.getGeneratorFor((org.eclipse.edt.compiler.core.ast.Statement)openStatement);
        OpenStatement stmt = generator.genOpenStatement(openStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)openStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.OpenUIStatement openUIStatement) {
        OpenUIStatement stmt = this.factory.createOpenUIStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)openUIStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.PrepareStatement prepareStatement) {
        IOStatementGenerator generator = this.getGeneratorFor((org.eclipse.edt.compiler.core.ast.Statement)prepareStatement);
        PrepareStatement stmt = generator.genPrepareStatement(prepareStatement, this.eObjects);
        this.setElementInformation((Node)prepareStatement, stmt);
        this.stack.push(stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.PrintStatement printStatement) {
        PrintStatement stmt = this.factory.createPrintStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)printStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.ReplaceStatement replaceStatement) {
        IOStatementGenerator generator = this.getGeneratorFor((org.eclipse.edt.compiler.core.ast.Statement)replaceStatement);
        ReplaceStatement stmt = generator.genReplaceStatement(replaceStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)replaceStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.SetStatement setStatement) {
        SetStatement stmt = this.factory.createSetStatement();
        for (Node node : setStatement.getSetTargets()) {
            node.accept((IASTVisitor)this);
            stmt.getTargets().add((Expression)this.stack.pop());
        }
        for (String state : setStatement.getStates()) {
            stmt.getStates().add(state);
        }
        this.stack.push(stmt);
        this.setElementInformation((Node)setStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.ShowStatement showStatement) {
        IOStatementGenerator generator = this.getGeneratorFor((org.eclipse.edt.compiler.core.ast.Statement)showStatement);
        ShowStatement stmt = generator.genShowStatement(showStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)showStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.ThrowStatement throwStatement) {
        ThrowStatement stmt = this.factory.createThrowStatement();
        throwStatement.getExpression().accept((IASTVisitor)this);
        stmt.setException((Expression)this.stack.pop());
        this.stack.push(stmt);
        this.setElementInformation((Node)throwStatement, stmt);
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.TransferStatement transferStatement) {
        TransferStatement stmt = this.factory.createTransferStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)transferStatement, stmt);
        transferStatement.getInvocationTarget().accept((IASTVisitor)this);
        stmt.setInvocationTarget((Expression)this.stack.pop());
        if (transferStatement.getPassingRecord() != null) {
            transferStatement.getPassingRecord().accept((IASTVisitor)this);
            stmt.setPassingRecord((Expression)this.stack.pop());
        }
        int targetType = transferStatement.isToProgram() ? 1 : 2;
        stmt.setTargetType(targetType);
        this.stack.push(stmt);
        if (transferStatement.hasSettingsBlock()) {
            this.processSettings(stmt, transferStatement.getSettingsBlock());
        }
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.TryStatement tryStatement) {
        TryStatement stmt = this.factory.createTryStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)tryStatement, stmt);
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)tryStatement, block);
        stmt.setTryBlock(block);
        for (Node node : tryStatement.getStmts()) {
            node.accept((IASTVisitor)this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        for (Node node : tryStatement.getOnExceptionBlocks()) {
            node.accept((IASTVisitor)this);
            stmt.getExceptionBlocks().add((ExceptionBlock)this.stack.pop());
        }
        return false;
    }

    public boolean visit(OnExceptionBlock onExceptionBlock) {
        ExceptionBlock block = this.factory.createExceptionBlock();
        this.stack.push(block);
        this.setElementInformation((Node)onExceptionBlock, block);
        if (onExceptionBlock.getExceptionName() != null) {
            Parameter ex = this.factory.createParameter();
            this.setElementInformation((Node)onExceptionBlock.getExceptionName(), ex);
            ex.setName(onExceptionBlock.getExceptionName().getCaseSensitiveIdentifier());
            ITypeBinding type = onExceptionBlock.getExceptionType().resolveTypeBinding();
            ex.setType((Type)this.mofTypeFor(type));
            this.eObjects.put(onExceptionBlock.getExceptionName().resolveDataBinding(), ex);
            block.setException(ex);
        }
        for (Node node : onExceptionBlock.getStmts()) {
            node.accept((IASTVisitor)this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        return false;
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.WhileStatement whileStatement) {
        WhileStatement stmt = this.factory.createWhileStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)whileStatement, stmt);
        whileStatement.getExpr().accept((IASTVisitor)this);
        stmt.setCondition((Expression)this.stack.pop());
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)whileStatement, block);
        stmt.setBody(block);
        for (Node node : whileStatement.getStmts()) {
            node.accept((IASTVisitor)this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        return false;
    }

    private IOStatementGenerator getGeneratorFor(org.eclipse.edt.compiler.core.ast.Statement node) {
        Name nameExpr = null;
        if (!node.getIOObjects().isEmpty()) {
            nameExpr = (Name)node.getIOObjects().get(0);
        }
        if (nameExpr == null) {
            if (node instanceof org.eclipse.edt.compiler.core.ast.ForEachStatement || node instanceof org.eclipse.edt.compiler.core.ast.PrepareStatement || node instanceof org.eclipse.edt.compiler.core.ast.ExecuteStatement) {
                return IOStatementGenerator.Registry.get("egl.io.sql.SQLRecord");
            }
            return IOStatementGenerator.Registry.get("egl.lang");
        }
        String generatorKey = null;
        IDataBinding ioObjectBinding = nameExpr.resolveDataBinding();
        if (ioObjectBinding.equals(IBinding.NOT_FOUND_BINDING)) {
            generatorKey = this.isDliStatement(node) ? "egl.io.sql.DLIRecord" : (this.isSqlStatement(node) ? "egl.io.sql.SQLRecord" : "egl.lang");
        } else {
            ITypeBinding typeBinding = nameExpr.resolveDataBinding().getType();
            Part part = typeBinding.getKind() == 2 ? (Part)this.mofTypeFor(((ArrayTypeBinding)typeBinding).getElementType()) : (Part)this.mofTypeFor(typeBinding);
            generatorKey = part.getStereotype().getEClass().getETypeSignature();
        }
        IOStatementGenerator generator = IOStatementGenerator.Registry.get(generatorKey);
        if (generator == null) {
            generator = IOStatementGenerator.Registry.get("egl.lang");
        }
        return generator;
    }

    private boolean isDliStatement(org.eclipse.edt.compiler.core.ast.Statement stmt) {
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.AddStatement) {
            return ((org.eclipse.edt.compiler.core.ast.AddStatement)stmt).getDliInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.DeleteStatement) {
            return ((org.eclipse.edt.compiler.core.ast.DeleteStatement)stmt).getDliInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.GetByKeyStatement) {
            return ((org.eclipse.edt.compiler.core.ast.GetByKeyStatement)stmt).getDliInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.GetByPositionStatement) {
            return ((org.eclipse.edt.compiler.core.ast.GetByPositionStatement)stmt).getDliInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.ReplaceStatement) {
            return ((org.eclipse.edt.compiler.core.ast.ReplaceStatement)stmt).getDliInfo() != null;
        }
        return false;
    }

    private boolean isSqlStatement(org.eclipse.edt.compiler.core.ast.Statement stmt) {
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.AddStatement) {
            return ((org.eclipse.edt.compiler.core.ast.AddStatement)stmt).getSqlInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.DeleteStatement) {
            return ((org.eclipse.edt.compiler.core.ast.DeleteStatement)stmt).getSqlInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.ExecuteStatement) {
            return true;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.ForEachStatement) {
            return true;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.GetByKeyStatement) {
            return ((org.eclipse.edt.compiler.core.ast.GetByKeyStatement)stmt).getSqlInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.GetByPositionStatement) {
            return !this.isDliStatement(stmt);
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.OpenStatement) {
            return ((org.eclipse.edt.compiler.core.ast.OpenStatement)stmt).getSqlInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.ReplaceStatement) {
            return ((org.eclipse.edt.compiler.core.ast.ReplaceStatement)stmt).getSqlInfo() != null;
        }
        return false;
    }
}

