/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.egl2mof.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.ForUpdateClause;
import org.eclipse.edt.compiler.core.ast.FromExpressionClause;
import org.eclipse.edt.compiler.core.ast.FromResultSetClause;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.NoCursorClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.PrepareStatement;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.SingleRowClause;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WithIDClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.sql.ItemNameToken;
import org.eclipse.edt.compiler.internal.sql.SQLInfo;
import org.eclipse.edt.compiler.internal.sql.Token;
import org.eclipse.edt.compiler.internal.sql.WhereCurrentOfToken;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.compiler.EGL2IREnvironment;
import org.eclipse.edt.mof.egl.egl2mof.DefaultIOStatementGenerator;
import org.eclipse.edt.mof.egl.sql.SqlAddStatement;
import org.eclipse.edt.mof.egl.sql.SqlClause;
import org.eclipse.edt.mof.egl.sql.SqlDeleteStatement;
import org.eclipse.edt.mof.egl.sql.SqlExecuteStatement;
import org.eclipse.edt.mof.egl.sql.SqlFactory;
import org.eclipse.edt.mof.egl.sql.SqlForEachStatement;
import org.eclipse.edt.mof.egl.sql.SqlGetByKeyStatement;
import org.eclipse.edt.mof.egl.sql.SqlGetByPositionStatement;
import org.eclipse.edt.mof.egl.sql.SqlHostVariableToken;
import org.eclipse.edt.mof.egl.sql.SqlOpenStatement;
import org.eclipse.edt.mof.egl.sql.SqlPrepareStatement;
import org.eclipse.edt.mof.egl.sql.SqlReplaceStatement;
import org.eclipse.edt.mof.egl.sql.SqlSelectNameToken;
import org.eclipse.edt.mof.egl.sql.SqlStringToken;
import org.eclipse.edt.mof.egl.sql.SqlToken;
import org.eclipse.edt.mof.egl.sql.SqlWhereCurrentOfToken;

public class SQLIOStatementGenerator
extends DefaultIOStatementGenerator {
    SqlFactory factory = SqlFactory.INSTANCE;
    final SQLIOStatementGenerator generator = this;

    public SQLIOStatementGenerator() {
        super(null);
    }

    public SQLIOStatementGenerator(EGL2IREnvironment env) {
        super(env);
    }

    @Override
    public boolean visit(AddStatement node) {
        super.visit(node);
        SqlAddStatement stmt = (SqlAddStatement)this.stack.peek();
        if (node.getSqlInfo() != null) {
            HashMap<String, List<SqlToken>> map = this.createSqlTokensMap(node.getSqlInfo());
            stmt.setColumnsClause(this.createSqlClause("columns", map));
            stmt.setInsertIntoClause(this.createSqlClause("insert into", map));
            stmt.setValuesClause(this.createSqlClause("values", map));
        }
        return false;
    }

    @Override
    public boolean visit(DeleteStatement node) {
        super.visit(node);
        final SqlDeleteStatement stmt = (SqlDeleteStatement)this.stack.peek();
        node.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

            public boolean visit(FromResultSetClause fromResultSetClause) {
                stmt.setResultSetIdentifier(fromResultSetClause.getResultSetID());
                return false;
            }

            public boolean visit(NoCursorClause noCursorClause) {
                stmt.setNoCursor(true);
                return false;
            }

            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                stmt.setHasExplicitSql(true);
                return false;
            }
        });
        if (node.getSqlInfo() != null) {
            List<SqlToken> tokens;
            HashMap<String, List<SqlToken>> map = this.createSqlTokensMap(node.getSqlInfo());
            stmt.setDeleteClause(this.createSqlClause("delete", map));
            stmt.setFromClause(this.createSqlClause("from", map));
            stmt.setWhereClause(this.createSqlClause("where", map));
            if (stmt.getResultSetIdentifier() == null && map.get("where current of resultSetID") != null && (tokens = map.get("where current of resultSetID")).size() > 0) {
                SqlWhereCurrentOfToken whereToken = (SqlWhereCurrentOfToken)tokens.get(0);
                stmt.setResultSetIdentifier(whereToken.getResultSetIdentifier());
            }
        }
        return false;
    }

    @Override
    public boolean visit(ExecuteStatement node) {
        final SqlExecuteStatement stmt = this.factory.createSqlExecuteStatement();
        this.stack.push(stmt);
        stmt.setIsUpdate(node.isUpdate());
        stmt.setIsDelete(node.isDelete());
        stmt.setIsInsert(node.isInsert());
        stmt.setPreparedStatementId(node.getPreparedStatementID());
        SQLIOStatementGenerator stmtGenerator = this;
        node.accept((IASTVisitor)new AbstractASTExpressionVisitor((IASTVisitor)stmtGenerator){
            private final /* synthetic */ IASTVisitor val$stmtGenerator;
            {
                this.val$stmtGenerator = iASTVisitor;
            }

            public boolean visit(UsingClause usingClause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : usingClause.getExpressions()) {
                    expr.accept((IASTVisitor)this);
                    stmt.getUsingExpressions().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                }
                return false;
            }

            public boolean visit(ForExpressionClause forExpressionClause) {
                forExpressionClause.getExpression().accept(this.val$stmtGenerator);
                stmt.getTargets().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                return false;
            }
        });
        if (node.getSqlInfo() != null) {
            HashMap<String, List<SqlToken>> map = this.createSqlTokensMap(node.getSqlInfo());
            stmt.setSqlClause(this.createSqlClause("execute", map));
        }
        return false;
    }

    @Override
    public boolean visit(ForEachStatement forEachStatement) {
        super.visit(forEachStatement);
        SqlForEachStatement forEachStmt = (SqlForEachStatement)this.stack.peek();
        this.stack.push(forEachStmt);
        if (forEachStatement.hasSQLRecord()) {
            forEachStatement.getSQLRecord().accept((IASTVisitor)this);
            forEachStmt.getTargets().add((Expression)this.stack.pop());
        } else if (forEachStatement.hasResultSetID()) {
            forEachStmt.setResultSetIdentifier(forEachStatement.getResultSetID());
        }
        if (forEachStatement.hasIntoClause()) {
            for (org.eclipse.edt.compiler.core.ast.Expression expr : forEachStatement.getIntoItems()) {
                expr.accept((IASTVisitor)this);
                forEachStmt.getIntoExpressions().add((Expression)this.stack.pop());
            }
        }
        StatementBlock block = this.irFactory.createStatementBlock();
        forEachStmt.setBody(block);
        for (Node node : forEachStatement.getStmts()) {
            node.accept((IASTVisitor)this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        return false;
    }

    @Override
    public boolean visit(GetByKeyStatement node) {
        super.visit(node);
        final SqlGetByKeyStatement stmt = (SqlGetByKeyStatement)this.stack.peek();
        node.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

            public boolean visit(ForUpdateClause clause) {
                stmt.setIsForUpdate(true);
                stmt.setResultSetIdentifier(clause.getID());
                return false;
            }

            public boolean visit(SingleRowClause clause) {
                stmt.setIsSingleRowSelect(true);
                return false;
            }

            public boolean visit(WithIDClause clause) {
                stmt.setPreparedStatementId(clause.getID());
                stmt.setHasExplicitSql(true);
                return false;
            }

            public boolean visit(IntoClause clause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : clause.getExpressions()) {
                    expr.accept((IASTVisitor)SQLIOStatementGenerator.this.generator);
                    stmt.getIntoExpressions().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                }
                return false;
            }

            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                stmt.setHasExplicitSql(true);
                return false;
            }
        });
        if (node.getSqlInfo() != null) {
            HashMap<String, List<SqlToken>> map = this.createSqlTokensMap(node.getSqlInfo());
            stmt.setCallClause(this.createSqlClause("call", map));
            stmt.setSelectClause(this.createSqlClause("select", map));
            stmt.setFromClause(this.createSqlClause("from", map));
            stmt.setWhereClause(this.createSqlClause("where", map));
            stmt.setGroupByClause(this.createSqlClause("group by", map));
            stmt.setHavingClause(this.createSqlClause("having", map));
            stmt.setOrderByClause(this.createSqlClause("order by", map));
            stmt.setForUpdateOfClause(this.createSqlClause("for update of", map));
        }
        return false;
    }

    @Override
    public boolean visit(GetByPositionStatement node) {
        super.visit(node);
        final SqlGetByPositionStatement stmt = (SqlGetByPositionStatement)this.stack.peek();
        if (node.hasFromResultSetID()) {
            stmt.setResultSetIdentifier(node.getFromResultSetID());
        }
        node.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

            public boolean visit(IntoClause clause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : clause.getExpressions()) {
                    expr.accept((IASTVisitor)SQLIOStatementGenerator.this.generator);
                    stmt.getIntoExpressions().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                }
                return false;
            }
        });
        return false;
    }

    @Override
    public boolean visit(OpenStatement node) {
        final SqlOpenStatement stmt = this.factory.createSqlOpenStatement();
        this.stack.push(stmt);
        stmt.setResultSetIdentifier(node.getResultSetID());
        stmt.setIsHold(node.hasHold());
        stmt.setIsScroll(node.hasScroll());
        node.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

            public boolean visit(ForUpdateClause clause) {
                stmt.setIsForUpdate(true);
                return false;
            }

            public boolean visit(WithIDClause clause) {
                stmt.setPreparedStatementId(clause.getID());
                stmt.setHasExplicitSql(true);
                return false;
            }

            public boolean visit(IntoClause clause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : clause.getExpressions()) {
                    expr.accept((IASTVisitor)SQLIOStatementGenerator.this.generator);
                    stmt.getIntoExpressions().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                }
                return false;
            }

            public boolean visit(UsingClause clause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : clause.getExpressions()) {
                    expr.accept((IASTVisitor)SQLIOStatementGenerator.this.generator);
                    stmt.getUsingExpressions().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                }
                return false;
            }

            public boolean visit(UsingKeysClause clause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : clause.getExpressions()) {
                    expr.accept((IASTVisitor)SQLIOStatementGenerator.this.generator);
                    stmt.getUsingKeyExpressions().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                }
                return false;
            }

            public boolean visit(ForExpressionClause forExpressionClause) {
                forExpressionClause.getExpression().accept((IASTVisitor)SQLIOStatementGenerator.this.generator);
                stmt.getTargets().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                return false;
            }

            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                stmt.setHasExplicitSql(true);
                return false;
            }
        });
        if (node.getSqlInfo() != null) {
            HashMap<String, List<SqlToken>> map = this.createSqlTokensMap(node.getSqlInfo());
            stmt.setCallClause(this.createSqlClause("call", map));
            stmt.setSelectClause(this.createSqlClause("select", map));
            stmt.setFromClause(this.createSqlClause("from", map));
            stmt.setWhereClause(this.createSqlClause("where", map));
            stmt.setGroupByClause(this.createSqlClause("group by", map));
            stmt.setHavingClause(this.createSqlClause("having", map));
            stmt.setOrderByClause(this.createSqlClause("order by", map));
            stmt.setForUpdateOfClause(this.createSqlClause("for update of", map));
        }
        return false;
    }

    @Override
    public boolean visit(PrepareStatement node) {
        final SqlPrepareStatement stmt = this.factory.createSqlPrepareStatement();
        this.stack.push(stmt);
        stmt.setPreparedStatementId(node.getPreparedStatementID());
        node.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

            public boolean visit(FromExpressionClause clause) {
                clause.getExpression().accept((IASTVisitor)SQLIOStatementGenerator.this.generator);
                stmt.setFromExpression((Expression)SQLIOStatementGenerator.this.stack.pop());
                return false;
            }

            public boolean visit(ForExpressionClause clause) {
                clause.getExpression().accept((IASTVisitor)SQLIOStatementGenerator.this.generator);
                stmt.setForExpression((Expression)SQLIOStatementGenerator.this.stack.pop());
                return false;
            }
        });
        return false;
    }

    @Override
    public boolean visit(ReplaceStatement node) {
        super.visit(node);
        final SqlReplaceStatement stmt = (SqlReplaceStatement)this.stack.peek();
        node.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

            public boolean visit(FromResultSetClause clause) {
                stmt.setResultSetIdentifier(clause.getResultSetID());
                return false;
            }

            public boolean visit(NoCursorClause noCursorClause) {
                stmt.setNoCursor(true);
                return false;
            }

            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                stmt.setHasExplicitSql(true);
                return false;
            }
        });
        if (node.getSqlInfo() != null) {
            List<SqlToken> tokens;
            HashMap<String, List<SqlToken>> map = this.createSqlTokensMap(node.getSqlInfo());
            stmt.setSetClause(this.createSqlClause("set", map));
            stmt.setUpdateClause(this.createSqlClause("update", map));
            stmt.setWhereClause(this.createSqlClause("where", map));
            if (stmt.getResultSetIdentifier() == null && map.get("where current of resultSetID") != null && (tokens = map.get("where current of resultSetID")).size() > 0) {
                SqlWhereCurrentOfToken whereToken = (SqlWhereCurrentOfToken)tokens.get(0);
                stmt.setResultSetIdentifier(whereToken.getResultSetIdentifier());
            }
        }
        return false;
    }

    @Override
    public EClass getStatementEClass(AddStatement stmt) {
        return this.factory.getSqlAddStatementEClass();
    }

    @Override
    public EClass getStatementEClass(CloseStatement stmt) {
        return this.factory.getSqlCloseStatementEClass();
    }

    @Override
    public EClass getStatementEClass(DeleteStatement stmt) {
        return this.factory.getSqlDeleteStatementEClass();
    }

    @Override
    public EClass getStatementEClass(ExecuteStatement stmt) {
        return this.factory.getSqlExecuteStatementEClass();
    }

    @Override
    public EClass getStatementEClass(ForEachStatement stmt) {
        return this.factory.getSqlForEachStatementEClass();
    }

    @Override
    public EClass getStatementEClass(GetByKeyStatement stmt) {
        return this.factory.getSqlGetByKeyStatementEClass();
    }

    @Override
    public EClass getStatementEClass(GetByPositionStatement stmt) {
        return this.factory.getSqlGetByPositionStatementEClass();
    }

    @Override
    public EClass getStatementEClass(OpenStatement stmt) {
        return this.factory.getSqlOpenStatementEClass();
    }

    @Override
    public EClass getStatementEClass(PrepareStatement stmt) {
        return this.factory.getSqlPrepareStatementEClass();
    }

    @Override
    public EClass getStatementEClass(ReplaceStatement stmt) {
        return this.factory.getSqlReplaceStatementEClass();
    }

    private HashMap<String, List<SqlToken>> createSqlTokensMap(SQLInfo sqlinfo) {
        HashMap<String, List<SqlToken>> map = new HashMap<String, List<SqlToken>>();
        HashMap clauseMap = sqlinfo.getClauseMap();
        for (String key : clauseMap.keySet()) {
            Token[] tokens = (Token[])clauseMap.get(key);
            map.put(key, this.convertSqlTokens(tokens));
        }
        return map;
    }

    private SqlToken convertSqlToken(Token oldToken) {
        if (oldToken.isItemNameToken()) {
            ItemNameToken itemNameToken = (ItemNameToken)oldToken;
            if (itemNameToken.getExpression() != null) {
                itemNameToken.getExpression().accept((IASTVisitor)this);
            }
            SqlHostVariableToken newToken = null;
            if (itemNameToken.isInputHostVariableToken()) {
                newToken = this.factory.createSqlInputHostVariableToken();
                newToken.setString(oldToken.getString());
                newToken.setSqlString(oldToken.getSQLString());
            } else if (itemNameToken.isOutputHostVariableToken()) {
                newToken = this.factory.createSqlOutputHostVariableToken();
                newToken.setString(oldToken.getString());
                newToken.setSqlString(oldToken.getSQLString());
            } else if (itemNameToken.isTableNameHostVariableToken()) {
                newToken = this.factory.createSqlTableNameHostVariableToken();
                newToken.setString(oldToken.getString());
                newToken.setSqlString(oldToken.getSQLString());
            }
            if (newToken != null) {
                newToken.setHostVarExpression((LHSExpr)this.stack.pop());
            }
            return newToken;
        }
        if (oldToken.isSelectNameToken()) {
            SqlSelectNameToken newToken = this.factory.createSqlSelectNameToken();
            newToken.setString(oldToken.getString());
            newToken.setSqlString(oldToken.getSQLString());
            return newToken;
        }
        if (oldToken.isStringToken()) {
            SqlStringToken newToken = this.factory.createSqlStringToken();
            newToken.setString(oldToken.getString());
            newToken.setSqlString(oldToken.getSQLString());
            return newToken;
        }
        if (oldToken.isWhereCurrentOfToken()) {
            SqlWhereCurrentOfToken whereToken = this.factory.createSqlWhereCurrentOfToken();
            whereToken.setString(oldToken.getString());
            whereToken.setSqlString(oldToken.getSQLString());
            whereToken.setResultSetIdentifier(((WhereCurrentOfToken)oldToken).getResultSetIdentifier());
            return whereToken;
        }
        return null;
    }

    private List<SqlToken> convertSqlTokens(Token[] oldTokens) {
        if (oldTokens == null) {
            return null;
        }
        ArrayList<SqlToken> list = new ArrayList<SqlToken>();
        int i = 0;
        while (i < oldTokens.length) {
            list.add(this.convertSqlToken(oldTokens[i]));
            ++i;
        }
        return list;
    }

    private SqlClause createSqlClause(String name, Map<String, List<SqlToken>> map) {
        if (map.get(name) != null) {
            SqlClause clause = this.factory.createSqlClause();
            clause.setName(name);
            clause.getTokens().addAll((Collection<SqlToken>)map.get(name));
            return clause;
        }
        return null;
    }
}

