/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.impl;

import java.util.List;
import org.eclipse.edt.mof.egl.AmbiguousFunctionReferenceError;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.GenericType;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.NoSuchFunctionError;
import org.eclipse.edt.mof.egl.QualifiedFunctionInvocation;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.impl.InvocationExpressionImpl;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class QualifiedFunctionInvocationImpl
extends InvocationExpressionImpl
implements QualifiedFunctionInvocation {
    private static int Slot_target = 0;
    private static int Slot_qualifier = 1;
    private static int totalSlots = 2;

    static {
        int offset = InvocationExpressionImpl.totalSlots();
        Slot_target += offset;
        Slot_qualifier += offset;
    }

    public static int totalSlots() {
        return totalSlots + InvocationExpressionImpl.totalSlots();
    }

    @Override
    public FunctionMember getTarget() {
        if (this.slotGet(Slot_target) == null) {
            try {
                this.setTarget(this.resolveFunction());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (FunctionMember)this.slotGet(Slot_target);
    }

    @Override
    public void setTarget(FunctionMember value) {
        this.slotSet(Slot_target, value);
    }

    @Override
    public Expression getQualifier() {
        return (Expression)this.slotGet(Slot_qualifier);
    }

    @Override
    public void setQualifier(Expression value) {
        this.slotSet(Slot_qualifier, value);
    }

    @Override
    public QualifiedFunctionInvocation addQualifier(Expression expr) {
        if (this.getQualifier() instanceof MemberAccess) {
            this.setQualifier(((MemberAccess)this.getQualifier()).addQualifier(expr));
        } else if (this.getQualifier() instanceof MemberName) {
            this.setQualifier(((MemberName)this.getQualifier()).addQualifier(expr));
        } else if (this.getQualifier() instanceof InvocationExpression) {
            this.setQualifier(((InvocationExpression)this.getQualifier()).addQualifier(expr));
        }
        return this;
    }

    @Override
    public Type getType() {
        Type type = this.getTarget().getType();
        if (type instanceof GenericType && type.getClassifier() == null) {
            type = ((GenericType)type).resolveTypeParameter(this.getQualifier().getType());
        }
        return type;
    }

    @Override
    public Type getParameterTypeForArg(int index) {
        Type type = super.getParameterTypeForArg(index);
        if (type instanceof GenericType && type.getClassifier() == null) {
            type = ((GenericType)type).resolveTypeParameter(this.getQualifier().getType());
        }
        return type;
    }

    private Function resolveFunction() {
        StructPart container = (StructPart)this.getQualifier().getType().getClassifier();
        Classifier[] argTypes = new Classifier[this.getArguments().size()];
        int i = 0;
        for (Expression expr : this.getArguments()) {
            argTypes[i] = expr.getType().getClassifier();
            ++i;
        }
        List<Function> result = null;
        result = TypeUtils.getBestFitFunction(container, this.getId(), argTypes);
        if (result.isEmpty()) {
            throw new NoSuchFunctionError();
        }
        if (result.size() > 1) {
            throw new AmbiguousFunctionReferenceError();
        }
        return result.get(0);
    }
}

