/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.lookup;

import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EDataType;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.MofFactory;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.FormGroup;
import org.eclipse.edt.mof.egl.GenericType;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.ParameterizedType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypeParameter;
import org.eclipse.edt.mof.egl.lookup.ProxyPart;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.ProxyEObject;
import org.eclipse.edt.mof.serialization.SerializationException;

public class EglLookupDelegate
implements IEnvironment.LookupDelegate {
    private IrFactory ir = IrFactory.INSTANCE;
    private String typeArgsSplitter = "[;]";
    private String primArgsSplitter = "[(: )]";

    public EObject find(String key, IEnvironment env) throws MofObjectNotFoundException, DeserializationException {
        return this.find(key, false, env);
    }

    public EObject find(String key, boolean useProxies, IEnvironment env) throws MofObjectNotFoundException, DeserializationException {
        int k = 0;
        String baseType = null;
        String nestedType = null;
        String[] typeArgs = null;
        String[] primArgs = null;
        int i = key.indexOf(60);
        int j = key.lastIndexOf(40);
        k = key.lastIndexOf("#");
        if (i == -1 && j == -1 && k == -1) {
            return env.lookup(key);
        }
        if (i != -1) {
            baseType = key.substring(0, i);
            typeArgs = key.substring(i + 1, key.length() - 1).split(this.typeArgsSplitter);
        }
        if (i == -1 && j != -1) {
            baseType = key.substring(0, j);
            primArgs = key.substring(j + 1, key.length() - 1).split(this.primArgsSplitter);
        }
        if (k != -1) {
            baseType = key.substring(0, k);
            nestedType = key.substring(k + 1);
            FormGroup fg = (FormGroup)env.lookup(baseType);
            return fg.getForm(nestedType);
        }
        Type result = null;
        try {
            Classifier eBaseType;
            Classifier classifier = eBaseType = baseType == null || baseType.equals("egl:") ? null : (Classifier)env.find(baseType, false);
            if (typeArgs == null) {
                EClass parameterizedTypeClass = ((ParameterizableType)eBaseType).getParameterizedType();
                if (parameterizedTypeClass != null) {
                    ParameterizedType type = (ParameterizedType)parameterizedTypeClass.newInstance();
                    type.setParameterizableType((ParameterizableType)eBaseType);
                    int totalSlots = parameterizedTypeClass.getAllEFields().size();
                    int l = totalSlots - primArgs.length;
                    while (l < totalSlots) {
                        String value = primArgs[l - (totalSlots - primArgs.length)];
                        if (!"".equals(value)) {
                            EField field = (EField)parameterizedTypeClass.getAllEFields().get(l);
                            Object converted = MofFactory.INSTANCE.createFromString((EDataType)field.getEType(), value);
                            type.eSet(field, converted);
                        }
                        ++l;
                    }
                    result = type;
                }
            } else {
                GenericType generic;
                boolean isArrayType = false;
                if (eBaseType != null && eBaseType.getTypeSignature().equalsIgnoreCase("egl.lang.List")) {
                    generic = this.ir.createArrayType();
                    isArrayType = true;
                } else {
                    generic = this.ir.createGenericType();
                }
                generic.setClassifier(eBaseType);
                if (typeArgs != null) {
                    String[] stringArray = typeArgs;
                    int n = typeArgs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String arg = stringArray[n2];
                        if (eBaseType == null) {
                            TypeParameter parm = this.ir.createTypeParameter();
                            parm.setName(arg);
                            generic.setTypeParameter(parm);
                            return generic;
                        }
                        if (isArrayType && arg.charAt(arg.length() - 1) == '?') {
                            arg = arg.substring(0, arg.length() - 1);
                            ((ArrayType)generic).setElementsNullable(true);
                        }
                        Type eType = (Type)env.find("egl:" + arg, useProxies);
                        generic.addTypeArgument(eType);
                        ++n2;
                    }
                }
                result = generic;
            }
            env.save(key, result, false);
        }
        catch (SerializationException serializationException) {}
        return result;
    }

    public Class<? extends ProxyEObject> getProxyClass() {
        return ProxyPart.class;
    }

    public boolean supportsScheme(String scheme) {
        return "egl".equals(scheme);
    }

    public String normalizeKey(String key) {
        return key.toUpperCase().toLowerCase();
    }
}

