/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.mof2binding;

import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.ConstantFormFieldBinding;
import org.eclipse.edt.compiler.binding.ConstructorBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.ProgramParameterBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.SystemFunctionParameterSpecialTypeBinding;
import org.eclipse.edt.compiler.binding.VariableFormFieldBinding;
import org.eclipse.edt.compiler.binding.annotationType.EGLSystemParameterTypesAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.lookup.IBindingEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemPartManager;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EDataType;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EFunction;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EModelElement;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EParameter;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.ETypedElement;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.MofFactory;
import org.eclipse.edt.mof.egl.ConstantFormField;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.ProgramParameter;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.StructuredField;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.VariableFormField;
import org.eclipse.edt.mof.egl.lookup.ProxyPart;
import org.eclipse.edt.mof.egl.mof2binding.EClassBinding;
import org.eclipse.edt.mof.egl.mof2binding.EFieldBinding;
import org.eclipse.edt.mof.egl.mof2binding.EFunctionBinding;
import org.eclipse.edt.mof.egl.mof2binding.EParameterBinding;
import org.eclipse.edt.mof.egl.mof2binding.Mof2BindingPart;

public abstract class Mof2BindingMember
extends Mof2BindingPart {
    public Mof2BindingMember(IBindingEnvironment env) {
        super(env);
    }

    public boolean visit(Field field) {
        IBinding binding = this.getBinding(field);
        if (binding == null) {
            String name = InternUtil.intern((String)field.getName());
            ITypeBinding type = this.bindingForType(field);
            field.getContainer().accept((EVisitor)this);
            IPartBinding declarer = (IPartBinding)this.stack.pop();
            if (field.getContainer() instanceof Record) {
                binding = new FlexibleRecordFieldBinding(name, declarer, type);
            } else {
                binding = new ClassFieldBinding(name, declarer, type);
                ((ClassFieldBinding)binding).setIsStatic(field.isStatic().booleanValue());
            }
            this.handleAnnotations(field, binding);
            this.putBinding(field, binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(StructuredField field) {
        StructureItemBinding binding = (StructureItemBinding)this.getBinding(field);
        if (binding == null) {
            String name = InternUtil.intern((String)field.getName());
            ITypeBinding type = this.bindingForType(field);
            field.getContainer().accept((EVisitor)this);
            IPartBinding declarer = (IPartBinding)this.stack.pop();
            binding = new StructureItemBinding(name, declarer, type);
            binding.setOccurs(field.getOccurs().intValue());
            this.handleAnnotations(field, (IBinding)binding);
            this.putBinding(field, (IBinding)binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(VariableFormField field) {
        VariableFormFieldBinding binding = (VariableFormFieldBinding)this.getBinding(field);
        if (binding == null) {
            String name = InternUtil.intern((String)field.getName());
            ITypeBinding type = this.bindingForType(field);
            field.getContainer().accept((EVisitor)this);
            IPartBinding declarer = (IPartBinding)this.stack.pop();
            binding = new VariableFormFieldBinding(name, declarer, type);
            binding.setOccurs(field.getOccurs().intValue());
            this.handleAnnotations(field, (IBinding)binding);
            this.handleElementAnnotations(field, (FormFieldBinding)binding);
            this.putBinding(field, (IBinding)binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(ConstantFormField field) {
        ConstantFormFieldBinding binding = (ConstantFormFieldBinding)this.getBinding(field);
        if (binding == null) {
            InternUtil.intern((String)field.getName());
            field.getContainer().accept((EVisitor)this);
            IPartBinding declarer = (IPartBinding)this.stack.pop();
            binding = new ConstantFormFieldBinding(declarer);
            binding.setOccurs(field.getOccurs().intValue());
            this.handleAnnotations(field, (IBinding)binding);
            this.handleElementAnnotations(field, (FormFieldBinding)binding);
            this.putBinding(field, (IBinding)binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(Constructor constructor) {
        IBinding binding = this.getBinding(constructor);
        if (binding == null) {
            IPartBinding type = (IPartBinding)this.getBinding(constructor.getContainer());
            if (type == null) {
                constructor.getContainer().accept((EVisitor)this);
                type = (IPartBinding)this.stack.pop();
            }
            binding = new ConstructorBinding(type);
            this.putBinding(constructor, (IBinding)((ConstructorBinding)binding).getType());
            for (FunctionParameter parm : constructor.getParameters()) {
                parm.accept((EVisitor)this);
                ((ConstructorBinding)binding).addParameter((FunctionParameterBinding)this.stack.pop());
            }
            this.handleAnnotations(constructor, binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(Function function) {
        IBinding binding = this.getBinding(function);
        if (binding == null) {
            String name = InternUtil.intern((String)function.getName());
            IPartBinding type = (IPartBinding)this.getBinding(function.getContainer());
            if (type == null) {
                function.getContainer().accept((EVisitor)this);
                type = (IPartBinding)this.stack.pop();
            }
            binding = new FunctionBinding(name, type);
            this.putBinding(function, binding);
            for (FunctionParameter parm : function.getParameters()) {
                parm.accept((EVisitor)this);
                ((FunctionBinding)binding).addParameter((FunctionParameterBinding)this.stack.pop());
            }
            if (function.getType() != null) {
                ((FunctionBinding)binding).setReturnType(this.bindingForType(function));
            }
            ((FunctionBinding)binding).setStatic(function.isStatic().booleanValue());
            this.handleAnnotations(function, binding);
            this.overrideFunctionParameterTypes((FunctionBinding)binding);
            binding = new NestedFunctionBinding(name, type, (IFunctionBinding)((FunctionBinding)binding));
        }
        this.stack.push(binding);
        return false;
    }

    private void overrideFunctionParameterTypes(FunctionBinding function) {
        IAnnotationBinding ann = function.getAnnotation((IAnnotationTypeBinding)EGLSystemParameterTypesAnnotationTypeBinding.getInstance());
        if (ann != null) {
            this.overrideParmTypes((Object[])ann.getValue(), function);
        }
    }

    private void overrideParmTypes(Object[] parmMap, FunctionBinding function) {
        int i = 0;
        while (i < parmMap.length) {
            SystemFunctionParameterSpecialTypeBinding newType;
            String value = parmMap[i].toString();
            if (value.length() > 0 && (newType = SystemFunctionParameterSpecialTypeBinding.getType((String)value)) != null) {
                ((FunctionParameterBinding)function.getParameters().get(i)).setType((ITypeBinding)newType);
            }
            ++i;
        }
    }

    public boolean visit(FunctionParameter parm) {
        IBinding binding = this.getBinding(parm);
        if (binding == null) {
            FunctionBinding func;
            IPartBinding declarer;
            String name = InternUtil.intern((String)parm.getName());
            parm.getType().accept((EVisitor)this);
            ITypeBinding type = (ITypeBinding)this.stack.pop();
            if (parm.getContainer() instanceof Delegate) {
                declarer = (IPartBinding)this.getBinding(parm.getContainer());
                func = null;
            } else {
                declarer = (IPartBinding)this.getBinding(((Member)((Object)parm.getContainer())).getContainer());
                func = (FunctionBinding)this.getBinding(parm.getContainer());
            }
            binding = new FunctionParameterBinding(name, declarer, type, (IFunctionBinding)func);
            if (parm.getParameterKind() == ParameterKind.PARM_IN) {
                ((FunctionParameterBinding)binding).setInput(true);
            } else if (parm.getParameterKind() == ParameterKind.PARM_OUT) {
                ((FunctionParameterBinding)binding).setOutput(true);
            }
            this.putBinding(parm, binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(ProgramParameter parm) {
        IBinding binding = this.getBinding(parm);
        if (binding == null) {
            String name = InternUtil.intern((String)parm.getName());
            parm.getType().accept((EVisitor)this);
            ITypeBinding type = (ITypeBinding)this.stack.pop();
            IPartBinding declarer = (IPartBinding)this.getBinding(parm.getContainer());
            binding = new ProgramParameterBinding(name, declarer, type);
            this.putBinding(parm, binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(EField field) {
        Object binding = this.getBinding((EObject)field);
        if (binding == null) {
            String name = InternUtil.intern((String)field.getName());
            field.getDeclarer().accept((EVisitor)this);
            IPartBinding declarer = (IPartBinding)this.stack.pop();
            ITypeBinding type = this.bindingForType((ETypedElement)field, (ITypeBinding)declarer);
            if (declarer instanceof FlexibleRecordBinding) {
                binding = new FlexibleRecordFieldBinding(name, declarer, type);
            } else if (declarer instanceof EClassBinding) {
                binding = new EFieldBinding(name, declarer, type);
                ((EFieldBinding)((Object)binding)).setTransient(field.isTransient());
                ((EFieldBinding)((Object)binding)).setContainment(field.getContainment());
            } else {
                binding = new ClassFieldBinding(name, declarer, type);
            }
            this.handleMetadata((EModelElement)field, (IBinding)binding);
            this.putBinding((EObject)field, (IBinding)binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(EFunction function) {
        Object binding = this.getBinding((EObject)function);
        if (binding == null) {
            String name = InternUtil.intern((String)function.getName());
            ITypeBinding type = null;
            function.getDeclarer().accept((EVisitor)this);
            IPartBinding declarer = (IPartBinding)this.stack.pop();
            if (function.getEType() != null) {
                type = this.bindingForType((ETypedElement)function, (ITypeBinding)declarer);
            }
            binding = new EFunctionBinding(name, declarer);
            this.putBinding((EObject)function, (IBinding)binding);
            for (EParameter parm : function.getEParameters()) {
                parm.accept((EVisitor)this);
                ((FunctionBinding)binding).addParameter((FunctionParameterBinding)((EParameterBinding)((Object)this.stack.pop())));
            }
            if (type != null) {
                ((FunctionBinding)binding).setReturnType(type);
            }
            binding = new NestedFunctionBinding(name, declarer, (IFunctionBinding)((FunctionBinding)binding));
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(EParameter parm) {
        Object binding = this.getBinding((EObject)parm);
        String name = InternUtil.intern((String)parm.getName());
        parm.getEType().accept((EVisitor)this);
        ITypeBinding type = (ITypeBinding)this.stack.pop();
        IPartBinding declarer = (IPartBinding)this.getBinding((EObject)parm.getFunction().getDeclarer());
        FunctionBinding func = (FunctionBinding)this.getBinding((EObject)parm.getFunction());
        binding = new EParameterBinding(name, declarer, type, (IFunctionBinding)func);
        this.putBinding((EObject)parm, (IBinding)binding);
        this.stack.push(binding);
        return false;
    }

    public boolean visit(EDataType type) {
        String key = type.getMofSerializationKey();
        PrimitiveTypeBinding binding = key.equals(MofFactory.INSTANCE.getEStringEDataType().getMofSerializationKey()) ? PrimitiveTypeBinding.getInstance((Primitive)Primitive.STRING) : (key.equals(MofFactory.INSTANCE.getEIntEDataType().getMofSerializationKey()) ? PrimitiveTypeBinding.getInstance((Primitive)Primitive.INT) : (key.equals(MofFactory.INSTANCE.getEBooleanEDataType().getMofSerializationKey()) ? PrimitiveTypeBinding.getInstance((Primitive)Primitive.BOOLEAN) : PrimitiveTypeBinding.getInstance((Primitive)Primitive.ANY)));
        this.stack.push(binding);
        return false;
    }

    public boolean visit(EGenericType type) {
        ((EType)type.getETypeArguments().get(0)).accept((EVisitor)this);
        ITypeBinding elementType = (ITypeBinding)this.stack.pop();
        ArrayTypeBinding binding = ArrayTypeBinding.getInstance((ITypeBinding)elementType);
        this.stack.push(binding);
        return false;
    }

    private ITypeBinding bindingForType(TypedElement element) {
        IPartBinding binding;
        if (element instanceof ProxyPart) {
            binding = this.createProxyBinding((ProxyPart)((Object)element));
        } else {
            element.getType().accept((EVisitor)this);
            binding = (ITypeBinding)this.stack.pop();
        }
        if (element.isNullable()) {
            binding = binding.getNullableInstance();
        }
        return binding;
    }

    private ITypeBinding bindingForType(ETypedElement element, ITypeBinding declarer) {
        ITypeBinding binding = null;
        if (declarer instanceof FlexibleRecordBinding && this.isEGLReflectType((EType)element.getEType().getEClassifier())) {
            binding = this.getEGLReflectTypeFor((EClass)element.getEType().getEClassifier());
        } else {
            element.getEType().accept((EVisitor)this);
            binding = (ITypeBinding)this.stack.pop();
        }
        if (element.isNullable()) {
            binding = binding.getNullableInstance();
        }
        return binding;
    }

    private boolean isEGLReflectType(EType type) {
        if (type.getEClassifier() instanceof EClass) {
            EClass eClass = (EClass)type.getEClassifier();
            String typeSignature = eClass.getETypeSignature();
            return typeSignature.equals("org.eclipse.edt.mof.EField") || typeSignature.equals("org.eclipse.edt.mof.EClass") || typeSignature.equals("org.eclipse.edt.mof.EClassifier") || typeSignature.equals("org.eclipse.edt.mof.EFunction");
        }
        return false;
    }

    private ITypeBinding getEGLReflectTypeFor(EClass eClass) {
        IPartBinding binding = null;
        String typeSignature = eClass.getETypeSignature();
        if (typeSignature.equals("org.eclipse.edt.mof.EField")) {
            binding = SystemPartManager.FIELDREF_BINDING;
        } else if (typeSignature.equals("org.eclipse.edt.mof.EClass")) {
            binding = SystemPartManager.TYPEREF_BINDING;
        } else if (typeSignature.equals("org.eclipse.edt.mof.EClassifier")) {
            binding = SystemPartManager.TYPEREF_BINDING;
        } else if (typeSignature.equals("org.eclipse.edt.mof.EFunction")) {
            binding = SystemPartManager.FUNCTIONREF_BINDING;
        }
        return binding;
    }
}

