/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.codegen.api;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.codegen.api.TemplateException;
import org.eclipse.edt.mof.codegen.api.TemplateFactory;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class TemplateContext
extends HashMap<Object, Object> {
    TemplateFactory tFactory;
    IEnvironment env;
    Map<String, Template> templates = new HashMap<String, Template>();

    public TemplateContext() {
        this.env = Environment.INSTANCE;
    }

    public TemplateContext(IEnvironment env) {
        this.env = env;
    }

    public void setTemplateFactory(TemplateFactory factory) {
        this.tFactory = factory;
    }

    public Template getTemplate(String key) throws TemplateException {
        Template template = this.templates.get(key);
        if (template == null) {
            template = this.tFactory.createTemplate(key);
            this.templates.put(key, template);
        }
        return template;
    }

    public Template getTemplateRaw(String key) {
        Template template = this.templates.get(key);
        if (template == null && this.tFactory.templates.containsKey(key)) {
            template = this.tFactory.createTemplateRaw(key);
            this.templates.put(key, template);
        }
        return template;
    }

    public String getTemplateKey(Template template) {
        for (Map.Entry<String, Class<? extends Template>> entry : this.tFactory.templates.entrySet()) {
            if (!entry.getValue().equals(template.getClass())) continue;
            return entry.getKey();
        }
        return null;
    }

    public Template getTemplateFor(EClassifier eClassifier) throws TemplateException {
        return this.getTemplate(eClassifier.getETypeSignature());
    }

    public Template getTemplateFor(Class javaClass) throws TemplateException {
        return this.getTemplate(javaClass.getName());
    }

    public void gen(String genMethod, Object object, TemplateContext ctx, TabbedWriter out, Object ... args) throws TemplateException {
        Template template = this.getTemplateFor(object.getClass());
        template.gen(genMethod, object, ctx, out, args);
    }

    public void gen(String genMethod, EObject object, TemplateContext ctx, TabbedWriter out, Object ... args) throws TemplateException {
        Template template = this.getTemplateFor(object.getEClass());
        template.gen(genMethod, object, ctx, out, args);
    }

    public final void foreach(List<? extends EObject> list, char separator, String genMethod, TemplateContext ctx, TabbedWriter out, Object ... args) throws TemplateException {
        int i = 0;
        while (i < list.size()) {
            this.gen(genMethod, list.get(i), ctx, out, args);
            if (i < list.size() - 1) {
                out.print(separator);
                out.print(' ');
            }
            ++i;
        }
    }

    public List<Object> xlate(String genMethod, EObject object, TemplateContext ctx, Object ... args) throws TemplateException {
        Template template = this.getTemplateFor(object.getEClass());
        return template.xlate(genMethod, object, ctx, args);
    }

    public void validate(String genMethod, EObject object, TemplateContext ctx, Object ... args) throws TemplateException {
        Template template = this.getTemplateFor(object.getEClass());
        template.validate(genMethod, object, ctx, args);
    }

    private TemplateMethod getTemplateMethod(String methodName, Class<?> objectClass, Object ... args) throws TemplateException {
        Class<?> iface;
        int n;
        int n2;
        Class<?>[] classArray;
        TemplateMethod tm = null;
        Method method = null;
        Template template = null;
        template = this.getTemplateForClass(objectClass);
        if (template == null) {
            classArray = objectClass.getInterfaces();
            n2 = classArray.length;
            n = 0;
            while (n < n2) {
                iface = classArray[n];
                template = this.getTemplateForClass(iface);
                if (template != null) break;
                ++n;
            }
        }
        if (template != null) {
            method = this.primGetMethod(methodName, template.getClass(), objectClass, args);
            if (method != null) {
                tm = new TemplateMethod(template, method);
            } else {
                classArray = objectClass.getInterfaces();
                n2 = classArray.length;
                n = 0;
                while (n < n2) {
                    iface = classArray[n];
                    tm = this.getTemplateMethod(methodName, iface, args);
                    if (tm != null) break;
                    ++n;
                }
                if (tm == null && objectClass.getSuperclass() != null) {
                    Class<?> superClass = objectClass.getSuperclass();
                    tm = this.getTemplateMethod(methodName, superClass, args);
                }
            }
        }
        return tm;
    }

    public TemplateMethod getTemplateMethod(String methodName, EClassifier eClass, Object ... args) throws TemplateException {
        TemplateMethod tm = null;
        Method method = null;
        Template template = null;
        template = this.getTemplateForEClassifier(eClass);
        if (template != null) {
            method = this.primGetMethod(methodName, template.getClass(), eClass.getClass(), args);
            if (method != null) {
                tm = new TemplateMethod(template, method);
            }
        } else if (eClass instanceof EClass) {
            for (EClass part : ((EClass)eClass).getSuperTypes()) {
                tm = this.getTemplateMethod(methodName, part, args);
                if (tm != null) break;
            }
        }
        return tm;
    }

    public Template getTemplateForClass(Class<?> clazz) {
        return this.getTemplateRaw(clazz.getName());
    }

    public Template getTemplateForEClassifier(EClassifier clazz) {
        return this.getTemplateRaw(clazz.getETypeSignature());
    }

    public Class<?> getClassForTemplate(Template template) {
        String signature = this.getTemplateKey(template);
        try {
            return Class.forName(signature, true, this.tFactory.classloader);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public EClassifier getEClassifierForTemplate(Template template) {
        String signature = this.getTemplateKey(template);
        try {
            return (EClassifier)this.env.find(signature);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object invoke(String methodName, Object object, Object ... args) {
        TemplateMethod tm = this.getTemplateMethod(methodName, object.getClass(), args);
        if (tm != null) {
            return this.doInvoke(tm.method, tm.template, object, args);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("No such method ");
        builder.append(methodName);
        builder.append("(");
        builder.append(object.getClass().getName());
        builder.append(", ");
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            builder.append(arg.getClass().getName());
            builder.append(", ");
            ++n2;
        }
        builder.append(") for any template for Class ");
        builder.append(object.getClass().getName());
        throw new TemplateException(builder.toString());
    }

    public Object invoke(String methodName, Class<?> clazz, Object ... args) {
        TemplateMethod tm = this.getTemplateMethod(methodName, clazz, args);
        if (tm != null) {
            return this.doInvoke(tm.method, tm.template, clazz, args);
        }
        return this.invoke(methodName, (Object)clazz, args);
    }

    public Object invokeSuper(Template template, String methodName, Object object, Object ... args) {
        Class<?> clazz = this.getClassForTemplate(template);
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null) {
            throw new IllegalArgumentException("Class " + object.getClass().getName() + " has no super class");
        }
        TemplateMethod tm = this.getTemplateMethod(methodName, superClass, args);
        if (tm != null) {
            return this.doInvoke(tm.method, tm.template, object, args);
        }
        return this.invoke(methodName, object, args);
    }

    public Object invokeSuper(Template template, String methodName, Class<?> clazz, Object ... args) {
        Class<?> baseclass = this.getClassForTemplate(template);
        Class<?> superClass = baseclass.getSuperclass();
        if (superClass == null) {
            return this.invokeSuper(template, methodName, (Object)clazz, args);
        }
        TemplateMethod tm = this.getTemplateMethod(methodName, superClass, args);
        if (tm != null) {
            return this.doInvoke(tm.method, tm.template, clazz, args);
        }
        return this.invokeSuper(template, methodName, (Object)clazz, args);
    }

    public Object invoke(String methodName, EObject object, Object ... args) {
        TemplateMethod tm = this.getTemplateMethod(methodName, object.getEClass(), args);
        if (tm != null) {
            return this.doInvoke(tm.method, tm.template, object, args);
        }
        return this.invoke(methodName, (Object)object, args);
    }

    public Object invoke(String methodName, EType etype, Object ... args) {
        TemplateMethod tm = this.getTemplateMethod(methodName, etype.getEClassifier(), args);
        if (tm == null) {
            tm = this.getTemplateMethod(methodName, etype.getEClassifier().getEClass(), args);
        }
        if (tm != null) {
            return this.doInvoke(tm.method, tm.template, etype, args);
        }
        return this.invoke(methodName, (Object)etype, args);
    }

    public Object invokeSuper(Template template, String methodName, EObject object, Object ... args) {
        EClass superClass;
        EClass clazz = (EClass)this.getEClassifierForTemplate(template);
        EClass eClass = superClass = clazz.getSuperTypes().isEmpty() ? null : clazz.getSuperTypes().get(0);
        if (superClass == null) {
            throw new IllegalArgumentException("EClass " + object.getEClass().getETypeSignature() + " has no super class");
        }
        TemplateMethod tm = this.getTemplateMethod(methodName, superClass, args);
        if (tm != null) {
            return this.doInvoke(tm.method, tm.template, object, args);
        }
        return this.invoke(methodName, (Object)object, args);
    }

    public Object invokeSuper(Template template, String methodName, EClass clazz, Object ... args) {
        EClass superClass;
        EClass baseclass = (EClass)this.getEClassifierForTemplate(template);
        EClass eClass = superClass = baseclass.getSuperTypes().isEmpty() ? null : baseclass.getSuperTypes().get(0);
        if (superClass == null) {
            return this.invokeSuper(template, methodName, (EObject)clazz, args);
        }
        TemplateMethod tm = this.getTemplateMethod(methodName, superClass, args);
        if (tm != null) {
            return this.doInvoke(tm.method, tm.template, clazz, args);
        }
        return this.invokeSuper(template, methodName, (EObject)clazz, args);
    }

    public Method primGetMethod(String methodName, Class<?> templateClass, Class<?> objectClass, Object ... args) {
        Method method = null;
        Method[] methodArray = templateClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            boolean matches = true;
            if (m.getName().equals(methodName)) {
                if (m.getParameterTypes().length == args.length + 1) {
                    Class<?>[] pTypes = m.getParameterTypes();
                    if (pTypes[0].isAssignableFrom(objectClass)) {
                        int i = 0;
                        while (i < args.length) {
                            if (!pTypes[i + 1].isAssignableFrom(args[i].getClass())) {
                                matches = false;
                                break;
                            }
                            ++i;
                        }
                    } else {
                        matches = false;
                    }
                }
            } else {
                matches = false;
            }
            if (matches) {
                method = m;
                break;
            }
            ++n2;
        }
        return method;
    }

    public Object doInvoke(Method method, Template template, Object object, Object[] args) {
        try {
            switch (args.length) {
                case 0: {
                    return method.invoke((Object)template, object);
                }
                case 1: {
                    return method.invoke((Object)template, object, args[0]);
                }
                case 2: {
                    return method.invoke((Object)template, object, args[0], args[1]);
                }
                case 3: {
                    return method.invoke((Object)template, object, args[0], args[1], args[2]);
                }
                case 4: {
                    return method.invoke((Object)template, object, args[0], args[1], args[2], args[3]);
                }
                case 5: {
                    return method.invoke((Object)template, object, args[0], args[1], args[2], args[3], args[4]);
                }
                case 6: {
                    return method.invoke((Object)template, object, args[0], args[1], args[2], args[3], args[4], args[5]);
                }
                case 7: {
                    return method.invoke((Object)template, object, args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
                }
                case 8: {
                    return method.invoke((Object)template, object, args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
                }
                case 9: {
                    return method.invoke((Object)template, object, args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
                }
            }
            return method.invoke((Object)template, object, args);
        }
        catch (TemplateException te) {
            throw te;
        }
        catch (InvocationTargetException itx) {
            Throwable t = itx.getTargetException();
            if (t instanceof TemplateException) {
                throw (TemplateException)t;
            }
            throw new TemplateException(t);
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }

    public class TemplateMethod {
        Method method;
        Template template;

        public TemplateMethod(Template template, Method method) {
            this.template = template;
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public Template getTemplate() {
            return this.template;
        }
    }
}

