/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.codegen.api;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.edt.mof.codegen.api.MissingTemplate;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.codegen.api.TemplateException;

public class TemplateFactory {
    Map<String, Class<? extends Template>> templates = new HashMap<String, Class<? extends Template>>();
    ClassLoader classloader;

    public Template createTemplate(String key) throws TemplateException {
        Class<? extends Template> clazz = this.templates.get(key);
        if (clazz == null) {
            throw new TemplateException("Template not found: " + key);
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new TemplateException(e);
        }
        catch (InstantiationException e2) {
            throw new TemplateException(e2);
        }
    }

    public Template createTemplateRaw(String key) throws TemplateException {
        Class<? extends Template> clazz = this.templates.get(key);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new TemplateException(e);
        }
        catch (InstantiationException e2) {
            throw new TemplateException(e2);
        }
    }

    public void load(String templateFilePaths, ClassLoader loader) throws TemplateException {
        String[] templateFiles;
        this.classloader = loader;
        String[] stringArray = templateFiles = templateFilePaths.split("[;]");
        int n = templateFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String templateFile = stringArray[n2];
            ResourceBundle bundle = ResourceBundle.getBundle(templateFile, Locale.getDefault(), loader);
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String className = bundle.getString(key);
                try {
                    if (this.templates.get(key) != null) continue;
                    Class<?> clazz = Class.forName(className, true, loader);
                    this.templates.put(key, clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.templates.put(key, MissingTemplate.class);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    this.templates.put(key, MissingTemplate.class);
                }
            }
            ++n2;
        }
    }
}

