/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.serialization;

import java.lang.reflect.Constructor;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Deserializer;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.ProxyEObject;
import org.eclipse.edt.mof.serialization.SerializationException;
import org.eclipse.edt.mof.serialization.SerializationFactory;
import org.eclipse.edt.mof.serialization.Serializer;
import org.eclipse.edt.mof.serialization.binary.BinarySerializationFactory;
import org.eclipse.edt.mof.serialization.xml.XMLSerializationFactory;

public abstract class AbstractObjectStore
implements ObjectStore {
    public IEnvironment env;
    public String storageFormat;
    public SerializationFactory factory;
    public String supportedScheme;
    public Class<? extends ProxyEObject> proxyClass;

    static {
        SerializationFactory.Registry.INSTANCE.put("BINARY", new BinarySerializationFactory());
        SerializationFactory.Registry.INSTANCE.put("XML", new XMLSerializationFactory());
    }

    public AbstractObjectStore() {
    }

    public AbstractObjectStore(IEnvironment env) {
        this(env, "BINARY");
    }

    public AbstractObjectStore(IEnvironment env, String storageFormat) {
        this.env = env;
        this.storageFormat = storageFormat;
        this.factory = SerializationFactory.Registry.INSTANCE.getFactory(storageFormat);
        this.supportedScheme = "mof";
    }

    @Override
    public void setEnvironment(IEnvironment env) {
        this.env = env;
    }

    @Override
    public IEnvironment getEnvironment() {
        return this.env;
    }

    @Override
    public EObject get(String key) throws DeserializationException {
        EObject obj;
        String rawKey = this.removeSchemeFromKey(key);
        Deserializer deserializer = this.createDeserializer(rawKey);
        if (deserializer == null) {
            return null;
        }
        try {
            ProxyEObject proxy = this.createProxyObject(rawKey);
            this.env.save(key, proxy, false);
            obj = deserializer.deserialize();
            if (!proxy.references.isEmpty()) {
                proxy.updateReferences(obj);
            }
            this.env.save(key, obj, false);
        }
        catch (DeserializationException e) {
            this.env.remove(key);
            throw e;
        }
        return obj;
    }

    @Override
    public void remove(String key) {
        key = this.removeSchemeFromKey(key);
        this.primRemove(key);
    }

    @Override
    public void put(String key, EObject obj) throws SerializationException {
        Serializer serializer = this.factory.createSerializer();
        serializer.serialize(obj);
        Object contents = serializer.getContents();
        byte[] bytes = contents instanceof String ? ((String)contents).getBytes() : (byte[])contents;
        key = this.removeSchemeFromKey(key);
        this.store(key, bytes);
    }

    @Override
    public String getKeyScheme() {
        if (this.supportedScheme == null) {
            this.supportedScheme = "mof";
        }
        return this.supportedScheme;
    }

    @Override
    public boolean supportsScheme(String scheme) {
        return scheme.equals(this.supportedScheme);
    }

    @Override
    public void setProxyClass(Class<? extends ProxyEObject> proxyClass) {
        this.proxyClass = proxyClass;
    }

    public String removeSchemeFromKey(String key) {
        int i = key.indexOf(":");
        return i == -1 ? key : key.substring(i + 1);
    }

    public ProxyEObject createProxyObject(String key) {
        if (this.proxyClass == null) {
            this.proxyClass = ProxyEObject.class;
        }
        try {
            Constructor<? extends ProxyEObject> constructor = this.proxyClass.getConstructor(String.class);
            return constructor.newInstance(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public long lastModified(String key) {
        return -1L;
    }

    public abstract Deserializer createDeserializer(String var1);

    public abstract void store(String var1, Object var2);

    public abstract void primRemove(String var1);
}

