/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.serialization;

import java.util.Stack;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.serialization.AbstractEnvironment;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.TypeNotFoundException;

public class Environment
extends AbstractEnvironment {
    public static Environment INSTANCE = new Environment();
    private static Stack<IEnvironment> currentEnvs = new Stack();

    public static synchronized IEnvironment getCurrentEnv() {
        return currentEnvs.size() == 0 ? INSTANCE : currentEnvs.peek();
    }

    public static synchronized void pushEnv(IEnvironment env) {
        currentEnvs.push(env);
    }

    public static synchronized IEnvironment popEnv() {
        return currentEnvs.pop();
    }

    public MofSerializable findType(String mofSignature) throws TypeNotFoundException, DeserializationException {
        EObject type;
        try {
            type = this.find(mofSignature);
        }
        catch (MofObjectNotFoundException e) {
            throw new TypeNotFoundException(e);
        }
        return (MofSerializable)type;
    }

    public void saveType(MofSerializable type) {
        this.save(type);
    }

    public void removeType(String mofSignature) {
        this.remove(mofSignature);
    }
}

