/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.serialization;

import java.util.ArrayList;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.MofFactory;
import org.eclipse.edt.mof.impl.DynamicEClass;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.ProxyEClass;
import org.eclipse.edt.mof.serialization.ProxyEObject;

public class MofLookupDelegate
implements IEnvironment.LookupDelegate {
    @Override
    public EObject find(String key, IEnvironment env) throws MofObjectNotFoundException, DeserializationException {
        return this.find(key, false, env);
    }

    @Override
    public EObject find(String key, boolean useProxies, IEnvironment env) throws MofObjectNotFoundException, DeserializationException {
        int i = 0;
        if (this.isDynamicReference(key)) {
            return this.createDynamicEClass(key, env);
        }
        String[] typeArgs = null;
        i = key.indexOf(60);
        int typeEnd = -1;
        if (i == -1) {
            return env.lookup(key);
        }
        typeEnd = i == -1 ? key.length() - 1 : i;
        String baseType = key.substring(0, typeEnd);
        if (i != -1) {
            String types = key.substring(i + 1);
            int j = types.lastIndexOf(62);
            typeArgs = types.substring(0, j).split("[,]");
        }
        EGenericType result = null;
        EClassifier eBaseType = (EClassifier)env.find(baseType, useProxies);
        ArrayList<EType> types = new ArrayList<EType>();
        if (typeArgs != null) {
            String[] stringArray = typeArgs;
            int n = typeArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                EType eType = (EType)env.find(arg, useProxies);
                types.add(eType);
                ++n2;
            }
        }
        EGenericType generic = (EGenericType)MofFactory.INSTANCE.getEGenericTypeClass().newInstance();
        generic.setEClassifier(eBaseType);
        if (typeArgs != null) {
            for (EType arg : types) {
                generic.addETypeArgument(arg);
            }
        }
        result = generic;
        env.save(key, result, false);
        return result;
    }

    @Override
    public boolean supportsScheme(String scheme) {
        return "mof".equals(scheme);
    }

    @Override
    public Class<? extends ProxyEObject> getProxyClass() {
        return ProxyEClass.class;
    }

    @Override
    public String normalizeKey(String key) {
        return key;
    }

    private boolean isDynamicReference(String key) {
        return key.startsWith("dynMof");
    }

    private DynamicEClass createDynamicEClass(String key, IEnvironment env) throws MofObjectNotFoundException, DeserializationException {
        DynamicEClass eClass = new DynamicEClass();
        String[] names = key.split("[:]");
        String typeSignature = names[2];
        int i = typeSignature.lastIndexOf(46);
        if (i != -1) {
            eClass.setPackageName(typeSignature.substring(0, i));
            eClass.setName(typeSignature.substring(i + 1));
        } else {
            eClass.setName(typeSignature);
        }
        EClass superType = (EClass)env.find(names[1]);
        eClass.getSuperTypes().add(superType);
        Environment.INSTANCE.save(eClass, false);
        return eClass;
    }
}

