/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "The error occurred in {0}." },
		{ Message.FUNCTION_ERROR_INFO, "The error occurred in {0} processing the {1} function." },
		{ Message.FILE_ERROR_INFO, "The error occurred in {0} processing the {1} function at line {2}." },
		{ Message.PROPERTIES_FILE_MISSING, "The {0} properties file could not be loaded." },
		{ Message.LOAD_LIBRARY_FAILED, "The {0} library cannot be loaded. The following error occurred: {1}." },
		{ Message.CREATE_OBJECT_FAILED, "An error occurred while creating an object of the {0} type. The following error occurred: {1}." },
		{ Message.INITIAL_CONTEXT_ERROR, "An error occurred while creating the InitialContext or looking up the java:comp/env environment. The following error occurred: {0}" },
		{ Message.LISTENER_ERROR, "The following exception and message occurred. Exception: {0}. Message: {1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "A value for the {0} property is required." },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "An external dependency is missing. The following exception occurred. Exception: {0}" },
		{ Message.UNSUPPORTED_COMPARE, "The {0} and {1} operands cannot be compared." },
		{ Message.ASSIGNMENT_OVERFLOW, "An overflow error occurred when assigning a value of {0} to {1}." },
		{ Message.EXPRESSION_OVERFLOW, "An overflow error occurred when calculating the following expression: {0}." },
		{ Message.UNSUPPORTED_OPERANDS, "The {0} operator is not supported for the {1} and {2} operands." },
		{ Message.UNSUPPORTED_OPERAND, "The {0} operator is not supported for the {1} operand of the {2} type." },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "The subscript operator is not supported for the {0} operand of the {1} type." },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "The substring operator is not supported for the {0} operand of the {1} type." },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "The SET EMPTY statement is not supported for the {0} operand of the {1} type." },
		{ Message.INVALID_REGULAR_EXPRESSION, "An error occurred in the {0} regular expression. Error: {1}." },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "When using CICSSSL protocol, both ctgKeyStore and ctgKeyStorePassword must be specified." },
		{ Message.INVALID_CTGPORT, "The {0} value for the ctgport entry is not correct." },
		{ Message.CTG_CONNECT_FAILED, "An error occurred when connecting to the CTG. The CTG location is {0}. The CTG port is {1}. The following error occurred: {2}" },
		{ Message.CTG_DISCONNECT_FAILED, "An error occurred when disconnecting from the CTG. The CTG location is {0}. The CTG port is {1}. The following error occurred: {2}" },
		{ Message.NO_CICS, "An error occurred while calling the {0} program that uses the CICS ECI. The return code is -3 (ECI_ERR_NO_CICS). The CICS system identifier is {1}." },
		{ Message.CICS_DIED, "An error occurred while calling the {0} program that uses the CICS ECI. The return code is -4 (ECI_ERR_CICS_DIED). The CICS system identifier is {1}." },
		{ Message.CICS_TIMEOUT, "An error occurred while calling the {0} program that uses the CICS ECI. The return code is -6 (ECI_ERR_RESPONSE_TIMEOUT). The CICS system identifier is {1}." },
		{ Message.CICS_TRANSACTION_ABEND, "An error occurred while calling the {0} program that uses the CICS ECI. The return code is -7 (ECI_ERR_TRANSACTION_ABEND). The CICS system identifier is {1}. The abend code is {2}." },
		{ Message.CICS_UNKNOWN_SERVER, "An error occurred while calling the {0} program that usesthe CICS ECI. The return code is -22 (ECI_ERR_UNKNOWN_SERVER). The CICS system identifier is {1}." },
		{ Message.CICS_SECURITY_ERROR, "An error occurred while calling the {0} program that uses the CICS ECI. The return code is -27 (ECI_ERR_SECURITY_ERROR). The CICS system identifier is {1}." },
		{ Message.CICS_MAX_SYSTEMS, "An error occurred while calling the {0} program that uses the CICS ECI. The return code is -28 (ECI_ERR_MAX_SYSTEMS). The CICS system identifier is {1}." },
		{ Message.CICS_NONZERO_RETURN_CODE, "An error occurred while calling the {0} program on the {1} system for the user named {2}. A {3} return code and {4} abend code was returned from the CICS ECI call." },
		{ Message.CICS_COMMIT_FAILED, "An error occurred while calling CICS ECI to commit a unit of work. The CICS return code is {0}." },
		{ Message.CICS_ROLLBACK_FAILED, "An error occurred while calling the CICS ECI to rollback a unit of work. The CICS return code is {0}." },
		{ Message.CICS_ECI_FLOW_FAILED, "An exception occurred on the flow of an ECI Request to CICS system {0}. Exception: {1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "A parameter length error. The stream has {0} parameters and the local function has {1} parameters." },
		{ Message.RECURSIVE_CALL_NOT_ALLOWED, "Program {0} cannot be called recursively." },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "The maximum size is exceeded for the {0} array." },
		{ Message.WRONG_NUMBER_OF_PARMS, "The called program {0} expected {1} parameters but was passed {2}." },
		{ Message.FUNCTION_NOT_FOUND, "An error occurred while obtaining the address of the {0} entry point within the {1} shared library. The return code is {2}." },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "An error occurred while loading the {0} shared library. The return code is {1}." },
		{ Message.CALL_NONZERO_RETURN_CODE, "The called program failed with a {0} return code." },
		{ Message.REMOTE_PROGRAM_ERROR, "An error occurred in the {0} remote program on the {3} system. The error occurred on {1} at {2}. {4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "An error occurred in the {0} remote program on the {1} system. {2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "The {0} hostname is an unknown TCP/IP hostname." },
		{ Message.SERVERID_IS_INVALID_PORT, "The {0} ServerID is not a valid port number." },
		{ Message.TCPIP_SERVER_ERROR, "The client has received notification that the server is unable to start the remote called program. Reason code: {0}." },
		{ Message.INVALID_REMOTECOMTYPE, "The remoteComType value is missing or not correct." },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "The {0} linkage properties file cannot be opened." },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "An entry for {0} called program cannot be found in the {1} linkage properties file." },
		{ Message.AS400_UNKNOWN_HOST, "The {0} host cannot be found or is not known." },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "The password or user ID is not correct for connecting to the {0} system. Error: {1}" },
		{ Message.AS400_EXCEPTION_CAUGHT, "An {0} AS400Toolbox execution error occurred while calling the {2} program on the {3} system. Error: {1}" },
		{ Message.AS400_NO_AUTHORITY, "A remote access security error occurred to the {0} system for the {1} user. Error: {2}" },
		{ Message.REMOTE_COMMIT_FAILED, "A commit function failed on the {0} system. Error: {1}" },
		{ Message.REMOTE_ROLLBACK_FAILED, "The rollback function failed on the {0} system. Error: {1}" },
		{ Message.AS400_CONNECTION_ERROR, "A remote connection error occurred accessing the {0} system. Error: {1}" },
		{ Message.AS400_SERVER_NOT_FOUND, "An EGL OS/400 Host Services error occurred. The required files are not found on the {0} system." },
		{ Message.AS400_APPLICATION_ERROR, "The run unit stopped because an application error on the {0} system occurred trying to call the {1} program. Message: {2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "The reference variable named {0} is null." },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "An unhandled error occurred. Error: {0}." },
		{ Message.DATA_FORMAT_ERROR, "The value of the {0} variable is not in the correct format." },
		{ Message.CONVERSION_ERROR, "The {0} value of {1} type cannot be converted to the {2} type." },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "The {0} date format pattern is not valid." },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "The {0} time format pattern is not valid." },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "The {0} timestamp format pattern is not valid." },
		{ Message.NULL_REFERENCE, "A null reference was used." },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "Dynamic access is not supported for {0}." },
		{ Message.DYNAMIC_ACCESS_FAILED, "A field with the {0} identifier cannot be found in {1}." },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "The {0} numeric format pattern is not valid." },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "An error occurred while assigning {0} to {1}. Error: {2}." },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "An error in the SET {0} EMPTY statement. Error: {1}." },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "A {0} error occurred while invoking the method with a {1} signature." },
		{ Message.RUN_COMMAND_FAILED, "An error running the {0} command.  Error: {1}." },
		{ Message.MDY_ERROR, "The DateTimeLib.mdy function cannot convert the {0}, {1}, and {2} values into a month, day, and year." },
		{ Message.NON_NUMERIC_STRING, "{0} was passed the {1} nonnumeric string. All characters in the portion of the string defined by the length argument must be numeric." },
		{ Message.SYSTEM_FUNCTION_ERROR, "{0} failed with error message {1}." },
		{ Message.INT_AS_CHAR_ERROR, "The argument to StrLib.intAsChar must be a number between 0 and 255." },
		{ Message.INVALID_LOB_LENGTH, "{0} is not a valid length for {1} which has a size of {2}." },
		{ Message.INVALID_LOB_POSITION, "{0} is not a valid position for {1}. Its size is {2}." },
		{ Message.LOB_ERROR, "An error occurred while processing a Blob or Clob item.  The error message is {0}" },
		{ Message.START_TRANSACTION_ERROR, "VGLib.startTransaction to class {0} failed. The exception is {1}" },
		{ Message.INT_AS_UNICODE_ERROR, "The argument to StrLib.intAsUnicode must be a number between 0 and 65535." },
		{ Message.INVALID_ARRAY_SIZE, "The {0} size value is not valid for the {1} array. The maximum size is {2}." },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "Index {0} is out of bounds for the {1} array. The array size is {2}." },
		{ Message.INVALID_SUBSTRING_INDEX, "Invalid substring indices {0}:{1}." },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "The argument to the function for the {0} array is not valid." },
		{ Message.INDEX_OUT_OF_BOUNDS, "The {0} index value is out of bounds." },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "{0} is an unsupported conversion table." },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "The csouidpwd.properties file cannot be read. Error: {0}" },
		{ Message.CALL_PARMS_TOO_LARGE, "The buffer for the client is too small for the amount of data being passed on the call. The cumulative size of the parameters being passed is {0} bytes and exceeds the maximum allowed which is {1} bytes." },
		{ Message.INVALID_PARMFORM, "The parmForm linkage property must be set to COMMPTR to call program {0} as there is at least one parameter that is a dynamic array." },
		{ Message.PARM_PASSING_ERROR, "An error occurred while passing parameters to {0} called program. Error: {1}" },
		{ Message.CALL_ERROR, "An error occurred calling the {0} program. Error: {1}" },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "{0} is an unsupported parameter type for System i service programs." },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "{0} is an unsupported return type for System i service programs." },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "Unable to get a ConnectionFactory. Exception is {0}" },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "The Interaction or Connection cannot be closed. Error: {0}" },
		{ Message.ERROR_GETTING_CONNECTION, "A connection cannot be established. Error: {0}" },
		{ Message.ERROR_GETTING_INTERACTION, "Unable to get an Interaction. Exception is: {0}" },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "Unable to set an interaction verb. Exception is {0}" },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "Unable to get a LocalTransaction for client unit of work. Exception is {0}" },
		{ Message.ERROR_SETTING_TIMEOUT, "Unable to set the timeout value on a CICSJ2C call. Exception is {0}" },
		{ Message.EXCEPTION_CALLING_CICS, "An error occurred during an attempt to communicate with CICS. Exception is {0}" },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "The attempt to execute the remote CICS transaction failed." },
		{ Message.EXCEPTION_CALLING_IMS, "An error occurred during an attempt to communicate with IMS. Exception is {0}" },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "An error occurred during an attempt to communicate with IMS." },
		{ Message.MATH_DOMAIN_ERROR, "{0} failed with error code 8 (domain error). An argument to the function is not valid." },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "{0} failed with error code 8 (domain error). The argument must be between -1 and 1." },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "{0} failed with error code 8 (domain error). The second argument must not be zero." },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "{0} failed with error code 8 (domain error). The argument must be greater than zero." },
		{ Message.MATH_POW_1_DOMAIN_ERR, "MathLib.pow failed with error code 8 (domain error). If the first argument is zero, the second must be greater than zero." },
		{ Message.MATH_POW_2_DOMAIN_ERR, "MathLib.pow failed with error code 8 (domain error). If the first argument is less than zero, the second must be an integer." },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "MathLib.sqrt failed with error code 8 (domain error). The argument must be greater than or equal to zero." },
		{ Message.MATH_RANGE_ERROR, "{0} failed with error code 12 (range error)." },		
		{ Message.STRING_INDEX_ERROR, "{0} failed with error code 8. The index must be between 1 and the length of the string." },
		{ Message.STRING_LENGTH_ERROR, "{0} failed with error code 12. The length must be greater than zero." },
		{ Message.STRING_NULT_ERROR, "StrLib.setNullTerminator failed with error code 16. The last byte of the target string must be a blank or null character." },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "{0} failed with error code 20. The index of a STRING, DBCHAR, or UNICODE substring must be odd so that the index identifies the first byte of a character." },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "{0} failed with error code 24. The length of a STRING, DBCHAR, or UNICODE substring must be even to refer to a whole number of characters." },
		{ Message.NO_DEBUG_LISTENER, "Cannot contact the EGL debugger at hostname {0} and port {1}. Exception is {2}" },
		{ Message.DEBUG_LISTENER_PROBLEM, "An error occurred while communicating with the EGL debugger at hostname {0} and port {1}. Exception is {2}" },
		{ Message.NOT_DEBUG_MODE, "The linkage specified a DEBUG call within a J2EE server. The call was not made on a J2EE server, the J2EE server is not in debug mode, or the J2EE server was not enabled for EGL debugging." },
		{ Message.LIBRARY_NOT_SPECIFIED, "The linkage specified a DEBUG call to an EGL listener but did not specify the library property." },
		
		{ Message.FILETYPE_MISSING, "The runtime property vgj.ra.fileName.fileType cannot be found for the {0} file." },
		{ Message.FILETYPE_INVALID, "The value of the runtime property vgj.ra.fileName.fileType is not valid for the {0} file." },
		{ Message.INVALID_RECORD_LENGTH, "The record length item must contain a value that splits non-character data at item boundaries." },
		{ Message.RECORD_LENGTH_TOO_LARGE, "The value in the occursItem or lengthItem is too big." },
		{ Message.IO_ERROR, "{0}: I/O with {1} failed for this reason: {2}." },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0}: prepared statement {1} not found[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0}: result set {1} not found[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_ERROR, "{0}: error[sqlstate:{1}][sqlcode:{2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0}: [sqlstate:02000][sqlcode:100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0}: {1}[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_CONNECTION_FAILED, "Cannot connect to {0}: {1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "Cannot connect to {0}, the database URL may be wrong: {1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "An error occurred while loading the JDBC drivers.  Error: {0}" },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "The {0} ResultSet is not scrollable." },
		{ Message.SQL_NO_DEFAULT_DATABASE, "Cannot connect to the default database. The name of the default database was not specified." },
		{ Message.SQL_NO_DATABASE_CONNECTION, "A database connection must be established prior to an SQL I/O operation." },
		{ Message.SQL_DISCONNECT_ERROR, "An error occurred while disconnecting from the {0} database. {1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "Cannot set connection to database {0}. The connection does not exist." },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "An SQL error occurred in function SQLLib.{0}: {1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "A non-SQL error occurred in function SQLLib.{0}: {1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "Null was received from the database but host variable {0} is not nullable." },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "No input was received for required field - enter again." },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "Data type error in input - enter again." },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "Number of allowable significant digits exceeded - enter again." },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "The input is not within the defined range of {0} to {1} - enter again." },
		{ Message.EDIT_VALID_VALUES_ERR, "The input is not in the defined list of valid values - enter again." },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "The specified date and time format of {0} is not valid." },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "Input minimum length error - enter again." },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "Input maximum length error - enter again." },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "Table edit validity error - enter again." },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "Modulus check error on input - enter again." },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "The input is not valid for defined date or time format {0}." },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "Input not valid for boolean field." },
		{ Message.EDIT_INVALID_PATTERN_ERR, "Value entered is invalid as it does not match the pattern that is set." },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "Edit table {0} is not defined for {1}." },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "Hexadecimal data is not valid." },
		{ Message.EDIT_VALIDATION_ERR, "A page validation error occurred.  Error: {0}." },
		{ Message.EDIT_INPUT_ERR, "Error parsing input value."},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "Error formatting value for display: {0}."},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "Input data with SO/SI characters is too long for the item length defined."},
		
		{ Message.ACTION_REQUEST_ERROR, "J2EELib RequestAttr function failed with key, {0}. Error: {1}" },
		{ Message.ACTION_SESSION_ERROR, "J2EELib SessionAttr function failed with key, {0}. Error: {1}" },
		{ Message.ACTION_APPLICATION_ERROR, "J2EELib ApplicationAttr function failed with key, {0}. Error: {1}" },
		{ Message.ACTION_NO_J2EE_ERROR, "J2EELib may only be used in the J2EE environment." },
		
		{ Message.PORTALLIB_SESSION_ERROR, "PortalLib PortletSessionAttr function failed with key {0}. Error: {1}" },
		{ Message.PORTALLIB_MODE_ERROR, "PortalLib setPortletMode failed. Error: {0}" },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "PortalLib setWindowState failed. Error: {0}" },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "Illegal attempt to change Portlet mode during render request" },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "Illegal attempt to change Portlet window state during render request" },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "Failed to get PortletSession" }, 
		{ Message.PORTALLIB_INVALIDKEY, "An invalid key was passed to function {0}" }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "Failed to get PortletRequest" }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "PortalLib resetPreferenceValue function failed with key {0}. Error: {1}" },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "PortalLib savePreferences function failed. Error: {0}" },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "PortalLib failed to set preference for key {0}. Error: {1}" }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "PortalLib failed to get preference for key {0}. Error: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "Failed to access Credential Vault Service. Error: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "Failed to access requested Credential in slot {0}. Error: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "Failed to create Credential Vault slot in user space. Error: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "Failed to delete Credential Vault slot in user space. Error: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "Failed to set Credential values. Error: {0}" },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "{0} failed. Invoking a method or accessing a field called {1} resulted in an unhandled error. The error message is {2}" },
		{ Message.JAVALIB_NULL_ID, "{0} failed. {1} is not an identifier, or it is the identifier of a null object." },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "{0} failed. A public method, field, or class named {1} does not exist or cannot be loaded, or the number or types of parameters are incorrect. The error message is {2}" },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "{0} failed. The type of a value in EGL does not match the type expected in Java for {1}. The error message is {2}" },
		{ Message.JAVALIB_NULL_RETURNED, "{0} failed. The target is a method that returned null, a method that does not return a value, or a field whose value is null." },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "{0} failed. The class {1} of a null argument could not be loaded. The error message is {2}" },
		{ Message.JAVALIB_ACCESS_ERROR, "{0} failed. Could not get information about the method or field named {1}, or an attempt was made to set the value of a field declared final. The error message is {2}" },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "{0} failed. {1} is an interface or abstract class, so the constructor cannot be called." },
		{ Message.JAVALIB_NOT_STATIC, "{0} failed. The method or field {1} is not static. An identifier must be used instead of a class name." },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "The {0} action field does not exist." },
		{ Message.CUI_E_ARRAY_FULL, "Another row cannot be inserted because the input array is full." },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "The {0} array cannot be found." },
		{ Message.CUI_E_ASSIGN_RESULT, "Assignment to prompt result variable failed." },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "The {0} size for the Screen Array field is not correct."	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "The DrawBox parameters are out of range." },
		{ Message.CUI_E_BAD_COORDINATES, "The display coordinates are outside the window boundaries." },
		{ Message.CUI_E_BAD_KEYNAME, "Malformed key name ''{0}''." },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "You cannot use this editing feature because a picture exists." },
		{ Message.CUI_E_BAD_WINDOW_NAME, "Cannot find window ''{0}''." },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "New window position[{0},{1}]/dimension[{2},{3}] values are  not valid." },
		{ Message.CUI_E_CMDSTACK_SYNC, "The command stack is out of synch." },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "The Console UI library is not initialized." },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "Illegal field type for construct." },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "ConstructQuery cannot be called with a variable list." },
		{ Message.CUI_E_DISABLE_INVISIBLE, "Cannot disable an invisible menu item." },
		{ Message.CUI_E_EDIT_FAILED, "Edit action failed." },
		{ Message.CUI_E_EXEC_HOTKEY, "Error occurred while executing hotkey action." },
		{ Message.CUI_E_EXIT_NO_CMD, "There is no active command to exit from." },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "There is no active command to continue." },
		{ Message.CUI_E_FATALERROR, "Fatal error: {0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "The {0} field does not exist." },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "The {0} screen array field is not an array." },
		{ Message.CUI_E_FIELD_NOT_FOUND, "The {0} field cannot be found." },
		{ Message.CUI_E_FIELD_NO_WINDOW, "Cannot create ConsoleField without a window." },
		{ Message.CUI_E_FIELD_COUNT, "Array field count mismatch." },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "The {0} form does not exist." },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "The {0} form does not fit in the {1} window." },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "The field lists do not match." },
		{ Message.CUI_E_FORM_IN_USE, "The {0} form is busy." },
		{ Message.CUI_E_FORM_NAME_USED, "A form with {0} name already exists." },
		{ Message.CUI_E_FORM_NOT_OPEN, "The {0} form is not open." },
		{ Message.CUI_E_FORM_NO_WINDOW, "The ConsoleForm cannot be created without a window." },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "Cannot use KeyObject.getChar() for virtual keys." },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "Cannot use KeyObject.getCookedChar() for virtual keys." },
		{ Message.CUI_E_INTERNAL, "INTERNAL ERROR: {0}" },
		{ Message.CUI_E_INTR_RECEIVED, "An INTERRUPT signal was received." },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "Cannot have invisible menu item with no accelerator." },
		{ Message.CUI_E_LABEL_NO_WINDOW, "ConsoleLabel cannot be created without a window." },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "The {0} menu item does not fit in window." },
		{ Message.CUI_E_MISSING_ITEM, "The {0} menu item does not exist." },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "Menu mnemonics conflict (key={0})." },
		{ Message.CUI_E_NO_ACTIVE_FORM, "There is not an active form." },
		{ Message.CUI_E_NO_EDITOR, "A blob editor was not specified." },
		{ Message.CUI_E_NO_HELP_FILE, "A help file was not specified." },
		{ Message.CUI_E_NO_HELP_MSG, "A help message was not specified." },
		{ Message.CUI_E_NO_NUMPAGES, "The menu is not laid out." },
		{ Message.CUI_E_NO_SCREENARRAY, "There is no active screen array." },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "There are no visible menu items." },
		{ Message.CUI_E_NULL_WNDOW_NAME, "The name for the new window was null." },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "Attempt to open a null window." },
		{ Message.CUI_E_PROMPT_EXCEPTION, "An exception occurred in the prompt." },
		{ Message.CUI_E_QUIT_RECEIVED, "A QUIT signal was received." },
		{ Message.CUI_E_SCROLL_FAILED, "Menu cannot scroll to current item." },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "Unknown attribute ''{0}''" },
		{ Message.CUI_E_VALIDATE_FIELD, "There is an error in the {0} field." },
		{ Message.CUI_E_VAR_LIST_SHORT, "Not enough variables were supplied." },
		{ Message.CUI_E_WINDOW_NAME_USED, "The {0} window name is already being used." },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "The window size is too small for the help screen." },
		{ Message.CUI_E_VALID_VALUES, "The specified value is not a valid value." },
		{ Message.CUI_W_NO_MORE_FIELDS, "There are no more fields in the direction you are going." },
		{ Message.CUI_W_NO_MORE_ROWS, "There are no more rows in the direction you are going." },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "The {0} screen array contents are not valid." },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "The {0} screen array cannot contain the {1} segmented field."	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "The {0} screen array is not compatible with the data array." },
		{ Message.CUI_E_FIELD_NAME_DUP, "The {0} field name is being used more than once." },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "{0} console field length is not valid." },
		{ Message.CUI_E_LABEL_NOT_FIT, "The label at [{0}, {1}] does not fit in the available space." },
		{ Message.CUI_E_FIELD_NOT_FIT, "The {0} field segment at ({1}, {2}) does not fit in the available space." },
		{ Message.CUI_E_PROMPT_TOO_LONG,"The prompt string is too long for the active window."},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"The OpenUI array arguments are not valid."},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, "The OpenUI field arguments are not valid."},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "Only a single variable may be bound to a prompt statement." },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "The data binding for {0} console field cannot be determined." },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "Warning: NUL characters found in clob data" },
		{ Message.CUI_I_STR_WINDOWTITLE , "EGL Console Window" },
		{ Message.CUI_E_MISSING_FORMAT , "The {0} field has no format object." },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "The two entries were not the same -- please try again" },
		{ Message.CUI_I_STR_VERIFY_INPUT, "Please type again for verification" },
		{ Message.CUI_I_STR_HELP,"Help"},
		{ Message.CUI_I_STR_RESUME,"Resume"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"Ends this Help session."},
		{ Message.CUI_I_STR_SCROLL , "Scroll" },
		{ Message.CUI_I_STR_LAST_PAGE, "You have reached the end of the help text. Press RETURN to continue."},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "Displays the next page of Help text."},
		{ Message.CUI_I_STR_SELECT , "SELECT"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "Error inserting first row in empty array."},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "F25-F64 not implemented."},
		{ Message.CUI_E_UNIMP_FN_KEYS , "INTERNAL: F25-64 not implemented" },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "Can''t have multiple instances of CursesCanvas" },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "CursesCanvas not initialized" },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "CursesCanvas is too small"},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "Display fields by name not implemented."},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "Minimum input {0} required - enter again." },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "Maximum input {0} exceeded - enter again." },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "Cannot open script file ''{0}''." },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "Cannot read script file."},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "The property automation.scenario ''{0}'' is not a directory."},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "Malformed <click> directive in replay script."},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "Cannot get automation property ''{0}''."},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "Invalid panic key name ''{0}''"},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "Exception in <click>."},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "Cannot open snapshot file ''{0}''"},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "The property set for automation.scriptdir ''{0}'' does not exist."},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "The property set for automation.scenario directory ''{0}'' cannot be created."},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "Invalid snapshot key name ''{0}''"},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "Compare ok."},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "Using display I/O operations are not permitted while running in RCP mode."},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "A message with the {0} ID does not exist in the {1} message table." },
		{ Message.MSG_TBL_LOAD_ERR, "The {0} message table file cannot be loaded." },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "There is not a user message table defined for the {0} VGUIRecord." },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "Field ''{0}'' at position({1},{2}) does not lie within the form." },
		{ Message.TUI_E_FIELD_OVERLAP, "Field ''{0}'' overlaps ''{1}''." },
		{ Message.TUI_E_NO_FORMGROUP, "Internal error: Cannot determine form group." },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "Form ''{0}'' does not fit in any floating area." },
		{ Message.TUI_E_BAD_FIELD_COORDS, "Field ''{0}'' coordinates are invalid." },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "Cannot get print association." },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "No suitable print device size exists." },
		{ Message.TUI_E_NO_DISPLAY, "No display device exists for forms." },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "No compatible device size exists for displayed forms." },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "Help form class ''{0}'' does not exist." },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "Unknown attribute ''{0}''." },
		{ Message.TUI_E_INVALID_VALID_VALUE, "The value specified in the valid values attribute is incorrect and could not be parsed." },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "Cannot create help form ''{0}''" },
		{ Message.TUI_E_INTERNAL, "INTERNAL ERROR: {0}" },
		{ Message.TUI_E_NO_PRINTERS, "There are no printers available." },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "There is no default printer." },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "Printer ''{0}'' was not found.\nThese printers are available:\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "Error loading message ''{0}''" },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "The content of {0} cannot be used as a field." },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "Printer ''{0}'' not found" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "Program {0} expected text form {1} but it was given text form {2} on a show statement." },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "Next" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "Page {0} of {1}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "Prev" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "Print" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "Print Preview - {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "Save" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "Save PrintJob - {0} " },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "Error printing to file: {0}" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "Error printing to printer: {0}" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "Setting EZEMNO" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "Validating field ''{0}''" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "Validating textform" },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "Validating textform - running validator function ''{0}''" },
		{ Message.TUI_E_INVALID_CURSOR_POSITION, "The cursor cannot be moved to line {0} and column {1}." },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "Cannot create logwriter." },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "Logging parameter ''{0}'' cannot be set after startup." },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "Logdir ''{0}'' does not exist." },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "Cannot write to logdir ''{0}''." },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "Cannot create logfile ''{0}''." },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "Cannot write to logfile ''{0}''." },
		
		{ Message.SOA_E_LOAD_SERVICE, "Problem loading service for Component/ExternalService {0}." },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "An error occurred creating a connection to Web service operation ''{0}''.  {1}." },
		{ Message.SOA_E_WS_GET_OPERATION, "An error occurred getting the operation:''{0}'' from the wsdl file:''{1}''." },
		{ Message.SOA_E_WS_MALFORMED_URL, "The target URL for the {1} Web service operation is not valid. URL: {0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "An error occurred while loading the {0} service. Error: {1}." },
		{ Message.SOA_E_LOAD_WEB_PROXY, "An error occurred when trying to load a Web service. Could not resolve the WSDL port for external service {0}." },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "The {0} component is missing the {1} property which is required by the service implementation." },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "Service reference ''{0}'' is either missing or does not have a target value." },
		{ Message.SOA_E_MISSING_BINDING, "Service binding:''{0}'' does not exist in the deployment descriptor:''{1}''" },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "An error occured when trying to convert record ''{0}'' into a SOAP message.  Could not find field ''{1}'' in record." },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "An error occured when trying to convert ''{0}'' into a SOAP message."},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "An error occurred when processing an in bound message from a Web service. The Java type is incompatible with the EGL type." },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "An error occurred when processing an out bound message to a Web service. The EGL type is incompatible with the Java type" },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "Unable to initialize record ''{0}''." },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "Cannot convert value ''{0}'' to a Calendar." },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "Cannot convert value ''{0}'' to a boolean." },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "Cannot convert value ''{0}'' to a Byte." },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "Cannot convert value ''{0}'' to a short." },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "Cannot convert value ''{0}'' to a URI." },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "EGL Type not supported as a Web service parameter." },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "An error occured when trying to create record array. {0}." },
		{ Message.SOA_E_METHOD_NOT_FOUND, "Method {0} not found in service {1}." },
		{ Message.SOA_E_NOT_WEB_SERVICE, "The service is not a web service." },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "An error occurred while trying to invoke function:{0} on WebService:{1}." },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "An error occurred while trying to invoke function:{0} on EGL Service:{1}." },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "An error occurred while trying to invoke function:{0} on EGL Service:{1} using {2}:{3}." },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "The service is not a tcpip service." },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "An error occurred while trying to invoke function:{0} on entry point:{1}." },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "An error occurred while trying to load Service binding file {0}. {1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "An error occurred while trying to invoke function:{0} on CICS Service:{1}. Error Code:{2}, Message:{3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "An error occurred while trying to invoke function:{0} on iSeries Service:{1}. Error Code:{2}, Message:{3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "The service is not a CICS service." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "An error occurred in remote service {0}, date {1}, time {2}, on system {3}." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "An error occurred in remote service {0}, on system {1}." },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "Run unit ended due to an application error on system {0} trying to call service {1}. Message: {2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "AS400Toolbox execution error: {0}, {1} while calling service {2} on system {3}." },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "Unsupported service binding. {0} was generated for Websphere, but is being called from a non J2EE envoronment. Regenerate into a non J2EE project." },
		{ Message.SOA_E_USER_ID_NOT_SET, "The remote user ID and password must be set before invoking WebService:{0} function:{1}." },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "An exception occurred while calling a service." },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "An exception occurred while communicating with the service. URL:{0}" },
		{ Message.SOA_E_WS_PROXY_REST, "An exception occurred during a REST service call. Binding:{0}, Operation:{0}" },
		{ Message.SOA_E_WS_PROXY_SOAP, "An exception occurred during a SOAP service call. Binding:{0}, Service:{1}, Port:{2}, WSDL location:{3}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "An exception occurred while converting from JSON. parameter:{0}, json:{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "An exception occurred while converting to JSON. parameter:{0}, value:{1}" },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "No REST-RPC service was found. URL:{0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "No response was received from the service. URL:{0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "The request could not be converted to a service call. The received request was ''{0}''. " },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "The service invocation timed out. exception: Connection read time out error. url:{0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "The service is not a rest service." },
		{ Message.SOA_E_REST_SERVICE, "The call to the REST service invocation failed. Binding:{0}, Operation:{1}, HTTP method:{2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "An exception occurred while converting data to EGL parameters. Binding:{0}, data to convert{1}, exception:{2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "A REST service invocation was made on a non REST service reference. Service Reference: {0}, Operation {1}, HTTP method: {2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "An exception occurred while converting from XML. The required element {0} is missing." },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "An exception occurred while converting from XML. parameter:{0}, xml:{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "An exception occurred while converting to XML. parameter:{0}, value:{1}" },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "An XML parsing exception occurred while converting {0} from XML." },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "An XML conversion exception occurred while converting {0} to XML." },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "The URL ''{0}'' used to invoke the service is invalid. It doesn''t contain the http:// protocol." },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "The URL ''{0}'' used to invoke the service is invalid. {1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "The URL used to invoke the service is blank. Specify a URL that points to the service." },
		{ Message.SOA_E_WS_GATEWAY_EXCEPTION, "An exception occured in the gatewat service while calling program:{0}." },
		{ Message.SOA_E_JSON_TYPE_EXCEPTION, "JSON conversion cannot be performed on {0}." },
		{ Message.SOA_E_JSON_CONVERSION_EXCEPTION, "Service library JSON conversion functions operate on a Record or Dictionary. {0} is not a supported type." },
		{ Message.SOA_E_NOT_JAXWS_WEB_SERVICE, "The service is not a JAX-WS web service." },
		{ Message.SOA_E_JAXWS_SOAP_HEADER_EXCEPTION, "Service library SOAP header functions operate on a Record or Dictionary. {0} is not a supported type." },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_ELEMENT_EXCEPTION, "unexpected element <{0}>. Expected elements are <{1}>." },
		{ Message.SOA_E_WS_PROXY_UNSUPPORTED_OPERATION, "The service being invoked: {0} is a system service. System services have no source code and can not be previewed and can only be debugged when they are deployed as a SOAP or EGL REST service."  },
		{ Message.SOA_E_WS_PROXY_NO_J2EE_OPERATION, "The service being invoked is accessing the J2EE context, J2EE context may only be used in the J2EE environment."  },
		
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "Could not fill report using connection {0}"},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "Could not fill report using sql statement {0}"},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "Could not fill report using dynamic array {0}"},
		{ Message.REPORT_E_FILL_ERROR , "Could not fill report {0}"},
		{ Message.REPORT_E_EXPORT_ERROR, "Could not export report {0}" },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "Could not convert between EGL {0} and Java {1} types" },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "Could not convert between Java {0} and EGL {1} types" },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "Could not add report parameter" },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "Could not reset report parameter list" },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "Incorrect field name {0}" },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "Incorrect sub-report name {0}" },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "Unsupported type being used in reporting" },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "Cannot pass complex types to this function" },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "Design file name should be set before calling getParameterDefaultValue() function." },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "Could not get the default value for parameter {0}. {1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "A report parameter named {0} does not exist." },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "Design file name should be set before calling createReportFromDesign() or createDocument() functions." },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, "Document file name should be set before calling createReportFromDocument() function." },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "Could not create the report document file. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "Could not create report from design file. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "Could not create report from document file. {0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "Handler object specified for a BirtReport must be of type BirtHandler." },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "Element {0} does not exist in the report design, or it is not of the specified type." },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "{0} row number {1} does not exist in the table {2}." },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "Row number {0} does not exist in the grid element {1}." },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "Group {0} does not exist in the table {1}." },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "{0} row number {1} does not exist in group {2} in the table {3}." },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "Column number {0} does not exist in a {1} row in the table {2}." },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "Column number {0} does not exist in the grid {1}." },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "Column number {0} does not exist in {1} row in group {2} in the table {3}." },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "''RowType'' property has to be specified for an event handler function for row(s) or cell(s) in table {0}." },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "Could not convert Java type {0} to an EGL type." },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "Could not convert EGL type {0} to a Java type." },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "Data set {0} does not exist in the report design." },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "Data set {0} is a scripted data set, but none of the following eventTypes were handled: openEvent, fetchEvent, closeEvent." },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "Data source {0} does not exist in the report design." },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "Data source {0} is a scripted data source, but none of the following eventTypes were handled: openEvent, closeEvent." },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "Column number {0} does not exist in the data set {1}." },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "Exception occured when getting column {0} from the data set {1}. {2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "Exception occured when setting column {0} of the scripted data set {1}. {2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "Exception occured when getting column binding {0}. {1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "Property vgj.defaultI4GLNativeLibrary not specified" },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "Library {0} load failed {1}" },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "Parameters returned does not match the function" },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "Could not allocate memory"},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "Could not convert between types"},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "Invalid Datetime or Interval precision"},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "Character host variable is too short for the data"},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "The function cannot be found in the symbol table"},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "A TEXT or BYTE data type must be supplied within this context"},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "The value on the stack could not be converted to a value type"},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "The value on the stack could not be converted to ANY"},
		{ Message.CINTERFACE_E_POP_ERROR, "Could not pop a value of type {0} off the stack"},
		{ Message.CINTERFACE_E_PUSH_ERROR, "Could not push a value of type {1} onto the stack"},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "Nothing to push/pop"},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "Could not pop Locator off the stack"},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "Stack is empty"},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "Could not copy locator"},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "A null reference was pushed onto the stack"},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "Could not push Any to the stack"},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "Could not assign the stack element to Any type"},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "Return Type mismatch"},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "Parameter Type mismatch"},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "Could not find the EGL source file {0}.  Generated code will be run instead." },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "Could not find the EGL source file for the web transaction named {0}." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "The following formatting problem occurred on field \"{0}\" while displaying form \"{1}\":" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, "{0}\n\nThe expected internal format of the field is \"{1}\". Check the date format properties in the EGL Java Runtime properties within the debug Build descriptor or your JDBC properties that affect date formats." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\nThe display format of the field is \"{1}\". Check the \"{2}\" property on the form field." },
		{ Message.DEBUG_UIPROGRAM_SOURCE_NOT_FOUND, "Could not find the EGL source file for the UI program named {0}." },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "Cannot run program, {0}, as a web transaction." },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "The web transaction was given input UI record {0}, but it was defined with input UI record {1}." },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "Input not valid for boolean field." },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "A timeout occurred in program {0} due to inactivity." },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "User Interface record {0} contains too much data to be sent to gateway servlet." },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "The program was unable to verify data from the gateway servlet.  The data identifier is {0}." },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "Array wrapper {0} cannot be expanded beyond its maximum size. The error occured in method {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "{0} is an invalid index for array wrapper {1}. Maximum size: {2}. Current size: {3}" },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "{0} is not a valid maximum size for array wrapper {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "{0} is an invalid object type to add to an array wrapper of type {1}." },
		
		{ Message.IMS_HOST_ABORT, "Abort packet was received from the remote host."},
		{ Message.IMS_HOST_TCPIP_ERROR, "TCPIP error occured on the remote host. Section:{0} TCPIP-Operation:{1} TCPIP-RETCODE:{2} TCPIP-ERRNO:{3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "Error occured on the host while calling:{0}"},
		{ Message.IMS_HOST_PACKET_ERROR, "The wrong response packet was received from the host. Expected:{0} Received:{1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "IO error executing the stored procedure. {0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "SQL error executing the stored procedure. {0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "Error on the remote host executing:{0} RETCODE:{1} DLI Proxy job id:{2}"},
		{ Message.IMS_HOST_DLI_ERROR, "DLI error on the remote host. DLI Function:{0} AIB-return:0x{1} AIB-reason:0x{2} statusCode:{3} DLI Proxy job id:{4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "DLI error on the remote host. DLI Function:{0} AIB-return:0x{1} AIB-reason:0x{2} DLIVar.statusCode:{3} DLIVar.DbName:{4} DLIVar.SegmentName:{5} DLIVar.SegmentLevel:{6} DLI Proxy job id:{7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "AIB-return code indicates a PCB-status code, but no PCB returned. AIB-function:{0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "Exception occured in CALL EZEDBTCP on the remote host. Section:{0} TCPIP-Operation:{1} TCPIP-RETCODE:{2} TCPIP-ERRNO:{3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "ABEND occured on the remote host. Routine:{0} Message:{1} "},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "Exception occured in on the remote host. CALL:{0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "The debugger does not support the DLI function. Function:{0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "A DL/I call is being issued but the build descriptor is not configured for DL/I access."},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "Remote exception: {0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "An error occured while trying to allocate a PSB. The IMSID is set indicating there is DL/I access, but there is no PSB specified"},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "The RBD client and host versions are not compatible. RBD client version:{0} Host version:{1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "An error occured while retrieving the data returned from a call to a host program. {0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "An error occured while retrieving the PCB name. PCB index:{0}, number of PCBs:{1}"},
		
		{ Message.UIPGM_GATEWAY_INFO_BOUND, "A gateway session is being bound for user, {0}." },
		{ Message.UIPGM_GATEWAY_INFO_UNBOUND, "A gateway session is being unbound for user, {0}." },
		{ Message.UIPGM_SESSIONID_PREFIX_TOO_LONG, "The SessionID Prefix cannot be more than {0} characters long." },
		{ Message.UIPGM_NO_PROGRAM_NAME, "No program name was specified on the invokeProgram call." },
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
