/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle_fr extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "L''erreur s''est produite dans {0}." },
		{ Message.FUNCTION_ERROR_INFO, "L''erreur s''est produite dans {0} lors du traitement de la fonction {1}." },
		{ Message.FILE_ERROR_INFO, "L''erreur s''est produite dans {0} lors du traitement de la fonction {1} \u00e0 la ligne {2}." },
		{ Message.PROPERTIES_FILE_MISSING, "Le fichier de propri\u00e9t\u00e9s {0} n''a pas pu \u00eatre charg\u00e9." },
		{ Message.LOAD_LIBRARY_FAILED, "La biblioth\u00e8que {0} ne peut pas \u00eatre charg\u00e9e. L''erreur suivante s''est produite : {1}." },
		{ Message.CREATE_OBJECT_FAILED, "Une erreur s''est produite lors de la cr\u00e9ation d''un objet du type {0}. L''erreur suivante s''est produite : {1}." },
		{ Message.INITIAL_CONTEXT_ERROR, "Erreur pendant la cr\u00e9ation d''InitialContext ou pendant la recherche de l''environnement java:comp/env. L''erreur suivante s''est produite : {0}" },
		{ Message.LISTENER_ERROR, "L''exception et le message suivants ont \u00e9t\u00e9 \u00e9mis. Exception : {0}. Message : {1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "Il est indispensable de fournir une valeur pour la propri\u00e9t\u00e9 {0}." },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "Une d\u00e9pendance externe est manquante. L''exception suivante s''est produite. Exception : {0}" },
		{ Message.UNSUPPORTED_COMPARE, "Les op\u00e9randes {0} et {1} ne peuvent pas \u00eatre compar\u00e9s." },
		{ Message.ASSIGNMENT_OVERFLOW, "Une erreur de d\u00e9bordement s''est produite lors de l''affectation de la valeur {0} \u00e0 {1}." },
		{ Message.EXPRESSION_OVERFLOW, "Une erreur de d\u00e9bordement s''est produite lors du calcul de l''expression suivante : {0}." },
		{ Message.UNSUPPORTED_OPERANDS, "L''op\u00e9rateur {0} n''est pas accept\u00e9 pour les op\u00e9randes {1} et {2}." },
		{ Message.UNSUPPORTED_OPERAND, "L''op\u00e9rateur {0} n''est pas accept\u00e9 pour l''op\u00e9rande {1} du type {2}." },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "L''op\u00e9rateur subscript n''est pas admis pour l''op\u00e9rande {0} du type {1}." },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "L''op\u00e9rateur substring n''est pas admis pour l''op\u00e9rande {0} du type {1}." },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "L''instruction SET EMPTY n''est pas admise pour l''op\u00e9rande {0} du type {1}." },
		{ Message.INVALID_REGULAR_EXPRESSION, "Une erreur s''est produite dans l''expression r\u00e9guli\u00e8re {0}. Erreur : {1}." },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "Si vous utilisez le protocole CICSSSL, vous devez d\u00e9finir les deux valeurs ctgKeyStore et ctgKeyStorePassword." },
		{ Message.INVALID_CTGPORT, "La valeur {0} n''est pas correcte pour l''entr\u00e9e ctgport." },
		{ Message.CTG_CONNECT_FAILED, "Une erreur s''est produite lors de la connexion au serveur CTG. L''emplacement du CTG est {0}. Le port du CTG est {1}. L''erreur suivante s''est produite : {2}" },
		{ Message.CTG_DISCONNECT_FAILED, "Une erreur est survenue lors de la d\u00e9connexion du serveur CTG. L''emplacement du CTG est {0}. Le port du CTG est {1}. L''erreur suivante s''est produite : {2}" },
		{ Message.NO_CICS, "Une erreur s''est produite lors de l''appel du programme {0} qui utilise l''interface ECI CICS. Le code retour est -3 (ECI_ERR_NO_CICS). L''identificateur du syst\u00e8me CICS est {1}." },
		{ Message.CICS_DIED, "Une erreur s''est produite lors de l''appel du programme {0} qui utilise l''interface ECI CICS. Le code retour est -4 (ECI_ERR_CICS_DIED). L''identificateur du syst\u00e8me CICS est {1}." },
		{ Message.CICS_TIMEOUT, "Une erreur s''est produite lors de l''appel du programme {0} qui utilise l''interface ECI CICS. Le code retour est -6 (ECI_ERR_RESPONSE_TIMEOUT). L''identificateur du syst\u00e8me CICS est {1}." },
		{ Message.CICS_TRANSACTION_ABEND, "Une erreur s''est produite lors de l''appel du programme {0} qui utilise l''interface ECI CICS. Le code retour est -7 (ECI_ERR_TRANSACTION_ABEND). L''identificateur du syst\u00e8me CICS est {1}. Le code de fin anormale est {2}." },
		{ Message.CICS_UNKNOWN_SERVER, "Une erreur s''est produite lors de l''appel du programme {0} qui utilise l''interface ECI CICS. Le code retour est -22 (ECI_ERR_UNKNOWN_SERVER). L''identificateur du syst\u00e8me CICS est {1}." },
		{ Message.CICS_SECURITY_ERROR, "Une erreur s''est produite lors de l''appel du programme {0} qui utilise l''interface ECI CICS. Le code retour est -27 (ECI_ERR_SECURITY_ERROR). L''identificateur du syst\u00e8me CICS est {1}." },
		{ Message.CICS_MAX_SYSTEMS, "Une erreur s''est produite lors de l''appel du programme {0} qui utilise l''interface ECI CICS. Le code retour est -28 (ECI_ERR_MAX_SYSTEMS). L''identificateur du syst\u00e8me CICS est {1}." },
		{ Message.CICS_NONZERO_RETURN_CODE, "Une erreur s''est produite lors de l''appel du programme {0} sur le syst\u00e8me {1} pour l''utilisateur nomm\u00e9 {2}. Un code de retour {3} et un code de fin anormale {4} ont \u00e9t\u00e9 renvoy\u00e9s en r\u00e9ponse \u00e0 l''appel \u00e0 l''interface ECI CICS." },
		{ Message.CICS_COMMIT_FAILED, "Une erreur s''est produite lors de l''appel de l''interface ECI de CICS pour valider une unit\u00e9 de travail. Le code retour CICS est {0}." },
		{ Message.CICS_ROLLBACK_FAILED, "Une erreur s''est produite lors de l''appel de l''interface ECI de CICS pour annuler une unit\u00e9 de travail. Le code retour CICS est {0}." },
		{ Message.CICS_ECI_FLOW_FAILED, "Exception dans le flux d''une demande ECI au syst\u00e8me CICS {0}. Exception : {1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "Erreur de longueur des param\u00e8tres. Le flux comporte {0} param\u00e8tres alors que la fonction locale en a {1}." },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "Taille maximale d\u00e9pass\u00e9e pour le tableau {0}." },
		{ Message.WRONG_NUMBER_OF_PARMS, "Le programme appel\u00e9, {0}, attendait {1} param\u00e8tres, mais {2} lui ont \u00e9t\u00e9 pass\u00e9s." },
		{ Message.FUNCTION_NOT_FOUND, "Une erreur s''est produite lors de l''obtention de l''adresse du point d''entr\u00e9e {0} dans la biblioth\u00e8que partag\u00e9e {1}. Le code retour est {2}." },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "Erreur rencontr\u00e9e au chargement de la biblioth\u00e8que partag\u00e9e {0}. Le code retour est {1}." },
		{ Message.CALL_NONZERO_RETURN_CODE, "Le programme appel\u00e9 a \u00e9chou\u00e9 avec le code retour {0}." },
		{ Message.REMOTE_PROGRAM_ERROR, "Une erreur s''est produite dans le programme distant {0} sur le syst\u00e8me {3}. L''erreur s''est produite dans {1} \u00e0 {2}. {4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "Une erreur s''est produite dans le programme distant {0} sur le syst\u00e8me {1}. {2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "{0} est un nom d''h\u00f4te TCP/IP inconnu." },
		{ Message.SERVERID_IS_INVALID_PORT, "Le ServerID {0} n''est pas un num\u00e9ro de port valide." },
		{ Message.TCPIP_SERVER_ERROR, "Le client a re\u00e7u une notification l''informant que le serveur ne peut pas d\u00e9marrer le programme distant appel\u00e9. Code raison : {0}." },
		{ Message.INVALID_REMOTECOMTYPE, "La valeur de remoteComType est manquante ou n''est pas correcte." },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "Le fichier de propri\u00e9t\u00e9s de liaison {0} ne peut pas \u00eatre ouvert." },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "Aucune entr\u00e9e pour le programme appel\u00e9 {0} n''a \u00e9t\u00e9 trouv\u00e9e dans le fichier de propri\u00e9t\u00e9s de liaison {1}." },
		{ Message.AS400_UNKNOWN_HOST, "L''h\u00f4te {0} est introuvable ou n''est pas connu." },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "Le mot de passe ou l''ID utilisateur ne sont pas corrects pour la connexion au syst\u00e8me {0}. Erreur : {1}" },
		{ Message.AS400_EXCEPTION_CAUGHT, "Une erreur d''ex\u00e9cution AS400Toolbox {0} s''est produite lors de l''appel du programme {2} sur le syst\u00e8me {3}. Erreur : {1}" },
		{ Message.AS400_NO_AUTHORITY, "Une erreur de s\u00e9curit\u00e9 d''acc\u00e8s \u00e0 distance au syst\u00e8me {0} s''est produite pour l''utilisateur {1}. Erreur : {2}" },
		{ Message.REMOTE_COMMIT_FAILED, "Une fonction de validation a \u00e9chou\u00e9 sur le syst\u00e8me {0}. Erreur : {1}" },
		{ Message.REMOTE_ROLLBACK_FAILED, "La fonction d''annulation a \u00e9chou\u00e9 sur le syst\u00e8me {0}. Erreur : {1}" },
		{ Message.AS400_CONNECTION_ERROR, "Une erreur de connexion \u00e0 distance s''est produite lors de l''acc\u00e8s au syst\u00e8me {0}. Erreur : {1}" },
		{ Message.AS400_SERVER_NOT_FOUND, "Erreur d''EGL OS/400 Host Services. Fichiers requis non trouv\u00e9s sur le syst\u00e8me {0}." },
		{ Message.AS400_APPLICATION_ERROR, "L''environnement d''ex\u00e9cution s''est arr\u00eat\u00e9 car une erreur d''application s''est produite sur le syst\u00e8me {0} lors de la tentative d''appel du programme {1}. Message : {2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "La variable de r\u00e9f\u00e9rence appel\u00e9e {0} est associ\u00e9e \u00e0 la valeur NULL." },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "Un erreur non g\u00e9r\u00e9e s''est produite. Erreur : {0}." },
		{ Message.DATA_FORMAT_ERROR, "La valeur de la variable {0} n''est pas au format correct." },
		{ Message.CONVERSION_ERROR, "La valeur {0} du type {1} ne peut pas \u00eatre convertie en type {2}." },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "Le masque de format de date {0} n''est pas valide." },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "Le masque de format d''heure {0} n''est pas valide." },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "Le masque de format d''horodatage {0} n''est pas valide." },
		{ Message.NULL_REFERENCE, "Une r\u00e9f\u00e9rence nulle a \u00e9t\u00e9 utilis\u00e9e." },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "L''acc\u00e8s dynamique n''est pas pris en charge pour {0}." },
		{ Message.DYNAMIC_ACCESS_FAILED, "Aucune zone dont l''identificateur est {0} ne peut \u00eatre trouv\u00e9 dans {1}." },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "Le masque de format num\u00e9rique {0} n''est pas valide." },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "Erreur lors de l''affectation de {0} \u00e0 {1}. Erreur : {2}." },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "Erreur dans l''instruction SET {0} EMPTY. Erreur : {1}." },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "Une erreur {0} s''est produite lors de l''invocation de la m\u00e9thode avec une signature {1}." },
		{ Message.RUN_COMMAND_FAILED, "Erreur pendant l''ex\u00e9cution de la commande {0}.  Erreur : {1}." },
		{ Message.MDY_ERROR, "La fonction DateTimeLib.mdy ne peut pas convertir les valeurs {0}, {1} et {2} en mois, jour et ann\u00e9e." },
		{ Message.NON_NUMERIC_STRING, "La cha\u00eene non num\u00e9rique {1} a \u00e9t\u00e9 pass\u00e9e \u00e0 {0}. Tous les caract\u00e8res du segment de cha\u00eene d\u00e9fini par l''argument length doivent \u00eatre num\u00e9riques." },
		{ Message.SYSTEM_FUNCTION_ERROR, "{0} a \u00e9chou\u00e9 avec le message d''erreur {1}." },
		{ Message.INT_AS_CHAR_ERROR, "L''argument pass\u00e9 \u00e0 StrLib.intAsChar doit \u00eatre un nombre compris entre 0 et 255." },
		{ Message.INVALID_LOB_LENGTH, "{0} n''est pas une longueur valide pour {1}, dont la taille est {2}." },
		{ Message.INVALID_LOB_POSITION, "{0} n''est pas une position valide pour {1}. Sa taille est {2}." },
		{ Message.LOB_ERROR, "Une erreur est survenue lors du traitement d''un \u00e9l\u00e9ment Blob ou Clob.  Le message d''erreur est {0}" },
		{ Message.START_TRANSACTION_ERROR, "L''appel VGLib.startTransaction \u00e0 la classe {0} a \u00e9chou\u00e9. L''exception est {1}" },
		{ Message.INT_AS_UNICODE_ERROR, "L''argument pass\u00e9 \u00e0 StrLib.intAsUnicode doit \u00eatre un nombre compris entre 0 et 65535." },
		{ Message.INVALID_ARRAY_SIZE, "La valeur de taille {0} n''est pas valide pour le tableau {1}. La taille maximale est {2}." },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "L''index {0} est hors limites pour le tableau {1}. La taille du tableau est {2}." },
		{ Message.INVALID_SUBSTRING_INDEX, "Index de sous-cha\u00eene non valides {0}:{1}." },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "L''argument pass\u00e9 \u00e0 la fonction pour le tableau {0} n''est pas valide." },
		{ Message.INDEX_OUT_OF_BOUNDS, "La valeur d''index {0} est hors limites." },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "{0} est une table de conversion non accept\u00e9e." },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "Le fichier csouidpwd.properties ne peut \u00eatre lu. Erreur : {0}" },
		{ Message.CALL_PARMS_TOO_LARGE, "Le tampon du client est trop petit pour stocker la quantit\u00e9 de donn\u00e9es pass\u00e9es dans l''appel. La taille cumul\u00e9e des param\u00e8tres envoy\u00e9s est de {0} octets et elle est sup\u00e9rieure au maximum autoris\u00e9 de {1} octets." },
		{ Message.INVALID_PARMFORM, "La propri\u00e9t\u00e9 de liaison parmForm doit avoir la valeur COMMPTR pour appeler le programme {0}, car au moins un des param\u00e8tres est un tableau dynamique." },
		{ Message.PARM_PASSING_ERROR, "Une erreur est survenue lors du passage des param\u00e8tres au programme appel\u00e9, {0}. Erreur : {1}" },
		{ Message.CALL_ERROR, "Une erreur s''est produite lors de l''appel du programme {0}. Erreur : {1}" },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "{0} est un type de param\u00e8tre non pris en charge pour les programmes de service System i." },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "{0} est un type de renvoi non pris en charge pour les programmes de service System i." },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "Impossible d''obtenir une fabrique de connexions (ConnectionFactory). L''exception est {0}" },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "L''interaction ou la connexion ne peuvent pas \u00eatre ferm\u00e9es. Erreur : {0}" },
		{ Message.ERROR_GETTING_CONNECTION, "Une connexion ne peut pas \u00eatre \u00e9tablie. Erreur : {0}" },
		{ Message.ERROR_GETTING_INTERACTION, "Impossible d''obtenir un objet Interaction. L''exception est : {0}" },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "Impossible de d\u00e9finir une instruction (verb) d''interaction. L''exception est {0}" },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "Impossible d''obtenir un objet LocalTransaction pour l''unit\u00e9 de travail client. L''exception est {0}" },
		{ Message.ERROR_SETTING_TIMEOUT, "Impossible d''\u00e9crire la valeur du d\u00e9lai (timeout) sur un appel CICSJ2C. L''exception est {0}" },
		{ Message.EXCEPTION_CALLING_CICS, "Une erreur est survenue lors d''une tentative de communication avec CICS. L''exception est {0}" },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "La tentative d''ex\u00e9cution de la transaction CICS distante a \u00e9chou\u00e9." },
		{ Message.EXCEPTION_CALLING_IMS, "Une erreur est survenue lors d''une tentative de communication avec IMS. L''exception est {0}" },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "Une erreur est survenue lors d''une tentative de communication avec IMS." },
		{ Message.MATH_DOMAIN_ERROR, "{0} a \u00e9chou\u00e9 avec le code d''erreur 8 (erreur de domaine). Un argument pass\u00e9 \u00e0 la fonction n''est pas valide." },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "{0} a \u00e9chou\u00e9 avec le code d''erreur 8 (erreur de domaine). L''argument doit \u00eatre compris entre -1 et 1." },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "{0} a \u00e9chou\u00e9 avec le code d''erreur 8 (erreur de domaine). Le deuxi\u00e8me argument ne doit pas \u00eatre z\u00e9ro." },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "{0} a \u00e9chou\u00e9 avec le code d''erreur 8 (erreur de domaine). L''argument doit \u00eatre sup\u00e9rieur \u00e0 z\u00e9ro." },
		{ Message.MATH_POW_1_DOMAIN_ERR, "MathLib.pow a \u00e9chou\u00e9 avec le code d''erreur 8 (erreur de domaine). Si le premier argument est z\u00e9ro, le second doit \u00eatre sup\u00e9rieur \u00e0 z\u00e9ro." },
		{ Message.MATH_POW_2_DOMAIN_ERR, "MathLib.pow a \u00e9chou\u00e9 avec le code d''erreur 8 (erreur de domaine). Si le premier argument est inf\u00e9rieur \u00e0 z\u00e9ro, le second doit \u00eatre un entier." },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "MathLib.sqrt a \u00e9chou\u00e9 avec le code d''erreur 8 (erreur de domaine). L''argument doit \u00eatre sup\u00e9rieur ou \u00e9gal \u00e0 z\u00e9ro." },
		{ Message.MATH_RANGE_ERROR, "{0} a \u00e9chou\u00e9 avec le code d''erreur 12 (erreur d''intervalle)." },		
		{ Message.STRING_INDEX_ERROR, "{0} a \u00e9chou\u00e9 avec le code d''erreur 8. L''index doit \u00eatre compris entre 1 et la longueur de la cha\u00eene." },
		{ Message.STRING_LENGTH_ERROR, "{0} a \u00e9chou\u00e9 avec le code d''erreur 12. La longueur doit \u00eatre sup\u00e9rieure \u00e0 z\u00e9ro." },
		{ Message.STRING_NULT_ERROR, "StrLib.setNullTerminator a \u00e9chou\u00e9 avec le code d''erreur 16. Le dernier octet de la cha\u00eene cible doit \u00eatre un caract\u00e8re blanc ou nul." },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "{0} a \u00e9chou\u00e9 avec le code d''erreur 20. L''index d''une sous-cha\u00eene STRING, DBCHAR ou UNICODE doit \u00eatre impair afin d''identifier le premier octet d''un caract\u00e8re." },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "{0} a \u00e9chou\u00e9 avec le code d''erreur 24. La longueur d''une sous-cha\u00eene STRING, DBCHAR ou UNICODE doit \u00eatre paire afin de correspondre \u00e0 un nombre entier de caract\u00e8res." },
		{ Message.NO_DEBUG_LISTENER, "Impossible de contacter le d\u00e9bogueur EGL au nom d''h\u00f4te {0}, port {1}. L''exception est {2}" },
		{ Message.DEBUG_LISTENER_PROBLEM, "Une erreur s''est produite lors de la communication avec d\u00e9bogueur EGL au nom d''h\u00f4te {0}, port {1}. L''exception est {2}" },
		{ Message.NOT_DEBUG_MODE, "Le lien a sp\u00e9cifi\u00e9 un appel DEBUG dans un serveur J2EE. Soit l''appel n''a pas \u00e9t\u00e9 \u00e9mis \u00e0 destination d''un serveur J2EE, soit le serveur J2EE n''est pas en mode d\u00e9bogage ou n''a pas \u00e9t\u00e9 activ\u00e9 pour le d\u00e9bogage EGL." },
		{ Message.LIBRARY_NOT_SPECIFIED, "Le lien a sp\u00e9cifi\u00e9 un appel DEBUG \u00e0 destination d''un \u00e9couteur (listener) mais n''a pas sp\u00e9cifi\u00e9 la propri\u00e9t\u00e9 library." },
		
		{ Message.FILETYPE_MISSING, "La propri\u00e9t\u00e9 d''ex\u00e9cution vgj.ra.fileName.fileType est introuvable pour le fichier {0}." },
		{ Message.FILETYPE_INVALID, "La valeur de la propri\u00e9t\u00e9 d''ex\u00e9cution vgj.ra.fileName.fileType n''est pas valide pour le fichier {0}." },
		{ Message.INVALID_RECORD_LENGTH, "L''\u00e9l\u00e9ment longueur d''enregistrement doit contenir une valeur qui divise les donn\u00e9es non-caract\u00e8re aux limites de l''\u00e9l\u00e9ment." },
		{ Message.RECORD_LENGTH_TOO_LARGE, "La valeur dans occursItem ou lengthItem est trop grande." },
		{ Message.IO_ERROR, "{0} : L''entr\u00e9e-sortie avec {1} a \u00e9chou\u00e9 pour cette raison : {2}." },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0} : instruction pr\u00e9par\u00e9e {1} non trouv\u00e9e[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0} : ensemble de r\u00e9sultats {1} non trouv\u00e9[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_ERROR, "{0} : erreur[sqlstate:{1}][sqlcode:{2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0} : [sqlstate:02000][sqlcode:100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0} : {1}[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_CONNECTION_FAILED, "Connexion impossible \u00e0 {0}: {1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "Impossible d''\u00e9tablir la connexion \u00e0 {0}. L''URL de la base de donn\u00e9es est peut-\u00eatre incorrecte : {1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "Une erreur s''est produite lors du chargement des pilotes JDBC.  Erreur : {0}" },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "Le ResultSet {0} n''est pas d\u00e9filable (scrollable)." },
		{ Message.SQL_NO_DEFAULT_DATABASE, "Impossible de se connecter \u00e0 la base de donn\u00e9es par d\u00e9faut. Le nom de la base de donn\u00e9es par d\u00e9faut n''a pas \u00e9t\u00e9 sp\u00e9cifi\u00e9." },
		{ Message.SQL_NO_DATABASE_CONNECTION, "Une connexion \u00e0 la base de donn\u00e9es doit \u00eatre \u00e9tablie avant tout op\u00e9ration d''entr\u00e9e-sortie SQL." },
		{ Message.SQL_DISCONNECT_ERROR, "Une erreur s''est produite lors de la d\u00e9connexion de la base de donn\u00e9es {0}. {1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "Impossible de d\u00e9finir la connexion \u00e0 la base de donn\u00e9es {0}. La connexion n''existe pas." },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "Une erreur SQL s''est produite dans la fonction SQLLib.{0} : {1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "Une erreur non-SQL s''est produite dans la fonction SQLLib.{0} : {1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "La valeur NULL a \u00e9t\u00e9 re\u00e7ue de la base de donn\u00e9es mais la variable h\u00f4te {0} n''accepte pas les valeurs NULL." },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "Aucune entr\u00e9e re\u00e7ue pour une zone obligatoire. Recommencez la saisie." },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "Erreur de type de donn\u00e9es dans l''entr\u00e9e. Recommencez la saisie." },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "D\u00e9passement du nombre de chiffres significatifs autoris\u00e9. Recommencez la saisie." },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "Entr\u00e9e non comprise dans la plage d\u00e9finie de {0} \u00e0 {1}. Recommencez la saisie." },
		{ Message.EDIT_VALID_VALUES_ERR, "Entr\u00e9e non comprise dans la liste d\u00e9finie de valeurs admises. Recommencez la saisie." },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "Le format de date et d''heure sp\u00e9cifi\u00e9, {0}, n''est pas valide." },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "La longueur minimale entr\u00e9e est erron\u00e9e. Recommencez la saisie." },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "La longueur maximale entr\u00e9e est erron\u00e9e. Recommencez la saisie." },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "Erreur de validit\u00e9 d''\u00e9dition de table. Recommencez la saisie." },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "Erreur de validit\u00e9 du modulo dans l''entr\u00e9e. Recommencez la saisie." },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "Entr\u00e9e non valide compte tenu du format de date ou d''heure d\u00e9fini, {0}." },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "Entr\u00e9e non valide pour une zone bool\u00e9nne." },
		{ Message.EDIT_INVALID_PATTERN_ERR, "La valeur entr\u00e9e n''est pas valide, car elle ne correspond pas au masque d\u00e9fini." },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "Edition de table {0} non d\u00e9finie pour {1}." },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "Donn\u00e9es hexad\u00e9cimales non valides." },
		{ Message.EDIT_VALIDATION_ERR, "Une erreur de validation de page s''est produite.  Erreur : {0}." },
		{ Message.EDIT_INPUT_ERR, "Erreur \u00e0 l''interpr\u00e9tation de la valeur d''entr\u00e9e."},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "Erreur lors du formatage de la valeur \u00e0 afficher : {0}."},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "Les donn\u00e9es d''entr\u00e9e avec des caract\u00e8res SO/SI sont trop longues pour la longueur d''\u00e9l\u00e9ment d\u00e9finie."},
		
		{ Message.ACTION_REQUEST_ERROR, "La fonction J2EELib RequestAttr a \u00e9chou\u00e9 avec la cl\u00e9, {0}. Erreur : {1}" },
		{ Message.ACTION_SESSION_ERROR, "La fonction J2EELib SessionAttr a \u00e9chou\u00e9 avec la cl\u00e9, {0}. Erreur : {1}" },
		{ Message.ACTION_APPLICATION_ERROR, "La fonction J2EELib ApplicationAttr a \u00e9chou\u00e9 avec la cl\u00e9, {0}. Erreur : {1}" },
		{ Message.ACTION_NO_J2EE_ERROR, "J2EELib ne peut \u00eatre utilis\u00e9e que dans l''environnement J2EE." },
		
		{ Message.PORTALLIB_SESSION_ERROR, "La fonction PortalLib PortletSessionAttr a \u00e9chou\u00e9 avec la cl\u00e9 {0}. Erreur : {1}" },
		{ Message.PORTALLIB_MODE_ERROR, "PortalLib setPortletMode a \u00e9chou\u00e9. Erreur : {0}" },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "PortalLib setWindowState a \u00e9chou\u00e9. Erreur : {0}" },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "Tentative ill\u00e9gale de changement du mode de portlet durant une demande de rendu" },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "Tentative ill\u00e9gale de changement d''\u00e9tat de la fen\u00eatre de portlet durant une demande de rendu" },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "Impossible d''obtenir PortletSession" }, 
		{ Message.PORTALLIB_INVALIDKEY, "Une cl\u00e9 non valide a \u00e9t\u00e9 pass\u00e9e \u00e0 la fonction {0}" }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "Impossible d''obtenir PortletRequest" }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "La fonction PortalLib resetPreferenceValue a \u00e9chou\u00e9 avec la cl\u00e9 {0}. Erreur : {1}" },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "La fonction PortalLib savePreferences a \u00e9chou\u00e9. Erreur : {0}" },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "PortalLib n''a pas pu d\u00e9finir de pr\u00e9f\u00e9rence pour la cl\u00e9 {0}. Erreur : {1}" }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "PortalLib n''a pas pu obtenir de pr\u00e9f\u00e9rence pour la cl\u00e9 {0}. Erreur : {1}" },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "Impossible d''acc\u00e9der au service du coffre d''accr\u00e9ditation. Erreur : {0}" },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "Impossible d''acc\u00e9der \u00e0 l''accr\u00e9ditation demand\u00e9e dans l''emplacement {0}. Erreur : {1}" },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "Impossible de cr\u00e9er un emplacement de coffre d''accr\u00e9ditation dans l''espace utilisateur. Erreur : {0}" },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "Impossible de supprimer un emplacement de coffre d''accr\u00e9ditation dans l''espace utilisateur. Erreur : {0}" },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "Impossible de d\u00e9finir les valeurs de l''accr\u00e9ditation. Erreur : {0}" },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "{0} a \u00e9chou\u00e9. L''invocation d''une m\u00e9thode ou l''acc\u00e8s \u00e0 une zone appel\u00e9e {1} a r\u00e9sult\u00e9 en une erreur non g\u00e9r\u00e9e. Le message d''erreur est {2}" },
		{ Message.JAVALIB_NULL_ID, "{0} a \u00e9chou\u00e9. {1} n''est pas un identificateur, ou alors il s''agit de l''identificateur d''un objet NULL." },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "{0} a \u00e9chou\u00e9. Une m\u00e9thode, une zone ou une classe publiques nomm\u00e9es {1} n''existent pas ou ne peuvent pas \u00eatre charg\u00e9s, ou alors le nombre ou les types des param\u00e8tres sont incorrects. Le message d''erreur est {2}" },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "{0} a \u00e9chou\u00e9. Le type d''une valeur dans EGL ne correspond pas au type attendu dans Java pour {1}. Le message d''erreur est {2}" },
		{ Message.JAVALIB_NULL_RETURNED, "{0} a \u00e9chou\u00e9. La cible est une m\u00e9thode qui renvoie NULL, une m\u00e9thode qui ne renvoie pas de valeur ou de zone dont la valeur est NULL." },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "{0} a \u00e9chou\u00e9. La classe {1} d''un argument NULL n''a pas pu \u00eatre charg\u00e9e. Le message d''erreur est {2}" },
		{ Message.JAVALIB_ACCESS_ERROR, "{0} a \u00e9chou\u00e9. Impossible d''obtenir les informations sur la m\u00e9thode ou la zone nomm\u00e9es {1}, ou il y a eu une tentative de d\u00e9finition de la valeur d''une zone d\u00e9clar\u00e9e ''finale''. Le message d''erreur est {2}" },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "{0} a \u00e9chou\u00e9. {1} est une interface ou une classe abstraite. Aucun constructeur ne peut donc \u00eatre appel\u00e9." },
		{ Message.JAVALIB_NOT_STATIC, "{0} a \u00e9chou\u00e9. La m\u00e9thode ou la zone {1} ne sont pas statiques. Un identificateur doit \u00eatre utilis\u00e9 \u00e0 la place d''un nom de classe." },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "La zone d''action {0} n''existe pas." },
		{ Message.CUI_E_ARRAY_FULL, "Impossible d''ins\u00e9rer une autre ligne car le tableau d''entr\u00e9e est plein." },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "Le tableau {0} ne peut pas \u00eatre trouv\u00e9." },
		{ Message.CUI_E_ASSIGN_RESULT, "L''affectation \u00e0 la variable de r\u00e9sultat de l''invite (prompt) a \u00e9chou\u00e9." },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "La taille {0} n''est pas correcte pour la zone Matricze d''\u00e9cran (Screen Array)."	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "Les param\u00e8tres DrawBox sont hors limites." },
		{ Message.CUI_E_BAD_COORDINATES, "Les coordonn\u00e9es d''affichage se trouvent en dehors des limites de la fen\u00eatre." },
		{ Message.CUI_E_BAD_KEYNAME, "Nom de touche mal form\u00e9, ''{0}''." },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "Vous ne pouvez pas utiliser cette fonction d''\u00e9dition car il existe une image." },
		{ Message.CUI_E_BAD_WINDOW_NAME, "Fen\u00eatre ''{0}'' introuvable." },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "Les valeurs de position[{0},{1}]/dimension[{2},{3}] de la nouvelle fen\u00eatre ne sont pas valides." },
		{ Message.CUI_E_CMDSTACK_SYNC, "La pile de commandes est d\u00e9synchronis\u00e9e." },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "La biblioth\u00e8que de l''interface graphique de la console n''est pas initialis\u00e9e." },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "Type de zone non conforme pour une construction (construct)." },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "ConstructQuery ne peut pas \u00eatre appel\u00e9e avec une liste de variables." },
		{ Message.CUI_E_DISABLE_INVISIBLE, "Impossible de d\u00e9sactiver une option de menu invisible." },
		{ Message.CUI_E_EDIT_FAILED, "L''action d''\u00e9dition a \u00e9chou\u00e9." },
		{ Message.CUI_E_EXEC_HOTKEY, "Erreur lors de l''ex\u00e9cution d''une action hotkey." },
		{ Message.CUI_E_EXIT_NO_CMD, "Il n''y a pas de commande active \u00e0 quitter." },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "Il n''y a pas de commande active \u00e0 continuer." },
		{ Message.CUI_E_FATALERROR, "Erreur bloquante : {0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "La zone {0} n''existe pas." },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "La zone Tableau d''\u00e9cran (Screen Array) {0} n''est pas un tableau." },
		{ Message.CUI_E_FIELD_NOT_FOUND, "La zone {0} est introuvable." },
		{ Message.CUI_E_FIELD_NO_WINDOW, "Impossible de cr\u00e9er un ConsoleField sans une fen\u00eatre." },
		{ Message.CUI_E_FIELD_COUNT, "Non-concordance du nombre de zones tableau." },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "Le formulaire {0} n''existe pas." },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "Le formulaire {0} ne tient pas dans la fen\u00eatre {1}." },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "Les listes de zones ne concordent pas." },
		{ Message.CUI_E_FORM_IN_USE, "Le formulaire {0} est occup\u00e9." },
		{ Message.CUI_E_FORM_NAME_USED, "Un formulaire portant le nom {0} existe d\u00e9j\u00e0." },
		{ Message.CUI_E_FORM_NOT_OPEN, "Le formulaire {0} n''est pas ouvert." },
		{ Message.CUI_E_FORM_NO_WINDOW, "Le ConsoleForm ne peut pas \u00eatre cr\u00e9\u00e9 sans une fen\u00eatre." },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "Impossible d''utiliser KeyObject.getChar() pour les touches virtuelles." },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "Impossible d''utiliser KeyObject.getCookedChar() pour les touches virtuelles." },
		{ Message.CUI_E_INTERNAL, "ERREUR INTERNE : {0}" },
		{ Message.CUI_E_INTR_RECEIVED, "R\u00e9ception d''un signal INTERRUPT." },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "Une option de menu invisible doit obligatoirement comporter une touche de raccourci." },
		{ Message.CUI_E_LABEL_NO_WINDOW, "Un ConsoleLabel ne peut pas \u00eatre cr\u00e9\u00e9 sans une fen\u00eatre." },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "L''option de menu {0} ne tient pas dans la fen\u00eatre." },
		{ Message.CUI_E_MISSING_ITEM, "L''option de menu {0} n''existe pas." },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "Conflit entre les mn\u00e9moniques du menu (touche={0})." },
		{ Message.CUI_E_NO_ACTIVE_FORM, "Aucun formulaire n''est actif." },
		{ Message.CUI_E_NO_EDITOR, "Aucun \u00e9diteur d''objet blob n''a \u00e9t\u00e9 sp\u00e9cifi\u00e9." },
		{ Message.CUI_E_NO_HELP_FILE, "Un fichier d''aide n''a pas \u00e9t\u00e9 sp\u00e9cifi\u00e9." },
		{ Message.CUI_E_NO_HELP_MSG, "Un message d''aide n''a pas \u00e9t\u00e9 sp\u00e9cifi\u00e9." },
		{ Message.CUI_E_NO_NUMPAGES, "L''agencement du menu n''est pas d\u00e9fini." },
		{ Message.CUI_E_NO_SCREENARRAY, "Aucun tableau d''\u00e9cran n''est actif." },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "Il n''y a pas d''option de menu visible." },
		{ Message.CUI_E_NULL_WNDOW_NAME, "Le nom de la nouvelle fen\u00eatre \u00e9tait null." },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "Tentative d''ouverture d''une fen\u00eatre null." },
		{ Message.CUI_E_PROMPT_EXCEPTION, "Une exception est survenue dans l''invite." },
		{ Message.CUI_E_QUIT_RECEIVED, "R\u00e9ception d''un signal QUIT." },
		{ Message.CUI_E_SCROLL_FAILED, "Impossible de faire d\u00e9filer le menu jusqu''\u00e0 l''option en cours." },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "Attribut ''{0}'' inconnu" },
		{ Message.CUI_E_VALIDATE_FIELD, "Il y a une erreur dans la zone {0}." },
		{ Message.CUI_E_VAR_LIST_SHORT, "Le nombre de variables fournies est insuffisant." },
		{ Message.CUI_E_WINDOW_NAME_USED, "Le nom de fen\u00eatre {0} est d\u00e9j\u00e0 utilis\u00e9." },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "La taille de la fen\u00eatre est trop petite pour l''\u00e9cran d''aide." },
		{ Message.CUI_E_VALID_VALUES, "La valeur sp\u00e9cifi\u00e9e n''est pas valide." },
		{ Message.CUI_W_NO_MORE_FIELDS, "Il n''y a plus de zone dans la direction ou vous allez." },
		{ Message.CUI_W_NO_MORE_ROWS, "Il n''y a plus de ligne dans la direction ou vous allez." },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "Le contenu du tableau d''\u00e9cran {0} n''est pas valide." },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "Le tableau d''\u00e9cran {0} ne peut pas contenir la zone segment\u00e9e {1}."	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "Le tableau d''\u00e9cran {0} n''est pas compatible avec le tableau de donn\u00e9es." },
		{ Message.CUI_E_FIELD_NAME_DUP, "Le nom de zone {0} est utilis\u00e9 plusieurs fois." },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "La longueur de la zone de console {0} n''est pas valide." },
		{ Message.CUI_E_LABEL_NOT_FIT, "Le libell\u00e9 situ\u00e9 \u00e0 [{0}, {1}] ne tient pas dans l''espace disponible." },
		{ Message.CUI_E_FIELD_NOT_FIT, "Le segment de zone {0} \u00e0 ({1}, {2}) ne tient pas dans l''espace disponible." },
		{ Message.CUI_E_PROMPT_TOO_LONG,"La cha\u00eene du message d''invite est trop longue pour la fen\u00eatre active."},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"Les arguments de tableau de l''instruction OpenUI ne sont pas valides."},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, "Les arguments de zone de l''instruction OpenUI ne sont pas valides."},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "Une seule variable peut \u00eatre li\u00e9e \u00e0 une instruction d''invite (prompt)." },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "Impossible de d\u00e9terminer la liaison de donn\u00e9es pour la zone de console {0}." },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "Avertissement : Caract\u00e8res NULL d\u00e9tect\u00e9s dans les donn\u00e9es clob" },
		{ Message.CUI_I_STR_WINDOWTITLE , "Fen\u00eatre de la console EGL" },
		{ Message.CUI_E_MISSING_FORMAT , "La zone {0} ne comporte pas d''objet de format." },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "Les deux entr\u00e9es ne sont pas identiques -- renouvelez l''op\u00e9ration" },
		{ Message.CUI_I_STR_VERIFY_INPUT, "Retapez votre entr\u00e9e pour v\u00e9rification" },
		{ Message.CUI_I_STR_HELP,"Aide"},
		{ Message.CUI_I_STR_RESUME,"Reprendre"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"Termine cette session d''aide."},
		{ Message.CUI_I_STR_SCROLL , "D\u00e9filement" },
		{ Message.CUI_I_STR_LAST_PAGE, "Vous avez atteint la fin du texte d''aide. Appuyez sur Entr\u00e9e pour continuer."},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "Affiche la page suivante du texte d''aide."},
		{ Message.CUI_I_STR_SELECT , "SELECTIONNER"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "Erreur lors de l''insertion de la premi\u00e8re ligne dans un tableau vide."},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "F25-F64 non impl\u00e9ment\u00e9es."},
		{ Message.CUI_E_UNIMP_FN_KEYS , "INTERNE : F25-64 non impl\u00e9ment\u00e9e" },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "Impossible d''avoir plusieurs instances de CursesCanvas" },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "CursesCanvas non initialis\u00e9" },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "CursesCanvas est trop petit"},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "Affichage des zones par nom non impl\u00e9ment\u00e9."},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "Valeur d''entr\u00e9e minimale {0} requise. Recommencez la saisie." },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "Valeur d''entr\u00e9e maximale {0} d\u00e9pass\u00e9e. Recommencez la saisie." },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "Impossible d''ouvrir le fichier de script ''{0}''." },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "Impossible de lire le fichier script."},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "La propri\u00e9t\u00e9 d''automation.scenario ''{0}'' n''est pas un r\u00e9pertoire."},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "Directive <click> mal form\u00e9e dans le script de r\u00e9ex\u00e9cution."},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "Impossible d''extraire la propri\u00e9t\u00e9 d''automatisation ''{0}''."},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "Nom de touche panique non valide : ''{0}''"},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "Exception dans <click>."},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "Impossible d''ouvrir le fichier d''images instantan\u00e9es ''{0}''"},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "La propri\u00e9t\u00e9 d\u00e9finie pour automation.scriptdir ''{0}'' n''existe pas."},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "La propri\u00e9t\u00e9 d\u00e9finie pour le r\u00e9pertoire ''{0}'' d''automation.scenario ne peut pas \u00eatre cr\u00e9\u00e9e."},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "Nom de touche de prise d''image instantan\u00e9e (snapshot) non valide : ''{0}''"},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "Comparaison OK."},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "L''utilisation des op\u00e9rations d''entr\u00e9e-sortie d''\u00e9cran n''est pas autoris\u00e9e pendant l''ex\u00e9cution en mode RCP."},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "Il n''existe pas de message avec l''ID {0} dans la table de messages {1}." },
		{ Message.MSG_TBL_LOAD_ERR, "Le fichier de table de messages {0} ne peut pas \u00eatre charg\u00e9." },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "Aucune table de messages utilisateur n''est d\u00e9finie pour le VGUIRecord {0}." },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "La zone ''{0}'' \u00e0 la position ({1},{2}) est en dehors du formulaire." },
		{ Message.TUI_E_FIELD_OVERLAP, "La zone ''{0}'' recouvre ''{1}''." },
		{ Message.TUI_E_NO_FORMGROUP, "Erreur interne : Impossible de d\u00e9terminer le groupe de formulaires." },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "Le formulaire ''{0}'' ne tient dans aucune zone flottante." },
		{ Message.TUI_E_BAD_FIELD_COORDS, "Les coordonn\u00e9es de la zone ''{0}'' ne sont pas valides." },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "Impossible d''obtenir une association d''imprimante." },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "Il n''existe aucune taille de p\u00e9riph\u00e9rique d''impression appropri\u00e9e." },
		{ Message.TUI_E_NO_DISPLAY, "Il n''existe aucun p\u00e9riph\u00e9rique d''affichage pour les formulaires." },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "Il n''existe aucune taille de p\u00e9riph\u00e9rique compatible pour les formulaires affich\u00e9s." },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "La classe de formulaire d''aide ''{0}'' n''existe pas." },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "Attribut ''{0}'' inconnu." },
		{ Message.TUI_E_INVALID_VALID_VALUE, "La valeur sp\u00e9cifi\u00e9e dans l''attribut des valeurs valides est incorrecte et n''a pas pu \u00eatre interpr\u00e9t\u00e9e." },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "Impossible de cr\u00e9er le formulaire d''aide ''{0}''" },
		{ Message.TUI_E_INTERNAL, "ERREUR INTERNE : {0}" },
		{ Message.TUI_E_NO_PRINTERS, "Aucune imprimante n''est disponible." },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "Il n''y a pas d''imprimante par d\u00e9faut." },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "L''imprimante ''{0}'' n''a pas \u00e9t\u00e9 trouv\u00e9e.\nLes imprimantes suivantes sont disponibles :\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "Erreur au chargement du message ''{0}''" },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "Le contenu de {0} ne peut pas \u00eatre utilis\u00e9 comme zone." },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "Imprimante ''{0}'' introuvable" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "Le programme {0} attendait le formulaire texte {1}, mais il a re\u00e7u le formulaire texte {2} dans une instruction show." },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "Suivant" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "Page {0} sur {1}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "Pr\u00e9c\u00e9dent" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "Imprimer" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "Aper\u00e7u avant impression - {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "Sauvegarder" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "Sauvegarde du travail d''impression - {0} " },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "Erreur lors de l''enregistrement dans le fichier : {0}" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "Erreur lors de l''impression sur l''imprimante : {0}" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "D\u00e9finition de : EZEMNO" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "Validation de la zone ''{0}''" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "Validation de formulaire texte" },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "Validation de formulaire texte - ex\u00e9cution de la fonction de validation ''{0}''" },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "Impossible de cr\u00e9er le programme de journalisation." },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "Le param\u00e8tre de journalisation ''{0}'' ne peut pas \u00eatre d\u00e9fini apr\u00e8s le d\u00e9marrage." },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "Le r\u00e9pertoire du journal ''{0}'' n''existe pas." },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "Impossible d''\u00e9crire dans le r\u00e9pertoire du journal ''{0}''." },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "Impossible de cr\u00e9er le fichier journal ''{0}''." },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "Impossible d''\u00e9crire dans le fichier journal ''{0}''." },
		
		{ Message.SOA_E_LOAD_SERVICE, "Probl\u00e8me de chargement du service pour le composant/service externe {0}." },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "Erreur lors de la cr\u00e9ation d''une connexion \u00e0 l''op\u00e9ration de service web ''{0}''.  {1}." },
		{ Message.SOA_E_WS_GET_OPERATION, "Erreur lors de l''obtention de l''op\u00e9ration :''{0}'' \u00e0 partir du fichier WSDL :''{1}''." },
		{ Message.SOA_E_WS_MALFORMED_URL, "L''URL cible de l''op\u00e9ration de service web {1} n''est pas valide. URL : {0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "Erreur rencontr\u00e9e au chargement du service {0}. Erreur : {1}." },
		{ Message.SOA_E_LOAD_WEB_PROXY, "Erreur lors d''une tentative de chargement d''un service web. Le port WSDL du service externe {0} n''a pas pu \u00eatre r\u00e9solu." },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "La propri\u00e9t\u00e9 {1} est absente du composant {0}. Or, elle est indispensable \u00e0 l''impl\u00e9mentation du service." },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "La r\u00e9f\u00e9rence de service ''{0}'' est manquante ou n''a pas de valeur cible." },
		{ Message.SOA_E_MISSING_BINDING, "La liaison de service ''{0}'' n''existe pas dans le descripteur de d\u00e9ploiement ''{1}''" },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "Erreur lors d''une tentative de conversion de l''enregistrement ''{0}'' en un message SOAP.  La zone ''{1}'' n''a pas \u00e9t\u00e9 trouv\u00e9e dans l''enregistrement." },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "Erreur lors d''une tentative de conversion de ''{0}'' en un message SOAP."},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "Erreur lors du traitement d''un message entrant en provenance d''un service web. Le type Java est incompatible avec le type EGL." },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "Erreur lors du traitement d''un message sortant \u00e0 destination d''un service web. Le type EGL est incompatible avec le type Java." },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "Impossible d''initialiser l''enregistrement ''{0}''." },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "Impossible de convertir la valeur ''{0}'' en un objet Calendar." },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "Impossible de convertir la valeur ''{0}'' en un bool\u00e9en." },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "Impossible de convertir la valeur ''{0}'' en un Byte." },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "Impossible de convertir la valeur ''{0}'' en un short." },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "Impossible de convertir la valeur ''{0}'' en un URI." },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "Type EGL non admis en tant que param\u00e8tre de service web." },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "Erreur lors d''une tentative de cr\u00e9ation d''un tableau d''enregistrements. {0}." },
		{ Message.SOA_E_METHOD_NOT_FOUND, "M\u00e9thode {0} non trouv\u00e9e dans le service {1}." },
		{ Message.SOA_E_NOT_WEB_SERVICE, "Il ne s''agit pas d''un service web." },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "Erreur lors d''une tentative d''invocation de la fonction : {0} sur le service web : {1}." },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "Erreur lors d''une tentative d''invocation de la fonction : {0} sur le service EGL : {1}." },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "Erreur lors d''une tentative d''invocation de la fonction : {0} sur le service EGL : {1} en utilisant {2}:{3}." },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "Le service n''est pas un service tcpip." },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "Erreur lors d''une tentative d''invocation de la fonction : {0} sur le point d''entr\u00e9e : {1}." },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "Erreur lors de la tentative de chargement du fichier de liaison de service {0}. {1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "Erreur lors d''une tentative d''invocation de la fonction : {0} sur le service CICS : {1}. Code d''erreur : {2}, Message : {3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "Erreur lors d''une tentative d''invocation de la fonction : {0} sur le service iSeries : {1}. Code d''erreur : {2}, Message : {3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "Le service n''est pas un service CICS." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "Une erreur est survenue sur le service distant {0}, date {1}, heure {2}, sur le syst\u00e8me {3}." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "Erreur dans le service distant {0}, syst\u00e8me {1}." },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "Arr\u00eat de l''unit\u00e9 d''ex\u00e9cution suite \u00e0 une erreur d''application sur le syst\u00e8me {0} qui tentait d''appeler le service {1}. Message : {2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "Erreur d''ex\u00e9cution AS400Toolbox : {0}, {1} lors de l''appel du service {2} sur le syst\u00e8me {3}." },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "Liaison de client de service non prise en charge. {0} a \u00e9t\u00e9 g\u00e9n\u00e9r\u00e9 pour webSphere, mais l''appel provient d''un environnement non J2EE. Relancez la g\u00e9n\u00e9ration dans un projet non J2EE." },
		{ Message.SOA_E_USER_ID_NOT_SET, "L''ID utilisateur et le mot de passe distants doivent \u00eatre d\u00e9finis avant l''appel au service web : {0} fonction :{1}." },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "Une exception s''est produite lors de l''appel d''un service." },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "Une exception s''est produite lors de la communication avec le service. URL : {0}" },
		{ Message.SOA_E_WS_PROXY_REST, "Une exception s''est produite lors de l''appel d''un service REST. Liaison :{0}, Op\u00e9ration :{0}" },
		{ Message.SOA_E_WS_PROXY_SOAP, "Une exception s''est produite lors de l''appel d''un service SOAP. Liaison :{0}, Service :{1}, Port :{2}, Emplacement WSDL :{3}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "Une exception s''est produite lors de la conversion \u00e0 partir de JSON. param\u00e8tre :{0}, json :{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "Une exception s''est produite lors de la conversion vers JSON. param\u00e8tre :{0}, valeur :{1}" },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "Aucun service REST-RPC n''a \u00e9t\u00e9 trouv\u00e9. URL : {0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "Aucune r\u00e9ponse n''a \u00e9t\u00e9 re\u00e7ue du service. URL : {0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "La requ\u00eate n''a pas pu \u00eatre convertie en appel de service. La requ\u00eate re\u00e7ue \u00e9tait ''{0}''. " },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "L''appel de service a d\u00e9pass\u00e9 le d\u00e9lai d''attente. exception : Erreur de d\u00e9passement de d\u00e9lai lors de la lecture de la connexion. Adresse URL :{0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "Il ne s''agit pas d''un service REST. " },
		{ Message.SOA_E_REST_SERVICE, "L''appel du service REST a \u00e9chou\u00e9. Liaison : {0}, op\u00e9ration : {1}, m\u00e9thode HTTP : {2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "Une exception est survenue lors de la conversion des donn\u00e9es en param\u00e8tres EGL. Liaison : {0}, donn\u00e9es \u00e0 convertir {1}, exception : {2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "Un service REST a \u00e9t\u00e9 appel\u00e9 sur une r\u00e9f\u00e9rence de service qui n''est pas une r\u00e9f\u00e9rence de service REST. R\u00e9f\u00e9rence de service : {0}, op\u00e9ration {1}, m\u00e9thode HTTP : {2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "Une exception est survenue lors de la conversion \u00e0 partir de XML. L''\u00e9l\u00e9ment requis {0} manque. " },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "Une exception est survenue lors de la conversion \u00e0 partir de XML. Param\u00e8tre : {0}, xml : {1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "Une exception est survenue lors de la conversion vers XML. Param\u00e8tre : {0}, valeur : {1}" },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "Une exception d''analyse syntaxique XML est survenue lors de la conversion de {0} \u00e0 partir de XML. " },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "Une exception de conversion XML est survenue lors de la conversion de {0} en XML." },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "L''adresse URL ''{0}'' utilis\u00e9e pour appeler le service n''est pas valide. Elle ne comporte pas le protocole http:// " },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "L''adresse URL ''{0}'' utilis\u00e9e pour appeler le service n''est pas valide. {1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "L''adresse URL utilis\u00e9e pour appeler le service n''est pas indiqu\u00e9e. Sp\u00e9cifiez une adresse URL d\u00e9signant le service. " },
			
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "Impossible de remplir le rapport en utilisant la connexion {0}"},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "Impossible de remplir le rapport en utilisant l''instruction SQL {0}"},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "Impossible de remplir le rapport en utilisant le tableau dynamique {0}"},
		{ Message.REPORT_E_FILL_ERROR , "Impossible de remplir le rapport {0}"},
		{ Message.REPORT_E_EXPORT_ERROR, "Impossible d''exporter le rapport {0}" },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "Conversion impossible entre les types EGL {0} et Java {1}" },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "Conversion impossible entre les types Java {0} et EGL {1}" },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "Impossible d''ajouter un param\u00e8tre de rapport" },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "Impossible de red\u00e9finir la liste de param\u00e8tres du rapport" },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "Nom de zone incorrect : {0}" },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "Nom de sous-rapport incorrect : {0}" },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "Type non pris en charge utilis\u00e9 dans la fonction de g\u00e9n\u00e9ration de rapports" },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "Impossible de passer des types complexes \u00e0 cette fonction" },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "Le nom du fichier de conception doit \u00eatre d\u00e9fini avant l''appel \u00e0 la fonction getParameterDefaultValue()." },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "Impossible d''obtenir la valeur par d\u00e9faut du param\u00e8tre {0}. {1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "Il n''existe pas de param\u00e8tre de rapport nomm\u00e9 {0}." },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "Le nom du fichier de conception doit \u00eatre d\u00e9fini avant l''appel \u00e0 la fonction createReportFromDesign() ou createDocument()." },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, "Le nom du fichier de document doit \u00eatre d\u00e9fini avant l''appel \u00e0 la fonction createReportFromDocument()." },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "Impossible de cr\u00e9er le fichier de document du rapport. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "Impossible de cr\u00e9er le rapport \u00e0 partir du fichier de conception. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "Impossible de cr\u00e9er le rapport \u00e0 partir du fichier de document. {0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "L''objet gestionnaire sp\u00e9cifi\u00e9 pour un rapport BIRT (BirtReport) doit \u00eatre du type BirtHandler." },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "L''\u00e9l\u00e9ment {0} n''existe pas dans la conception du rapport, ou alors il n''est pas du type sp\u00e9cifi\u00e9." },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "La ligne {0} num\u00e9ro {1} n''existe pas dans la table {2}." },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "La ligne num\u00e9ro {0} n''existe pas dans l''\u00e9l\u00e9ment de grille {1}." },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "Le groupe {0} n''existe pas dans la table {1}." },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "La ligne {0} num\u00e9ro {1} n''existe pas dans le groupe {2}, dans la table {3}." },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "La colonne num\u00e9ro {0} n''existe pas dans une ligne {1}, dans la table {2}." },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "La colonne num\u00e9ro {0} n''existe pas dans la grille {1}." },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "La colonne num\u00e9ro {0} n''existe pas dans la ligne {1} du groupe {2}, dans la table {3}." },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "La propri\u00e9t\u00e9 ''RowType'' doit \u00eatre sp\u00e9cifi\u00e9e doit \u00eatre sp\u00e9cifi\u00e9e pour la fonction gestionnaire d''\u00e9v\u00e9nements des lignes ou des colonnes de la table {0}." },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "Le type Java {0} n''a pas pu \u00eatre converti en un type EGL." },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "Le type EGL {0} n''a pas pu \u00eatre converti en un type Java." },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "L''ensemble de donn\u00e9es {0} n''existe pas dans la conception du rapport." },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "{0} est un ensemble de donn\u00e9es script\u00e9, mais aucun des types d''\u00e9v\u00e9nement (eventTypes) suivants n''a \u00e9t\u00e9 g\u00e9r\u00e9 : openEvent, fetchEvent, closeEvent." },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "La source de donn\u00e9es {0} n''existe pas dans la conception du rapport." },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "{0} est une source de donn\u00e9es script\u00e9e, mais aucun des types d''\u00e9v\u00e9nement (eventTypes) suivants n''a \u00e9t\u00e9 g\u00e9r\u00e9 : openEvent, closeEvent." },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "La colonne num\u00e9ro {0} n''existe pas dans l''ensemble de donn\u00e9es {1}." },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "Exception lors de l''obtention de la colonne {0} \u00e0 partir de l''ensemble de donn\u00e9es {1}. {2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "Exception lors de la d\u00e9finition de la colonne {0} de l''ensemble de donn\u00e9es script\u00e9 {1}. {2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "Exception lors de l''obtention de la liaison de colonne {0}. {1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "Propri\u00e9t\u00e9 vgj.defaultI4GLNativeLibrary non sp\u00e9cifi\u00e9e" },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "Le chargement de la biblioth\u00e8que {0} a \u00e9chou\u00e9 {1}" },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "Les param\u00e8tres renvoy\u00e9s ne correspondent pas \u00e0 la fonction" },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "Impossible d''allouer de la m\u00e9moire"},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "Conversion impossible entre les types"},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "Pr\u00e9cision non valide pour une valeur Datetime ou Interval"},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "Variable h\u00f4te Character trop courte pour les donn\u00e9es"},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "Fonction non trouv\u00e9e dans la table de symboles"},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "Un type de donn\u00e9es TEXT ou BYTE doit \u00eatre fourni dans ce contexte"},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "La valeur sur la pile n''a pas pu \u00eatre convertie en un type de valeur"},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "La valeur sur la pile n''a pas pu \u00eatre convertie en type ANY"},
		{ Message.CINTERFACE_E_POP_ERROR, "Impossible d''extraire de la pile une valeur du type {0}"},
		{ Message.CINTERFACE_E_PUSH_ERROR, "Impossible d''ins\u00e9rer dans la pile une valeur du type {1}"},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "Rien \u00e0 ins\u00e9rer ni \u00e0 extraire"},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "Impossible d''extraire le localisateur (Locator) de la pile"},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "La pile est vide"},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "Impossible de copier le localisateur (locator)"},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "Une r\u00e9f\u00e9rence null a \u00e9t\u00e9 ins\u00e9r\u00e9e dans la pile."},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "Impossible d''ins\u00e9rer un type Any dans la pile"},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "Impossible d''affecter l''\u00e9l\u00e9ment de pile au type Any"},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "Non-concordance du type de retour"},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "Non-concordance du type de param\u00e8tre"},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "Fichier source EGL {0} introuvable.  Le code g\u00e9n\u00e9r\u00e9 sera ex\u00e9cut\u00e9 \u00e0 la place." },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "Impossible de trouver le fichier source EGL pour la transaction web nomm\u00e9e {0}." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "Le probl\u00e8me de formatage suivant est survenu pour la zone \"{0}\" lors de l''affichage du formulaire \"{1}\" : " },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, "{0}\n\nLe format interne attendu pour la zone est \"{1}\". V\u00e9rifiez les propri\u00e9t\u00e9s de format de date dans les propri\u00e9t\u00e9s d''ex\u00e9cution Java EGL dans le descripteur de g\u00e9n\u00e9ration de d\u00e9bogage ou dans les propri\u00e9t\u00e9s JDBC ayant un impact sur les formats de date. " },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\nLe format d''affichage de la zone est \"{1}\". V\u00e9rifiez la propri\u00e9t\u00e9 \"{2}\" dans la zone de formulaire. " },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "Impossible d''ex\u00e9cuter le programme {0} comme transaction web." },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "La transaction a re\u00e7u l''enregistrement UI d''entr\u00e9e {0}, mais elle a \u00e9t\u00e9 d\u00e9finie avec l''enregistrement UI d''entr\u00e9e {1}." },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "Entr\u00e9e non valide pour une zone bool\u00e9nne." },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "Un d\u00e9passement de d\u00e9lai s''est produit dans le programme {0} pour cause d''inactivit\u00e9." },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "L''enregistrement d''interface utilisateur {0} contient trop de donn\u00e9es pour \u00eatre envoy\u00e9 au servlet passerelle." },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "Le programme n''a pas pu v\u00e9rifier les donn\u00e9es re\u00e7ues du servlet passerelle.  L''identificateur des donn\u00e9es est {0}." },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "L''encapsuleur de tableau {0} ne peut pas \u00eatre \u00e9tendu au-del\u00e0 de sa taille maximale. L''erreur s''est produite dans la m\u00e9thode {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "{0} est un index non valide pour l''encapsuleur de tableau {1}. Taille maximale : {2}. Taille actuelle : {3}" },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "{0} n''est pas une taille maximale valide pour l''encapsuleur de tableau {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "{0} n''est pas un type d''objet valide pour \u00eatre ajout\u00e9 \u00e0 un encapsuleur de tableau du type {1}." },
		
		{ Message.IMS_HOST_ABORT, "Un paquet d''abandon a \u00e9t\u00e9 re\u00e7u de l''h\u00f4te distant. "},
		{ Message.IMS_HOST_TCPIP_ERROR, "Une erreur TCPIP s''est produite sur l''h\u00f4te distant. Section :{0} Op\u00e9ration TCPIP :{1} CODE RET TCPIP  :{2} N\u00b0 ERR TCPIP :{3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "Erreur sur l''h\u00f4te lors de l''appel :{0}"},
		{ Message.IMS_HOST_PACKET_ERROR, "Le mauvais paquet de r\u00e9ponse a \u00e9t\u00e9 re\u00e7u de l''h\u00f4te distant. Attendu :{0} Re\u00e7u :{1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "Erreur d''entr\u00e9e-sortie lors de l''ex\u00e9cution de la proc\u00e9dure m\u00e9moris\u00e9e. {0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "Erreur SQL lors de l''ex\u00e9cution de la proc\u00e9dure m\u00e9moris\u00e9e. {0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "Erreur sur l''h\u00f4te distant ex\u00e9cutant {0} Code retour : {1} ID du travail du proxy DLI : {2}"},
		{ Message.IMS_HOST_DLI_ERROR, "Erreur DLI sur l''h\u00f4te distant. Fonction DLI : {0} Retour AIB : 0x{1} Motif AIB : 0x{2} Code d''\u00e9tat : {3} ID du travail du proxy DLI : {4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "Erreur DLI sur l''h\u00f4te distant. Fonction DLI : {0} Retour AIB : 0x{1} Motif AIB : 0x{2} DLIVar.statusCode : {3} DLIVar.DbName : {4} DLIVar.SegmentName : {5} DLIVar.SegmentLevel : {6} ID du travail du proxy DLI : {7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "Le code retour AIB indique un code de statut PCB, mais aucun PCB n''a \u00e9t\u00e9 renvoy\u00e9. Fonction AIB :{0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "Une exception s''est produite dans CALL EZEDBTCP sur l''h\u00f4te distant. Section :{0} Op\u00e9ration TCPIP :{1} CODE RET TCPIP  :{2} N\u00b0 ERR TCPIP :{3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "Fin anormale (ABEND) sur l''h\u00f4te distant. Routine :{0} Message :{1} "},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "Exception sur l''h\u00f4te distant. APPEL :{0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "Le d\u00e9bogueur ne prend pas en charge la fonction DLI. Fonction :{0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "Un appel DL/I est en cours d''\u00e9mission, mais le descripteur de g\u00e9n\u00e9ration n''est pas configur\u00e9 pour l''acc\u00e8s DL/I."},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "Exception distante : {0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "Une erreur s''est produite lors de l''allocation d''un PSB. L''IMSID est d\u00e9fini, indiquant qu''il existe un acc\u00e8s DL/I, mais pas de PSB sp\u00e9cifi\u00e9"},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "La version du client RBD et la version de l''h\u00f4te ne sont pas compatibles. Version du client RBD : {0} Version de l''h\u00f4te : {1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "Une erreur s''est produite lors de l''extraction des donn\u00e9es retourn\u00e9es par un appel \u00e0 un programme h\u00f4te. {0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "Une erreur est survenue lors de l''extraction du nom du PCB. Index du PCB : {0}, nombre de PCB : {1}"},
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
