/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle_hu extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "A hiba a(z) {0} programban t\u00f6rt\u00e9nt." },
		{ Message.FUNCTION_ERROR_INFO, "A hiba a(z) {0} programban a(z) {1} f\u00fcggv\u00e9ny feldolgoz\u00e1sa k\u00f6zben t\u00f6rt\u00e9nt." },
		{ Message.FILE_ERROR_INFO, "A hiba a(z) {0} programban a(z) {1} f\u00fcggv\u00e9ny {2} sor\u00e1nak feldolgoz\u00e1sa k\u00f6zben t\u00f6rt\u00e9nt." },
		{ Message.PROPERTIES_FILE_MISSING, "A(z) {0} tulajdons\u00e1gf\u00e1jl nem t\u00f6lthet\u0151 be." },
		{ Message.LOAD_LIBRARY_FAILED, "A(z) {0} k\u00f6nyvt\u00e1r nem t\u00f6lthet\u0151 be. A k\u00f6vetkez\u0151 hiba t\u00f6rt\u00e9nt: {1}." },
		{ Message.CREATE_OBJECT_FAILED, "Hiba t\u00f6rt\u00e9nt a(z) {0} t\u00edpus\u00fa objektum l\u00e9trehoz\u00e1sa k\u00f6zben. A k\u00f6vetkez\u0151 hiba t\u00f6rt\u00e9nt: {1}." },
		{ Message.INITIAL_CONTEXT_ERROR, "Hiba t\u00f6rt\u00e9nt az InitialContext l\u00e9trehoz\u00e1sa, vagy a java:comp/env k\u00f6rnyezet kikeres\u00e9se k\u00f6zben. A k\u00f6vetkez\u0151 hiba jelentkezett: {0}." },
		{ Message.LISTENER_ERROR, "A k\u00f6vetkez\u0151 kiv\u00e9tel \u00e9s \u00fczenet t\u00f6rt\u00e9nt. Kiv\u00e9tel: {0}. \u00dczenet: {1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "A(z) {0} tulajdons\u00e1ghoz egy \u00e9rt\u00e9k sz\u00fcks\u00e9ges." },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "Hi\u00e1nyzik egy k\u00fcls\u0151 f\u00fcgg\u0151s\u00e9g. A k\u00f6vetkez\u0151 kiv\u00e9tel t\u00f6rt\u00e9nt. Kiv\u00e9tel: {0}" },
		{ Message.UNSUPPORTED_COMPARE, "A(z) {0} \u00e9s a(z) {1} operandusok nem hasonl\u00edthat\u00f3k \u00f6ssze." },
		{ Message.ASSIGNMENT_OVERFLOW, "T\u00falcsordul\u00e1si hiba t\u00f6rt\u00e9nt a(z) {0} \u00e9rt\u00e9k {1} v\u00e1ltoz\u00f3hoz rendel\u00e9se k\u00f6zben." },
		{ Message.EXPRESSION_OVERFLOW, "T\u00falcsordul\u00e1si hiba t\u00f6rt\u00e9nt a k\u00f6vetkez\u0151 kifejez\u00e9s kisz\u00e1m\u00edt\u00e1sakor: {0}." },
		{ Message.UNSUPPORTED_OPERANDS, "A(z) {0} oper\u00e1tor nem t\u00e1mogatott a(z) {1} \u00e9s {2} operandusokhoz." },
		{ Message.UNSUPPORTED_OPERAND, "A(z) {0} oper\u00e1tor nem t\u00e1mogatott a(z) {2} t\u00edpus\u00fa {1} operandusokhoz." },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "Az als\u00f3 index oper\u00e1tor nem t\u00e1mogatott a(z) {1} t\u00edpus\u00fa {0} operandusokhoz." },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "A r\u00e9sz-karaktersorozat oper\u00e1tor nem t\u00e1mogatott a(z) {1} t\u00edpus\u00fa {0} operandusokhoz." },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "A SET EMPTY oper\u00e1tor nem t\u00e1mogatott a(z) {1} t\u00edpus\u00fa {0} operandusokhoz." },
		{ Message.INVALID_REGULAR_EXPRESSION, "Hiba t\u00f6rt\u00e9nt a(z) {0} regul\u00e1ris kifejez\u00e9sben. Hiba: {1}." },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "CICSSSL protokoll haszn\u00e1latakor a ctgKeyStore \u00e9s a ctgKeyStorePassword param\u00e9tert is meg kell adni." },
		{ Message.INVALID_CTGPORT, "A(z) {0} \u00e9rt\u00e9k a ctgport bejegyz\u00e9shez helytelen." },
		{ Message.CTG_CONNECT_FAILED, "Hiba t\u00f6rt\u00e9nt a CTG csatlakoz\u00e1s k\u00f6zben. A CTG helye: {0}. A CTG portja: {1}. A k\u00f6vetkez\u0151 hiba jelentkezett: {2}." },
		{ Message.CTG_DISCONNECT_FAILED, "Hiba t\u00f6rt\u00e9nt a CTG bont\u00e1sa k\u00f6zben. A CTG helye: {0}. A CTG portja: {1}. A k\u00f6vetkez\u0151 hiba jelentkezett: {2}." },
		{ Message.NO_CICS, "Hiba jelentkezett a(z) {0} program megh\u00edv\u00e1sa k\u00f6zben, ami CICS ECI \u00f6sszetev\u0151t haszn\u00e1l. A visszat\u00e9r\u00e9si k\u00f3d: -3 (ECI_ERR_NO_CICS). A CICS rendszer azonos\u00edt\u00f3: {1}." },
		{ Message.CICS_DIED, "Hiba jelentkezett a(z) {0} program megh\u00edv\u00e1sa k\u00f6zben, ami CICS ECI \u00f6sszetev\u0151t haszn\u00e1l. A visszat\u00e9r\u00e9si k\u00f3d: -4 (ECI_ERR_CICS_DIED). A CICS rendszer azonos\u00edt\u00f3: {1}." },
		{ Message.CICS_TIMEOUT, "Hiba jelentkezett a(z) {0} program megh\u00edv\u00e1sa k\u00f6zben, ami CICS ECI \u00f6sszetev\u0151t haszn\u00e1l. A visszat\u00e9r\u00e9si k\u00f3d: -6 (ECI_ERR_RESPONSE_TIMEOUT). A CICS rendszer azonos\u00edt\u00f3: {1}." },
		{ Message.CICS_TRANSACTION_ABEND, "Hiba jelentkezett a(z) {0} program megh\u00edv\u00e1sa k\u00f6zben, ami CICS ECI \u00f6sszetev\u0151t haszn\u00e1l. A visszat\u00e9r\u00e9si k\u00f3d: -7 (ECI_ERR_TRANSACTION_ABEND). A CICS rendszer azonos\u00edt\u00f3: {1}. Az abend k\u00f3d: {2}." },
		{ Message.CICS_UNKNOWN_SERVER, "Hiba jelentkezett a(z) {0} program megh\u00edv\u00e1sa k\u00f6zben, ami CICS ECI \u00f6sszetev\u0151t haszn\u00e1l. A visszat\u00e9r\u00e9si k\u00f3d: -22 (ECI_ERR_UNKNOWN_SERVER). A CICS rendszer azonos\u00edt\u00f3: {1}." },
		{ Message.CICS_SECURITY_ERROR, "Hiba jelentkezett a(z) {0} program megh\u00edv\u00e1sa k\u00f6zben, ami CICS ECI \u00f6sszetev\u0151t haszn\u00e1l. A visszat\u00e9r\u00e9si k\u00f3d: -27 (ECI_ERR_SECURITY_ERROR). A CICS rendszer azonos\u00edt\u00f3: {1}." },
		{ Message.CICS_MAX_SYSTEMS, "Hiba jelentkezett a(z) {0} program megh\u00edv\u00e1sa k\u00f6zben, ami CICS ECI \u00f6sszetev\u0151t haszn\u00e1l. A visszat\u00e9r\u00e9si k\u00f3d: -28 (ECI_ERR_MAX_SYSTEMS). A CICS rendszer azonos\u00edt\u00f3: {1}." },
		{ Message.CICS_NONZERO_RETURN_CODE, "Hiba jelentkezett a(z) {0} program megh\u00edv\u00e1sa k\u00f6zben az {1} rendszeren a(z) {2} nev\u0171 felhaszn\u00e1l\u00f3 eset\u00e9ben. Egy {3} visszat\u00e9r\u00e9si k\u00f3d \u00e9s {4} abend k\u00f3d ker\u00fclt visszaad\u00e1sra a CICS ECI h\u00edv\u00e1sb\u00f3l." },
		{ Message.CICS_COMMIT_FAILED, "Hiba t\u00f6rt\u00e9nt a CICS ECI h\u00edv\u00e1sa sor\u00e1n egy munkaegys\u00e9g v\u00e9gleges\u00edt\u00e9s\u00e9re. A CICS visszat\u00e9r\u00e9si k\u00f3d: {0}." },
		{ Message.CICS_ROLLBACK_FAILED, "Hiba t\u00f6rt\u00e9nt a CICS ECI h\u00edv\u00e1sa sor\u00e1n egy munkaegys\u00e9g visszag\u00f6rget\u00e9s\u00e9re. A CICS visszat\u00e9r\u00e9si k\u00f3d: {0}." },
		{ Message.CICS_ECI_FLOW_FAILED, "Kiv\u00e9tel t\u00f6rt\u00e9nt a(z) {0} CICS rendszerhez int\u00e9zett ECI k\u00e9r\u00e9s sor\u00e1n. Kiv\u00e9tel: {1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "Hib\u00e1s param\u00e9terhossz. Az adatfolyam {0} param\u00e9terrel, a helyi f\u00fcggv\u00e9ny pedig {1} param\u00e9terrel rendelkezik." },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "A(z) {0} t\u00f6mb t\u00fall\u00e9pte a maxim\u00e1lis m\u00e9retet." },
		{ Message.WRONG_NUMBER_OF_PARMS, "A megh\u00edvott {0} program {1} param\u00e9tert v\u00e1rt, de {2} param\u00e9tert kapott." },
		{ Message.FUNCTION_NOT_FOUND, "Hiba a(z) {0} bel\u00e9p\u00e9si pont c\u00edm\u00e9nek lek\u00e9rdez\u00e9se sor\u00e1n a(z) {1} megosztott f\u00fcggv\u00e9nyt\u00e1ron bel\u00fcl. A visszat\u00e9r\u00e9si k\u00f3d: {2}." },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "Hiba t\u00f6rt\u00e9nt a(z) {0} megosztott k\u00f6nyvt\u00e1r bet\u00f6lt\u00e9se k\u00f6zben. A visszat\u00e9r\u00e9si k\u00f3d: {1}." },
		{ Message.CALL_NONZERO_RETURN_CODE, "A megh\u00edvott program {0} visszat\u00e9r\u00e9si k\u00f3ddal meghi\u00fasult." },
		{ Message.REMOTE_PROGRAM_ERROR, "Hiba t\u00f6rt\u00e9nt a(z) {0} t\u00e1voli programban a(z) {3} rendszeren. Hiba t\u00f6rt\u00e9nt a(z) {1} elemen {2} helyen. {4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "Hiba t\u00f6rt\u00e9nt a(z) {0} t\u00e1voli programban a(z) {1} rendszeren. {2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "A(z) {0} hosztn\u00e9v egy ismeretlen TCP/IP hosztn\u00e9v." },
		{ Message.SERVERID_IS_INVALID_PORT, "A(z) {0} ServerID \u00e9rv\u00e9nytelen portsz\u00e1m." },
		{ Message.TCPIP_SERVER_ERROR, "Az \u00fcgyf\u00e9l \u00e9rtes\u00edt\u00e9st kapott arr\u00f3l, hogy a kiszolg\u00e1l\u00f3 nem tudja elind\u00edtani a t\u00e1voli megh\u00edvott programot. Okk\u00f3d: {0}." },
		{ Message.INVALID_REMOTECOMTYPE, "A remoteComType \u00e9rt\u00e9k hi\u00e1nyzik, vagy helytelen." },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "A(z) {0} \u00f6sszek\u00f6ttet\u00e9si tulajdons\u00e1gf\u00e1jl nem nyithat\u00f3 meg." },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "A h\u00edvott program ({0}) egy bejegyz\u00e9se nem tal\u00e1lhat\u00f3 az \u00f6sszeszerkeszt\u00e9si tulajdons\u00e1gf\u00e1jlban ({1})." },
		{ Message.AS400_UNKNOWN_HOST, "A(z) {0} hoszt nem tal\u00e1lhat\u00f3, vagy nem ismert." },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "A jelsz\u00f3, vagy felhaszn\u00e1l\u00f3i azonos\u00edt\u00f3 helytelen a(z) {0} rendszerhez csatlakoz\u00e1shoz. Hiba: {1}" },
		{ Message.AS400_EXCEPTION_CAUGHT, "Egy {0} AS400Toolbox v\u00e9grehajt\u00e1si hiba t\u00f6rt\u00e9nt a(z) {2} program h\u00edv\u00e1sakor a(z) {3} rendszeren. Hiba: {1}" },
		{ Message.AS400_NO_AUTHORITY, "Egy t\u00e1voli hozz\u00e1f\u00e9r\u00e9si biztons\u00e1gi hiba t\u00f6rt\u00e9nt a(z) {0} rendszeren {1} felhaszn\u00e1l\u00f3n\u00e1l. Hiba: {2}" },
		{ Message.REMOTE_COMMIT_FAILED, "Nem siker\u00fclt egy v\u00e9gleges\u00edt\u00e9si funkci\u00f3 a(z) {0} rendszeren. Hiba: {1}" },
		{ Message.REMOTE_ROLLBACK_FAILED, "A visszag\u00f6rget\u00e9si funkci\u00f3 nem siker\u00fclt a(z) {0} rendszeren. Hiba: {1}" },
		{ Message.AS400_CONNECTION_ERROR, "Egy t\u00e1voli csatlakoz\u00e1si hiba t\u00f6rt\u00e9nt a(z) {0} rendszer el\u00e9r\u00e9se k\u00f6zben. Hiba: {1}" },
		{ Message.AS400_SERVER_NOT_FOUND, "Egy EGL OS/400 hosztszolg\u00e1ltat\u00e1si hiba t\u00f6rt\u00e9nt. A sz\u00fcks\u00e9ges f\u00e1jlok nem tal\u00e1lhat\u00f3k a(z) {0} rendszeren." },
		{ Message.AS400_APPLICATION_ERROR, "A fut\u00e1si egys\u00e9g le\u00e1llt, mivel egy alkalmaz\u00e1si hiba t\u00f6rt\u00e9nt a(z) {0} rendszeren a(z) {1} program megh\u00edv\u00e1sa k\u00f6zben. \u00dczenet: {2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "A hivatkoz\u00e1s v\u00e1ltoz\u00f3 neve {0} \u00fcres." },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "Egy kezeletlen hiba t\u00f6rt\u00e9nt. Hiba: {0}." },
		{ Message.DATA_FORMAT_ERROR, "A(z) {0} v\u00e1ltoz\u00f3 \u00e9rt\u00e9ke nincs megfelel\u0151 form\u00e1tumban." },
		{ Message.CONVERSION_ERROR, "A(z) {1} t\u00edpus\u00fa {0} \u00e9rt\u00e9k nem alak\u00edthat\u00f3 \u00e1t {2} t\u00edpusba." },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "A(z) {0} d\u00e1tumform\u00e1tum minta \u00e9rv\u00e9nytelen." },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "A(z) {0} id\u0151form\u00e1tum minta \u00e9rv\u00e9nytelen." },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "A(z) {0} id\u0151b\u00e9lyeg form\u00e1tum minta \u00e9rv\u00e9nytelen." },
		{ Message.NULL_REFERENCE, "Null hivatkoz\u00e1s haszn\u00e1lat\u00e1ra ker\u00fclt sor." },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "A dinamikus hozz\u00e1f\u00e9r\u00e9s nem t\u00e1mogatott a k\u00f6vetkez\u0151 helyen: {0}." },
		{ Message.DYNAMIC_ACCESS_FAILED, "Nem tal\u00e1lhat\u00f3 {0} azonos\u00edt\u00f3val mez\u0151 a(z) {1} objektumban." },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "A(z) {0} numerikus form\u00e1tum minta \u00e9rv\u00e9nytelen." },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "Hiba t\u00f6rt\u00e9nt a(z) {0} hozz\u00e1rendel\u00e9se k\u00f6zben {1} objektumhoz. Hiba: {2}." },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "Hiba a SET {0} EMPTY utas\u00edt\u00e1sban. Hiba: {1}." },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "Egy {0} hiba t\u00f6rt\u00e9nt a met\u00f3dus megh\u00edv\u00e1sa k\u00f6zben a(z) {1} al\u00e1\u00edr\u00e1ssal." },
		{ Message.RUN_COMMAND_FAILED, "Hiba t\u00f6rt\u00e9nt a(z) {0} parancs futtat\u00e1sa k\u00f6zben.  Hiba: {1}." },
		{ Message.MDY_ERROR, "A DateTimeLib.mdy funkci\u00f3 nem k\u00e9pes a(z) {0}, {1}, \u00e9s {2} \u00e9rt\u00e9kek \u00e1talak\u00edt\u00e1s\u00e1ra h\u00f3nap, nap, \u00e9v \u00e9rt\u00e9kekre." },
		{ Message.NON_NUMERIC_STRING, "{0} a(z) {1} nem numerikus karakterl\u00e1nc sz\u00e1m\u00e1ra lett \u00e1tadva. A karaktersorozat length argumentum \u00e1ltal megadott r\u00e9sz\u00e9nek minden karaktere csak numerikus lehet." },
		{ Message.SYSTEM_FUNCTION_ERROR, "{0} meghi\u00fasult a k\u00f6vetkez\u0151 hiba\u00fczenettel: {1}." },
		{ Message.INT_AS_CHAR_ERROR, "A StrLib.intAsChar argumentum\u00e1nak 0 \u00e9s 255 k\u00f6z\u00f6tti sz\u00e1mnak kell lennie." },
		{ Message.INVALID_LOB_LENGTH, "A(z) {0} nem \u00e9rv\u00e9nyes hossz a k\u00f6vetkez\u0151h\u00f6z: {1}, amely m\u00e9rete {2}." },
		{ Message.INVALID_LOB_POSITION, "A(z) {0} nem \u00e9rv\u00e9nyes poz\u00edci\u00f3 a k\u00f6vetkez\u0151h\u00f6z: {1}. Ennek a m\u00e9rete: {2}." },
		{ Message.LOB_ERROR, "Hiba t\u00f6rt\u00e9nt egy Blob vagy Clob elem feldolgoz\u00e1sa sor\u00e1n.  A hiba\u00fczenet: {0}" },
		{ Message.START_TRANSACTION_ERROR, "A VGLib.startTransaction a(z) {0} oszt\u00e1lyn\u00e1l meghi\u00fasult. A kiv\u00e9tel: {1}" },
		{ Message.INT_AS_UNICODE_ERROR, "A StrLib.intAsUnicode argumentum\u00e1nak 0 \u00e9s 65535 k\u00f6z\u00f6tti sz\u00e1mnak kell lennie." },
		{ Message.INVALID_ARRAY_SIZE, "A(z) {0} m\u00e9ret \u00e9rt\u00e9k nem \u00e9rv\u00e9nyes a(z) {1} t\u00f6mbh\u00f6z. A maxim\u00e1lis m\u00e9ret {2}." },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "A(z) {0} index k\u00edv\u00fcl esik a hat\u00e1ron {1} t\u00f6mb eset\u00e9ben. A t\u00f6mb m\u00e9rete {2}." },
		{ Message.INVALID_SUBSTRING_INDEX, "\u00c9rv\u00e9nytelen r\u00e9sz-karaktersorozat indexek {0}:{1}." },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "A {0} t\u00f6mb f\u00fcggv\u00e9ny\u00e9nek argumentuma \u00e9rv\u00e9nytelen." },
		{ Message.INDEX_OUT_OF_BOUNDS, "A(z) {0} index\u00e9rt\u00e9k k\u00edv\u00fcl esik a hat\u00e1rokon." },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "{0} nem t\u00e1mogatott \u00e1talak\u00edt\u00e1si t\u00e1bla." },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "A csouidpwd.properties f\u00e1jl nem olvashat\u00f3. Hiba: {0}" },
		{ Message.CALL_PARMS_TOO_LARGE, "Az \u00fcgyf\u00e9l puffere t\u00fal kicsi a h\u00edv\u00e1s sor\u00e1n \u00e1tadott adatok sz\u00e1m\u00e1ra. Az \u00e1tad\u00e1sra ker\u00fcl\u0151 param\u00e9terek \u00f6sszes\u00edtett m\u00e9rete {0}, ami meghaladja a megengedett maxim\u00e1lis \u00e9rt\u00e9ket ({1})." },
		{ Message.INVALID_PARMFORM, "A parmForm \u00f6sszeszerkeszt\u00e9si tulajdons\u00e1gnak COMMPTR \u00e9rt\u00e9kkel kell rendelkeznie {0} program megh\u00edv\u00e1s\u00e1hoz, mivel legal\u00e1bb egy param\u00e9ter dinamikus t\u00f6mb." },
		{ Message.PARM_PASSING_ERROR, "Hiba t\u00f6rt\u00e9nt a param\u00e9terek \u00e1tad\u00e1sa sor\u00e1n a(z) {0} megh\u00edvott program sz\u00e1m\u00e1ra. Hiba: {1}" },
		{ Message.CALL_ERROR, "Hiba t\u00f6rt\u00e9nt a(z) {0} program h\u00edv\u00e1sakor. Hiba: {1}" },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "{0} nem t\u00e1mogatott param\u00e9ter t\u00edpus a System i szolg\u00e1ltat\u00e1s programokhoz." },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "{0} nem t\u00e1mogatott visszt\u00e9r\u00e9si t\u00edpus a System i szolg\u00e1ltat\u00e1s programokhoz." },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "A ConnectionFactory lek\u00e9r\u00e9se sikertelen. A kiv\u00e9tel: {0}" },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "Az egy\u00fcttm\u0171k\u00f6d\u00e9s vagy kapcsolat nem z\u00e1rhat\u00f3 be. Hiba: {0}" },
		{ Message.ERROR_GETTING_CONNECTION, "Nem lehet kapcsolatot l\u00e9trehozni. Hiba: {0}" },
		{ Message.ERROR_GETTING_INTERACTION, "Nem lehet egy interakci\u00f3t beolvasni. A kiv\u00e9tel: {0}" },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "Nem lehet be\u00e1ll\u00edtani egy interakci\u00f3s parancssz\u00f3t. A kiv\u00e9tel: {0}" },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "Nem kaphat\u00f3 meg a LocalTransaction az \u00fcgyf\u00e9l munkaegys\u00e9g sz\u00e1m\u00e1ra. A kiv\u00e9tel: {0}" },
		{ Message.ERROR_SETTING_TIMEOUT, "Nem \u00e1ll\u00edthat\u00f3 be az id\u0151korl\u00e1t \u00e9rt\u00e9k egy CICSJ2C h\u00edv\u00e1shoz. A kiv\u00e9tel: {0}" },
		{ Message.EXCEPTION_CALLING_CICS, "Hiba t\u00f6rt\u00e9nt a CICS kommunik\u00e1ci\u00f3s k\u00eds\u00e9rlete sor\u00e1n. A kiv\u00e9tel: {0}" },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "A t\u00e1voli CICS tranzakci\u00f3 v\u00e9grehajt\u00e1s\u00e1ra tett k\u00eds\u00e9rlet sikertelen." },
		{ Message.EXCEPTION_CALLING_IMS, "Hiba t\u00f6rt\u00e9nt az IMS kommunik\u00e1ci\u00f3s k\u00eds\u00e9rlete sor\u00e1n. A kiv\u00e9tel: {0}" },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "Hiba t\u00f6rt\u00e9nt az IMS kommunik\u00e1ci\u00f3s k\u00eds\u00e9rlete sor\u00e1n." },
		{ Message.MATH_DOMAIN_ERROR, "A(z) {0} 8-as hibak\u00f3ddal meghi\u00fasult (tartom\u00e1nyhiba). A f\u00fcggv\u00e9ny egyik argumentuma \u00e9rv\u00e9nytelen." },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "A(z) {0} 8-as hibak\u00f3ddal meghi\u00fasult (tartom\u00e1nyhiba). Az argumentumnak -1 \u00e9s 1 k\u00f6z\u00e9 kell esni." },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "A(z) {0} 8-as hibak\u00f3ddal meghi\u00fasult (tartom\u00e1nyhiba). A m\u00e1sodik argumentum nem lehet nulla." },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "A(z) {0} 8-as hibak\u00f3ddal meghi\u00fasult (tartom\u00e1nyhiba). Az argumentum csak null\u00e1n\u00e1l nagyobb lehet." },
		{ Message.MATH_POW_1_DOMAIN_ERR, "A MathLib.pow 8-as hibak\u00f3ddal meghi\u00fasult (tartom\u00e1nyhiba). Ha az els\u0151 argumentum nulla, akkor a m\u00e1sodik csak null\u00e1n\u00e1l nagyobb lehet." },
		{ Message.MATH_POW_2_DOMAIN_ERR, "A MathLib.pow 8-as hibak\u00f3ddal meghi\u00fasult (tartom\u00e1nyhiba). Ha az els\u0151 argumentum kisebb, mint nulla, akkor a m\u00e1sodik eg\u00e9sz lehet." },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "A MathLib.sqrt 8-as hibak\u00f3ddal meghi\u00fasult (tartom\u00e1nyhiba). Az argumentumnak legal\u00e1bb null\u00e1nak kell lenni." },
		{ Message.MATH_RANGE_ERROR, "A(z) {0} 12-es hibak\u00f3ddal meghi\u00fasult (\u00e9rt\u00e9ktartom\u00e1ny hiba)." },		
		{ Message.STRING_INDEX_ERROR, "A(z) {0} 8-as hibak\u00f3ddal meghi\u00fasult. Az indexnek 1 \u00e9s a karaktersorozat hossza k\u00f6z\u00f6tti \u00e9rt\u00e9knek kell lenni." },
		{ Message.STRING_LENGTH_ERROR, "A(z) {0} 12-es hibak\u00f3ddal meghi\u00fasult. A hossz csak null\u00e1n\u00e1l nagyobb lehet." },
		{ Message.STRING_NULT_ERROR, "A StrLib.setNullTerminator 16-os hibak\u00f3ddal meghi\u00fasult. A c\u00e9l karaktersorozat utols\u00f3 byte-ja csak \u00fcres vagy null karakter lehet." },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "A(z) {0} 20-as hibak\u00f3ddal meghi\u00fasult. A STRING, DBCHAR vagy UNICODE r\u00e9sz-karaktersorozatok indexe csak p\u00e1ratlan lehet, \u00edgy az index a karakter els\u0151 byte-j\u00e1t azonos\u00edtja." },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "A(z) {0} 24-es hibak\u00f3ddal meghi\u00fasult. A STRING, DBCHAR vagy UNICODE r\u00e9sz-karaktersorozatok hossza csak p\u00e1ros lehet, \u00edgy mindig eg\u00e9sz sz\u00e1m\u00fa karakterre hivatkozik." },
		{ Message.NO_DEBUG_LISTENER, "Nem lehet csatlakozni az EGL hibakeres\u0151h\u00f6z a(z) {0} hoszt {1} portj\u00e1n. A kiv\u00e9tel: {2}" },
		{ Message.DEBUG_LISTENER_PROBLEM, "Hiba t\u00f6rt\u00e9nt a kommunik\u00e1ci\u00f3ban az EGL hibakeres\u0151vel a(z) {0} hoszt {1} portj\u00e1n. A kiv\u00e9tel: {2}" },
		{ Message.NOT_DEBUG_MODE, "Az \u00f6sszek\u00f6t\u00e9s egy DEBUG h\u00edv\u00e1st adott meg a J2EE kiszolg\u00e1l\u00f3n bel\u00fcl. A h\u00edv\u00e1s nem a J2EE kiszolg\u00e1l\u00f3n, vagy nem hibakeres\u00e9s m\u00f3dban t\u00f6rt\u00e9nt, vagy a J2EE kiszolg\u00e1l\u00f3n nem enged\u00e9lyezett a hibakeres\u00e9s." },
		{ Message.LIBRARY_NOT_SPECIFIED, "Az \u00f6sszek\u00f6ttet\u00e9s DEBUG h\u00edv\u00e1st adott meg egy EGL figyel\u0151nek, de nem adta meg a f\u00fcggv\u00e9nyt\u00e1r tulajdons\u00e1got." },
		
		{ Message.FILETYPE_MISSING, "A vgj.ra.fileName.fileType fut\u00e1s k\u00f6zbeni tulajdons\u00e1g nem tal\u00e1lhat\u00f3 meg a(z) {0} f\u00e1jl eset\u00e9n." },
		{ Message.FILETYPE_INVALID, "A vgj.ra.fileName.fileType fut\u00e1s k\u00f6zbeni tulajdons\u00e1g \u00e9rt\u00e9ke \u00e9rv\u00e9nytelen a(z) {0} f\u00e1jl eset\u00e9n." },
		{ Message.INVALID_RECORD_LENGTH, "A rekordhossz elemben csak olyan \u00e9rt\u00e9k lehet, amely az elemek hat\u00e1r\u00e1n felosztja a nem karakteres adatokat." },
		{ Message.RECORD_LENGTH_TOO_LARGE, "Az occursItem vagy lengthItem \u00e9rt\u00e9ke t\u00fal nagy." },
		{ Message.IO_ERROR, "{0}: A(z) {1} I/O m\u0171velete meghi\u00fasult a k\u00f6vetkez\u0151 ok miatt: {2}." },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0}: A(z) {1} el\u0151k\u00e9sz\u00edtett utas\u00edt\u00e1s nem tal\u00e1lhat\u00f3[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0}: A(z) {1} eredm\u00e9nyhalmaz nem tal\u00e1lhat\u00f3[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_ERROR, "{0}: hiba[sqlstate:{1}][sqlcode:{2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0}: [sqlstate:02000][sqlcode:100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0}: {1}[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_CONNECTION_FAILED, "Nem lehet kapcsol\u00f3dni a k\u00f6vetkez\u0151h\u00f6z: {0}: {1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "Nem lehet kapcsol\u00f3dni a k\u00f6vetkez\u0151h\u00f6z: {0}, lehet, hogy hib\u00e1s az adatb\u00e1zis URL-c\u00edme: {1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "Hiba t\u00f6rt\u00e9nt a JDBC illeszt\u0151programok bet\u00f6lt\u00e9se k\u00f6zben.  Hiba: {0}" },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "A(z) {0} ResultSet nem g\u00f6rgethet\u0151." },
		{ Message.SQL_NO_DEFAULT_DATABASE, "Nem lehet csatlakozni az alap\u00e9rtelmezett adatb\u00e1zishoz. Az alap\u00e9rtelmezett adatb\u00e1zis neve nem volt megadva." },
		{ Message.SQL_NO_DATABASE_CONNECTION, "SQL I/O m\u0171veletet megel\u0151z\u0151en adatb\u00e1zis-kapcsolatot kell l\u00e9trehozni." },
		{ Message.SQL_DISCONNECT_ERROR, "Hiba t\u00f6rt\u00e9nt {0} adatb\u00e1zis kapcsolat\u00e1nak bont\u00e1sakor. {1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "Nem lehet kapcsolatot be\u00e1ll\u00edtani {0} adatb\u00e1zishoz. A kapcsolat nem l\u00e9tezik." },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "SQL hiba t\u00f6rt\u00e9nt az SQLLib.{0} f\u00fcggv\u00e9nyben: {1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "Egy nem SQL hiba t\u00f6rt\u00e9nt az SQLLib.{0} f\u00fcggv\u00e9nyben: {1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "Null\u00e9rt\u00e9k \u00e9rkezett az adatb\u00e1zisb\u00f3l, de a(z) {0} hosztv\u00e1ltoz\u00f3 nem nullk\u00e9pes." },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "Nem \u00e9rkezett bevitel egy k\u00f6telez\u0151 mez\u0151h\u00f6z - adja meg \u00fajra." },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "Hib\u00e1s adatt\u00edpus a bevitelben - adja meg \u00fajra." },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "T\u00fall\u00e9pte a megengedett jelent\u0151s sz\u00e1mjegyek sz\u00e1m\u00e1t - adja meg \u00fajra." },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "A bevitel nincs a meghat\u00e1rozott {0} - {1} tartom\u00e1nyban - \u00edrja be \u00fajra." },
		{ Message.EDIT_VALID_VALUES_ERR, "A bevitel nincs a meghat\u00e1rozott \u00e9rv\u00e9nyes \u00e9rt\u00e9kek list\u00e1j\u00e1ban - \u00edrja be \u00fajra." },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "A(z) {0} megadott id\u0151form\u00e1tuma \u00e9rv\u00e9nytelen." },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "Minim\u00e1lis hossz hiba a bevitelben - adja meg \u00fajra." },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "Maxim\u00e1lis hossz hiba a bevitelben - adja meg \u00fajra." },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "T\u00e1blaszerkeszt\u00e9s \u00e9rv\u00e9nyess\u00e9gi hiba - adja meg \u00fajra." },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "Beviteli modulus-ellen\u0151rz\u00e9si hiba - adja meg \u00fajra." },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "A bevitel nem felel meg a meghat\u00e1rozott d\u00e1tum- vagy id\u0151form\u00e1tumnak: {0}." },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "A bevitel nem \u00e9rv\u00e9nyes logikai mez\u0151h\u00f6z." },
		{ Message.EDIT_INVALID_PATTERN_ERR, "A megadott \u00e9rt\u00e9k \u00e9rv\u00e9nytelen, mivel nem felel meg a be\u00e1ll\u00edtott mint\u00e1nak." },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "A(z) {0} szerkeszt\u0151t\u00e1bla nincs meghat\u00e1rozva a k\u00f6vetkez\u0151h\u00f6z: {1}." },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "A hexadecim\u00e1lis adatok nem \u00e9rv\u00e9nyesek." },
		{ Message.EDIT_VALIDATION_ERR, "Egy oldal\u00e9rv\u00e9nyes\u00edt\u00e9si hiba t\u00f6rt\u00e9nt.  Hiba: {0}." },
		{ Message.EDIT_INPUT_ERR, "Hiba a beviteli \u00e9rt\u00e9kek \u00e9rtelmez\u00e9sekor."},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "Hiba t\u00f6rt\u00e9nt az \u00e9rt\u00e9k megjelen\u00edt\u00e9shez t\u00f6rt\u00e9n\u0151 form\u00e1z\u00e1sakor: {0}."},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "Az SO/SI karaktereket tartalmaz\u00f3 bemenet hosszabb a megadott elemhosszn\u00e1l."},
		
		{ Message.ACTION_REQUEST_ERROR, "J2EELib A RequestAttr f\u00fcggv\u00e9ny meghi\u00fasult a k\u00f6vetkez\u0151 kulccsal: {0}. Hiba: {1}" },
		{ Message.ACTION_SESSION_ERROR, "J2EELib A SessionAttr f\u00fcggv\u00e9ny meghi\u00fasult a k\u00f6vetkez\u0151 kulccsal: {0}. Hiba: {1}" },
		{ Message.ACTION_APPLICATION_ERROR, "J2EELib Az ApplicationAttr f\u00fcggv\u00e9ny meghi\u00fasult a k\u00f6vetkez\u0151 kulccsal: {0}. Hiba: {1}" },
		{ Message.ACTION_NO_J2EE_ERROR, "J2EELib csak J2EE k\u00f6rnyezetben haszn\u00e1lhat\u00f3." },
		
		{ Message.PORTALLIB_SESSION_ERROR, "A PortalLib PortletSessionAttr f\u00fcggv\u00e9ny meghi\u00fasult a k\u00f6vetkez\u0151 kulccsal: {0}. Hiba: {1}" },
		{ Message.PORTALLIB_MODE_ERROR, "A PortalLib setPortletMode meghi\u00fasult. Hiba: {0}" },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "A PortalLib setWindowState meghi\u00fasult. Hiba: {0}" },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "\u00c9rv\u00e9nytelen k\u00eds\u00e9rlet t\u00f6rt\u00e9nt a port\u00e1l kisalkalmaz\u00e1s m\u00f3d megv\u00e1ltoztat\u00e1s\u00e1ra a lek\u00e9pez\u00e9si k\u00e9r\u00e9s k\u00f6zben" },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "\u00c9rv\u00e9nytelen k\u00eds\u00e9rlet t\u00f6rt\u00e9nt a port\u00e1l kisalkalmaz\u00e1s ablak \u00e1llapot megv\u00e1ltoztat\u00e1s\u00e1ra a lek\u00e9pez\u00e9si k\u00e9r\u00e9s k\u00f6zben" },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "PortletSession megszerz\u00e9se nem siker\u00fclt" }, 
		{ Message.PORTALLIB_INVALIDKEY, "A(z) {0} f\u00fcggv\u00e9ny \u00e9rv\u00e9nytelen kulcsot kapott" }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "PortletRequest megszerz\u00e9se nem siker\u00fclt" }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "A PortalLib resetPreferenceValue f\u00fcggv\u00e9ny meghi\u00fasult a k\u00f6vetkez\u0151 kulccsal: {0}. Hiba: {1}" },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "A PortalLib savePreferences f\u00fcggv\u00e9ny meghi\u00fasult. Hiba: {0}" },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "A PortalLib oszt\u00e1lynak nem siker\u00fclt megadnia a(z) {0} kulcs be\u00e1ll\u00edt\u00e1sait. Hiba: {1}" }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "A PortalLib oszt\u00e1lynak nem siker\u00fclt lek\u00e9rnie a(z) {0} kulcs be\u00e1ll\u00edt\u00e1sait. Hiba: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "Nem siker\u00fclt el\u00e9rni a Hiteles\u00edt\u00e9si adatt\u00e1r szolg\u00e1ltat\u00e1st. Hiba: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "Nem siker\u00fclt el\u00e9rni a(z) {0} helyen tal\u00e1lhat\u00f3 hiteles\u00edt\u00e9si adatokat. Hiba: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "A hiteles\u00edt\u00e9si adatt\u00e1r hely l\u00e9trehoz\u00e1sa nem siker\u00fclt a felhaszn\u00e1l\u00f3i t\u00e1rter\u00fcleten. Hiba: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "A hiteles\u00edt\u00e9si adatt\u00e1r hely t\u00f6rl\u00e9se nem siker\u00fclt a felhaszn\u00e1l\u00f3i t\u00e1rter\u00fcletr\u0151l. Hiba: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "A hiteles\u00edt\u00e9si adatok be\u00e1ll\u00edt\u00e1sa meghi\u00fasult. Hiba: {0}" },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "A(z) {0} meghi\u00fasult. Egy met\u00f3dush\u00edv\u00e1s, vagy egy {1} nev\u0171 mez\u0151 el\u00e9r\u00e9se kezeletlen hib\u00e1t eredm\u00e9nyezett. A hiba\u00fczenet: {2}" },
		{ Message.JAVALIB_NULL_ID, "A(z) {0} meghi\u00fasult. A(z) {1} nem azonos\u00edt\u00f3, vagy egy null objektum azonos\u00edt\u00f3ja." },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "A(z) {0} meghi\u00fasult. A(z) {1} nev\u0171 nyilv\u00e1nos met\u00f3dus, mez\u0151 vagy oszt\u00e1ly nem l\u00e9tezik, vagy nem lehet bet\u00f6lteni, vagy param\u00e9tereinek sz\u00e1ma vagy t\u00edpusa helytelen. A hiba\u00fczenet: {2}" },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "A(z) {0} meghi\u00fasult. Az EGL \u00e9rt\u00e9k t\u00edpusa nem felel meg a v\u00e1rt t\u00edpusnak a(z) {1} Java hozz\u00e1f\u00e9r\u00e9s f\u00fcggv\u00e9nyben. A hiba\u00fczenet: {2}" },
		{ Message.JAVALIB_NULL_RETURNED, "A(z) {0} meghi\u00fasult. A c\u00e9l egy met\u00f3dus, amely null\u00e9rt\u00e9kkel t\u00e9r vissza, egy met\u00f3dus, amely nem ad vissza \u00e9rt\u00e9ket, vagy egy null \u00e9rt\u00e9k\u0171 mez\u0151." },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "A(z) {0} meghi\u00fasult. A(z) {1} oszt\u00e1ly null argumentummal nem t\u00f6lthet\u0151 be. A hiba\u00fczenet: {2}" },
		{ Message.JAVALIB_ACCESS_ERROR, "A(z) {0} meghi\u00fasult. Nem szerezhet\u0151 inform\u00e1ci\u00f3 a(z) {1} nev\u0171 met\u00f3dusr\u00f3l vagy mez\u0151r\u0151l, vagy pr\u00f3b\u00e1lkoz\u00e1s t\u00f6rt\u00e9nt egy v\u00e9glegesnek deklar\u00e1lt mez\u0151 \u00e9rt\u00e9k\u00e9nek m\u00f3dos\u00edt\u00e1s\u00e1ra. A hiba\u00fczenet: {2}" },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "A(z) {0} meghi\u00fasult. A(z) {1} egy fel\u00fclet vagy egy absztrakt oszt\u00e1ly, ez\u00e9rt a konstruktora nem h\u00edvhat\u00f3." },
		{ Message.JAVALIB_NOT_STATIC, "A(z) {0} meghi\u00fasult. A(z) {1} met\u00f3dus vagy mez\u0151 nem statikus. Az oszt\u00e1lyn\u00e9v helyett egy azonos\u00edt\u00f3t kell haszn\u00e1lni." },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "A(z) {0} m\u0171veletmez\u0151 nem l\u00e9tezik." },
		{ Message.CUI_E_ARRAY_FULL, "Nem lehet egy m\u00e1sik sort beilleszteni, mivel a bemeneti t\u00f6mb megtelt." },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "A(z) {0} t\u00f6mb nem tal\u00e1lhat\u00f3." },
		{ Message.CUI_E_ASSIGN_RESULT, "A t\u00e1rs\u00edt\u00e1s a felsz\u00f3l\u00edt\u00e1s eredm\u00e9ny v\u00e1ltoz\u00f3hoz meghi\u00fasult." },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "A(z) K\u00e9perny\u0151 t\u00f6mb {0} m\u00e9rete nem helyes."	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "A DrawBox param\u00e9terek k\u00edv\u00fcl esnek az \u00e9rtelmez\u00e9si tartom\u00e1nyon." },
		{ Message.CUI_E_BAD_COORDINATES, "A megjelen\u00edt\u00e9si koordin\u00e1t\u00e1k k\u00edv\u00fcl esnek az ablak hat\u00e1rain." },
		{ Message.CUI_E_BAD_KEYNAME, "A(z) ''{0}'' kulcs neve rossz form\u00e1tum\u00fa." },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "Ez a szerkeszt\u0151 szolg\u00e1ltat\u00e1s nem haszn\u00e1lhat\u00f3, mivel szerepel egy k\u00e9p." },
		{ Message.CUI_E_BAD_WINDOW_NAME, "Nem tal\u00e1lhat\u00f3 a(z) ''{0}'' ablak." },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "Az \u00faj ablak position[{0},{1}]/dimension[{2},{3}] \u00e9rt\u00e9kei \u00e9rv\u00e9nytelenek." },
		{ Message.CUI_E_CMDSTACK_SYNC, "A parancsverem nincs szinkronban." },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "A konzol UI f\u00fcggv\u00e9nyt\u00e1r nincs inicializ\u00e1lva." },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "Illeg\u00e1lis mez\u0151t\u00edpus az \u00f6ssze\u00e1ll\u00edt\u00e1shoz." },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "A ConstructQuery m\u0171veletet nem lehet v\u00e1ltoz\u00f3list\u00e1val megh\u00edvni." },
		{ Message.CUI_E_DISABLE_INVISIBLE, "Nem lehet letiltani l\u00e1thatatlan men\u00fcpontot." },
		{ Message.CUI_E_EDIT_FAILED, "A szerkeszt\u00e9si m\u0171velet meghi\u00fasult." },
		{ Message.CUI_E_EXEC_HOTKEY, "Hiba t\u00f6rt\u00e9nt a gyorsbillenty\u0171 m\u0171velet\u00e9nek v\u00e9grehajt\u00e1sa sor\u00e1n." },
		{ Message.CUI_E_EXIT_NO_CMD, "Nincs akt\u00edv parancs, amib\u0151l ki lehetne l\u00e9pni." },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "Nincs akt\u00edv parancs, amit folytatni lehetne." },
		{ Message.CUI_E_FATALERROR, "S\u00falyos hiba: {0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "A(z) {0} mez\u0151 nem l\u00e9tezik." },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "A(z) {0} k\u00e9perny\u0151t\u00f6mb mez\u0151 nem t\u00f6mb." },
		{ Message.CUI_E_FIELD_NOT_FOUND, "A(z) {0} mez\u0151 nem tal\u00e1lhat\u00f3." },
		{ Message.CUI_E_FIELD_NO_WINDOW, "A ConsoleField nem hozhat\u00f3 l\u00e9tre ablak n\u00e9lk\u00fcl." },
		{ Message.CUI_E_FIELD_COUNT, "A t\u00f6mbmez\u0151k sz\u00e1ma nem egyezik." },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "A(z) {0} \u0171rlap nem l\u00e9tezik." },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "A(z) {0} \u0171rlap nem f\u00e9r el a(z) {1} ablakban." },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "A mez\u0151 list\u00e1k nem egyeznek." },
		{ Message.CUI_E_FORM_IN_USE, "A(z) {0} \u0171rlap foglalt." },
		{ Message.CUI_E_FORM_NAME_USED, "M\u00e1r l\u00e9tezik \u0171rlap {0} n\u00e9vvel." },
		{ Message.CUI_E_FORM_NOT_OPEN, "A(z) {0} \u0171rlap nincs nyitva." },
		{ Message.CUI_E_FORM_NO_WINDOW, "A ConsoleForm nem hozhat\u00f3 l\u00e9tre ablak n\u00e9lk\u00fcl." },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "A KeyObject.getChar() met\u00f3dus nem haszn\u00e1lhat\u00f3 virtu\u00e1lis kulcsokhoz." },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "A KeyObject.getCookedChar() met\u00f3dus nem haszn\u00e1lhat\u00f3 virtu\u00e1lis kulcsokhoz." },
		{ Message.CUI_E_INTERNAL, "BELS\u0150 HIBA: {0}" },
		{ Message.CUI_E_INTR_RECEIVED, "Egy MEGSZAK\u00cdT\u00c1S jel \u00e9rkezett." },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "Nem l\u00e9tezhet gyorsbillenty\u0171 n\u00e9lk\u00fcli l\u00e1thatatlan men\u00fcpont." },
		{ Message.CUI_E_LABEL_NO_WINDOW, "ConsoleLabel nem hozhat\u00f3 l\u00e9tre ablak n\u00e9lk\u00fcl." },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "A(z) {0} men\u00fcpont nem illeszkedik az ablakba." },
		{ Message.CUI_E_MISSING_ITEM, "A(z) {0} men\u00fcpont nem l\u00e9tezik." },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "\u00dctk\u00f6z\u00e9s a men\u00fc gyorsbillenty\u0171in\u00e9l (kulcs={0})." },
		{ Message.CUI_E_NO_ACTIVE_FORM, "Nincs akt\u00edv \u0171rlap." },
		{ Message.CUI_E_NO_EDITOR, "Nem lett blob szerkeszt\u0151 megadva." },
		{ Message.CUI_E_NO_HELP_FILE, "Nem lett s\u00fag\u00f3f\u00e1jl megadva." },
		{ Message.CUI_E_NO_HELP_MSG, "A s\u00fag\u00f3\u00fczenet nem lett megadva." },
		{ Message.CUI_E_NO_NUMPAGES, "A men\u00fc nincs kiter\u00edtve." },
		{ Message.CUI_E_NO_SCREENARRAY, "Nincs akt\u00edv k\u00e9perny\u0151t\u00f6mb." },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "Nincsenek l\u00e1that\u00f3 men\u00fcpontok." },
		{ Message.CUI_E_NULL_WNDOW_NAME, "Az \u00faj ablak neve null \u00e9rt\u00e9k\u0171." },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "Null \u00e9rt\u00e9k\u0171 ablakot k\u00eds\u00e9relt meg megnyitni." },
		{ Message.CUI_E_PROMPT_EXCEPTION, "Parancssori kiv\u00e9tel t\u00f6rt\u00e9nt." },
		{ Message.CUI_E_QUIT_RECEIVED, "Egy QUIT jelz\u00e9s \u00e9rkezett." },
		{ Message.CUI_E_SCROLL_FAILED, "A men\u00fct nem lehet az aktu\u00e1lis elemhez g\u00f6rgetni." },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "Ismeretlen attrib\u00fatum: ''{0}''" },
		{ Message.CUI_E_VALIDATE_FIELD, "Hiba van a(z) {0} mez\u0151ben." },
		{ Message.CUI_E_VAR_LIST_SHORT, "Nem volt el\u00e9g v\u00e1ltoz\u00f3 megadva." },
		{ Message.CUI_E_WINDOW_NAME_USED, "A(z) {0} ablakn\u00e9v m\u00e1r haszn\u00e1latban van." },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "Az ablak m\u00e9rete t\u00fal kicsi a s\u00fag\u00f3k\u00e9perny\u0151h\u00f6z." },
		{ Message.CUI_E_VALID_VALUES, "A megadott \u00e9rt\u00e9k \u00e9rv\u00e9nytelen \u00e9rt\u00e9k." },
		{ Message.CUI_W_NO_MORE_FIELDS, "Nincs t\u00f6bb mez\u0151 abban az ir\u00e1nyban, amerre halad." },
		{ Message.CUI_W_NO_MORE_ROWS, "Nincs t\u00f6bb sor abban az ir\u00e1nyban, amerre halad." },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "A(z) {0} k\u00e9perny\u0151t\u00f6mb tartalom \u00e9rv\u00e9nytelen." },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "A(z) {0} k\u00e9perny\u0151t\u00f6mb nem tartalmazhatja a(z) {1} r\u00e9szekre osztott mez\u0151t."	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "A(z) {0} k\u00e9perny\u0151t\u00f6mb nem kompatibilis az adatt\u00f6mbbel." },
		{ Message.CUI_E_FIELD_NAME_DUP, "A(z) {0} mez\u0151n\u00e9v t\u00f6bbsz\u00f6r van haszn\u00e1latban." },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "{0} konzolmez\u0151 hossza \u00e9rv\u00e9nytelen." },
		{ Message.CUI_E_LABEL_NOT_FIT, "A c\u00edmke a [{0}, {1}] helyen nem f\u00e9r el a rendelkez\u00e9sre \u00e1ll\u00f3 ter\u00fcleten." },
		{ Message.CUI_E_FIELD_NOT_FIT, "A(z) {0} mez\u0151 szegmens a(z) ({1}, {2}) helyen nem f\u00e9r r\u00e1 a rendelkez\u00e9sre \u00e1ll\u00f3 ter\u00fcletre." },
		{ Message.CUI_E_PROMPT_TOO_LONG,"A felsz\u00f3l\u00edt\u00e1s karaktersorozata t\u00fal hossz\u00fa az akt\u00edv ablakhoz."},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"Az OpenUI t\u00f6mb argumentumok \u00e9rv\u00e9nytelenek."},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, "Az OpenUI mez\u0151 argumentumok \u00e9rv\u00e9nytelenek."},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "Egy felsz\u00f3l\u00edt\u00e1s utas\u00edt\u00e1shoz csak egyetlen v\u00e1ltoz\u00f3t lehet k\u00f6tni." },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "A(z) {0} konzolmez\u0151h\u00f6z az adatk\u00f6t\u00e9s nem \u00e1llap\u00edthat\u00f3 meg." },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "Figyelmeztet\u00e9s: NUL karakterek tal\u00e1lhat\u00f3k a clob adatokban" },
		{ Message.CUI_I_STR_WINDOWTITLE , "EGL konzolablak" },
		{ Message.CUI_E_MISSING_FORMAT , "A(z) {0} mez\u0151 nem rendelkezik form\u00e1tum objektummal." },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "A k\u00e9t bejegyz\u00e9s nem ugyanaz volt -- pr\u00f3b\u00e1lkozzon \u00fajra" },
		{ Message.CUI_I_STR_VERIFY_INPUT, "\u00cdrja be ism\u00e9t az ellen\u0151rz\u00e9shez" },
		{ Message.CUI_I_STR_HELP,"S\u00fag\u00f3"},
		{ Message.CUI_I_STR_RESUME,"Folytat\u00e1s"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"Befejezi a s\u00fag\u00f3 munkamenetet."},
		{ Message.CUI_I_STR_SCROLL , "G\u00f6rget\u00e9s" },
		{ Message.CUI_I_STR_LAST_PAGE, "El\u00e9rte a s\u00fag\u00f3sz\u00f6veg v\u00e9g\u00e9t. A folytat\u00e1shoz nyomja meg a RETURN gombot."},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "A s\u00fag\u00f3sz\u00f6veg k\u00f6vetkez\u0151 oldal\u00e1t jelen\u00edti meg."},
		{ Message.CUI_I_STR_SELECT , "KIV\u00c1LASZT\u00c1S"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "Hiba az els\u0151 sor besz\u00far\u00e1sakor az \u00fcres t\u00f6mbbe."},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "Az F25-F64 nincs megval\u00f3s\u00edtva."},
		{ Message.CUI_E_UNIMP_FN_KEYS , "BELS\u0150: Az F25-64 nincs megval\u00f3s\u00edtva" },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "Nem l\u00e9tezhet a CursesCanvas t\u00f6bb p\u00e9ld\u00e1nya" },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "A CursesCanvas nincs inicializ\u00e1lva" },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "A CursesCanvas t\u00fal kicsi"},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "A mez\u0151k n\u00e9v szerinti megjelen\u00edt\u00e9se nincs megval\u00f3s\u00edtva."},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "A minim\u00e1lis bevitel: {0} - adja meg \u00fajra." },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "T\u00fall\u00e9pte a maxim\u00e1lis bevitelt :{0} - adja meg \u00fajra." },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "A(z) ''{0}'' parancsf\u00e1jlt nem lehet megnyitni." },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "Nem olvashat\u00f3 a parancsf\u00e1jl."},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "Az automation.scenario ''{0}'' tulajdons\u00e1g nem k\u00f6nyvt\u00e1r."},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "Rossz form\u00e1tum\u00fa <click> direkt\u00edva az \u00fajrak\u00fcld\u00e9si parancsf\u00e1jlban."},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "Nem olvashat\u00f3 be a(z) ''{0}'' automatiz\u00e1l\u00e1si tulajdons\u00e1g."},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "\u00c9rv\u00e9nytelen p\u00e1nikgomb n\u00e9v: ''{0}''"},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "Kiv\u00e9tel t\u00f6rt\u00e9nt: <click>."},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "Nem lehet megnyitni a(z) ''{0}'' pillanatk\u00e9p f\u00e1jlt."},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "Az automation.scriptdir ''{0}'' be\u00e1ll\u00edtott tulajdons\u00e1ga nem l\u00e9tezik."},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "Az automation.scenario ''{0}'' k\u00f6nyvt\u00e1r be\u00e1ll\u00edtott tulajdons\u00e1ga nem hozhat\u00f3 l\u00e9tre."},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "\u00c9rv\u00e9nytelen pillanatk\u00e9p kulcsn\u00e9v: ''{0}''"},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "\u00d6sszehasonl\u00edt\u00e1s rendben."},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "K\u00e9perny\u0151 I/O m\u0171veletek haszn\u00e1lata nem megengedett RCP m\u00f3dban fut\u00e1s k\u00f6zben."},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "A(z) {0} azonos\u00edt\u00f3val nem l\u00e9tezik \u00fczenet a(z) {1} \u00fczenett\u00e1bl\u00e1ban." },
		{ Message.MSG_TBL_LOAD_ERR, "A(z) {0} \u00fczenett\u00e1bla f\u00e1jl nem t\u00f6lthet\u0151 be." },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "Nincs felhaszn\u00e1l\u00f3i \u00fczenet t\u00e1bla meghat\u00e1rozva a(z) {0} VGUIRecord elemhez." },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "A(z) ({1},{2}) poz\u00edci\u00f3ban l\u00e9v\u0151 ''{0}'' mez\u0151 nem az \u0171rlapon bel\u00fcl fekszik." },
		{ Message.TUI_E_FIELD_OVERLAP, "A(z) ''{0}'' mez\u0151 \u00e1tfedi ezt: ''{1}''." },
		{ Message.TUI_E_NO_FORMGROUP, "Bels\u0151 hiba: nem lehet meghat\u00e1rozni az \u0171rlapcsoportot." },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "A(z) ''{0}'' \u0171rlap nem illeszkedik egyik lebeg\u0151 ter\u00fcletre sem." },
		{ Message.TUI_E_BAD_FIELD_COORDS, "A(z) ''{0}'' mez\u0151 koordin\u00e1t\u00e1i \u00e9rv\u00e9nytelenek." },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "Nem lehet lek\u00e9rni a nyomtat\u00e1si hozz\u00e1rendel\u00e9st." },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "Nem l\u00e9tezik megfelel\u0151 nyomtat\u00e1si eszk\u00f6z m\u00e9ret." },
		{ Message.TUI_E_NO_DISPLAY, "Nincs megjelen\u00edt\u0151 eszk\u00f6z az \u0171rlapok sz\u00e1m\u00e1ra." },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "Nincs kompatibilis eszk\u00f6z m\u00e9ret a megjelen\u00edtett \u0171rlapokhoz." },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "A s\u00fag\u00f3\u0171rlap ''{0}'' oszt\u00e1lya nem l\u00e9tezik." },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "Ismeretlen attrib\u00fatum: ''{0}''." },
		{ Message.TUI_E_INVALID_VALID_VALUE, "Az \u00e9rv\u00e9nyes \u00e9rt\u00e9kek attrib\u00fatumban megadott \u00e9rt\u00e9k helytelen vagy nem \u00e9rtelmezhet\u0151." },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "Nem lehet l\u00e9trehozni s\u00fag\u00f3f\u00e1jlt a k\u00f6vetkez\u0151b\u0151l: ''{0}''." },
		{ Message.TUI_E_INTERNAL, "BELS\u0150 HIBA: {0}" },
		{ Message.TUI_E_NO_PRINTERS, "Nem \u00e1llnak rendelkez\u00e9sre nyomtat\u00f3k." },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "Nincs megadva alap\u00e9rtelmezett nyomtat\u00f3." },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "A(z) ''{0}'' nyomtat\u00f3 nem tal\u00e1lhat\u00f3.\nA k\u00f6vetkez\u0151 nyomtat\u00f3k el\u00e9rhet\u0151ek:\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "A(z) ''{0}'' \u00fczenet bet\u00f6lt\u00e9se sor\u00e1n hiba t\u00f6rt\u00e9nt." },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "{0} tartalm\u00e1t nem lehet mez\u0151k\u00e9nt haszn\u00e1lni." },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "A(z) ''{0}'' nyomtat\u00f3 nem tal\u00e1lhat\u00f3" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "A(z) {0} program show utas\u00edt\u00e1sa egy sz\u00f6veget v\u00e1rt innen: {1}, de a k\u00f6vetkez\u0151b\u0151l kapta: {2}." },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "K\u00f6vetkez\u0151" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "{0}. oldal, \u00f6sszesen: {1}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "El\u0151k\u00e9p" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "Nyomtat\u00e1s" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "Nyomtat\u00e1si el\u0151k\u00e9p - {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "Ment\u00e9s" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "Nyomtat\u00e1si feladat ment\u00e9se - {0} " },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "Hiba a k\u00f6vetkez\u0151 f\u00e1jlba v\u00e9gzett nyomtat\u00e1s sor\u00e1n: {0}" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "Hiba a k\u00f6vetkez\u0151 nyomtat\u00f3ra v\u00e9gzett nyomtat\u00e1s sor\u00e1n: {0}" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "EZEMNO be\u00e1ll\u00edt\u00e1sa" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "''{0}'' mez\u0151 \u00e9rv\u00e9nyes\u00edt\u00e9se" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "textform \u00e9rv\u00e9nyes\u00edt\u00e9se" },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "textform \u00e9rv\u00e9nyes\u00edt\u00e9se - ''{0}'' \u00e9rv\u00e9nyes\u00edt\u0151 f\u00fcggv\u00e9ny futtat\u00e1sa" },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "Nem lehet l\u00e9trehozni a napl\u00f3\u00edr\u00f3t." },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "A(z) ''{0}'' napl\u00f3z\u00e1si param\u00e9ter nem \u00e1ll\u00edthat\u00f3 be az ind\u00edt\u00e1s ut\u00e1n." },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "A(z) ''{0}'' napl\u00f3k\u00f6nyvt\u00e1r nem l\u00e9tezik." },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "A(z) ''{0}'' napl\u00f3k\u00f6nyvt\u00e1r nem \u00edrhat\u00f3." },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "A(z) ''{0}'' napl\u00f3f\u00e1jlt nem lehet l\u00e9trehozni." },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "A(z) ''{0}'' napl\u00f3f\u00e1jlt nem lehet \u00edrni." },
		
		{ Message.SOA_E_LOAD_SERVICE, "Probl\u00e9ma t\u00f6rt\u00e9nt a(z) {0} \u00f6sszetev\u0151/k\u00fcls\u0151 szolg\u00e1ltat\u00e1s szolg\u00e1ltat\u00e1s\u00e1nak bet\u00f6lt\u00e9se sor\u00e1n." },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "Hiba t\u00f6rt\u00e9nt a(z) ''{0}'' webszolg\u00e1ltat\u00e1si m\u0171velet kapcsolat\u00e1nak l\u00e9trehoz\u00e1sa sor\u00e1n.  {1}." },
		{ Message.SOA_E_WS_GET_OPERATION, "Hiba t\u00f6rt\u00e9nt a(z) ''{0}'' m\u0171velet megszerz\u00e9sekor a(z) ''{1}'' wsdl f\u00e1jlb\u00f3l." },
		{ Message.SOA_E_WS_MALFORMED_URL, "A(z) {1} Webszolg\u00e1ltat\u00e1s m\u0171velethez a c\u00e9l URL c\u00edm \u00e9rv\u00e9nytelen. URL: {0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "Hiba t\u00f6rt\u00e9nt a(z) {0} szolg\u00e1ltat\u00e1s bet\u00f6lt\u00e9se k\u00f6zben. Hiba: {1}." },
		{ Message.SOA_E_LOAD_WEB_PROXY, "Hiba t\u00f6rt\u00e9nt egy webszolg\u00e1ltat\u00e1s bet\u00f6lt\u00e9si k\u00eds\u00e9rlete sor\u00e1n. Nem lehet feloldani a(z) {0} k\u00fcls\u0151 szolg\u00e1ltat\u00e1s WSDL portj\u00e1t." },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "A(z) ''{0}'' \u00f6sszetev\u0151 ''{1}'' tulajdons\u00e1ga hi\u00e1nyzik, amelyre sz\u00fcks\u00e9g van a szolg\u00e1ltat\u00e1s megval\u00f3s\u00edt\u00e1s\u00e1hoz." },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "A(z) ''{0}'' szolg\u00e1ltat\u00e1si hivatkoz\u00e1s hi\u00e1nyzik, vagy nem rendelkezik c\u00e9l\u00e9rt\u00e9kkel." },
		{ Message.SOA_E_MISSING_BINDING, "A(z) ''{0}'' szolg\u00e1ltat\u00e1si k\u00f6t\u00e9s nem l\u00e9tezik a(z) ''{1}'' telep\u00edt\u00e9si le\u00edr\u00f3ban." },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "Hiba t\u00f6rt\u00e9nt a(z) ''{0}'' rekord \u00e1talak\u00edt\u00e1si k\u00eds\u00e9rlete sor\u00e1n SOAP \u00fczenetre.  Nem tal\u00e1lhat\u00f3 a(z) ''{1}'' mez\u0151 a rekordban." },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "Hiba t\u00f6rt\u00e9nt a(z) ''{0}'' \u00e1talak\u00edt\u00e1si k\u00eds\u00e9rlete sor\u00e1n SOAP \u00fczenetre."},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "Hiba t\u00f6rt\u00e9nt egy webszolg\u00e1ltat\u00e1st\u00f3l bej\u00f6v\u0151 \u00fczenet feldolgoz\u00e1sa sor\u00e1n. A Java t\u00edpus nem kompatibilis az EGL t\u00edpussal." },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "Hiba t\u00f6rt\u00e9nt egy webszolg\u00e1ltat\u00e1sra kimen\u0151 \u00fczenet feldolgoz\u00e1sa sor\u00e1n. Az EGL t\u00edpus nem kompatibilis a Java t\u00edpussal." },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "Nem inicializ\u00e1lhat\u00f3 a(z) ''{0}'' rekord." },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "Nem lehet \u00e1talak\u00edtani a(z) ''{0}'' \u00e9rt\u00e9ket Calendar t\u00edpusra." },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "Nem lehet \u00e1talak\u00edtani a(z) ''{0}'' \u00e9rt\u00e9ket boolean t\u00edpusra." },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "Nem lehet \u00e1talak\u00edtani a(z) ''{0}'' \u00e9rt\u00e9ket Byte t\u00edpusra." },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "Nem lehet \u00e1talak\u00edtani a(z) ''{0}'' \u00e9rt\u00e9ket short t\u00edpusra." },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "Nem lehet \u00e1talak\u00edtani a(z) ''{0}'' \u00e9rt\u00e9ket URI c\u00edmre." },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "Az EGL t\u00edpus nem t\u00e1mogatott webszolg\u00e1ltat\u00e1si param\u00e9terk\u00e9nt." },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "Hiba t\u00f6rt\u00e9nt a rekordt\u00f6mb l\u00e9trehoz\u00e1si k\u00eds\u00e9rlete sor\u00e1n. {0}." },
		{ Message.SOA_E_METHOD_NOT_FOUND, "A(z) {0} met\u00f3dus nem tal\u00e1lhat\u00f3 {1} szolg\u00e1ltat\u00e1sban." },
		{ Message.SOA_E_NOT_WEB_SERVICE, "A szolg\u00e1ltat\u00e1s nem webszolg\u00e1ltat\u00e1s." },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "Hiba t\u00f6rt\u00e9nt a(z) {0} f\u00fcggv\u00e9ny megh\u00edv\u00e1sakor a(z) {1} webszolg\u00e1ltat\u00e1son." },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "Hiba t\u00f6rt\u00e9nt a(z) {0} f\u00fcggv\u00e9ny megh\u00edv\u00e1sakor a(z) {1} EGL szolg\u00e1ltat\u00e1son." },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "Hiba t\u00f6rt\u00e9nt a(z) {0} f\u00fcggv\u00e9ny megh\u00edv\u00e1sakor a(z) {1} EGL szolg\u00e1ltat\u00e1son a(z) {2} haszn\u00e1lat\u00e1val: {3}." },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "A szolg\u00e1ltat\u00e1s nem tcpip szolg\u00e1ltat\u00e1s." },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "Hiba t\u00f6rt\u00e9nt a(z) {0} f\u00fcggv\u00e9ny megh\u00edv\u00e1sakor a(z) {1} bel\u00e9p\u00e9si ponton." },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "Hiba t\u00f6rt\u00e9nt a(z) {0} szolg\u00e1ltat\u00e1s k\u00f6t\u00e9si f\u00e1jl bet\u00f6lt\u00e9s\u00e9re tett k\u00eds\u00e9rlet sor\u00e1n. {1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "Hiba t\u00f6rt\u00e9nt a(z) {0} f\u00fcggv\u00e9ny megh\u00edv\u00e1sakor a(z) {1} CICS szolg\u00e1ltat\u00e1son. Hibak\u00f3d: {2}, \u00dczenet: {3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "Hiba t\u00f6rt\u00e9nt a(z) {0} f\u00fcggv\u00e9ny megh\u00edv\u00e1sakor a(z) {1} iSeries szolg\u00e1ltat\u00e1son. Hibak\u00f3d: {2}, \u00dczenet: {3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "A szolg\u00e1ltat\u00e1s nem CICS szolg\u00e1ltat\u00e1s." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "Hiba t\u00f6rt\u00e9nt a(z) {0} t\u00e1voli programban, d\u00e1tum: {1}, id\u0151: {2}, rendszer: {3}." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "Hiba t\u00f6rt\u00e9nt a(z) {0} t\u00e1voli szolg\u00e1ltat\u00e1sban a(z) {1} rendszeren." },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "A fut\u00e1si egys\u00e9g a(z) {0} rendszeren alkalmaz\u00e1shiba miatt le\u00e1llt a(z) {1} szolg\u00e1ltat\u00e1s h\u00edv\u00e1sakor. \u00dczenet: {2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "AS400Toolbox v\u00e9grehajt\u00e1si hiba: {0}, {1} a(z) {2} szolg\u00e1ltat\u00e1s h\u00edv\u00e1sa sor\u00e1n {3} rendszeren." },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "Nem t\u00e1mogatott szolg\u00e1ltat\u00e1si \u00fcgyf\u00e9lk\u00f6t\u00e9s. A(z) {0} a Websphere rendszer sz\u00e1m\u00e1ra j\u00f6tt l\u00e9tre, de egy nem J2EE k\u00f6rnyezetb\u0151l ker\u00fcl megh\u00edv\u00e1sra. \u00c1ll\u00edtsa el\u0151 \u00fajb\u00f3l egy nem J2EE projektben." },
		{ Message.SOA_E_USER_ID_NOT_SET, "A t\u00e1voli felhaszn\u00e1l\u00f3i azonos\u00edt\u00f3t \u00e9s jelsz\u00f3t a(z) {0} webszolg\u00e1ltat\u00e1s \u00e9s a(z) {1} f\u00fcggv\u00e9ny megh\u00edv\u00e1sa el\u0151tt be kell \u00e1ll\u00edtani." },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "Kiv\u00e9tel t\u00f6rt\u00e9nt egy szolg\u00e1ltat\u00e1s h\u00edv\u00e1sa sor\u00e1n." },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "Kiv\u00e9tel t\u00f6rt\u00e9nt a szolg\u00e1ltat\u00e1ssal folytatott kommunik\u00e1ci\u00f3 k\u00f6zben. URL: {0}" },
		{ Message.SOA_E_WS_PROXY_REST, "Kiv\u00e9tel t\u00f6rt\u00e9nt egy REST szolg\u00e1ltat\u00e1sh\u00edv\u00e1s sor\u00e1n. K\u00f6t\u00e9s:{0}, M\u0171velet:{0}" },
		{ Message.SOA_E_WS_PROXY_SOAP, "Kiv\u00e9tel t\u00f6rt\u00e9nt egy SOAP szolg\u00e1ltat\u00e1sh\u00edv\u00e1s sor\u00e1n. K\u00f6t\u00e9s:{0}, Szolg\u00e1ltat\u00e1s:{1}, Port:{2}, WSDL hely:{3}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "Kiv\u00e9tel t\u00f6rt\u00e9nt a JSON-b\u0151l t\u00f6rt\u00e9n\u0151 \u00e1talak\u00edt\u00e1s sor\u00e1n. param\u00e9ter:{0}, json:{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "Kiv\u00e9tel t\u00f6rt\u00e9nt JSON-re t\u00f6rt\u00e9n\u0151 \u00e1talak\u00edt\u00e1s sor\u00e1n. param\u00e9ter:{0}, \u00e9rt\u00e9k:{1}" },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "Nem tal\u00e1lhat\u00f3 REST-RPC szolg\u00e1ltat\u00e1s. URL: {0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "Nem \u00e9rkezett v\u00e1lasz a szolg\u00e1ltat\u00e1st\u00f3l. URL: {0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "A k\u00e9r\u00e9s nem alak\u00edthat\u00f3 \u00e1t szolg\u00e1ltat\u00e1sh\u00edv\u00e1ss\u00e1. A fogadott k\u00e9r\u00e9s a k\u00f6vetkez\u0151 volt: ''{0}''. " },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "A szolg\u00e1ltat\u00e1sh\u00edv\u00e1s t\u00fall\u00e9pte az id\u0151korl\u00e1tot. kiv\u00e9tel: Kapcsolat olvas\u00e1si id\u0151t\u00fall\u00e9p\u00e9s hiba. url:{0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "A szolg\u00e1ltat\u00e1s nem REST szolg\u00e1ltat\u00e1s." },
		{ Message.SOA_E_REST_SERVICE, "A REST szolg\u00e1ltat\u00e1s h\u00edv\u00e1sa meghi\u00fasult. K\u00f6t\u00e9s:{0}, M\u0171velet:{1}, HTTP met\u00f3dus:{2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "Kiv\u00e9tel t\u00f6rt\u00e9nt az adatok EGL param\u00e9terekk\u00e9 alak\u00edt\u00e1sakor. K\u00f6t\u00e9s:{0}, \u00e1talak\u00edtand\u00f3 adatok:{1}, kiv\u00e9tel:{2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "REST szolg\u00e1ltat\u00e1s h\u00edv\u00e1s t\u00f6rt\u00e9nt egy nem-REST szolg\u00e1ltat\u00e1shivatkoz\u00e1son. Szolg\u00e1ltat\u00e1shivatkoz\u00e1s: {0}, M\u0171velet: {1}, HTTP met\u00f3dus: {2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "Kiv\u00e9tel t\u00f6rt\u00e9nt az XML form\u00e1tumb\u00f3l v\u00e9gzett \u00e1talak\u00edt\u00e1s sor\u00e1n. A sz\u00fcks\u00e9ges {0} elem hi\u00e1nyzik." },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "Kiv\u00e9tel t\u00f6rt\u00e9nt az XML form\u00e1tumb\u00f3l v\u00e9gzett \u00e1talak\u00edt\u00e1s sor\u00e1n. param\u00e9ter:{0}, xml:{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "Kiv\u00e9tel t\u00f6rt\u00e9nt az XML form\u00e1tumra v\u00e9gzett \u00e1talak\u00edt\u00e1s sor\u00e1n. param\u00e9ter:{0}, \u00e9rt\u00e9k:{1}" },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "XML \u00e9rtelmez\u00e9si kiv\u00e9tel t\u00f6rt\u00e9nt a(z) {0} XML form\u00e1tumb\u00f3l v\u00e9gzett \u00e1talak\u00edt\u00e1sa sor\u00e1n." },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "XML \u00e1talak\u00edt\u00e1si kiv\u00e9tel t\u00f6rt\u00e9nt a(z) {0} XML form\u00e1tumra v\u00e9gzett \u00e1talak\u00edt\u00e1sa sor\u00e1n." },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "A szolg\u00e1ltat\u00e1s megh\u00edv\u00e1s\u00e1ra haszn\u00e1lt ''{0}'' URL \u00e9rv\u00e9nytelen. Nem tartalmazza a http:// protokollt." },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "A szolg\u00e1ltat\u00e1s megh\u00edv\u00e1s\u00e1ra haszn\u00e1lt ''{0}'' URL \u00e9rv\u00e9nytelen. {1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "A szolg\u00e1ltat\u00e1s megh\u00edv\u00e1s\u00e1ra haszn\u00e1lt URL \u00fcres. Adjon meg a szolg\u00e1ltat\u00e1sra mutat\u00f3 URL c\u00edmet." },
			
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "Nem lehet kit\u00f6lteni a jelent\u00e9st a(z) {0} kapcsolat seg\u00edts\u00e9g\u00e9vel."},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "Nem lehet kit\u00f6lteni a jelent\u00e9st a(z) {0} sql utas\u00edt\u00e1s seg\u00edts\u00e9g\u00e9vel."},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "Nem lehet kit\u00f6lteni a jelent\u00e9st a(z) {0} dinamikus t\u00f6mb seg\u00edts\u00e9g\u00e9vel."},
		{ Message.REPORT_E_FILL_ERROR , "Nem lehet kit\u00f6lteni {0} jelent\u00e9st."},
		{ Message.REPORT_E_EXPORT_ERROR, "Nem lehet export\u00e1lni a(z) {0} jelent\u00e9st." },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "Nem lehet v\u00e9grehajtani \u00e1talak\u00edt\u00e1st EGL {0} \u00e9s Java {1} t\u00edpusok k\u00f6z\u00f6tt." },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "Nem lehet v\u00e9grehajtani \u00e1talak\u00edt\u00e1st Java {0} \u00e9s EGL {1} t\u00edpusok k\u00f6z\u00f6tt." },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "Nem lehetett param\u00e9tert felvenni a jelent\u00e9shez." },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "Nem lehetett vissza\u00e1ll\u00edtani a jelent\u00e9s param\u00e9terlist\u00e1j\u00e1t." },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "Helytelen mez\u0151n\u00e9v: {0}" },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "Helytelen r\u00e9szjelent\u00e9sn\u00e9v: {0}" },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "Nem t\u00e1mogatott t\u00edpus szerepel a jelent\u00e9sben" },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "Ennek a f\u00fcggv\u00e9nynek nem adhat\u00f3k \u00e1t komplex t\u00edpusok" },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "A getParameterDefaultValue() f\u00fcggv\u00e9ny megh\u00edv\u00e1sa el\u0151tt be kell \u00e1ll\u00edtani a tervf\u00e1jl nev\u00e9t." },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "Nem lehet a(z) {0} param\u00e9terhez az alap\u00e9rtelmezett \u00e9rt\u00e9ket megszerezni. {1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "Nem l\u00e9tezik a(z) {0} nev\u0171 jelent\u00e9s param\u00e9ter." },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "A createReportFromDesign() vagy createDocument() f\u00fcggv\u00e9nyek megh\u00edv\u00e1sa el\u0151tt be kell \u00e1ll\u00edtani a tervf\u00e1jl nev\u00e9t." },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, "A createReportFromDocument() f\u00fcggv\u00e9ny megh\u00edv\u00e1sa el\u0151tt be kell \u00e1ll\u00edtani a dokumentumf\u00e1jl nev\u00e9t." },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "A jelent\u00e9s dokumentum f\u00e1jl l\u00e9trehoz\u00e1sa nem siker\u00fclt. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "A tervf\u00e1jl alapj\u00e1n nem \u00e1ll\u00edthat\u00f3 el\u0151 jelent\u00e9s. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "A dokumentumf\u00e1jl alapj\u00e1n nem \u00e1ll\u00edthat\u00f3 el\u0151 jelent\u00e9s. {0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "A BirtReport kezel\u0151j\u00e9nek BirtHandler t\u00edpus\u00fanak kell lennie." },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "A(z) {0} elem nem l\u00e9tezik a jelent\u00e9s tervben, vagy nem a megadott t\u00edpus\u00fa." },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "A(z) {1} sz\u00e1m\u00fa {0} sor nem l\u00e9tezik a(z) {2} t\u00e1bl\u00e1ban." },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "A(z) {0} sorsz\u00e1m nem l\u00e9tezik a(z) {1} r\u00e1cselemben." },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "A(z) {0} csoport nem l\u00e9tezik a(z) {1} t\u00e1bl\u00e1ban." },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "A(z) {1} sz\u00e1m\u00fa {0} sor nem l\u00e9tezik a(z) {3} t\u00e1bla {2} csoportj\u00e1ban." },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "A(z) {0} sz\u00e1m\u00fa oszlop nem l\u00e9tezik a(z) {2} t\u00e1bla {1} sor\u00e1ban." },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "A(z) {0} oszlopsz\u00e1m nem l\u00e9tezik a(z) {1} r\u00e1csban." },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "A(z) {0} sz\u00e1m\u00fa oszlop nem l\u00e9tezik a(z) {3} t\u00e1bla {2} csoportj\u00e1nak {1} sor\u00e1ban." },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "''RowType'' tulajdons\u00e1got meg kell adni egy esem\u00e9nykezel\u0151 f\u00fcggv\u00e9nyhez a(z) {0} t\u00e1bla soraihoz vagy cell\u00e1ihoz." },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "A(z) {0} Java t\u00edpus nem alak\u00edthat\u00f3 \u00e1t EGL t\u00edpuss\u00e1." },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "A(z) {0} EGL t\u00edpus nem alak\u00edthat\u00f3 \u00e1t Java t\u00edpuss\u00e1." },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "A(z) {0} adathalmaz nem l\u00e9tezik a jelent\u00e9s tervben, vagy nem a megadott t\u00edpus\u00fa." },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "A(z) {0} adatsor egy parancsf\u00e1jllal ell\u00e1tott adatsor, de a k\u00f6vetkez\u0151 eventTypes egyike sem lett lekezelve: openEvent, fetchEvent, closeEvent." },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "A(z) {0} adatforr\u00e1s nem l\u00e9tezik a jelent\u00e9s tervben, vagy nem a megadott t\u00edpus\u00fa." },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "A(z) {0} adatforr\u00e1s egy parancsf\u00e1jllal ell\u00e1tott adatforr\u00e1s, de a k\u00f6vetkez\u0151 eventTypes egyike sem lett lekezelve: openEvent, closeEvent." },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "A(z) {0} oszlopsz\u00e1m nem l\u00e9tezik a(z) {1} adatsorban." },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "Kiv\u00e9tel t\u00f6rt\u00e9nt a(z) {0} oszlop lek\u00e9rdez\u00e9sekor a(z) {1} adatsorb\u00f3l. {2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "Kiv\u00e9tel t\u00f6rt\u00e9nt a(z) {1} parancsf\u00e1jllal ell\u00e1tott adatsor {0} oszlop\u00e1nak be\u00e1ll\u00edt\u00e1sakor. {2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "Kiv\u00e9tel t\u00f6rt\u00e9nt a(z) {0} oszlop k\u00f6t\u00e9s lek\u00e9r\u00e9sekor. {1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "A vgj.defaultI4GLNativeLibrary tulajdons\u00e1g nincs megadva" },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "A(z) {0} f\u00fcggv\u00e9nyt\u00e1r bet\u00f6lt\u00e9se meghi\u00fasult: {1}" },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "A visszaadott param\u00e9terek nem egyeznek a f\u00fcggv\u00e9nnyel" },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "Nem lehetett mem\u00f3ri\u00e1t lefoglalni"},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "Nem lehetett \u00e1talak\u00edt\u00e1st v\u00e9grehajtani a t\u00edpusok k\u00f6z\u00f6tt"},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "\u00c9rv\u00e9nytelen a Datetime vagy az Interval pontoss\u00e1ga"},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "A karakter hosztv\u00e1ltoz\u00f3 t\u00fal r\u00f6vid az adatok sz\u00e1m\u00e1ra"},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "A f\u00fcggv\u00e9ny nem tal\u00e1lhat\u00f3 a szimb\u00f3lumt\u00e1bl\u00e1ban."},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "Meg kell adni egy TEXT vagy BYTE adatt\u00edpust ebben a kontextusban"},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "A veremben l\u00e9v\u0151 \u00e9rt\u00e9k nem alak\u00edthat\u00f3 \u00e1t \u00e9rt\u00e9kt\u00edpuss\u00e1"},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "A veremben l\u00e9v\u0151 \u00e9rt\u00e9k nem alak\u00edthat\u00f3 \u00e1t ANY \u00e9rt\u00e9kk\u00e9"},
		{ Message.CINTERFACE_E_POP_ERROR, "Nem siker\u00fclt {0} t\u00edpus\u00fa \u00e9rt\u00e9ket levenni a veremb\u0151l."},
		{ Message.CINTERFACE_E_PUSH_ERROR, "Nem siker\u00fclt {1} t\u00edpus\u00fa \u00e9rt\u00e9ket a verembe helyezni."},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "Nincs mit a veremb\u0151l kivenni vagy odahelyezni"},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "A helymeghat\u00e1roz\u00f3t nem lehetett kiemelni a veremb\u0151l"},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "A verem \u00fcres"},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "A helymeghat\u00e1roz\u00f3t nem lehetett \u00e1tm\u00e1solni"},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "Nullhivatkoz\u00e1s ker\u00fclt a verembe"},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "Any t\u00edpust nem lehetett a verembe helyezni"},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "A verem elem\u00e9t nem lehetett Any t\u00edpushoz rendelni"},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "A visszat\u00e9r\u00e9si t\u00edpus nem megfelel\u0151"},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "A param\u00e9ter t\u00edpusa nem megfelel\u0151"},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "Nem tal\u00e1lhat\u00f3 a(z) {0} EGL forr\u00e1sf\u00e1jl.  Helyette az el\u0151\u00e1ll\u00edtott k\u00f3d fog futni." },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "Nem tal\u00e1lhat\u00f3 EGL forr\u00e1sf\u00e1jl a(z) {0} nev\u0171 tranzakci\u00f3hoz." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "A k\u00f6vetkez\u0151 form\u00e1z\u00e1si probl\u00e9ma mer\u00fclt fel a(z) \"{0}\" mez\u0151ben, a(z) \"{1}\" \u0171rlap megjelen\u00edt\u00e9sekor:" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, "{0}\n\nA mez\u0151 elv\u00e1rt bels\u0151 form\u00e1tuma a k\u00f6vetkez\u0151: \"{1}\". Ellen\u0151rizze a d\u00e1tumform\u00e1tumot a hibakeres\u00e9si \u00d6ssze\u00e9p\u00edt\u00e9si le\u00edr\u00f3n bel\u00fcl tal\u00e1lhat\u00f3 EGL Java fut\u00e1si k\u00f6rnyezet tulajdons\u00e1gok k\u00f6z\u00f6tt, illetve vizsg\u00e1lja meg a d\u00e1tumform\u00e1tumokat befoly\u00e1sol\u00f3 JDBC tulajdons\u00e1gokat." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\nA mez\u0151 megjelen\u00edt\u00e9si form\u00e1tuma a k\u00f6vetkez\u0151: \"{1}\". Ellen\u0151rizze az \u0171rlapmez\u0151  \"{2}\" tulajdons\u00e1g\u00e1t." },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "A(z) {0} program nem futtathat\u00f3 webes tranzakci\u00f3k\u00e9nt." },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "A webes tranzakci\u00f3 bemenete {0} UI rekordot kapott, de {1} UI rekorddal lett megadva." },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "A bevitel nem \u00e9rv\u00e9nyes logikai mez\u0151h\u00f6z." },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "Inaktivit\u00e1s miatt id\u0151t\u00fall\u00e9p\u00e9s t\u00f6rt\u00e9nt a(z) {0} programban." },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "A(z) {0} felhaszn\u00e1l\u00f3i fel\u00fclet rekord t\u00fal sok adatot tartalmaz ahhoz, hogy elk\u00fcldhesse az \u00e1tj\u00e1r\u00f3 kiszolg\u00e1l\u00f3 kisalkalmaz\u00e1snak." },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "A program nem tudta ellen\u0151rizni az \u00e1tj\u00e1r\u00f3 kiszolg\u00e1l\u00f3 kisalkalmaz\u00e1st\u00f3l kapott adatokat.  Az adatazonos\u00edt\u00f3: {0}." },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "A(z) {0} t\u00f6mb\u00e1talak\u00edt\u00f3t nem lehet a maxim\u00e1lis m\u00e9ret\u00e9n\u00e9l nagyobbra b\u0151v\u00edteni. A hiba a(z) {1} met\u00f3dusban l\u00e9pett fel." },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "A(z) {1} t\u00f6mb\u00e1talak\u00edt\u00f3nak megadott {0} index \u00e9rv\u00e9nytelen. A maxim\u00e1lis m\u00e9ret: {2}. A jelenlegi m\u00e9ret: {3}." },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "\u00c9rv\u00e9nytelen maxim\u00e1lis m\u00e9ret a(z) {1} t\u00f6mb\u00e1talak\u00edt\u00f3hoz: {0}." },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "A(z) {0} objektumt\u00edpust nem lehet hozz\u00e1adni a(z) {1} t\u00edpus\u00fa t\u00f6mb\u00e1talak\u00edt\u00f3hoz." },
		
		{ Message.IMS_HOST_ABORT, "Megszak\u00edt\u00e1si csomag \u00e9rkezett a t\u00e1voli hosztr\u00f3l."},
		{ Message.IMS_HOST_TCPIP_ERROR, "A t\u00e1voli hoszton TCP/IP hiba t\u00f6rt\u00e9nt. Szakasz:{0} TCPIP-m\u0171velet:{1} TCPIP-RETCODE:{2} TCPIP-ERRNO:{3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "Hiba t\u00f6rt\u00e9nt a hoszton a k\u00f6vetkez\u0151 h\u00edv\u00e1sa k\u00f6zben: {0}"},
		{ Message.IMS_HOST_PACKET_ERROR, "A hosztt\u00f3l rossz v\u00e1laszcsomag \u00e9rkezett. V\u00e1rt:{0} \u00c9rkezett:{1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "I/O m\u0171veleti hiba t\u00f6rt\u00e9nt a t\u00e1rolt elj\u00e1r\u00e1s v\u00e9grehajt\u00e1sa k\u00f6zben. {0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "SQL hiba t\u00f6rt\u00e9nt a t\u00e1rolt elj\u00e1r\u00e1s v\u00e9grehajt\u00e1sa k\u00f6zben. {0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "Hiba t\u00f6rt\u00e9nt a t\u00e1voli hoszton a(z) {0} futtat\u00e1sa k\u00f6zben. RETCODE:{1}DLI proxy feladatazonos\u00edt\u00f3:{2}"},
		{ Message.IMS_HOST_DLI_ERROR, "A t\u00e1voli hoszton TCP/IP hiba t\u00f6rt\u00e9nt. DLI f\u00fcggv\u00e9ny:{0} AIB visszat\u00e9r\u00e9si \u00e9rt\u00e9k:0x{1} AIB ok:0x{2} \u00e1llapotk\u00f3d:{3} DLI proxy feladatazonos\u00edt\u00f3:{4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "A t\u00e1voli hoszton TCP/IP hiba t\u00f6rt\u00e9nt. DLI f\u00fcggv\u00e9ny:{0} AIB visszat\u00e9r\u00e9si \u00e9rt\u00e9k:0x{1} AIB ok:0x{2} DLIVar.statusCode:{3} DLIVar.DbName:{4} DLIVar.SegmentName:{5} DLIVar.SegmentLevel:{6} DLI proxy feladatazonos\u00edt\u00f3:{7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "Az AIB visszat\u00e9r\u00e9si k\u00f3d egy PCB \u00e1llapotk\u00f3dra utal, de nem egyetlen PCB sem t\u00e9rt vissza. AIB-f\u00fcggv\u00e9ny:{0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "Egy CALL EZEDBTCP h\u00edv\u00e1sban hiba t\u00f6rt\u00e9nt a t\u00e1voli hoszton. Szakasz:{0} TCPIP-m\u0171velet:{1} TCPIP-RETCODE:{2} TCPIP-ERRNO:{3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "A t\u00e1voli hoszton ABEND t\u00f6rt\u00e9nt. Rutin:{0}, \u00fczenet:{1} "},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "Kiv\u00e9tel t\u00f6rt\u00e9nt a t\u00e1voli hoszton. H\u00cdV\u00c1S:{0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "A hibakeres\u0151 nem t\u00e1mogatja a DLI f\u00fcggv\u00e9nyt. F\u00fcggv\u00e9ny:{0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "DL/I h\u00edv\u00e1s ker\u00fclt kiad\u00e1sra, de az \u00f6ssze\u00e9p\u00edt\u00e9si le\u00edr\u00f3 nincs be\u00e1ll\u00edtva DL/I hozz\u00e1f\u00e9r\u00e9shez."},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "T\u00e1voli kiv\u00e9tel: {0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "Hiba t\u00f6rt\u00e9nt egy PSB lefoglal\u00e1s\u00e1ra tett k\u00eds\u00e9rlet sor\u00e1n. Az IMSID be\u00e1ll\u00edt\u00e1sa DL/I hozz\u00e1f\u00e9rt jelez, de nincs megadva PSB"},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "Az RBD \u00fcgyf\u00e9l \u00e9s hoszt verzi\u00f3sz\u00e1mok nem kompatibilisek. RBD \u00fcgyf\u00e9l verzi\u00f3sz\u00e1m:{0} Hoszt verzi\u00f3sz\u00e1m:{1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "Hiba t\u00f6rt\u00e9nt egy h\u00edv\u00e1sb\u00f3l hosztprogramnak visszaadott adatok lek\u00e9r\u00e9se sor\u00e1n. {0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "Hiba t\u00f6rt\u00e9nt a PCB lek\u00e9r\u00e9se sor\u00e1n. PCB index:{0}, PCB-k sz\u00e1ma:{1}"},
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
