/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle_it extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "L''errore si \u00e8 verificato in {0}." },
		{ Message.FUNCTION_ERROR_INFO, "L''errore si \u00e8 verificato in {0} durante l''elaborazione della funzione {1}." },
		{ Message.FILE_ERROR_INFO, "L''errore si \u00e8 verificato in {0} durante l''elaborazione della funzione {1} alla riga {2}." },
		{ Message.PROPERTIES_FILE_MISSING, "Impossibile caricare il file delle propriet\u00e0 {0}." },
		{ Message.LOAD_LIBRARY_FAILED, "Impossibile caricare la libreria {0}. Si \u00e8 verificato il seguente errore: {1}." },
		{ Message.CREATE_OBJECT_FAILED, "Si \u00e8 verificato un errore durante la creazione di un oggetto di tipo {0}. Si \u00e8 verificato il seguente errore: {1}." },
		{ Message.INITIAL_CONTEXT_ERROR, "Si \u00e8 verificato un errore durante la creazione di InitialContext o durante la ricerca nell''ambiente java:comp/env. Si \u00e8 verificato il seguente errore: {0}" },
		{ Message.LISTENER_ERROR, "Si \u00e8 verificata la seguente eccezione con messaggio. Eccezione: {0}. Messaggio: {1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "\u00c8 richiesto un valore per la propriet\u00e0 {0}." },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "Dipendenza esterna mancante. Si \u00e8 verificata la seguente eccezione. Eccezione: {0}" },
		{ Message.UNSUPPORTED_COMPARE, "Impossibile confrontare gli operandi {0} e {1}." },
		{ Message.ASSIGNMENT_OVERFLOW, "Si \u00e8 verificato un errore di overflow durante l''assegnazione del valore {0} a {1}." },
		{ Message.EXPRESSION_OVERFLOW, "Si \u00e8 verificato un errore di overflow durante il calcolo della seguente espressione: {0}." },
		{ Message.UNSUPPORTED_OPERANDS, "L''operatore {0} non \u00e8 supportato per gli operandi {1} e {2}." },
		{ Message.UNSUPPORTED_OPERAND, "L''operatore {0} non \u00e8 supportato per l''operando {1} di tipo {2}." },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "L''operatore script secondario non \u00e8 supportato per l''operando {0} di tipo {1}." },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "L''operatore stringa secondaria non \u00e8 supportato per l''operando {0} di tipo {1}." },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "L''istruzione SET EMPTY non \u00e8 supportata per l''operando {0} di tipo {1}." },
		{ Message.INVALID_REGULAR_EXPRESSION, "Si \u00e8 verificato un errore nell''espressione regolare {0}. Errore: {1}." },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "Quando si utilizza il protocollo CICSSSL, \u00e8 necessario specificare sia ctgKeyStore che ctgKeyStorePassword." },
		{ Message.INVALID_CTGPORT, "Il valore {0} per la voce ctgport non \u00e8 corretto." },
		{ Message.CTG_CONNECT_FAILED, "Si \u00e8 verificato un errore durante la connessione a CTG. Il percorso di CTG \u00e8 {0}. La porta di CTG \u00e8 {1}. Si \u00e8 verificato il seguente errore: {2}" },
		{ Message.CTG_DISCONNECT_FAILED, "Si \u00e8 verificato un errore durante la disconnessione da CTG. Il percorso di CTG \u00e8 {0}. La porta di CTG \u00e8 {1}. Si \u00e8 verificato il seguente errore: {2}" },
		{ Message.NO_CICS, "Si \u00e8 verificato un errore durante la chiamata al programma {0} che utilizza CICS ECI. Il codice di restituzione \u00e8 -3 (ECI_ERR_NO_CICS). L''identificativo del sistema CICS \u00e8 {1}." },
		{ Message.CICS_DIED, "Si \u00e8 verificato un errore durante la chiamata al programma {0} che utilizza CICS ECI. Il codice di restituzione \u00e8 -4 (ECI_ERR_CICS_DIED). L''identificativo del sistema CICS \u00e8 {1}." },
		{ Message.CICS_TIMEOUT, "Si \u00e8 verificato un errore durante la chiamata al programma {0} che utilizza CICS ECI. Il codice di restituzione \u00e8 -6 (ECI_ERR_RESPONSE_TIMEOUT). L''identificativo del sistema CICS \u00e8 {1}." },
		{ Message.CICS_TRANSACTION_ABEND, "Si \u00e8 verificato un errore durante la chiamata al programma {0} che utilizza CICS ECI. Il codice di restituzione \u00e8 -7 (ECI_ERR_TRANSACTION_ABEND). L''identificativo del sistema CICS \u00e8 {1}. Il codice di chiusura \u00e8 {2}." },
		{ Message.CICS_UNKNOWN_SERVER, "Si \u00e8 verificato un errore durante la chiamata al programma {0} che utilizza CICS ECI. Il codice di restituzione \u00e8 -22 (ECI_ERR_UNKNOWN_SERVER). L''identificativo del sistema CICS \u00e8 {1}." },
		{ Message.CICS_SECURITY_ERROR, "Si \u00e8 verificato un errore durante la chiamata al programma {0} che utilizza CICS ECI. Il codice di restituzione \u00e8 -27 (ECI_ERR_SECURITY_ERROR). L''identificativo del sistema CICS \u00e8 {1}." },
		{ Message.CICS_MAX_SYSTEMS, "Si \u00e8 verificato un errore durante la chiamata al programma {0} che utilizza CICS ECI. Il codice di restituzione \u00e8 -28 (ECI_ERR_MAX_SYSTEMS). L''identificativo del sistema CICS \u00e8 {1}." },
		{ Message.CICS_NONZERO_RETURN_CODE, "Si \u00e8 verificato un errore durante la chiamata al programma {0} sul sistema {1} per l''utente {2} I codici di restituzione {3} e di chiusura {4} sono stati restituiti dalla chiamata CICS ECI." },
		{ Message.CICS_COMMIT_FAILED, "Si \u00e8 verificato un errore durante la chiamata CICS ECI per eseguire il commit di un''unit\u00e0 di lavoro. Il codice di restituzione CICS \u00e8 {0}." },
		{ Message.CICS_ROLLBACK_FAILED, "Si \u00e8 verificato un errore durante la chiamata CICS ECI per eseguire il rollback di un''unit\u00e0 di lavoro. Il codice di restituzione CICS \u00e8 {0}." },
		{ Message.CICS_ECI_FLOW_FAILED, "Si \u00e8 verificata un''eccezione sul flusso di una richiesta ECI al sistema CICS {0}. Eccezione: {1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "Errore di lunghezza di un parametro. Il flusso ha {0} parametri e la funzione locale ha {1}." },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "\u00c8 stata superata la dimensione massima per l''array {0}." },
		{ Message.WRONG_NUMBER_OF_PARMS, "Il programma richiamato {0} era in attesa di {1} parametri ma ne sono stati trasmessi {2}." },
		{ Message.FUNCTION_NOT_FOUND, "Si \u00e8 verificato un errore durante il richiamo dell''indirizzo del punto di ingresso {0} con la libreria condivisa {1}. Il codice di restituzione \u00e8 {2}." },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "Si \u00e8 verificato un errore durante il caricamento della libreria condivisa {0}. Il codice di restituzione \u00e8 {1}." },
		{ Message.CALL_NONZERO_RETURN_CODE, "Il programma richiamato ha avuto esito negativo con codice di restituzione {0}." },
		{ Message.REMOTE_PROGRAM_ERROR, "Si \u00e8 verificato un errore nel programma remoto {0} sul sistema {3}. L''errore si \u00e8 verificato su {1} in {2}. {4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "Si \u00e8 verificato un errore nel programma remoto {0} sul sistema {1}. {2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "Il nome host {0} ha un nome host TCP/IP sconosciuto." },
		{ Message.SERVERID_IS_INVALID_PORT, "L''ID server {0} non ha un numero di porta valido." },
		{ Message.TCPIP_SERVER_ERROR, "Il client ha ricevuto la notifica che il server non \u00e8 riuscito ad avviare il programma chiamato in remoto. Codice motivo: {0}." },
		{ Message.INVALID_REMOTECOMTYPE, "Il valore remoteComType manca o non \u00e8 corretto." },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "Impossibile aprire il file propriet\u00e0 collegamento {0}." },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "Impossibile trovare una voce relativa al programma richiamato {0} nel file propriet\u00e0 collegamento {1}." },
		{ Message.AS400_UNKNOWN_HOST, "Impossibile trovare il nome host {0} o non \u00e8 noto." },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "La password o l''ID utente non \u00e8 corretto per connettersi al sistema {0}. Errore: {1}" },
		{ Message.AS400_EXCEPTION_CAUGHT, "Si \u00e8 verificato un errore di esecuzione {0} AS400Toolbox durante la chiamata la programma {2} sul sistema {3}. Errore: {1}" },
		{ Message.AS400_NO_AUTHORITY, "Si \u00e8 verificato un errore di sicurezza di accesso remoto al sistema {0} per l''utente {1}. Errore: {2}" },
		{ Message.REMOTE_COMMIT_FAILED, "Una funzione di commit ha avuto esito negativo sul sistema {0}. Errore: {1}" },
		{ Message.REMOTE_ROLLBACK_FAILED, "La funzione di rollback ha avuto esito negativo sul sistema {0}. Errore: {1}" },
		{ Message.AS400_CONNECTION_ERROR, "Si \u00e8 verificato un errore di connessione remota durante l''accesso al sistema {0}. Errore: {1}" },
		{ Message.AS400_SERVER_NOT_FOUND, "Si \u00e8 verificato un errore EGL OS/400 Host Services. Impossibile trovare i file richiesti sul sistema {0}." },
		{ Message.AS400_APPLICATION_ERROR, "L''unit\u00e0 di esecuzione \u00e8 stata arrestata a causa di un errore di applicazione verificatosi sul sistema {0} durante la chiamata al programma {1}. Messaggio: {2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "La variabile di riferimento {0} \u00e8 null." },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "Si \u00e8 verificato un errore non gestito. Errore: {0}." },
		{ Message.DATA_FORMAT_ERROR, "Il valore della variabile {0} non ha il formato corretto." },
		{ Message.CONVERSION_ERROR, "Il valore {0} di tipo {1} non pu\u00f2 essere convertito nel tipo {2}." },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "Il modello di formato data {0} non \u00e8 valido." },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "Il modello di formato ora {0} non \u00e8 valido." },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "Il modello di formato data/ora {0} non \u00e8 valido." },
		{ Message.NULL_REFERENCE, "\u00c8 stato utilizzato un riferimento null." },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "Accesso dinamico non supportato per {0}." },
		{ Message.DYNAMIC_ACCESS_FAILED, "Impossibile trovare un campo con identificativo {0} in {1}." },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "Il modello di formato numerico {0} non \u00e8 valido." },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "Si \u00e8 verificato un errore durante l''assegnazione di {0} a {1}. Errore: {2}." },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "Si \u00e8 verificato un errore nell''istruzione SET {0} EMPTY. Errore: {1}." },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "Si \u00e8 verificato un errore {0} durante il richiamo del metodo con una firma {1}." },
		{ Message.RUN_COMMAND_FAILED, "Si \u00e8 verificato un errore durante l''esecuzione del comando {0}.  Errore: {1}." },
		{ Message.MDY_ERROR, "La funzione DateTimeLib.mdy non riesce a convertire i valori {0}, {1} e {2} in mese, giorno e anno." },
		{ Message.NON_NUMERIC_STRING, "A {0} \u00e8 stata passata la stringa non numerica {1}. Tutti i caratteri nella porzione della stringa definita dall''argomento lunghezza devono essere numerici." },
		{ Message.SYSTEM_FUNCTION_ERROR, "{0} non \u00e8 riuscita con il messaggio di errore {1}." },
		{ Message.INT_AS_CHAR_ERROR, "L''argomento per StrLib.intAsChar deve essere un numero compreso tra 0 e 255." },
		{ Message.INVALID_LOB_LENGTH, "{0} non \u00e8 una lunghezza valida per {1} che ha dimensione {2}." },
		{ Message.INVALID_LOB_POSITION, "{0} non \u00e8 una posizione valida per {1}. La sua dimensione \u00e8 {2}." },
		{ Message.LOB_ERROR, "Si \u00e8 verificato un errore durante l''elaborazione di un elemento Blob o Clob.  il messaggio di errore \u00e8 {0}" },
		{ Message.START_TRANSACTION_ERROR, "VGLib.startTransaction alla classe {0} non \u00e8 riuscita. L''eccezione \u00e8: {1}" },
		{ Message.INT_AS_UNICODE_ERROR, "L''argomento per StrLib.intAsUnicode deve essere un numero compreso tra 0 e 65535." },
		{ Message.INVALID_ARRAY_SIZE, "Il valore della dimensione {0} non \u00e8 valido per l''array {1}. La dimensione massima \u00e8 {2}." },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "L''indice {0} \u00e8 fuori limite per l''array {1}. La dimensione dell''array \u00e8 {2}." },
		{ Message.INVALID_SUBSTRING_INDEX, "Indici di stringa secondaria non validi {0}:{1}." },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "L''argomento della funzione per l''array {0} non \u00e8 valido." },
		{ Message.INDEX_OUT_OF_BOUNDS, "Il valore indice {0} \u00e8 fuori limite." },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "{0} \u00e8 una tabella di conversione non supportata." },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "Impossibile leggere il file csouidpwd.properties. Errore: {0}" },
		{ Message.CALL_PARMS_TOO_LARGE, "Il buffer del client \u00e8 troppo piccolo per la quantit\u00e0 di dati da trasferire con la chiamata. La dimensione totale dei parametri da trasferire \u00e8 {0} byte e supera la quantit\u00e0 massima consentita di {1} byte." },
		{ Message.INVALID_PARMFORM, "La propriet\u00e0 di collegamento parmForm deve essere impostata su COMMPTR per chiamare il programma {0} dal momento che almeno un parametro \u00e8 un array dinamico." },
		{ Message.PARM_PASSING_ERROR, "Si \u00e8 verificato un errore durante il trasferimento di parametri al programma richiamato {0}. Errore: {1}" },
		{ Message.CALL_ERROR, "Si \u00e8 verificato un errore nella chiamata al programma {0}. Errore: {1}" },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "{0} \u00e8 un tipo di parametro non supportato per i programmi di servizio System i." },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "{0} \u00e8 un tipo di restituzione non supportato per i programmi di servizio System i." },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "Impossibile ottenere ConnectionFactory. Eccezione: {0}" },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "Impossibile chiudere l''interazione o la connessione. Errore: {0}" },
		{ Message.ERROR_GETTING_CONNECTION, "Impossibile stabilire una connessione. Errore: {0}" },
		{ Message.ERROR_GETTING_INTERACTION, "Impossibile ottenere un''interazione. Eccezione: {0}" },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "Impossibile ottenere un''espressione di interazione. Eccezione: {0}" },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "Impossibile ottenere un LocalTransaction per l''unit\u00e0 di lavoro client. Eccezione: {0}" },
		{ Message.ERROR_SETTING_TIMEOUT, "Impossibile impostare il valore di timeout su una chiamata CICSJ2C. Eccezione: {0}" },
		{ Message.EXCEPTION_CALLING_CICS, "Si \u00e8 verificato un errore durante un tentativo di comunicazione con CICS. Eccezione: {0}" },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "Tentativo di eseguire la transazione CICS remota non riuscito." },
		{ Message.EXCEPTION_CALLING_IMS, "Si \u00e8 verificato un errore durante un tentativo di comunicazione con IMS. Eccezione: {0}" },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "Si \u00e8 verificato un errore durante un tentativo di comunicazione con IMS." },
		{ Message.MATH_DOMAIN_ERROR, "{0} non \u00e8 riuscito con il codice di errore 8 (errore di dominio). Un argomento per la funzione non \u00e8 valido." },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "{0} non \u00e8 riuscito con il codice di errore 8 (errore di dominio). L''argomento deve essere compreso tra -1 e 1." },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "{0} non \u00e8 riuscito con il codice di errore 8 (errore di dominio). Il secondo argomento non deve essere 0." },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "{0} non \u00e8 riuscito con il codice di errore 8 (errore di dominio). L''argomento deve essere maggiore di zero." },
		{ Message.MATH_POW_1_DOMAIN_ERR, "MathLib.pow non \u00e8 riuscito con il codice di errore 8 (errore di dominio). Se il primo argomento \u00e8 zero, il secondo deve essere maggiore di zero." },
		{ Message.MATH_POW_2_DOMAIN_ERR, "MathLib.pow non \u00e8 riuscito con il codice di errore 8 (errore di dominio). Se il primo argomento \u00e8 inferiore a zero, il secondo deve essere un numero intero." },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "MathLib.sqrt non \u00e8 riuscito con il codice di errore 8 (errore di dominio). L''argomento deve essere maggiore o uguale a zero." },
		{ Message.MATH_RANGE_ERROR, "{0} non \u00e8 riuscito con codice di errore 12 (errore di intervallo)." },		
		{ Message.STRING_INDEX_ERROR, "{0} non \u00e8 riuscito con il codice di errore 8. L''indice deve rientrare tra 1 e la lunghezza della stringa." },
		{ Message.STRING_LENGTH_ERROR, "{0} non \u00e8 riuscito con il codice di errore 12. La lunghezza deve essere maggiore di zero." },
		{ Message.STRING_NULT_ERROR, "StrLib.setNullTerminator non \u00e8 riuscito con il codice di errore 16. L''ultimo byte della stringa di destinazione deve essere uno spazio vuoto o un carattere null." },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "{0} non \u00e8 riuscito con codice di errore 20. L''indice di una stringa secondaria STRING, DBCHAR o UNICODE deve essere dispari cos\u00ec che l''indice identifica il primo byte di un carattere." },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "{0} non \u00e8 riuscito con il codice di errore 24. La lunghezza di una stringa secondaria STRING, DBCHAR o UNICODE deve essere pari per fare riferimento ad un numero intero di caratteri." },
		{ Message.NO_DEBUG_LISTENER, "Impossibile contattare il programma di debug EGL nel nome host {0} e nella porta {1}. Eccezione: {2}" },
		{ Message.DEBUG_LISTENER_PROBLEM, "Si \u00e8 verificato un errore durante la comunicazione con il programma di debug EGL nel nome host {0} e nella porta {1}. Eccezione: {2}" },
		{ Message.NOT_DEBUG_MODE, "Il collegamento ha specificato una chiamata DEBUG in un server J2EE. La chiamata non \u00e8 stata effettuata su un server J2EE, tale server non si trova in modalit\u00e0 debug o non \u00e8 stato abilitato per il debug EGL." },
		{ Message.LIBRARY_NOT_SPECIFIED, "Il collegamento ha specificato una chiamata DEBUG a un listener EGL ma non ha specificato la propriet\u00e0 della libreria." },
		
		{ Message.FILETYPE_MISSING, "Impossibile trovare la propriet\u00e0 runtime vgj.ra.fileName.fileType per il file {0}." },
		{ Message.FILETYPE_INVALID, "Il valore della propriet\u00e0 runtime vgj.ra.fileName.fileType non \u00e8 valido per il file {0}." },
		{ Message.INVALID_RECORD_LENGTH, "L''elemento lunghezza deve contenere un valore che spezza dati non di carattere ai confini dell''elemento." },
		{ Message.RECORD_LENGTH_TOO_LARGE, "Il valore in occursItem o lengthItem \u00e8 troppo elevato." },
		{ Message.IO_ERROR, "{0}: I/O con {1} non \u00e8 riuscito per questo motivo: {2}." },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0}: istruzione preparata {1} non trovata[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0}: serie di risultati {1} non trovata[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_ERROR, "{0}: errore[sqlstate:{1}][sqlcode:{2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0}: [sqlstate:02000][sqlcode:100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0}: {1}[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_CONNECTION_FAILED, "Impossibile collegarsi a {0}: {1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "Impossibile collegarsi a {0}, L''URL del database potrebbe essere errato: {1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "Si \u00e8 verificato un errore durante il caricamento dei driver JDBC.  Errore: {0}" },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "Impossibile scorrere la serie di risultati {0}." },
		{ Message.SQL_NO_DEFAULT_DATABASE, "Impossibile collegarsi al database predefinito. Il nome del database predefinito non era specificato." },
		{ Message.SQL_NO_DATABASE_CONNECTION, "\u00c8 necessario stabilire una connessione al database prima di un''operazione SQL I/O." },
		{ Message.SQL_DISCONNECT_ERROR, "Si \u00e8 verificato un errore durante la disconnessione del database {0}. {1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "Impossibile stabilire una connessione al database {0}. La connessione non esiste." },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "Si \u00e8 verificato un errore SQL nella funzione SQLLib.{0}: {1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "Si \u00e8 verificato un errore non-SQL nella funzione SQLLib.{0}: {1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "\u00c8 stato ricevuto nullo dal database ma la variabile host {0} non consente valori nulli." },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "Non \u00e8 stato ricevuto alcun input per il campo obbligatorio: riprovare." },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "Errore di tipo dati nell''input: riprovare." },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "Numero di cifre consentite superato: riprovare." },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "L''input non \u00e8 compreso nell''intervallo definito da {0} a {1}: riprovare." },
		{ Message.EDIT_VALID_VALUES_ERR, "L''input non \u00e8 compreso nell''intervallo valido di valori: riprovare." },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "Il formato data e ora specificato di {0} non \u00e8 valido." },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "Errore nella lunghezza minima di input: riprovare." },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "Errore nella lunghezza massima di input: riprovare." },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "Errore di validit\u00e0 nella modifica della tabella: riprovare." },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "Errore nel controllo modulus in fase di input: riprovare." },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "L''input non \u00e8 valido per il formato data o ora definito {0}." },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "Input non valido per campo booleano." },
		{ Message.EDIT_INVALID_PATTERN_ERR, "Valore immesso non valido perch\u00e9 non riscontra il modello impostato." },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "Tabella di modifica {0} non definita per {1}." },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "Dati esadecimali non validi." },
		{ Message.EDIT_VALIDATION_ERR, "Si \u00e8 verificato un errore di convalida pagina.  Errore: {0}." },
		{ Message.EDIT_INPUT_ERR, "Errore durante l''analisi del valore immesso."},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "Errore durante la formattazione del valore per la visualizzazione: {0}."},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "I dati di input con i caratteri SO/SI sono troppo lunghi per la lunghezza elemento definita."},
		
		{ Message.ACTION_REQUEST_ERROR, "Funzione J2EELib RequestAttr non riuscita con chiave, {0}. Errore: {1}" },
		{ Message.ACTION_SESSION_ERROR, "Funzione J2EELib SessionAttr non riuscita con chiave, {0}. Errore: {1}" },
		{ Message.ACTION_APPLICATION_ERROR, "Funzione J2EELib ApplicationAttr non riuscita con chiave, {0}. Errore: {1}" },
		{ Message.ACTION_NO_J2EE_ERROR, "J2EELib pu\u00f2 essere utilizzato solo nell''ambiente J2EE." },
		
		{ Message.PORTALLIB_SESSION_ERROR, "Funzione PortalLib PortletSessionAttr non riuscita con chiave {0}. Errore: {1}" },
		{ Message.PORTALLIB_MODE_ERROR, "PortalLib setPortletMode non riuscito. Errore: {0}" },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "PortalLib setWindowState non riuscito. Errore: {0}" },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "Tentativo non consentito di modificare la modalit\u00e0 Portlet durante la richiesta di rendering" },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "Tentativo non consentito di modificare lo stato della finestra Portlet durante la richiesta di rendering" },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "Richiamo di PortletSession non riuscito" }, 
		{ Message.PORTALLIB_INVALIDKEY, "Una chiave non valida \u00e8 stata trasmessa alla funzione {0}" }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "Richiamo di PortletRequest non riuscito" }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "Funzione PortalLib resetPreferenceValue non riuscita con chiave {0}. Errore: {1}" },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "Funzione PortalLib savePreferences non riuscita. Errore: {0}" },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "PortalLib non \u00e8 riuscito ad impostare la preferenza per la chiave {0}. Errore: {1}" }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "PortalLib non \u00e8 riuscito a richiamare la preferenza per la chiave {0}. Errore: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "Accesso al servizio vault credenziali non riuscito. Errore: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "Accesso alla credenziale richiesta nello slot {0} non riuscito. Errore: {1}" },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "Creazione slot del vault credenziali nello spazio utente non riuscita. Errore: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "Eliminazione slot del vault credenziali nello spazio utente non riuscita. Errore: {0}" },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "Impostazione dei valori di credenziale non riuscita. Errore: {0}" },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "{0} non riuscito. Richiamare un metodo o accedere ad un campo denominato {1} \u00e8 risultato in un errore non gestito. il messaggio di errore \u00e8 {2}" },
		{ Message.JAVALIB_NULL_ID, "{0} non riuscito. {1} non \u00e8 un identificativo o \u00e8 l''identificativo di un oggetto null." },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "{0} non riuscito. Un metodo, campo, o classe pubblici denominati {1} non esistono o non possono essere caricati, oppure il numero o i tipi di parametri non sono corretti. il messaggio di errore \u00e8 {2}" },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "{0} non riuscito. Il tipo di un valore in EGL non corrisponde al tipo atteso in Java per {1}. il messaggio di errore \u00e8 {2}" },
		{ Message.JAVALIB_NULL_RETURNED, "{0} non riuscito. La destinazione \u00e8 un metodo che ha restituito null, un metodo che non restituisce un valore, o un campo il cui valore \u00e8 null." },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "{0} non riuscito. Impossibile caricare la classe {1} di un argomento null. il messaggio di errore \u00e8 {2}" },
		{ Message.JAVALIB_ACCESS_ERROR, "{0} non riuscito. Impossibile reperire informazioni sul metodo o sul campo denominati {1}, oppure \u00e8 stato fatto un tentativo di impostare il valore di un campo dichiarato finale. il messaggio di errore \u00e8 {2}" },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "{0} non riuscito. {1} \u00e8 un''interfaccia o una classe astratta, cos\u00ec \u00e8 impossibile chiamare il costruttore." },
		{ Message.JAVALIB_NOT_STATIC, "{0} non riuscito. Il metodo o il campo {1} non sono statici. Deve essere utilizzato un identificativo al posto di un nome classe." },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "Il campo azione {0} non esiste." },
		{ Message.CUI_E_ARRAY_FULL, "Impossibile inserire una nuova riga perch\u00e9 l''array di input \u00e8 pieno." },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "Impossibile trovare l''array {0}." },
		{ Message.CUI_E_ASSIGN_RESULT, "Assegnazione alla variabile di richiesta risultati non riuscita." },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "La dimensione {0} per il campo Array schermo non \u00e8 corretta"	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "I parametri DrawBox non sono compresi nell''intervallo." },
		{ Message.CUI_E_BAD_COORDINATES, "Le coordinate di visualizzazione sono esterne ai margini della finestra." },
		{ Message.CUI_E_BAD_KEYNAME, "Nome chiave non corretto ''{0}''." },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "Non \u00e8 possibile utilizzare questa funzione di modifica perch\u00e9 \u00e8 presente un''immagine." },
		{ Message.CUI_E_BAD_WINDOW_NAME, "Impossibile trovare la finestra ''{0}''." },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "I nuovi valori della posizione[{0},{1}]/dimensione[{2},{3}] della finestra non sono validi." },
		{ Message.CUI_E_CMDSTACK_SYNC, "Lo stack di comando \u00e8 fuori sincronizzazione." },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "La libreria dell''UI della Console non \u00e8 stata inizializzata." },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "Tipo di campo non valido per il costrutto." },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "Impossibile chiamare ConstructQuery con un elenco di variabili." },
		{ Message.CUI_E_DISABLE_INVISIBLE, "Impossibile disabilitare una voce di menu invisibile." },
		{ Message.CUI_E_EDIT_FAILED, "Azione non riuscita." },
		{ Message.CUI_E_EXEC_HOTKEY, "Si \u00e8 verificato un errore durante l''esecuzione dell''azione hotkey." },
		{ Message.CUI_E_EXIT_NO_CMD, "Nessun comando attivo da chiudere." },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "Nessun comando attivo da proseguire." },
		{ Message.CUI_E_FATALERROR, "Errore irreversibile: {0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "Il campo {0} non esiste." },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "Il campo Array schermo {0} non \u00e8 un array." },
		{ Message.CUI_E_FIELD_NOT_FOUND, "Impossibile trovare il campo {0}." },
		{ Message.CUI_E_FIELD_NO_WINDOW, "Impossibile creare ConsoleField senza una finestra." },
		{ Message.CUI_E_FIELD_COUNT, "Conteggio campi dell''array non corrispondente." },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "Il modulo {0} non esiste." },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "Il modulo {0} non pu\u00f2 essere contenuto nella finestra {1}." },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "Gli elenchi dei campi non corrispondono." },
		{ Message.CUI_E_FORM_IN_USE, "Il modulo {0} \u00e8 occupato." },
		{ Message.CUI_E_FORM_NAME_USED, "Esiste gi\u00e0 un modulo con nome {0}." },
		{ Message.CUI_E_FORM_NOT_OPEN, "Il modulo {0} non \u00e8 aperto." },
		{ Message.CUI_E_FORM_NO_WINDOW, "Impossibile creare ConsoleForm senza una finestra." },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "Impossibile utilizzare KeyObject.getChar() per i tasti virtuali." },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "Impossibile utilizzare KeyObject.getCookedChar() per i tasti virtuali." },
		{ Message.CUI_E_INTERNAL, "ERRORE INTERNO: {0}" },
		{ Message.CUI_E_INTR_RECEIVED, "\u00c8 stato ricevuto un segnale di interruzione." },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "Impossibile avere una voce di menu invisibile senza tasto di scelta rapida." },
		{ Message.CUI_E_LABEL_NO_WINDOW, "Impossibile creare una ConsoleLabel senza una finestra." },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "La voce di menu {0} non pu\u00f2 essere contenuta nella finestra." },
		{ Message.CUI_E_MISSING_ITEM, "La voce di menu {0} non esiste." },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "Gli mnemonici generano conflitti (tasto={0})." },
		{ Message.CUI_E_NO_ACTIVE_FORM, "Non esiste un modulo attivo." },
		{ Message.CUI_E_NO_EDITOR, "Non \u00e8 stato specificato un editor blob." },
		{ Message.CUI_E_NO_HELP_FILE, "Non \u00e8 stato specificato un file di aiuto." },
		{ Message.CUI_E_NO_HELP_MSG, "Non \u00e8 stato specificato un messaggio di aiuto." },
		{ Message.CUI_E_NO_NUMPAGES, "Il menu non \u00e8 visualizzato." },
		{ Message.CUI_E_NO_SCREENARRAY, "Non sono presenti array schermo attivi." },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "Non sono presenti voci di menu visibili." },
		{ Message.CUI_E_NULL_WNDOW_NAME, "Il nome relativo alla nuova finestra era null." },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "Si \u00e8 tentato di aprire una finestra null." },
		{ Message.CUI_E_PROMPT_EXCEPTION, "Si \u00e8 verificata un''eccezione nella richiesta." },
		{ Message.CUI_E_QUIT_RECEIVED, "\u00c8 stato ricevuto un segnale QUIT." },
		{ Message.CUI_E_SCROLL_FAILED, "Impossibile scorrere alla voce corrente del menu." },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "Attributo sconosciuto ''{0}''" },
		{ Message.CUI_E_VALIDATE_FIELD, "Il campo {0} contiene un errore." },
		{ Message.CUI_E_VAR_LIST_SHORT, "Non sono state fornite sufficienti variabili." },
		{ Message.CUI_E_WINDOW_NAME_USED, "Il nome della finestra {0} \u00e8 gi\u00e0 utilizzato." },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "La dimensione della finestra \u00e8 troppo piccola per la schermata della guida." },
		{ Message.CUI_E_VALID_VALUES, "Il valore specificato non \u00e8 valido." },
		{ Message.CUI_W_NO_MORE_FIELDS, "Non vi sono campi disponibili nella direzione scelta." },
		{ Message.CUI_W_NO_MORE_ROWS, "Non vi sono righe disponibili nella direzione scelta." },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "Il contenuto dell''array schermo {0} non \u00e8 valido." },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "L''array schermo {0} non pu\u00f2 contenere il campo {1} segmentato."	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "L''array schermo {0} non \u00e8 compatibile con l''array dati." },
		{ Message.CUI_E_FIELD_NAME_DUP, "Il nome campo {0} \u00e8 utilizzato pi\u00f9 volte." },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "La lunghezza del campo console {0} non \u00e8 valida." },
		{ Message.CUI_E_LABEL_NOT_FIT, "L''etichetta su [{0}, {1}] \u00e8 di dimensioni eccessive per lo spazio disponibile." },
		{ Message.CUI_E_FIELD_NOT_FIT, "Il segmento campo {0} su ({1}, {2}) \u00e8 di dimensioni eccessive per lo spazio disponibile." },
		{ Message.CUI_E_PROMPT_TOO_LONG,"La stringa di comando \u00e8 troppo lunga per la finestra attiva."},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"Gli argomenti dell''array OpenUI non sono validi."},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, "Gli argomenti del campo OpenUI non sono validi."},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "Ad una istruzione di comando \u00e8 possibile assegnare una sola variabile." },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "Impossibile determinare il binding di dati per il campo console {0}." },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "Avviso: caratteri NULL trovati nei dati clob" },
		{ Message.CUI_I_STR_WINDOWTITLE , "Finestra Console EGL" },
		{ Message.CUI_E_MISSING_FORMAT , "Il campo {0} non ha oggetto formato." },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "Le due voci non sono le stesse, riprovare" },
		{ Message.CUI_I_STR_VERIFY_INPUT, "Immettere nuovamente per la verifica" },
		{ Message.CUI_I_STR_HELP,"Guida"},
		{ Message.CUI_I_STR_RESUME,"Riprendi"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"Termina questa sessione di aiuto."},
		{ Message.CUI_I_STR_SCROLL , "Scorri" },
		{ Message.CUI_I_STR_LAST_PAGE, "\u00c8 stata raggiunta la fine del testo di aiuto. Scegliere RETURN per continuare."},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "Visualizza la pagina successiva del testo di aiuto."},
		{ Message.CUI_I_STR_SELECT , "SELEZIONA"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "Errore durante l''inserimento della prima riga in un array vuoto."},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "F25-F64 non implementato."},
		{ Message.CUI_E_UNIMP_FN_KEYS , "INTERNO: F25-64 non implementato" },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "Non \u00e8 possibile avere pi\u00f9 istanze di CursesCanvas" },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "CursesCanvas non inizializzato" },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "CursesCanvas troppo piccolo"},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "Visualizzazione campi per nome non implementata"},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "Richiesto input minimo {0}: riprovare." },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "Input massimo {0} superato - riprovare." },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "Impossibile aprire il file di script ''{0}''." },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "Impossibile leggere il file di script."},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "La propriet\u00e0 automation.scenario ''{0}'' non \u00e8 una directory."},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "Direttiva <click> non valida in script replay."},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "Impossibile ottenere la propriet\u00e0 di automazione ''{0}''."},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "Nome chiave panic ''{0}'' non valido"},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "Eccezione in <click>."},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "Impossibile aprire il file di istantanea ''{0}''"},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "La propriet\u00e0 impostata per automation.scriptdir ''{0}'' non esiste."},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "Impossibile creare la propriet\u00e0 impostata per la directory automation.scenario ''{0}''."},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "Nome chiave istantanea ''{0}'' non valido"},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "Comparazione ok."},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "L''uso di operazioni I/O di visualizzazione non \u00e8 consentito durante l''esecuzione in modalit\u00e0 RCP."},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "Un messaggio con ID {0} non esiste nella tabella dei messaggi {1}." },
		{ Message.MSG_TBL_LOAD_ERR, "Impossibile caricare il file della tabella dei messaggi {0}." },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "Nessuna tabella dei messaggi utente definita per VGUIRecord {0}." },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "Il campo ''{0}'' nella posizione ({1},{2}) non \u00e8 contenuto nel modulo." },
		{ Message.TUI_E_FIELD_OVERLAP, "Il campo ''{0}'' si sovrappone a ''{1}''." },
		{ Message.TUI_E_NO_FORMGROUP, "Errore interno: impossibile determinare il gruppo di moduli." },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "Il modulo ''{0}'' non pu\u00f2 essere contenuto in nessuna area mobile." },
		{ Message.TUI_E_BAD_FIELD_COORDS, "Le coordinate del campo ''{0}'' non sono valide." },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "Impossibile richiamare le associazioni di stampa." },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "Non esiste alcuna dimensione di dispositivo di stampa adatta." },
		{ Message.TUI_E_NO_DISPLAY, "Non esiste alcun dispositivo di visualizzazione per i moduli." },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "Nessuna dimensione di dispositivo compatibile per i moduli visualizzati." },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "La classe dei moduli di aiuto ''{0}'' non esiste." },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "Attributo sconosciuto ''{0}''." },
		{ Message.TUI_E_INVALID_VALID_VALUE, "Il valore specificato nell''attributo dei valori validi non \u00e8 corretto e non pu\u00f2 essere analizzato." },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "Impossibile creare il modulo di aiuto ''{0}''" },
		{ Message.TUI_E_INTERNAL, "ERRORE INTERNO: {0}" },
		{ Message.TUI_E_NO_PRINTERS, "Non sono disponibili stampanti." },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "Non \u00e8 presente una stampante predefinita." },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "La stampante ''{0}'' non \u00e8 stata trovata.\nSono disponibili queste stampanti:\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "Errore durante il caricamento del messaggio ''{0}''" },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "Il contenuto di {0} non pu\u00f2 essere utilizzato come un campo." },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "Stampante ''{0}'' non trovata" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "Il programma {0} prevedeva il modulo di testo {1} ma \u00e8 stato fornito il modulo di testo {2} in un''istruzione show." },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "Avanti" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "Pagina {0} di {1}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "Precedente" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "Stampa" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "Anteprima di stampa - {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "Salva" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "Salva lavoro di stampa - {0} " },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "Errore durante la stampa su file: {0}" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "Errore durante la stampa su stampante: {0}" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "Impostazione di EZEMNO" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "Convalida campo ''{0}''" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "Convalida textform" },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "Convalida textform - esecuzione della funzione validator ''{0}''" },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "Impossibile creare il logwriter." },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "Impossibile impostare la registrazione log del parametro ''{0}'' dopo l''avvio." },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "Logdir ''{0}'' non esiste." },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "Impossibile scrivere in logdir ''{0}''." },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "Impossibile creare il logfile ''{0}''." },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "Impossibile scrivere nel logfile ''{0}''." },
		
		{ Message.SOA_E_LOAD_SERVICE, "Si \u00e8 verificato un problema durante il caricamento del servizio per Component/ExternalService {0}." },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "Si \u00e8 verificato un errore durante la creazione di una connessione all''operazione di servizio Web ''{0}''.  {1}." },
		{ Message.SOA_E_WS_GET_OPERATION, "Si \u00e8 verificato un errore durante il richiamo dell''operazione: ''{0}'' dal file wsdl:''{1}''." },
		{ Message.SOA_E_WS_MALFORMED_URL, "L''URL di destinazione per l''operazione del servizio Web {1} non \u00e8 valido. URL: {0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "Si \u00e8 verificato un errore durante il caricamento del servizio {0}. Errore: {1}." },
		{ Message.SOA_E_LOAD_WEB_PROXY, "Si \u00e8 verificato un errore durante il tentativo di caricamento del servizio Web. Impossibile risolvere la porta WSDL per il servizio esterno {0}." },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "Al componente {0} manca la propriet\u00e0 {1} necessaria per l''implementazione del servizio." },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "Il riferimento del servizio ''{0}'' potrebbe mancare o non avere un valore di destinazione." },
		{ Message.SOA_E_MISSING_BINDING, "Binding di servizio:''{0}'' non esiste nel descrittore di distribuzione:''{1}''" },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "Si \u00e8 verificato un errore durante il tentativo di conversione del record ''{0}'' in un messaggio SOAP.  Impossibile trovare il campo ''{1}'' nel record." },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "Si \u00e8 verificato un errore durante il tentativo di conversione di ''{0}'' in un messaggio SOAP."},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "Si \u00e8 verificato un errore durante l''elaborazione di un messaggio di associazione da un servizio Web. Il tipo Java non \u00e8 compatibile con il tipo EGL." },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "Si \u00e8 verificato un errore durante l''elaborazione di un messaggio di associazione in uscita ad un servizio Web. Il tipo EGL non \u00e8 compatibile con il tipo Java." },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "Impossibile inizializzare il record ''{0}''." },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "Impossibile convertire il valore ''{0}'' in un calendario." },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "Impossibile convertire il valore ''{0}'' in un valore booleano." },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "Impossibile convertire il valore ''{0}'' in un byte." },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "Impossibile convertire il valore ''{0}'' in un valore breve." },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "Impossibile convertire il valore ''{0}'' in un URI." },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "Tipo EGL non supportato come parametro di servizio Web." },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "Si \u00e8 verificato un errore durante il tentativo di creare un array di record. {0}." },
		{ Message.SOA_E_METHOD_NOT_FOUND, "Metodo {0} non trovato nel servizio {1}." },
		{ Message.SOA_E_NOT_WEB_SERVICE, "Il servizio non \u00e8 un servizio Web." },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "Si \u00e8 verificato un errore durante il tentativo di richiamare la funzione:{0} su WebService:{1}." },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "Si \u00e8 verificato un errore nel tentativo di richiamare la funzione:{0} sul Servizio EGL:{1}." },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "Si \u00e8 verificato un errore nel tentativo di richiamare la funzione:{0} sul Servizio EGL:{1} mediante {2}:{3}." },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "Il servizio non \u00e8 un servizio tcpip." },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "Si \u00e8 verificato un errore nel tentativo di richiamare la funzione:{0} sul punto d''ingresso:{1}." },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "Si \u00e8 verificato un errore nel tentativo di caricare il file di binding del servizio{0}. {1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "Si \u00e8 verificato un errore nel tentativo di richiamare la funzione:{0} sul Servizio CICS:{1}. Codice di errore:{2}, Messaggio:{3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "Si \u00e8 verificato un errore nel tentativo di richiamare la funzione:{0} sul Servizio iSeries:{1}. Codice di errore:{2}, Messaggio:{3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "Il servizio non \u00e8 un servizio CICS." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "Si \u00e8 verificato un errore nel servizio remoto {0}, data {1}, ora {2}, sul sistema {3}." },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "Si \u00e8 verificato un errore nel servizio remoto {0}, sul sistema {1}." },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "Esecuzione dell''unit\u00e0 terminata a causa di un errore dell''applicazione sul sistema {0} durante il tentativo di richiamare il servizio {1}. Messaggio: {2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "Errore di esecuzione AS400Toolbox: {0}, {1} durante la chiamata al servizio {2} sul sistema {3}." },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "Binding del client di servizi non supportato. {0} \u00e8 stato generato per Websphere, ma \u00e8 stato richiamato da un ambiente non J2EE. Rigenerare in un progetto non J2EE." },
		{ Message.SOA_E_USER_ID_NOT_SET, "L''ID utente remoto ID e la password devono essere impostati prima di richiamare WebService:{0} function:{1}." },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "Si \u00e8 verificata un''eccezione durante la chiamata a un servizio." },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "Si \u00e8 verificata un''eccezione durante la comunicazione con il servizio. URL: {0}" },
		{ Message.SOA_E_WS_PROXY_REST, "Si \u00e8 verificata un''eccezione durante la chiamata di servizio REST. Binding: {0}, Operazione :{0}" },
		{ Message.SOA_E_WS_PROXY_SOAP, "Si \u00e8 verificata un''eccezione durante una chiamata al servizio SOAP. Binding: {0}, Servizio: {1}, Porta: {2}, Percorso WSDL: {3}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "Si \u00e8 verificata un''eccezione durante la conversione da JSON. Parametro: {0}, json: {1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "Si \u00e8 verificata un''eccezione durante la conversione a JSON. Parametro: {0}, Valore: {1}" },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "Non \u00e8 stato trovato nessun servizio REST-RPC. URL: {0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "Non \u00e8 stata ricevuta alcuna risposta dal servizio. URL: {0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "Impossibile convertire la richiesta in una chiamata al servizio. La richiesta ricevuta era ''{0}''. " },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "Timeout della chiamata del servizio. Eccezione: errore di timeout nella lettura della connessione. url:{0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "Il servizio non \u00e8 un servizio rest." },
		{ Message.SOA_E_REST_SERVICE, "La chiamata al servizio REST ha avuto esito negativo. Binding:{0}, Operazione:{1}, Metodo HTTP:{2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "Si \u00e8 verificata un''eccezione durante la conversione dei dati in parametri EGL. Binding:{0}, dati da convertire {1}, eccezione:{2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "\u00c8 stata effettuata una chiamata del servizio REST su un riferimento a un servizio non REST. Riferimento servizio: {0}, Operazione {1}, Metodo HTTP: {2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "Si \u00e8 verificata un''eccezione durante la conversione da XML. Manca l''elemento richiesto {0}." },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "Si \u00e8 verificata un''eccezione durante la conversione da XML. Parametro: {0}, xml: {1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "Si \u00e8 verificata un''eccezione durante la conversione a XML. Parametro: {0}, Valore: {1}" },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "Si \u00e8 verificata un''eccezione di analisi XML durante la conversione di {0} da XML." },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "Si \u00e8 verificata un''eccezione di conversione XML durante la conversione di {0} in XML." },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "L''URL ''{0}'' utilizzato per richiamare il servizio non \u00e8 valido. Non contiene il protocollo http://." },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "L''URL ''{0}'' utilizzato per richiamare il servizio non \u00e8 valido. {1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "L''URL utilizzato per richiamare il servizio \u00e8 vuoto. Specificare un URL che faccia riferimento al servizio." },
			
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "Impossibile compilare report utilizzando la connessione {0}"},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "Impossibile compilare report utilizzando l''istruzione sql {0}"},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "Impossibile compilare report utilizzando l''array dinamica {0}"},
		{ Message.REPORT_E_FILL_ERROR , "Impossibile compilare il report {0}"},
		{ Message.REPORT_E_EXPORT_ERROR, "Impossibile esportare il report {0}" },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "Impossibile eseguire la conversione tra i tipi EGL {0} e Java {1}" },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "Impossibile eseguire la conversione tra i tipi Java {0} ed EGL {1}" },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "Impossibile aggiungere un parametro di report" },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "Impossibile reimpostare un elenco di parametri" },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "Nome campo non corretto {0}" },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "Nome report secondario {0} non corretto" },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "Tipo non supportato utilizzato in attivit\u00e0 di report" },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "Impossibile passare tipi complessi a queste informazioni" },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "Il nome file progetto deve essere impostato prima di richiamare la funzione getParameterDefaultValue()." },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "Impossibile ottenere il valore predefinito per il parametro {0}. {1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "Un parametro report chiamato {0} non esiste." },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "Il nome file progetto deve essere impostato prima di richiamare le funzioni createReportFromDesign() o createDocument()." },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, "Il nome file documento deve essere impostato prima di richiamare la funzione createReportFromDocument()." },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "Non \u00e8 stato possibile creare il file documento del report. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "Non \u00e8 stato possibile creare il report dal file progetto. {0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "Non \u00e8 stato possibile creare il report dal file documento. {0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "L''oggetto gestore specificato per un BirtReport deve essere di tipo BirtHandler." },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "L''elemento {0} non esiste nel progetto del report oppure non \u00e8 del tipo specificato." },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "Il numero riga {0} {1} non esiste nella tabella {2}." },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "Il numero riga {0} non esiste nell''elemento griglia {1}." },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "Il gruppo {0} non esiste nella tabella {1}." },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "Il numero riga {0} {1} non esiste nel gruppo {2} nella tabella {3}." },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "Il numero colonna {0} non esiste nella riga {1} nella tabella {2}." },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "Il numero colonna {0} non esiste nella griglia {1}." },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "Il numero colonna {0} non esiste nella riga {1} nel gruppo {2} nella tabella {3}." },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "La propriet\u00e0 ''RowType'' deve essere specificata per una funzione di gestione eventi per le righe o le celle nella tabella {0}." },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "Non \u00e8 stato possibile convertire il tipo Java {0} in un tipo EGL." },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "Impossibile convertire il tipo EGL {0} in un tipo Java." },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "Il data set {0} non esiste nel progetto del report." },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "Il data set {0} \u00e8 un data set di script, ma non \u00e8 stato gestito nessuno dei seguenti tipi di evento: openEvent, fetchEvent, closeEvent." },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "L''origine dati {0} non esiste nel progetto del report." },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "L''origine dati {0} \u00e8 un''origine dati di script, ma non \u00e8 stato gestito nessuno dei seguenti tipi di evento: openEvent, closeEvent." },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "Il numero colonna {0} non esiste nel data set {1}." },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "Si \u00e8 verificata un''eccezione durante il richiamo della colonna {0} dal data set {1}. {2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "Si \u00e8 verificata un''eccezione durante l''impostazione della colonna {0} del data set di script {1}. {2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "Si \u00e8 verificata un''eccezione durante il richiamo del binding di colonna {0}. {1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "Propriet\u00e0 vgj.defaultI4GLNativeLibrary non specificata" },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "Caricamento della libreria {0} non riuscito {1}" },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "I parametri restituiti non riscontrano la funzione" },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "Impossibile allocare memoria"},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "Impossibile eseguire la conversione fra tipi"},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "Data/ora o intervallo di precisione"},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "Variabile host del carattere troppo breve per i dati"},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "Impossibile trovare la funzione nella tabella dei simboli"},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "\u00c8 necessario fornire un tipo di dati TEXT o BYTE all''interno di questo contesto"},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "Impossibile convertire il valore nello stack in un tipo di valore"},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "Impossibile convertire il valore nello stack in ANY"},
		{ Message.CINTERFACE_E_POP_ERROR, "Impossibile estrarre un valore di tipo {0} dallo stack"},
		{ Message.CINTERFACE_E_PUSH_ERROR, "Impossibile inserire un valore di tipo {1} nello stack"},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "Nessun valore da eliminare/inserire"},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "Impossibile eliminare il valore Locator dallo stack"},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "Lo stack \u00e8 vuoto"},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "Impossibile copiare il valore Locator"},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "\u00c8 stato inserito un riferimento null nello stack"},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "Impossibile inserire valori Any nello stack"},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "Impossibile assegnare l''elemento stack al tipo Any"},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "Tipo restituito non corrispondente"},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "Tipo parametro non corrispondente"},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "Impossibile trovare il file sorgente EGL {0}.  Verr\u00e0 invece eseguito il codice generato." },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "Impossibile trovare il file sorgente EGL per la transazione Web {0}." },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "Si \u00e8 verificato il seguente problema di formattazione sul campo \"{0}\" durante la visualizzazione da \"{1}\":" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, "{0}\n\nIl formato interno previsto del campo \u00e8 \"{1}\". Verificare le propriet\u00e0 del formato data nelle propriet\u00e0 di EGL Java Runtime nel descrittore di build o le propriet\u00e0 JDBC che influenzano il formato della data. " },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\nIl formato di visualizzazione del campo \u00e8 \"{1}\". Verificare la propriet\u00e0 \"{2}\" nel campo modulo. " },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "Impossibile eseguire il programma {0} come transazione Web." },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "Alla transazione Web \u00e8 stato fornito il record UI di input {0}, ma \u00e8 stata definita con record UI di input {1}." },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "Input non valido per campo booleano." },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "Si \u00e8 verificato un timeout nel programma {0} a causa di inattivit\u00e0." },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "Il record UI {0} contiene troppi dati da inviare al servlet del gateway." },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "Il programma non \u00e8 stato in grado di verificare i dati provenienti dal servlet del gateway.  L''identificativo dati \u00e8 {0}." },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "Impossibile espandere il wrapper di array {0} oltre la sua dimensione massima. L''errore si \u00e8 verificato nel metodo {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "{0} \u00e8 un indice non valido per il wrapper di array {1}. Dimensione massima: {2}. Dimensione corrente: {3}" },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "{0} non \u00e8 una dimensione massima valida per il wrapper di array {1}." },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "{0} non \u00e8 un tipo di oggetto valido da aggiungere ad un wrapper di array di tipo {1}." },
		
		{ Message.IMS_HOST_ABORT, "\u00c8 stato ricevuto un pacchetto di arresto dall''host remoto."},
		{ Message.IMS_HOST_TCPIP_ERROR, "Si \u00e8 verificato un errore TCPIP sull''host remoto. Sezione:{0} Operazione TCPIP:{1} CODRIT TCPIP:{2} ERRNUM TCPIP:{3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "Si \u00e8 verificato un errore sull''host durante la chiamata a:{0}"},
		{ Message.IMS_HOST_PACKET_ERROR, "\u00c8 stato ricevuto il package di risposta errato dall''host remoto. Previsto:{0} Ricevuto:{1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "Errore di IO durante l''esecuzione della procedura memorizzata. {0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "Errore SQL durante l''esecuzione della procedura memorizzata. {0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "Errore sull''host remoto durante l''esecuzione di:{0} RETCODE:{1} DLI Proxy ID lavoro:{2}"},
		{ Message.IMS_HOST_DLI_ERROR, "Errore DLI sull''host remoto. Funzione DLI:{0} Ritorno AIB:0x{1} Motivo AIB:0x{2} codice stato:{3} DLI Proxy ID lavoro:{4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "Errore DLI sull''host remoto. Funzione DLI:{0} Ritorno AIB:0x{1} Motivo AIB:0x{2} DLIVar.statusCode:{3} DLIVar.DbName:{4} DLIVar.SegmentName:{5} DLIVar.SegmentLevel:{6} DLI Proxy ID lavoro:{7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "Il codice restituzione AIB indica un codice stato PCB ma non \u00e8 stato restituito un PCB. Funzione AIB:{0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "Si \u00e8 verificata un''eccezione in CALL EZEDBTCP sull''host remoto. Sezione:{0} Operazione TCPIP:{1} CODRIT TCPIP:{2} ERRNUM TCPIP:{3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "Si \u00e8 verificato un ABEND sull''host remoto. Routine:{0} Messaggio:{1} "},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "Si \u00e8 verificata un''eccezione sull''host remoto. CALL:{0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "Il programma di debug non supporta la funzione DLI. Funzione:{0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "\u00c8 stata effettuata una chiamata DL/I ma il descrittore di build non \u00e8 configurato per l''accesso DL/I."},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "Eccezione remota: {0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "Si \u00e8 verificato un errore durante il tentativo di allocare un PSB. L''IMSID \u00e8 impostato in modo da indicare che c''\u00e8 accesso DL/I, ma non \u00e8 specificato nessun PSB"},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "Il client RBD e le versioni host non sono compatibili. Versione client RBD:{0} Versione host:{1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "Si \u00e8 verificato un errore durante il richiamo dei dati restituiti da una chiamata a un programma host. {0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "Si \u00e8 verificato un errore durante il richiamo del nome PCB. Indice PCB:{0}, numero di PCB:{1}"},
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
