/*******************************************************************************
 * Copyright © 2006, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_ALL
package org.eclipse.edt.javart.messages;

import java.util.ListResourceBundle;

/**
 * The resource bundle containing the messages.
 */
public class MessageBundle_zh extends ListResourceBundle
{
	/**
	 * The array containing the messages.
	 */
	static final Object[][] contents =
	{
		{ Message.PROGRAM_ERROR_INFO, "{0} \u4e2d\u53d1\u751f\u9519\u8bef\u3002" },
		{ Message.FUNCTION_ERROR_INFO, "{0} \u5728\u5904\u7406 {1} \u51fd\u6570\u65f6\u53d1\u751f\u9519\u8bef\u3002" },
		{ Message.FILE_ERROR_INFO, "{0} \u5728\u5904\u7406\u7b2c {2} \u884c\u7684 {1} \u51fd\u6570\u65f6\u53d1\u751f\u9519\u8bef\u3002" },
		{ Message.PROPERTIES_FILE_MISSING, "\u672a\u80fd\u88c5\u5165\u5c5e\u6027\u6587\u4ef6 {0}\u3002" },
		{ Message.LOAD_LIBRARY_FAILED, "\u65e0\u6cd5\u88c5\u5165\u5e93 {0}\u3002\u53d1\u751f\u4e86\u4ee5\u4e0b\u9519\u8bef\uff1a{1}\u3002" },
		{ Message.CREATE_OBJECT_FAILED, "\u521b\u5efa\u7c7b\u578b\u4e3a {0} \u7684\u5bf9\u8c61\u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u53d1\u751f\u4e86\u4ee5\u4e0b\u9519\u8bef\uff1a{1}\u3002" },
		{ Message.INITIAL_CONTEXT_ERROR, "\u521b\u5efa InitialContext \u6216\u67e5\u627e java:comp/env \u73af\u5883\u65f6\u53d1\u751f\u9519\u8bef\u3002\u53d1\u751f\u4e86\u4ee5\u4e0b\u9519\u8bef\uff1a{0}" },
		{ Message.LISTENER_ERROR, "\u53d1\u751f\u4e86\u4ee5\u4e0b\u5f02\u5e38\u5e76\u4ea7\u751f\u4e86\u4ee5\u4e0b\u6d88\u606f\u3002\u5f02\u5e38\uff1a{0}\u3002\u6d88\u606f\uff1a{1}" },
		{ Message.REQUIRED_PROPERTY_MISSING, "\u5c5e\u6027 {0} \u7684\u503c\u662f\u5fc5\u9700\u7684\u3002" },
		{ Message.EXTERNAL_DEPENDENCY_MISSING, "\u7f3a\u5c11\u5916\u90e8\u4f9d\u8d56\u9879\u3002\u53d1\u751f\u4e86\u4ee5\u4e0b\u5f02\u5e38\u3002\u5f02\u5e38\uff1a{0}" },
		{ Message.UNSUPPORTED_COMPARE, "\u4e0d\u80fd\u5bf9\u64cd\u4f5c\u6570 {0} \u548c {1} \u8fdb\u884c\u6bd4\u8f83\u3002" },
		{ Message.ASSIGNMENT_OVERFLOW, "\u5728\u4e3a {1} \u6307\u5b9a\u503c {0} \u65f6\u53d1\u751f\u4e86\u6ea2\u51fa\u9519\u8bef\u3002" },
		{ Message.EXPRESSION_OVERFLOW, "\u5728\u8ba1\u7b97\u4ee5\u4e0b\u8868\u8fbe\u5f0f\u65f6\u53d1\u751f\u4e86\u6ea2\u51fa\u9519\u8bef\uff1a{0}\u3002" },
		{ Message.UNSUPPORTED_OPERANDS, "\u64cd\u4f5c\u6570 {1} \u548c {2} \u4e0d\u652f\u6301\u8fd0\u7b97\u7b26 {0}\u3002" },
		{ Message.UNSUPPORTED_OPERAND, "\u7c7b\u578b\u4e3a {2} \u7684\u64cd\u4f5c\u6570 {1} \u4e0d\u652f\u6301\u8fd0\u7b97\u7b26 {0}\u3002" },
		{ Message.UNSUPPORTED_SUBSCRIPT_OPERAND, "\u7c7b\u578b\u4e3a {1} \u7684\u64cd\u4f5c\u6570 {0} \u4e0d\u652f\u6301\u4e0b\u6807\u8fd0\u7b97\u7b26\u3002" },
		{ Message.UNSUPPORTED_SUBSTRING_OPERAND, "\u7c7b\u578b\u4e3a {1} \u7684\u64cd\u4f5c\u6570 {0} \u4e0d\u652f\u6301\u5b50\u4e32\u8fd0\u7b97\u7b26\u3002" },
		{ Message.UNSUPPORTED_SET_EMPTY_OPERAND, "\u7c7b\u578b\u4e3a {1} \u7684\u64cd\u4f5c\u6570 {0} \u4e0d\u652f\u6301 SET EMPTY \u8bed\u53e5\u3002" },
		{ Message.INVALID_REGULAR_EXPRESSION, "\u6b63\u5219\u8868\u8fbe\u5f0f {0} \u4e2d\u53d1\u751f\u4e86\u9519\u8bef\u3002\u9519\u8bef\uff1a{1}\u3002" },
		{ Message.CICSSSL_KEYSTORE_AND_PASSWORD_NOT_SPECIFIED, "\u5f53\u4f7f\u7528 CICSSSL \u534f\u8bae\u65f6\uff0c\u5fc5\u987b\u540c\u65f6\u6307\u5b9a ctgKeyStore \u548c ctgKeyStorePassword\u3002" },
		{ Message.INVALID_CTGPORT, "ctgport \u6761\u76ee\u7684\u503c {0} \u4e0d\u6b63\u786e\u3002" },
		{ Message.CTG_CONNECT_FAILED, "\u8fde\u63a5\u81f3 CTG \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002CTG \u4f4d\u7f6e\u4e3a {0}\u3002CTG \u7aef\u53e3\u4e3a {1}\u3002\u53d1\u751f\u4e86\u4ee5\u4e0b\u9519\u8bef\uff1a{2}" },
		{ Message.CTG_DISCONNECT_FAILED, "\u4e0e CTG \u65ad\u5f00\u8fde\u63a5\u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002CTG \u4f4d\u7f6e\u4e3a {0}\u3002CTG \u7aef\u53e3\u4e3a {1}\u3002\u53d1\u751f\u4e86\u4ee5\u4e0b\u9519\u8bef\uff1a{2}" },
		{ Message.NO_CICS, "\u8c03\u7528\u4f7f\u7528 CICS ECI \u7684\u7a0b\u5e8f {0} \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u8fd4\u56de\u7801\u4e3a -3\uff08ECI_ERR_NO_CICS\uff09\u3002CICS \u7cfb\u7edf\u6807\u8bc6\u4e3a {1}\u3002" },
		{ Message.CICS_DIED, "\u8c03\u7528\u4f7f\u7528 CICS ECI \u7684\u7a0b\u5e8f {0} \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u8fd4\u56de\u7801\u4e3a -4\uff08ECI_ERR_CICS_DIED\uff09\u3002CICS \u7cfb\u7edf\u6807\u8bc6\u4e3a {1}\u3002" },
		{ Message.CICS_TIMEOUT, "\u8c03\u7528\u4f7f\u7528 CICS ECI \u7684\u7a0b\u5e8f {0} \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u8fd4\u56de\u7801\u4e3a -6\uff08ECI_ERR_RESPONSE_TIMEOUT\uff09\u3002CICS \u7cfb\u7edf\u6807\u8bc6\u4e3a {1}\u3002" },
		{ Message.CICS_TRANSACTION_ABEND, "\u8c03\u7528\u4f7f\u7528 CICS ECI \u7684\u7a0b\u5e8f {0} \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u8fd4\u56de\u7801\u4e3a -7\uff08ECI_ERR_TRANSACTION_ABEND\uff09\u3002CICS \u7cfb\u7edf\u6807\u8bc6\u4e3a {1}\u3002\u5f02\u5e38\u7ec8\u6b62\u4ee3\u7801\u4e3a {2}\u3002" },
		{ Message.CICS_UNKNOWN_SERVER, "\u8c03\u7528\u4f7f\u7528 CICS ECI \u7684\u7a0b\u5e8f {0} \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u8fd4\u56de\u7801\u4e3a -22\uff08ECI_ERR_UNKNOWN_SERVER\uff09\u3002CICS \u7cfb\u7edf\u6807\u8bc6\u4e3a {1}\u3002" },
		{ Message.CICS_SECURITY_ERROR, "\u8c03\u7528\u4f7f\u7528 CICS ECI \u7684\u7a0b\u5e8f {0} \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u8fd4\u56de\u7801\u4e3a -27\uff08ECI_ERR_SECURITY_ERROR\uff09\u3002CICS \u7cfb\u7edf\u6807\u8bc6\u4e3a {1}\u3002" },
		{ Message.CICS_MAX_SYSTEMS, "\u8c03\u7528\u4f7f\u7528 CICS ECI \u7684\u7a0b\u5e8f {0} \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u8fd4\u56de\u7801\u4e3a -28\uff08ECI_ERR_MAX_SYSTEMS\uff09\u3002CICS \u7cfb\u7edf\u6807\u8bc6\u4e3a {1}\u3002" },
		{ Message.CICS_NONZERO_RETURN_CODE, "\u5728\u7cfb\u7edf {1} \u4e0a\u4e3a\u540d\u4e3a {2} \u7684\u7528\u6237\u8c03\u7528\u7a0b\u5e8f {0} \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u8c03\u7528 CICS ECI \u65f6\u8fd4\u56de\u4e86\u8fd4\u56de\u7801 {3} \u548c\u5f02\u5e38\u7ec8\u6b62\u4ee3\u7801 {4}\u3002" },
		{ Message.CICS_COMMIT_FAILED, "\u8c03\u7528 CICS ECI \u4ee5\u843d\u5b9e\u5de5\u4f5c\u5355\u5143\u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002CICS \u8fd4\u56de\u7801\u4e3a {0}\u3002" },
		{ Message.CICS_ROLLBACK_FAILED, "\u8c03\u7528 CICS ECI \u4ee5\u56de\u6eda\u5de5\u4f5c\u5355\u5143\u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002CICS \u8fd4\u56de\u7801\u4e3a {0}\u3002" },
		{ Message.CICS_ECI_FLOW_FAILED, "\u5728\u5bf9 CICS \u7cfb\u7edf {0} \u53d1\u51fa ECI \u8bf7\u6c42\u7684\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002\u5f02\u5e38\uff1a{1}" },
		{ Message.SERVICE_PARAMETER_ERROR, "\u53c2\u6570\u957f\u5ea6\u9519\u8bef\u3002\u6d41\u6709 {0} \u4e2a\u53c2\u6570\uff0c\u800c\u672c\u5730\u51fd\u6570\u6709 {1} \u4e2a\u53c2\u6570\u3002" },
		{ Message.ARRAY_MAXSIZE_EXCEEDED, "\u8d85\u51fa\u4e86\u6570\u7ec4 {0} \u7684\u6700\u5927\u5927\u5c0f\u3002" },
		{ Message.WRONG_NUMBER_OF_PARMS, "\u88ab\u8c03\u7528\u7a0b\u5e8f {0} \u9700\u8981 {1} \u4e2a\u53c2\u6570\uff0c\u4f46\u4f20\u9012\u4e86 {2} \u4e2a\u53c2\u6570\u3002" },
		{ Message.FUNCTION_NOT_FOUND, "\u83b7\u53d6\u5171\u4eab\u5e93 {1} \u4e2d\u7684\u5165\u53e3\u70b9 {0} \u7684\u5730\u5740\u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u8fd4\u56de\u7801\u4e3a {2}\u3002" },
		{ Message.SHARED_LIBRARY_NOT_FOUND, "\u88c5\u5165\u5171\u4eab\u5e93 {0} \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u8fd4\u56de\u7801\u4e3a {1}\u3002" },
		{ Message.CALL_NONZERO_RETURN_CODE, "\u88ab\u8c03\u7528\u7a0b\u5e8f\u5931\u8d25\uff0c\u8fd4\u56de\u7801\u4e3a {0}\u3002" },
		{ Message.REMOTE_PROGRAM_ERROR, "\u7cfb\u7edf {3} \u4e0a\u7684\u8fdc\u7a0b\u7a0b\u5e8f {0} \u4e2d\u53d1\u751f\u4e86\u9519\u8bef\u3002\u5728 {1} \u4e0a\u7684 {2} \u5904\u53d1\u751f\u4e86\u9519\u8bef\u3002{4} {5}" },
		{ Message.REMOTE_PROGRAM_ERROR2, "\u7cfb\u7edf {1} \u4e0a\u7684\u8fdc\u7a0b\u7a0b\u5e8f {0} \u4e2d\u53d1\u751f\u4e86\u9519\u8bef\u3002{2} {3}" },
		{ Message.UNKNOWN_TCPIP_HOSTNAME, "\u4e3b\u673a\u540d {0} \u662f\u4e00\u4e2a\u672a\u77e5\u7684 TCP/IP \u4e3b\u673a\u540d\u3002" },
		{ Message.SERVERID_IS_INVALID_PORT, "\u670d\u52a1\u5668\u6807\u8bc6 {0} \u4e0d\u662f\u6709\u6548\u7684\u7aef\u53e3\u53f7\u3002" },
		{ Message.TCPIP_SERVER_ERROR, "\u5ba2\u6237\u673a\u63a5\u6536\u5230\u901a\u77e5\uff1a\u670d\u52a1\u5668\u65e0\u6cd5\u542f\u52a8\u8fdc\u7a0b\u88ab\u8c03\u7528\u7a0b\u5e8f\u3002\u539f\u56e0\u7801\uff1a{0}\u3002" },
		{ Message.INVALID_REMOTECOMTYPE, "\u7f3a\u5c11 remoteComType \u503c\u6216\u8005\u8be5\u503c\u4e0d\u6b63\u786e\u3002" },
		{ Message.CANNOT_OPEN_LINKAGE_FILE, "\u65e0\u6cd5\u6253\u5f00\u94fe\u63a5\u5c5e\u6027\u6587\u4ef6 {0}\u3002" },
		{ Message.NAME_NOT_FOUND_IN_LINKAGE, "\u5728\u94fe\u63a5\u5c5e\u6027\u6587\u4ef6 {1} \u4e2d\u627e\u4e0d\u5230\u88ab\u8c03\u7528\u7a0b\u5e8f {0} \u7684\u5165\u53e3\u3002" },
		{ Message.AS400_UNKNOWN_HOST, "\u627e\u4e0d\u5230\u4e3b\u673a {0} \u6216\u8005\u8be5\u4e3b\u673a\u662f\u672a\u77e5\u7684\u3002" },
		{ Message.AS400_PASSWORD_OR_USER_INVALID, "\u7528\u4e8e\u8fde\u63a5\u81f3\u7cfb\u7edf {0} \u7684\u5bc6\u7801\u6216\u7528\u6237\u6807\u8bc6\u4e0d\u6b63\u786e\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.AS400_EXCEPTION_CAUGHT, "\u5728\u7cfb\u7edf {3} \u4e0a\u8c03\u7528\u7a0b\u5e8f {2} \u65f6\u53d1\u751f\u4e86 {0} AS400Toolbox \u6267\u884c\u9519\u8bef\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.AS400_NO_AUTHORITY, "\u7528\u6237 {1} \u5728\u7cfb\u7edf {0} \u4e0a\u53d1\u751f\u4e86\u8fdc\u7a0b\u8bbf\u95ee\u5b89\u5168\u6027\u9519\u8bef\u3002\u9519\u8bef\uff1a{2}" },
		{ Message.REMOTE_COMMIT_FAILED, "\u5728\u7cfb\u7edf {0} \u4e0a\u843d\u5b9e\u5931\u8d25\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.REMOTE_ROLLBACK_FAILED, "\u5728\u7cfb\u7edf {0} \u4e0a\u56de\u6eda\u5931\u8d25\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.AS400_CONNECTION_ERROR, "\u8bbf\u95ee\u7cfb\u7edf {0} \u65f6\u53d1\u751f\u4e86\u8fdc\u7a0b\u8fde\u63a5\u9519\u8bef\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.AS400_SERVER_NOT_FOUND, "\u53d1\u751f\u4e86 EGL OS/400 \u4e3b\u673a\u670d\u52a1\u9519\u8bef\u3002\u5728\u7cfb\u7edf {0} \u4e0a\u627e\u4e0d\u5230\u5fc5\u9700\u7684\u6587\u4ef6\u3002" },
		{ Message.AS400_APPLICATION_ERROR, "\u8fd0\u884c\u5355\u5143\u5df2\u505c\u6b62\uff0c\u56e0\u4e3a\u5728\u5c1d\u8bd5\u8c03\u7528\u7a0b\u5e8f {1} \u65f6\u5728\u7cfb\u7edf {0} \u4e0a\u53d1\u751f\u4e86\u5e94\u7528\u7a0b\u5e8f\u9519\u8bef\u3002\u6d88\u606f\uff1a{2}" },
		{ Message.NULL_REFERENCE_VARIABLE, "\u540d\u79f0\u4e3a {0} \u7684\u5f15\u7528\u53d8\u91cf\u4e3a\u7a7a\uff08null\uff09\u3002" },
		{ Message.CAUGHT_JAVA_EXCEPTION, "{0}" },
		{ Message.UNHANDLED_EXCEPTION, "\u53d1\u751f\u4e86\u672a\u5904\u7406\u7684\u9519\u8bef\u3002\u9519\u8bef\uff1a{0}\u3002" },
		{ Message.DATA_FORMAT_ERROR, "\u53d8\u91cf {0} \u7684\u503c\u683c\u5f0f\u4e0d\u6b63\u786e\u3002" },
		{ Message.CONVERSION_ERROR, "\u4e0d\u80fd\u5c06\u7c7b\u578b\u4e3a {1} \u7684\u503c {0} \u8f6c\u6362\u4e3a\u7c7b\u578b {2}\u3002" },
		{ Message.INVALID_DATE_FORMAT_PATTERN, "\u65e5\u671f\u683c\u5f0f\u6a21\u5f0f {0} \u65e0\u6548\u3002" },
		{ Message.INVALID_TIME_FORMAT_PATTERN, "\u65f6\u95f4\u683c\u5f0f\u6a21\u5f0f {0} \u65e0\u6548\u3002" },
		{ Message.INVALID_TIMESTAMP_FORMAT_PATTERN, "\u65f6\u95f4\u6233\u8bb0\u683c\u5f0f\u6a21\u5f0f {0} \u65e0\u6548\u3002" },
		{ Message.NULL_REFERENCE, "\u4f7f\u7528\u4e86\u7a7a\uff08null\uff09\u5f15\u7528\u3002" },
		{ Message.DYNAMIC_ACCESS_NOT_SUPPORTED, "\u4e0d\u652f\u6301\u5bf9 {0} \u8fdb\u884c\u52a8\u6001\u8bbf\u95ee\u3002" },
		{ Message.DYNAMIC_ACCESS_FAILED, "\u5728 {1} \u4e2d\u627e\u4e0d\u5230\u6807\u8bc6\u4e3a {0} \u7684\u5b57\u6bb5\u3002" },
		{ Message.INVALID_NUMERIC_FORMAT_PATTERN, "\u6570\u5b57\u683c\u5f0f\u6a21\u5f0f {0} \u65e0\u6548\u3002" },
		{ Message.EXCEPTION_IN_LOB_ASSIGNMENT, "\u5c06 {0} \u6307\u5b9a\u7ed9 {1} \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u9519\u8bef\uff1a{2}\u3002" },
		{ Message.EXCEPTION_IN_LOB_SET_EMPTY, "SET {0} EMPTY \u8bed\u53e5\u4e2d\u51fa\u9519\u3002\u9519\u8bef\uff1a{1}\u3002" },
		{ Message.EXCEPTION_IN_DELEGATE_INVOKE, "\u8c03\u7528\u5177\u6709\u7279\u5f81\u7b26 {1} \u7684\u65b9\u6cd5\u65f6\u53d1\u751f\u4e86\u9519\u8bef {0}\u3002" },
		{ Message.RUN_COMMAND_FAILED, "\u8fd0\u884c {0} \u547d\u4ee4\u65f6\u51fa\u9519\u3002\u9519\u8bef\uff1a{1}\u3002" },
		{ Message.MDY_ERROR, "DateTimeLib.mdy \u51fd\u6570\u4e0d\u80fd\u5c06\u503c {0}\u3001{1} \u548c {2} \u8f6c\u6362\u4e3a\u6708\u3001\u65e5\u548c\u5e74\u3002" },
		{ Message.NON_NUMERIC_STRING, "\u5411 {0} \u4f20\u9012\u4e86\u975e\u6570\u5b57\u5b57\u7b26\u4e32 {1}\u3002\u7531\u957f\u5ea6\u53c2\u6570\u5b9a\u4e49\u7684\u5b57\u7b26\u4e32\u90e8\u5206\u4e2d\u7684\u6240\u6709\u5b57\u7b26\u90fd\u5fc5\u987b\u662f\u6570\u5b57\u3002" },
		{ Message.SYSTEM_FUNCTION_ERROR, "{0} \u5931\u8d25\uff0c\u9519\u8bef\u6d88\u606f\u4e3a {1}\u3002" },
		{ Message.INT_AS_CHAR_ERROR, "StrLib.intAsChar \u7684\u81ea\u53d8\u91cf\u5fc5\u987b\u662f 0 \u5230 255 \u4e4b\u95f4\u7684\u67d0\u4e2a\u6570\u5b57\u3002" },
		{ Message.INVALID_LOB_LENGTH, "{1} \u7684\u5927\u5c0f\u4e3a {2}\uff0c{0} \u5bf9\u4e8e\u5b83\u6765\u8bf4\u4e0d\u662f\u6709\u6548\u7684\u957f\u5ea6\u3002" },
		{ Message.INVALID_LOB_POSITION, "{0} \u5bf9\u4e8e {1} \u4e0d\u662f\u6709\u6548\u7684\u4f4d\u7f6e\u3002\u5b83\u7684\u5927\u5c0f\u662f {2}\u3002" },
		{ Message.LOB_ERROR, "\u5904\u7406 Blob \u6216 Clob \u9879\u65f6\u53d1\u751f\u9519\u8bef\u3002\u9519\u8bef\u6d88\u606f\u4e3a {0}" },
		{ Message.START_TRANSACTION_ERROR, "\u7c7b {0} \u7684 VGLib.startTransaction \u5931\u8d25\u3002\u5f02\u5e38\u4e3a {1}" },
		{ Message.INT_AS_UNICODE_ERROR, "StrLib.intAsUnicode \u7684\u81ea\u53d8\u91cf\u5fc5\u987b\u662f 0 \u5230 65535 \u4e4b\u95f4\u7684\u67d0\u4e2a\u6570\u5b57\u3002" },
		{ Message.INVALID_ARRAY_SIZE, "\u5927\u5c0f\u503c {0} \u5bf9\u4e8e\u6570\u7ec4 {1} \u65e0\u6548\u3002\u6700\u5927\u5927\u5c0f\u4e3a {2}\u3002" },
		{ Message.ARRAY_INDEX_OUT_OF_BOUNDS, "\u4e0b\u6807 {0} \u8d85\u51fa\u6570\u7ec4 {1} \u7684\u754c\u9650\u3002\u6570\u7ec4\u5927\u5c0f\u4e3a {2}\u3002" },
		{ Message.INVALID_SUBSTRING_INDEX, "\u5b50\u4e32\u4e0b\u6807 {0}:{1} \u65e0\u6548\u3002" },
		{ Message.INVALID_ARRAY_FUNCTION_ARGUMENT, "\u51fd\u6570\u7684\u81ea\u53d8\u91cf\u5bf9\u4e8e\u6570\u7ec4 {0} \u65e0\u6548\u3002" },
		{ Message.INDEX_OUT_OF_BOUNDS, "\u4e0b\u6807\u503c {0} \u8d85\u51fa\u754c\u9650\u3002" },
		{ Message.UNSUPPORTED_CONVERSION_TABLE, "{0} \u662f\u4e00\u4e2a\u4e0d\u53d7\u652f\u6301\u7684\u8f6c\u6362\u8868\u3002" },
		{ Message.CANNOT_READ_CSOUIDPWD_FILE, "\u65e0\u6cd5\u8bfb\u53d6 csouidpwd.properties \u6587\u4ef6\u3002\u9519\u8bef\uff1a{0}" },
		{ Message.CALL_PARMS_TOO_LARGE, "\u5ba2\u6237\u673a\u7684\u7f13\u51b2\u533a\u5bf9\u4e8e\u6b63\u5728\u8c03\u7528\u4e2d\u4f20\u9012\u7684\u6570\u636e\u91cf\u6765\u8bf4\u592a\u5c0f\u3002\u6b63\u5728\u4f20\u9012\u7684\u53c2\u6570\u7d2f\u8ba1\u5927\u5c0f\u4e3a {0} \u5b57\u8282\uff0c\u8d85\u51fa\u4e86\u5141\u8bb8\u7684\u6700\u5927\u503c\uff08{1} \u5b57\u8282\uff09\u3002" },
		{ Message.INVALID_PARMFORM, "\u7531\u4e8e\u81f3\u5c11\u5b58\u5728\u4e00\u4e2a\u52a8\u6001\u6570\u7ec4\u53c2\u6570\uff0cparmForm \u94fe\u63a5\u5c5e\u6027\u5fc5\u987b\u8bbe\u7f6e\u4e3a COMMPTR \u624d\u80fd\u8c03\u7528\u7a0b\u5e8f {0}\u3002" },
		{ Message.PARM_PASSING_ERROR, "\u5c06\u53c2\u6570\u4f20\u9012\u81f3\u88ab\u8c03\u7528\u7a0b\u5e8f {0} \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.CALL_ERROR, "\u8c03\u7528\u7a0b\u5e8f {0} \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.UNSUPPORTED_SRVPGM_PARAM_TYPE, "\u5bf9\u4e8e System i \u670d\u52a1\u7a0b\u5e8f\uff0c{0} \u662f\u4e0d\u53d7\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b\u3002" },
		{ Message.UNSUPPORTED_SRVPGM_RETURN_TYPE, "\u5bf9\u4e8e System i \u670d\u52a1\u7a0b\u5e8f\uff0c{0} \u662f\u4e0d\u53d7\u652f\u6301\u7684\u8fd4\u56de\u7c7b\u578b\u3002" },
		{ Message.ERROR_GETTING_CONNECTION_FACTORY, "\u65e0\u6cd5\u83b7\u53d6\u8fde\u63a5\u5de5\u5382\u3002\u5f02\u5e38\u4e3a {0}" },
		{ Message.ERROR_CLOSING_INTERACTION_OR_CONNECTION, "\u65e0\u6cd5\u5173\u95ed\u4ea4\u4e92\u6216\u8fde\u63a5\u3002\u9519\u8bef\uff1a{0}" },
		{ Message.ERROR_GETTING_CONNECTION, "\u65e0\u6cd5\u5efa\u7acb\u8fde\u63a5\u3002\u9519\u8bef\uff1a{0}" },
		{ Message.ERROR_GETTING_INTERACTION, "\u65e0\u6cd5\u83b7\u53d6\u4ea4\u4e92\u3002\u5f02\u5e38\u4e3a\uff1a{0}" },
		{ Message.ERROR_SETTING_INTERACTION_VERB, "\u65e0\u6cd5\u8bbe\u7f6e\u4ea4\u4e92\u52a8\u8bcd\u3002\u5f02\u5e38\u4e3a {0}" },
		{ Message.ERROR_GETTING_LOCAL_TRANSACTION, "\u65e0\u6cd5\u4e3a\u5ba2\u6237\u7aef\u5de5\u4f5c\u5355\u5143\u83b7\u53d6 LocalTransaction\u3002\u5f02\u5e38\u4e3a {0}" },
		{ Message.ERROR_SETTING_TIMEOUT, "\u65e0\u6cd5\u5bf9 CICSJ2C \u8c03\u7528\u8bbe\u7f6e\u8d85\u65f6\u503c\u3002\u5f02\u5e38\u4e3a {0}" },
		{ Message.EXCEPTION_CALLING_CICS, "\u5728\u5c1d\u8bd5\u4e0e CICS \u901a\u4fe1\u65f6\u53d1\u751f\u9519\u8bef\u3002\u5f02\u5e38\u4e3a {0}" },
		{ Message.CALLING_CICS_UNSUCCESSFUL, "\u5c1d\u8bd5\u6267\u884c\u8fdc\u7a0b CICS \u4e8b\u52a1\u5931\u8d25\u3002" },
		{ Message.EXCEPTION_CALLING_IMS, "\u5728\u5c1d\u8bd5\u4e0e IMS \u901a\u4fe1\u65f6\u53d1\u751f\u9519\u8bef\u3002\u5f02\u5e38\u4e3a {0}" },
		{ Message.CALLING_IMS_UNSUCCESSFUL, "\u5728\u5c1d\u8bd5\u4e0e IMS \u901a\u4fe1\u65f6\u53d1\u751f\u9519\u8bef\u3002" },
		{ Message.MATH_DOMAIN_ERROR, "{0} \u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a 8\uff08\u57df\u9519\u8bef\uff09\u3002\u51fd\u6570\u7684\u81ea\u53d8\u91cf\u65e0\u6548\u3002" },
		{ Message.MATH_ACOS_ASIN_DOMAIN_ERROR, "{0} \u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a 8\uff08\u57df\u9519\u8bef\uff09\u3002\u81ea\u53d8\u91cf\u5fc5\u987b\u4ecb\u4e8e -1 \u4e0e 1 \u4e4b\u95f4\u3002" },
		{ Message.MATH_FLQUO_FLMOD_DOMAIN_ERROR, "{0} \u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a 8\uff08\u57df\u9519\u8bef\uff09\u3002\u7b2c\u4e8c\u4e2a\u81ea\u53d8\u91cf\u4e0d\u80fd\u4e3a\u96f6\u3002" },
		{ Message.MATH_LOG_LOG10_DOMAIN_ERROR, "{0} \u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a 8\uff08\u57df\u9519\u8bef\uff09\u3002\u81ea\u53d8\u91cf\u5fc5\u987b\u5927\u4e8e\u96f6\u3002" },
		{ Message.MATH_POW_1_DOMAIN_ERR, "MathLib.pow \u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a 8\uff08\u57df\u9519\u8bef\uff09\u3002\u5982\u679c\u7b2c\u4e00\u4e2a\u81ea\u53d8\u91cf\u4e3a\u96f6\uff0c\u90a3\u4e48\u7b2c\u4e8c\u4e2a\u81ea\u53d8\u91cf\u5fc5\u987b\u5927\u4e8e\u96f6\u3002" },
		{ Message.MATH_POW_2_DOMAIN_ERR, "MathLib.pow \u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a 8\uff08\u57df\u9519\u8bef\uff09\u3002\u5982\u679c\u7b2c\u4e00\u4e2a\u81ea\u53d8\u91cf\u5c0f\u4e8e\u96f6\uff0c\u90a3\u4e48\u7b2c\u4e8c\u4e2a\u81ea\u53d8\u91cf\u5fc5\u987b\u662f\u6574\u6570\u3002" },
		{ Message.MATH_SQRT_DOMAIN_ERROR, "MathLib.sqrt \u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a 8\uff08\u57df\u9519\u8bef\uff09\u3002\u81ea\u53d8\u91cf\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e\u96f6\u3002" },
		{ Message.MATH_RANGE_ERROR, "{0} \u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a 12\uff08\u8303\u56f4\u9519\u8bef\uff09\u3002" },		
		{ Message.STRING_INDEX_ERROR, "{0} \u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a 8\u3002\u4e0b\u6807\u5fc5\u987b\u5728 1 \u548c\u5b57\u7b26\u4e32\u957f\u5ea6\u4e4b\u95f4\u3002" },
		{ Message.STRING_LENGTH_ERROR, "{0} \u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a 12\u3002\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e 0\u3002" },
		{ Message.STRING_NULT_ERROR, "StrLib.setNullTerminator \u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a 6\u3002\u76ee\u6807\u5b57\u7b26\u4e32\u7684\u6700\u540e\u4e00\u4e2a\u5b57\u8282\u5fc5\u987b\u4e3a\u7a7a\u767d\u6216\u7a7a\u5b57\u7b26\u3002" },
		{ Message.STRING_DOUBLE_BYTE_INDEX_ERROR, "{0} \u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a 20\u3002STRING\u3001DBCHAR \u6216 UNICODE \u5b50\u4e32\u7684\u4e0b\u6807\u5fc5\u987b\u662f\u5947\u6570\uff0c\u4ee5\u4fbf\u4e0b\u6807\u6807\u8bc6\u5b57\u7b26\u7684\u7b2c\u4e00\u4e2a\u5b57\u8282\u3002" },
		{ Message.STRING_DOUBLE_BYTE_LENGTH_ERROR, "{0} \u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a 24\u3002STRING\u3001DBCHAR \u6216 UNICODE \u5b50\u4e32\u7684\u957f\u5ea6\u5fc5\u987b\u4e3a\u5076\u6570\uff0c\u4ee5\u4fbf\u5f15\u7528\u6574\u6570\u4e2a\u5b57\u7b26\u3002" },
		{ Message.NO_DEBUG_LISTENER, "\u65e0\u6cd5\u4e0e\u4f4d\u4e8e\u4e3b\u673a\u540d {0} \u7aef\u53e3 {1} \u4e0a\u7684 EGL \u8c03\u8bd5\u5668\u53d6\u5f97\u8054\u7cfb\u3002\u5f02\u5e38\u4e3a {2}" },
		{ Message.DEBUG_LISTENER_PROBLEM, "\u4e0e\u4f4d\u4e8e\u4e3b\u673a\u540d {0} \u7aef\u53e3 {1} \u4e0a\u7684 EGL \u8c03\u8bd5\u5668\u901a\u4fe1\u65f6\u53d1\u751f\u9519\u8bef\u3002\u5f02\u5e38\u4e3a {2}" },
		{ Message.NOT_DEBUG_MODE, "\u94fe\u63a5\u6307\u5b9a\u8981\u5728 J2EE \u670d\u52a1\u5668\u4e2d\u8fdb\u884c DEBUG \u8c03\u7528\u3002\u672a\u5728 J2EE \u670d\u52a1\u5668\u4e0a\u8fdb\u884c\u8be5\u8c03\u7528\uff0cJ2EE \u670d\u52a1\u5668\u672a\u5904\u4e8e\u8c03\u8bd5\u65b9\u5f0f\uff0c\u6216\u8005 J2EE \u670d\u52a1\u5668\u672a\u542f\u7528 EGL \u8c03\u8bd5\u3002" },
		{ Message.LIBRARY_NOT_SPECIFIED, "\u94fe\u63a5\u6307\u5b9a\u4e86\u5bf9 EGL \u4fa6\u542c\u5668\u8fdb\u884c DEBUG \u8c03\u7528\uff0c\u4f46\u662f\u672a\u6307\u5b9a\u5e93\u5c5e\u6027\u3002" },
		
		{ Message.FILETYPE_MISSING, "\u5bf9\u4e8e\u6587\u4ef6 {0}\uff0c\u627e\u4e0d\u5230\u8fd0\u884c\u65f6\u5c5e\u6027 vgj.ra.fileName.fileType\u3002" },
		{ Message.FILETYPE_INVALID, "\u5bf9\u4e8e\u6587\u4ef6 {0}\uff0c\u8fd0\u884c\u65f6\u5c5e\u6027 vgj.ra.fileName.fileType \u7684\u503c\u65e0\u6548\u3002" },
		{ Message.INVALID_RECORD_LENGTH, "\u8bb0\u5f55\u957f\u5ea6\u9879\u5fc5\u987b\u5305\u542b\u5206\u79bb\u9879\u8fb9\u754c\u5904\u975e\u5b57\u7b26\u6570\u636e\u7684\u503c\u3002" },
		{ Message.RECORD_LENGTH_TOO_LARGE, "occursItem \u6216 lengthItem \u4e2d\u7684\u503c\u592a\u5927\u3002" },
		{ Message.IO_ERROR, "{0}\uff1a\u5bf9\u4e8e {1}\uff0cI/O \u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a{2}\u3002" },

		{ Message.SQL_PREPARED_STATEMENT_NOT_FOUND, "{0}\uff1a\u627e\u4e0d\u5230\u9884\u7f16\u8bd1\u8bed\u53e5 {1} [sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_RESULT_SET_NOT_FOUND, "{0}\uff1a\u627e\u4e0d\u5230\u7ed3\u679c\u96c6 {1} [sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_ERROR, "{0}\uff1a\u9519\u8bef [sqlstate:{1}][sqlcode:{2}]" },
		{ Message.SQL_NO_RECORD_FOUND, "{0}\uff1a[sqlstate:02000][sqlcode:100]" },
		{ Message.SQL_EXCEPTION_CAUGHT, "{0}\uff1a{1}[sqlstate:{2}][sqlcode:{3}]" },
		{ Message.SQL_CONNECTION_FAILED, "\u4e0d\u80fd\u8fde\u63a5\u81f3 {0}\uff1a{1}" },
		{ Message.SQL_NO_JDBC_DRIVER, "\u4e0d\u80fd\u8fde\u63a5\u81f3 {0}\uff0c\u6570\u636e\u5e93 URL \u53ef\u80fd\u4e0d\u6b63\u786e\uff1a{1}" },
		{ Message.SQL_JDBC_DRIVER_LOAD_ERROR, "\u88c5\u5165 JDBC \u9a71\u52a8\u7a0b\u5e8f\u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u9519\u8bef\uff1a{0}" },
		{ Message.SQL_RESULT_SET_NOT_SCROLLABLE, "\u7ed3\u679c\u96c6 {0} \u4e0d\u53ef\u6eda\u52a8\u3002" },
		{ Message.SQL_NO_DEFAULT_DATABASE, "\u4e0d\u80fd\u8fde\u63a5\u81f3\u7f3a\u7701\u6570\u636e\u5e93\u3002\u672a\u6307\u5b9a\u7f3a\u7701\u6570\u636e\u5e93\u7684\u540d\u79f0\u3002" },
		{ Message.SQL_NO_DATABASE_CONNECTION, "\u5728\u6267\u884c SQL I/O \u64cd\u4f5c\u4e4b\u524d\u5fc5\u987b\u5efa\u7acb\u6570\u636e\u5e93\u8fde\u63a5\u3002" },
		{ Message.SQL_DISCONNECT_ERROR, "\u4e0e\u6570\u636e\u5e93 {0} \u65ad\u5f00\u8fde\u63a5\u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002{1}" },
		{ Message.SQL_CONNECTION_SET_ERROR, "\u4e0d\u80fd\u8bbe\u7f6e\u4e0e\u6570\u636e\u5e93 {0} \u7684\u8fde\u63a5\u3002\u8fde\u63a5\u4e0d\u5b58\u5728\u3002" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_SQL_ERROR, "\u51fd\u6570 SQLLib.{0} \u4e2d\u53d1\u751f\u4e86 SQL \u9519\u8bef\uff1a{1}" },
		{ Message.SQL_LOAD_TABLE_UNLOAD_TABLE_IO_ERROR, "\u51fd\u6570 SQLLib.{0} \u4e2d\u53d1\u751f\u4e86\u975e SQL \u9519\u8bef\uff1a{1}" },
		{ Message.SQL_HOST_VAR_NOT_NULLABLE, "\u4ece\u6570\u636e\u5e93\u4e2d\u63a5\u6536\u5230 NULL\uff0c\u4f46\u662f\u4e3b\u53d8\u91cf {0} \u4e0d\u53ef\u7a7a\u3002" },
		
		{ Message.EDIT_INPUT_REQUIRED_ERR, "\u5fc5\u9700\u5b57\u6bb5\u672a\u63a5\u6536\u5230\u8f93\u5165\u5185\u5bb9 \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002" },
		{ Message.EDIT_INVALID_NUMERIC_DATA_ERR, "\u8f93\u5165\u5185\u5bb9\u7684\u6570\u636e\u7c7b\u578b\u9519\u8bef \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002" },
		{ Message.EDIT_SIGNIFICANT_NUMERIC_DIGITS_ERR, "\u5141\u8bb8\u7684\u6709\u6548\u6570\u5b57\u4f4d\u6570\u8d85\u51fa\u8303\u56f4 \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002" },
		{ Message.EDIT_NUMERIC_RANGE_ERR, "\u8f93\u5165\u5185\u5bb9\u4e0d\u5728\u5df2\u5b9a\u4e49\u7684\u8303\u56f4 {0} \u5230 {1} \u5185 \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002" },
		{ Message.EDIT_VALID_VALUES_ERR, "\u8f93\u5165\u5185\u5bb9\u4e0d\u5728\u5df2\u5b9a\u4e49\u7684\u6709\u6548\u503c\u5217\u8868\u4e2d \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002" },
		{ Message.EDIT_DATE_TIME_FORMAT_SPECIFIED_ERR, "\u6307\u5b9a\u7684\u65e5\u671f\u548c\u65f6\u95f4\u683c\u5f0f {0} \u65e0\u6548\u3002" },
		{ Message.EDIT_MINIMUM_INPUT_ERR, "\u8f93\u5165\u6700\u5c0f\u957f\u5ea6\u51fa\u9519 \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002" },
		{ Message.EDIT_MAXIMUM_INPUT_ERR, "\u8f93\u5165\u6700\u5927\u957f\u5ea6\u51fa\u9519 \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002" },
		{ Message.EDIT_TABLE_VALIDATION_ERR, "\u8868\u7f16\u8f91\u6709\u6548\u6027\u9519\u8bef \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002" },
		{ Message.EDIT_MODULUS_VALIDATION_ERR, "\u5bf9\u8f93\u5165\u7684\u6a21\u6570\u68c0\u67e5\u53d1\u73b0\u9519\u8bef \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002" },
		{ Message.EDIT_INVALID_DATE_TIME_ERR, "\u8f93\u5165\u5185\u5bb9\u5bf9\u4e8e\u5df2\u5b9a\u4e49\u7684\u65e5\u671f\u6216\u65f6\u95f4\u683c\u5f0f {0} \u65e0\u6548\u3002" },
		{ Message.EDIT_BOOLEAN_CHECK_ERR, "\u5bf9\u4e8e\u5e03\u5c14\u503c\u5b57\u6bb5\uff0c\u8f93\u5165\u65e0\u6548\u3002" },
		{ Message.EDIT_INVALID_PATTERN_ERR, "\u8f93\u5165\u7684\u503c\u65e0\u6548\uff0c\u56e0\u4e3a\u5b83\u4e0e\u6240\u8bbe\u7f6e\u7684\u6a21\u5f0f\u4e0d\u5339\u914d\u3002" },
		{ Message.EDIT_MESSAGE_TABLE_NOT_DEFINED_ERR, "\u672a\u5bf9 {1} \u5b9a\u4e49\u7f16\u8f91\u8868 {0}\u3002" },
		{ Message.EDIT_INVALID_HEXIDECIMAL_DATA_ERR, "\u5341\u516d\u8fdb\u5236\u6570\u636e\u65e0\u6548\u3002" },
		{ Message.EDIT_VALIDATION_ERR, "\u53d1\u751f\u4e86\u9875\u9762\u9a8c\u8bc1\u9519\u8bef\u3002\u9519\u8bef\uff1a{0}\u3002" },
		{ Message.EDIT_INPUT_ERR, "\u5bf9\u8f93\u5165\u503c\u8fdb\u884c\u8bed\u6cd5\u5206\u6790\u65f6\u51fa\u9519\u3002"},
		{ Message.EDIT_OUTPUT_FORMATTING_ERR, "\u5bf9\u503c\u8fdb\u884c\u683c\u5f0f\u5316\u4ee5\u4fbf\u663e\u793a\u65f6\u51fa\u9519\uff1a{0}\u3002"},
		{ Message.EDIT_SOSI_INPUT_LENGTH_ERR, "\u5e26\u6709 SO/SI \u5b57\u7b26\u7684\u8f93\u5165\u6570\u636e\u8d85\u8fc7\u4e86\u6240\u5b9a\u4e49\u7684\u9879\u957f\u5ea6\u3002"},
		
		{ Message.ACTION_REQUEST_ERROR, "J2EELib RequestAttr \u51fd\u6570\u5931\u8d25\uff0c\u952e\u4e3a {0}\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.ACTION_SESSION_ERROR, "J2EELib SessionAttr \u51fd\u6570\u5931\u8d25\uff0c\u952e\u4e3a {0}\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.ACTION_APPLICATION_ERROR, "J2EELib ApplicationAttr \u51fd\u6570\u5931\u8d25\uff0c\u952e\u4e3a {0}\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.ACTION_NO_J2EE_ERROR, "\u53ea\u80fd\u5728 J2EE \u73af\u5883\u4e2d\u4f7f\u7528 J2EELib\u3002" },
		
		{ Message.PORTALLIB_SESSION_ERROR, "PortalLib PortletSessionAttr \u51fd\u6570\u5931\u8d25\uff0c\u952e\u4e3a {0}\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.PORTALLIB_MODE_ERROR, "PortalLib setPortletMode \u5931\u8d25\u3002\u9519\u8bef\uff1a{0}" },
		{ Message.PORTALLIB_WINDOWSTATE_ERROR, "PortalLib setWindowState \u5931\u8d25\u3002\u9519\u8bef\uff1a{0}" },
		{ Message.PORTALLIB_RENDERREQUEST_MODE_ERROR, "\u5728\u5448\u793a\u8bf7\u6c42\u671f\u95f4\u975e\u6cd5\u5c1d\u8bd5\u66f4\u6539 Portlet \u65b9\u5f0f" },
		{ Message.PORTALLIB_RENDERREQUEST_STATE_ERROR, "\u5728\u5448\u793a\u8bf7\u6c42\u671f\u95f4\u975e\u6cd5\u5c1d\u8bd5\u66f4\u6539 Portlet \u7a97\u53e3\u72b6\u6001" },
		{ Message.PORTALLIB_PORTLETSESSION_ERROR, "\u65e0\u6cd5\u83b7\u53d6 PortletSession" }, 
		{ Message.PORTALLIB_INVALIDKEY, "\u65e0\u6548\u952e\u5df2\u4f20\u9012\u81f3\u51fd\u6570 {0}" }, 
		{ Message.PORTALLIB_PORTLETREQUEST_ERROR, "\u65e0\u6cd5\u83b7\u53d6 PortletRequest" }, 
		{ Message.PORTALLIB_PREFERENCE_RESET_ERROR, "PortalLib resetPreferenceValue \u51fd\u6570\u5931\u8d25\uff0c\u952e\u4e3a {0}\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.PORTALLIB_PREFERENCE_STORE_ERROR, "PortalLib savePreferences \u51fd\u6570\u5931\u8d25\u3002\u9519\u8bef\uff1a{0}" },
		{ Message.PORTALLIB_PREFERENCE_SET_ERROR, "PortalLib \u65e0\u6cd5\u4e3a\u952e {0} \u8bbe\u7f6e\u9996\u9009\u9879\u3002\u9519\u8bef\uff1a{1}" }, 
		{ Message.PORTALLIB_PREFERENCE_GET_ERROR, "PortalLib \u65e0\u6cd5\u4e3a\u952e {0} \u83b7\u53d6\u9996\u9009\u9879\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.PORTALLIB_CREDENTIAL_VAULT_ERROR, "\u65e0\u6cd5\u8bbf\u95ee\u51ed\u8bc1\u4fdd\u9669\u5e93\u670d\u52a1\u3002\u9519\u8bef\uff1a{0}" },
		{ Message.PORTALLIB_CREDENTIAL_ACCESS_ERROR, "\u65e0\u6cd5\u8bbf\u95ee\u63d2\u69fd {0} \u4e2d\u6240\u8bf7\u6c42\u7684\u51ed\u8bc1\u3002\u9519\u8bef\uff1a{1}" },
		{ Message.PORTALLIB_CREDENTIAL_CREATE_ERROR, "\u65e0\u6cd5\u5728\u7528\u6237\u7a7a\u95f4\u4e2d\u521b\u5efa\u51ed\u8bc1\u4fdd\u9669\u5e93\u63d2\u69fd\u3002\u9519\u8bef\uff1a{0}" },
		{ Message.PORTALLIB_CREDENTIAL_DELETE_ERROR, "\u65e0\u6cd5\u5728\u7528\u6237\u7a7a\u95f4\u4e2d\u5220\u9664\u51ed\u8bc1\u4fdd\u9669\u5e93\u63d2\u69fd\u3002\u9519\u8bef\uff1a{0}" },
		{ Message.PORTALLIB_CREDENTIAL_SET_ERROR, "\u65e0\u6cd5\u8bbe\u7f6e\u51ed\u8bc1\u503c\u3002\u9519\u8bef\uff1a{0}" },

		{ Message.JAVALIB_CAUGHT_EXCEPTION, "{0} \u5931\u8d25\u3002\u8c03\u7528\u65b9\u6cd5\u6216\u8bbf\u95ee\u79f0\u4e3a {1} \u7684\u5b57\u6bb5\u5bfc\u81f4\u4e86\u672a\u5904\u7406\u7684\u9519\u8bef\u3002\u9519\u8bef\u6d88\u606f\u4e3a {2}" },
		{ Message.JAVALIB_NULL_ID, "{0} \u5931\u8d25\u3002{1} \u4e0d\u662f\u6807\u8bc6\uff0c\u6216\u8005\u5b83\u662f\u7a7a\u5bf9\u8c61\u7684\u6807\u8bc6\u3002" },
		{ Message.JAVALIB_NO_PUBLIC_METHOD_FIELD_CLASS, "{0} \u5931\u8d25\u3002\u540d\u4e3a {1} \u7684\u516c\u7528\u65b9\u6cd5\u3001\u5b57\u6bb5\u6216\u7c7b\u4e0d\u5b58\u5728\u6216\u4e0d\u80fd\u88c5\u5165\uff0c\u6216\u8005\u53c2\u6570\u7684\u6570\u76ee\u6216\u7c7b\u578b\u4e0d\u6b63\u786e\u3002\u9519\u8bef\u6d88\u606f\u4e3a {2}" },
		{ Message.JAVALIB_ARG_TYPE_MISMATCH, "{0} \u5931\u8d25\u3002EGL \u4e2d\u503c\u7684\u7c7b\u578b\u4e0e Java for {1} \u4e2d\u9700\u8981\u7684\u7c7b\u578b\u4e0d\u5339\u914d\u3002\u9519\u8bef\u6d88\u606f\u4e3a {2}" },
		{ Message.JAVALIB_NULL_RETURNED, "{0} \u5931\u8d25\u3002\u76ee\u6807\u662f\u8fd4\u56de\u4e3a\u7a7a\u7684\u65b9\u6cd5\uff0c\u5373\u672a\u8fd4\u56de\u503c\u6216\u8fd4\u56de\u4e86\u503c\u4e3a\u7a7a\u7684\u5b57\u6bb5\u7684\u65b9\u6cd5\u3002" },
		{ Message.JAVALIB_NO_CLASS_FOR_NULL_ARG, "{0} \u5931\u8d25\u3002\u672a\u80fd\u88c5\u5165\u7a7a\u81ea\u53d8\u91cf\u7684\u7c7b {1}\u3002\u9519\u8bef\u6d88\u606f\u4e3a {2}" },
		{ Message.JAVALIB_ACCESS_ERROR, "{0} \u5931\u8d25\u3002\u672a\u80fd\u83b7\u53d6\u6709\u5173\u540d\u4e3a {1} \u7684\u65b9\u6cd5\u6216\u5b57\u6bb5\u7684\u4fe1\u606f\uff0c\u6216\u8005\u5c1d\u8bd5\u4e86\u8bbe\u7f6e\u5df2\u58f0\u660e\u4e3a\u7ec8\u6001\u7684\u5b57\u6bb5\u7684\u503c\u3002\u9519\u8bef\u6d88\u606f\u4e3a {2}" },
		{ Message.JAVALIB_INSTANTIATION_ERROR, "{0} \u5931\u8d25\u3002{1} \u662f\u63a5\u53e3\u6216\u62bd\u8c61\u7c7b\uff0c\u56e0\u6b64\u4e0d\u80fd\u8c03\u7528\u6784\u9020\u51fd\u6570\u3002" },
		{ Message.JAVALIB_NOT_STATIC, "{0} \u5931\u8d25\u3002\u65b9\u6cd5\u6216\u5b57\u6bb5 {1} \u4e0d\u662f\u9759\u6001\u7684\u3002\u5fc5\u987b\u4f7f\u7528\u6807\u8bc6\u800c\u4e0d\u662f\u7c7b\u540d\u3002" },

		{ Message.CUI_E_ACTION_FIELD_DOES_NOT_EXIST, "\u64cd\u4f5c\u5b57\u6bb5 {0} \u4e0d\u5b58\u5728\u3002" },
		{ Message.CUI_E_ARRAY_FULL, "\u65e0\u6cd5\u63d2\u5165\u53e6\u4e00\u884c\uff0c\u8fd9\u662f\u56e0\u4e3a\u8f93\u5165\u6570\u7ec4\u5df2\u6ee1\u3002" },
		{ Message.CUI_E_ARRAY_NOT_FOUND, "\u627e\u4e0d\u5230\u6570\u7ec4 {0}\u3002" },
		{ Message.CUI_E_ASSIGN_RESULT, "\u5bf9\u63d0\u793a\u7ed3\u679c\u53d8\u91cf\u7684\u8d4b\u503c\u5931\u8d25\u3002" },
		{ Message.CUI_E_BAD_ARRAY_SIZE, "\u201c\u5c4f\u5e55\u6570\u7ec4\u201d\u5b57\u6bb5\u7684\u5927\u5c0f {0} \u4e0d\u6b63\u786e\u3002"	},
		{ Message.CUI_E_BAD_BOX_PARAMS, "DrawBox \u53c2\u6570\u8d85\u51fa\u8303\u56f4\u3002" },
		{ Message.CUI_E_BAD_COORDINATES, "\u663e\u793a\u5750\u6807\u8d85\u51fa\u7a97\u53e3\u8fb9\u754c\u3002" },
		{ Message.CUI_E_BAD_KEYNAME, "\u952e\u540d\u201c{0}\u201d\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\u3002" },
		{ Message.CUI_E_BAD_PICTURE_EDIT, "\u56e0\u4e3a\u5b58\u5728\u56fe\u7247\uff0c\u6240\u4ee5\u4e0d\u80fd\u4f7f\u7528\u6b64\u7f16\u8f91\u529f\u80fd\u3002" },
		{ Message.CUI_E_BAD_WINDOW_NAME, "\u627e\u4e0d\u5230\u7a97\u53e3\u201c{0}\u201d\u3002" },
		{ Message.CUI_E_BAD_WINDOW_POS_SIZE, "\u65b0\u7a97\u53e3\u4f4d\u7f6e[{0},{1}]/\u7ef4\u6570[{2},{3}] \u503c\u65e0\u6548\u3002" },
		{ Message.CUI_E_CMDSTACK_SYNC, "\u547d\u4ee4\u5806\u6808\u4e0d\u540c\u6b65\u3002" },
		{ Message.CUI_E_CONSOLELLIB_NOT_INITIALIZED, "\u63a7\u5236\u53f0 UI \u5e93\u672a\u521d\u59cb\u5316\u3002" },
		{ Message.CUI_E_CONSTRUCT_ILL_TYPE, "\u6784\u9020\u7684\u5b57\u6bb5\u7c7b\u578b\u975e\u6cd5\u3002" },
		{ Message.CUI_E_CONSTRUCT_WITH_VARLIST, "\u4e0d\u80fd\u7528\u53d8\u91cf\u5217\u8868\u8c03\u7528 ConstructQuery\u3002" },
		{ Message.CUI_E_DISABLE_INVISIBLE, "\u4e0d\u80fd\u7981\u7528\u4e0d\u53ef\u89c6\u7684\u83dc\u5355\u9879\u3002" },
		{ Message.CUI_E_EDIT_FAILED, "\u7f16\u8f91\u64cd\u4f5c\u5931\u8d25\u3002" },
		{ Message.CUI_E_EXEC_HOTKEY, "\u6267\u884c\u70ed\u952e\u64cd\u4f5c\u65f6\u53d1\u751f\u9519\u8bef\u3002" },
		{ Message.CUI_E_EXIT_NO_CMD, "\u6ca1\u6709\u8981\u9000\u51fa\u7684\u6d3b\u52a8\u547d\u4ee4\u3002" },
		{ Message.CUI_E_EXIT_NO_CONTINUE, "\u6ca1\u6709\u8981\u7ee7\u7eed\u6267\u884c\u7684\u6d3b\u52a8\u547d\u4ee4\u3002" },
		{ Message.CUI_E_FATALERROR, "\u81f4\u547d\u9519\u8bef\uff1a{0}" },
		{ Message.CUI_E_FIELD_DOES_NOT_EXIST, "\u5b57\u6bb5 {0} \u4e0d\u5b58\u5728\u3002" },
		{ Message.CUI_E_FIELD_NOT_ARRAY, "\u5c4f\u5e55\u6570\u7ec4\u5b57\u6bb5 {0} \u4e0d\u662f\u6570\u7ec4\u3002" },
		{ Message.CUI_E_FIELD_NOT_FOUND, "\u627e\u4e0d\u5230\u5b57\u6bb5 {0}\u3002" },
		{ Message.CUI_E_FIELD_NO_WINDOW, "\u6ca1\u6709\u7a97\u53e3\u5c31\u4e0d\u80fd\u521b\u5efa ConsoleField\u3002" },
		{ Message.CUI_E_FIELD_COUNT, "\u6570\u7ec4\u5b57\u6bb5\u8ba1\u6570\u4e0d\u5339\u914d\u3002" },
		{ Message.CUI_E_FORM_DOES_NOT_EXIST, "\u8868\u5355 {0} \u4e0d\u5b58\u5728\u3002" },
		{ Message.CUI_E_FORM_DOES_NOT_FIT, "\u8868\u5355 {0} \u4e0d\u80fd\u5168\u90e8\u663e\u793a\u5728\u7a97\u53e3 {1} \u4e2d\u3002" },
		{ Message.CUI_E_FORM_FLDLIST_MISMATCH, "\u5b57\u6bb5\u5217\u8868\u4e0d\u5339\u914d\u3002" },
		{ Message.CUI_E_FORM_IN_USE, "\u6b63\u5728\u4f7f\u7528\u8868\u5355 {0}\u3002" },
		{ Message.CUI_E_FORM_NAME_USED, "\u540d\u79f0\u4e3a {0} \u7684\u8868\u5355\u5df2\u5b58\u5728\u3002" },
		{ Message.CUI_E_FORM_NOT_OPEN, "\u8868\u5355 {0} \u672a\u6253\u5f00\u3002" },
		{ Message.CUI_E_FORM_NO_WINDOW, "\u6ca1\u6709\u7a97\u53e3\u5c31\u4e0d\u80fd\u521b\u5efa ConsoleForm\u3002" },
		{ Message.CUI_E_GETCHAR_VIRTUAL, "\u4e0d\u80fd\u5c06 KeyObject.getChar() \u7528\u4e8e\u865a\u62df\u952e\u3002" },
		{ Message.CUI_E_GETCOOKED_VIRTUAL, "\u4e0d\u80fd\u5c06 KeyObject.getCookedChar() \u7528\u4e8e\u865a\u62df\u952e\u3002" },
		{ Message.CUI_E_INTERNAL, "\u5185\u90e8\u9519\u8bef\uff1a{0}" },
		{ Message.CUI_E_INTR_RECEIVED, "\u63a5\u6536\u5230\u4e2d\u65ad\uff08INTERRUPT\uff09\u4fe1\u53f7\u3002" },
		{ Message.CUI_E_INVIS_NO_MNEMONIC, "\u6ca1\u6709\u52a0\u901f\u952e\u5c31\u4e0d\u80fd\u83b7\u5f97\u4e0d\u53ef\u89c6\u83dc\u5355\u9879\u3002" },
		{ Message.CUI_E_LABEL_NO_WINDOW, "\u6ca1\u6709\u7a97\u53e3\u5c31\u4e0d\u80fd\u521b\u5efa ConsoleLabel\u3002" },
		{ Message.CUI_E_MENU_DOES_NOT_FIT, "\u83dc\u5355\u9879 {0} \u4e0d\u80fd\u5168\u90e8\u663e\u793a\u5728\u7a97\u53e3\u4e2d\u3002" },
		{ Message.CUI_E_MISSING_ITEM, "\u83dc\u5355\u9879 {0} \u4e0d\u5b58\u5728\u3002" },
		{ Message.CUI_E_MNEMONIC_CONFLICT, "\u83dc\u5355\u52a9\u8bb0\u7b26\u51b2\u7a81\uff08\u952e={0}\uff09\u3002" },
		{ Message.CUI_E_NO_ACTIVE_FORM, "\u6ca1\u6709\u6d3b\u52a8\u8868\u5355\u3002" },
		{ Message.CUI_E_NO_EDITOR, "\u672a\u6307\u5b9a blob \u7f16\u8f91\u5668\u3002" },
		{ Message.CUI_E_NO_HELP_FILE, "\u672a\u6307\u5b9a\u5e2e\u52a9\u6587\u4ef6\u3002" },
		{ Message.CUI_E_NO_HELP_MSG, "\u672a\u6307\u5b9a\u5e2e\u52a9\u6d88\u606f\u3002" },
		{ Message.CUI_E_NO_NUMPAGES, "\u672a\u5e03\u7f6e\u83dc\u5355\u3002" },
		{ Message.CUI_E_NO_SCREENARRAY, "\u6ca1\u6709\u6d3b\u52a8\u5c4f\u5e55\u6570\u7ec4\u3002" },
		{ Message.CUI_E_NO_VISIBLE_ITEMS, "\u6ca1\u6709\u53ef\u89c6\u83dc\u5355\u9879\u3002" },
		{ Message.CUI_E_NULL_WNDOW_NAME, "\u65b0\u7a97\u53e3\u7684\u540d\u79f0\u4e3a\u7a7a\u3002" },
		{ Message.CUI_E_OPEN_NULL_WINDOW, "\u5c1d\u8bd5\u6253\u5f00\u7a7a\u7a97\u53e3\u3002" },
		{ Message.CUI_E_PROMPT_EXCEPTION, "\u63d0\u793a\u4e2d\u53d1\u751f\u4e86\u5f02\u5e38\u3002" },
		{ Message.CUI_E_QUIT_RECEIVED, "\u63a5\u6536\u5230\u9000\u51fa\uff08QUIT\uff09\u4fe1\u53f7\u3002" },
		{ Message.CUI_E_SCROLL_FAILED, "\u83dc\u5355\u4e0d\u80fd\u6eda\u52a8\u81f3\u5f53\u524d\u9879\u3002" },
		{ Message.CUI_E_UNKNOWN_ATTRIBUTE, "\u672a\u77e5\u5c5e\u6027\u201c{0}\u201d" },
		{ Message.CUI_E_VALIDATE_FIELD, "\u5b57\u6bb5 {0} \u4e2d\u5b58\u5728\u9519\u8bef\u3002" },
		{ Message.CUI_E_VAR_LIST_SHORT, "\u672a\u63d0\u4f9b\u8db3\u591f\u7684\u53d8\u91cf\u3002" },
		{ Message.CUI_E_WINDOW_NAME_USED, "\u5df2\u7ecf\u4f7f\u7528\u4e86\u7a97\u53e3\u540d {0}\u3002" },
		{ Message.CUI_E_WINDOW_TOO_SMALL, "\u5bf9\u4e8e\u5e2e\u52a9\u5c4f\u5e55\u6765\u8bf4\uff0c\u7a97\u53e3\u5927\u5c0f\u592a\u5c0f\u4e86\u3002" },
		{ Message.CUI_E_VALID_VALUES, "\u6307\u5b9a\u7684\u503c\u662f\u4e00\u4e2a\u65e0\u6548\u503c\u3002" },
		{ Message.CUI_W_NO_MORE_FIELDS, "\u5728\u60a8\u79fb\u52a8\u7684\u65b9\u5411\u4e0a\u4e0d\u518d\u6709\u5176\u4ed6\u5b57\u6bb5\u3002" },
		{ Message.CUI_W_NO_MORE_ROWS, "\u5728\u60a8\u79fb\u52a8\u7684\u65b9\u5411\u4e0a\u4e0d\u518d\u6709\u5176\u4ed6\u884c\u3002" },
		{ Message.CUI_E_SCREENARRAY_INVALID_CONTENTS, "\u5c4f\u5e55\u6570\u7ec4\u5185\u5bb9 {0} \u65e0\u6548\u3002" },
		{ Message.CUI_E_SCREENARRAY_SEGMENTED_FIELD, "\u5c4f\u5e55\u6570\u7ec4 {0} \u4e0d\u80fd\u5305\u542b\u5206\u6bb5\u5b57\u6bb5 {1}\u3002"	},
		{ Message.CUI_E_SCREENARRAY_INCOMPATIBLE, "\u5c4f\u5e55\u6570\u7ec4 {0} \u4e0e\u6570\u636e\u6570\u7ec4\u4e0d\u517c\u5bb9\u3002" },
		{ Message.CUI_E_FIELD_NAME_DUP, "\u591a\u6b21\u4f7f\u7528\u4e86\u5b57\u6bb5\u540d\u79f0 {0}\u3002" },
		{ Message.CUI_E_FIELD_LENGTH_INVALID, "\u63a7\u5236\u53f0\u5b57\u6bb5\u957f\u5ea6 {0} \u65e0\u6548\u3002" },
		{ Message.CUI_E_LABEL_NOT_FIT, "[{0}, {1}] \u5904\u7684\u6807\u7b7e\u65e0\u6cd5\u88c5\u5165\u5230\u63d0\u4f9b\u7684\u7a7a\u95f4\u4e2d\u3002" },
		{ Message.CUI_E_FIELD_NOT_FIT, "({1}, {2}) \u5904\u5206\u6bb5\u7684\u5b57\u6bb5 {0} \u65e0\u6cd5\u88c5\u5165\u5230\u63d0\u4f9b\u7684\u7a7a\u95f4\u4e2d\u3002" },
		{ Message.CUI_E_PROMPT_TOO_LONG,"\u5bf9\u4e8e\u6d3b\u52a8\u7a97\u53e3\u800c\u8a00\uff0c\u63d0\u793a\u5b57\u7b26\u4e32\u8fc7\u957f\u3002"},
		{ Message.CUI_E_OPENUI_ARRAY_ARGS_INVALID,"\u6570\u7ec4\u81ea\u53d8\u91cf OpenUI \u65e0\u6548\u3002"},
		{ Message.CUI_E_OPENUI_FIELD_ARGS_INVALID, "\u5b57\u6bb5\u81ea\u53d8\u91cf OpenUI \u65e0\u6548\u3002"},
		{ Message.CUI_E_PROMPT_SINGLE_VAR, "\u53ea\u80fd\u5c06\u5355\u4e2a\u53d8\u91cf\u7ed1\u5b9a\u81f3\u63d0\u793a\u8bed\u53e5\u3002" },
		{ Message.CUI_E_OPENUI_MISSING_BINDING, "\u65e0\u6cd5\u786e\u5b9a\u63a7\u5236\u53f0\u5b57\u6bb5 {0} \u7684\u6570\u636e\u7ed1\u5b9a\u3002" },
		{ Message.CUI_W_CLOB_DATA_HAS_NULLS , "\u8b66\u544a\uff1a\u5728 CLOB \u6570\u636e\u4e2d\u627e\u5230\u4e86 NUL \u5b57\u7b26" },
		{ Message.CUI_I_STR_WINDOWTITLE , "EGL \u63a7\u5236\u53f0\u7a97\u53e3" },
		{ Message.CUI_E_MISSING_FORMAT , "\u5b57\u6bb5 {0} \u6ca1\u6709\u683c\u5f0f\u5bf9\u8c61\u3002" },
		{ Message.CUI_E_VERIFY_FIELD_MISMATCH , "\u8fd9\u4e24\u4e2a\u6761\u76ee\u4e0d\u76f8\u540c \uff0d \u8bf7\u91cd\u8bd5" },
		{ Message.CUI_I_STR_VERIFY_INPUT, "\u8bf7\u518d\u6b21\u8f93\u5165\u4ee5\u8fdb\u884c\u9a8c\u8bc1" },
		{ Message.CUI_I_STR_HELP,"\u5e2e\u52a9"},
		{ Message.CUI_I_STR_RESUME,"\u7ee7\u7eed"},
		{ Message.CUI_I_STR_RESUME_COMMENT,"\u7ed3\u675f\u8be5\u5e2e\u52a9\u4f1a\u8bdd\u3002"},
		{ Message.CUI_I_STR_SCROLL , "\u6eda\u52a8" },
		{ Message.CUI_I_STR_LAST_PAGE, "\u60a8\u5df2\u7ecf\u5230\u8fbe\u5e2e\u52a9\u6587\u672c\u7684\u672b\u5c3e\u3002\u6309\u201c\u8fd4\u56de\u201d\u4ee5\u7ee7\u7eed\u3002"},
		{ Message.CUI_I_STR_SCROLL_COMMENT , "\u663e\u793a\u5e2e\u52a9\u6587\u672c\u7684\u4e0b\u4e00\u9875\u3002"},
		{ Message.CUI_I_STR_SELECT , "\u9009\u62e9"},
		{ Message.CUI_E_INSERT_FIRST_ARRAY_ROW , "\u5728\u7a7a\u7684\u6570\u7ec4\u4e2d\u63d2\u5165\u7b2c\u4e00\u884c\u65f6\u51fa\u9519\u3002"},
		{ Message.CUI_E_STR_FN_KEYS_NOT_IMPLEMENTED , "\u672a\u5b9e\u73b0 F25-F64\u3002"},
		{ Message.CUI_E_UNIMP_FN_KEYS , "\u5185\u90e8\uff1a\u672a\u5b9e\u73b0 F25-F64" },
		{ Message.CUI_E_STR_MULTIPLE_CANVAS , "\u4e0d\u80fd\u5177\u6709 CursesCanvas \u7684\u591a\u4e2a\u5b9e\u4f8b" },
		{ Message.CUI_E_STR_CANVAS_NOT_INITIALIZED , "CursesCanvas \u672a\u521d\u59cb\u5316" },
		{ Message.CUI_E_STR_CANVAS_TOO_SMALL, "CursesCanvas \u592a\u5c0f"},
		{ Message.CUI_E_STR_DISP_FIELDS_BY_NAME_NOT_IMPLEMENTED, "\u6309\u540d\u79f0\u663e\u793a\u5b57\u6bb5\u7684\u64cd\u4f5c\u672a\u5b9e\u73b0\u3002"},
		{ Message.CUI_W_MINIMUM_INPUT_REQUIRED, "\u8981\u6c42\u6700\u5c0f\u8f93\u5165 {0} \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002" },
		{ Message.CUI_W_MAXIMUM_INPUT_EXCEEDED, "\u8d85\u51fa\u6700\u5927\u8f93\u5165 {0} \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002" },
		{ Message.CUI_E_AUTOMATION_OPENING_SCRIPT_FILE, "\u65e0\u6cd5\u6253\u5f00\u811a\u672c\u6587\u4ef6\u201c{0}\u201d\u3002" },
		{ Message.CUI_E_AUTOMATION_READING_SCRIPT_FILE, "\u65e0\u6cd5\u8bfb\u53d6\u811a\u672c\u6587\u4ef6\u3002"},
		{ Message.CUI_E_AUTOMATION_SCENARIODIR_NOT_DIR, "\u5c5e\u6027 automation.scenario\u201c{0}\u201d\u4e0d\u662f\u76ee\u5f55\u3002"},
		{ Message.CUI_W_AUTOMATION_BAD_CLICK_SYNTAX, "\u5e94\u7b54\u811a\u672c\u4e2d\u7684 <click> \u4f2a\u6307\u4ee4\u683c\u5f0f\u4e0d\u6b63\u786e\u3002"},
		{ Message.CUI_E_AUTOMATION_GETTING_PROPERTY, "\u65e0\u6cd5\u83b7\u53d6\u81ea\u52a8\u5c5e\u6027\u201c{0}\u201d\u3002"},
		{ Message.CUI_E_AUTOMATION_INVALID_PANIC_KEY, "\u5e94\u6025\u952e\u540d\u201c{0}\u201d\u65e0\u6548"},
		{ Message.CUI_E_AUTOMATION_EXECUTING_CLICK, "<click> \u4e2d\u5b58\u5728\u5f02\u5e38\u3002"},
		{ Message.CUI_E_AUTOMATION_OPENING_SNAPSHOT_FILE, "\u6253\u4e0d\u5f00\u5feb\u7167\u6587\u4ef6\u201c{0}\u201d"},
		{ Message.CUI_E_AUTOMATION_SCRIPTDIR_DOES_NOT_EXIST, "automation.scriptdir\u201c{0}\u201d\u7684\u5c5e\u6027\u96c6\u4e0d\u5b58\u5728\u3002"},
		{ Message.CUI_E_AUTOMATION_CREATING_SCENARIODIR, "\u65e0\u6cd5\u4e3a automation.scenario \u76ee\u5f55\u201c{0}\u201d\u521b\u5efa\u5c5e\u6027\u96c6\u3002"},
		{ Message.CUI_W_AUTOMATION_INVALID_SNAPSHOT_KEY, "\u5feb\u7167\u952e\u540d\u201c{0}\u201d\u65e0\u6548"},
		{ Message.CUI_I_AUTOMATION_COMPARE_OK, "\u6bd4\u8f83\u5b8c\u6210\u3002"},
		{ Message.CUI_E_RCP_DISPLAYLINEMODE, "\u4ee5 RCP \u65b9\u5f0f\u8fd0\u884c\u65f6\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u663e\u793a I/O \u64cd\u4f5c\u3002"},
		
		{ Message.MSG_TBL_MSG_MISSING_ERR, "\u6d88\u606f\u8868 {1} \u4e2d\u4e0d\u5b58\u5728\u6807\u8bc6\u4e3a {0} \u7684\u6d88\u606f\u3002" },
		{ Message.MSG_TBL_LOAD_ERR, "\u65e0\u6cd5\u88c5\u5165\u6d88\u606f\u8868\u6587\u4ef6 {0}\u3002" },
		{ Message.MSG_TBL_AS_BUNDLE_LOAD_ERR, "\u6ca1\u6709\u4e3a {0} VGUIRecord \u5b9a\u4e49\u7684\u7528\u6237\u6d88\u606f\u8868\u3002" },

		
		{ Message.TUI_E_FIELD_OUTSIDE_FORM, "\u4f4d\u7f6e ({1},{2}) \u5904\u7684\u5b57\u6bb5\u201c{0}\u201d\u4e0d\u5728\u8868\u5355\u4e2d\u3002" },
		{ Message.TUI_E_FIELD_OVERLAP, "\u5b57\u6bb5\u201c{0}\u201d\u4e0e\u201c{1}\u201d\u91cd\u53e0\u3002" },
		{ Message.TUI_E_NO_FORMGROUP, "\u5185\u90e8\u9519\u8bef\uff1a\u65e0\u6cd5\u786e\u5b9a\u8868\u5355\u7ec4\u3002" },
		{ Message.TUI_E_FLOATING_FORM_DOES_NOT_FIT, "\u8868\u5355\u201c{0}\u201d\u7684\u5927\u5c0f\u5728\u4efb\u4f55\u6d6e\u52a8\u533a\u57df\u4e2d\u5747\u4e0d\u9002\u5408\u3002" },
		{ Message.TUI_E_BAD_FIELD_COORDS, "\u5b57\u6bb5\u201c{0}\u201d\u7684\u5750\u6807\u65e0\u6548\u3002" },
		{ Message.TUI_E_NO_PRINTASSOCIATION, "\u65e0\u6cd5\u83b7\u53d6\u6253\u5370\u5173\u8054\u3002" },
		{ Message.TUI_E_NO_SUITABLE_PRINT_DEVICE_SIZE, "\u4e0d\u5b58\u5728\u5408\u9002\u7684\u6253\u5370\u8bbe\u5907\u5927\u5c0f\u3002" },
		{ Message.TUI_E_NO_DISPLAY, "\u4e0d\u5b58\u5728\u7528\u4e8e\u8868\u5355\u7684\u663e\u793a\u8bbe\u5907\u3002" },
		{ Message.TUI_E_NO_SUITABLE_DEVICE_SIZE, "\u5bf9\u4e8e\u6240\u663e\u793a\u7684\u8868\u5355\uff0c\u4e0d\u5b58\u5728\u517c\u5bb9\u7684\u8bbe\u5907\u5927\u5c0f\u3002" },
		{ Message.TUI_E_HELP_FORM_CLASS_DOES_NOT_EXIST, "\u5e2e\u52a9\u8868\u5355\u7c7b\u201c{0}\u201d\u4e0d\u5b58\u5728\u3002" },
		{ Message.TUI_E_UNKNOWN_ATTRIBUTE, "\u672a\u77e5\u5c5e\u6027\u201c{0}\u201d\u3002" },
		{ Message.TUI_E_INVALID_VALID_VALUE, "\u5728\u6709\u6548\u503c\u5c5e\u6027\u4e2d\u6307\u5b9a\u7684\u503c\u4e0d\u6b63\u786e\uff0c\u672a\u80fd\u5bf9\u5b83\u8fdb\u884c\u8bed\u6cd5\u5206\u6790\u3002" },
		{ Message.TUI_E_CANT_CREATE_HELP_FORM, "\u65e0\u6cd5\u521b\u5efa\u5e2e\u52a9\u8868\u5355\u201c{0}\u201d" },
		{ Message.TUI_E_INTERNAL, "\u5185\u90e8\u9519\u8bef\uff1a{0}" },
		{ Message.TUI_E_NO_PRINTERS, "\u6ca1\u6709\u53ef\u4ee5\u4f7f\u7528\u7684\u6253\u5370\u673a\u3002" },
		{ Message.TUI_E_NO_DEFAULT_PRINTER, "\u4e0d\u5b58\u5728\u7f3a\u7701\u6253\u5370\u673a\u3002" },
		{ Message.TUI_E_PRINTER_NOT_FOUND, "\u627e\u4e0d\u5230\u6253\u5370\u673a\u201c{0}\u201d\u3002\n\u53ef\u4ee5\u4f7f\u7528\u4e0b\u5217\u6253\u5370\u673a\uff1a\n{1}" },
		{ Message.TUI_E_LOADING_MESSAGE, "\u88c5\u5165\u6d88\u606f\u201c{0}\u201d\u65f6\u51fa\u9519" },
		{ Message.TUI_CONTENT_CONVERSION_ERR, "{0} \u7684\u5185\u5bb9\u4e0d\u80fd\u7528\u4f5c\u5b57\u6bb5\u3002" },
		{ Message.TUI_E_PRINTJOB_PRINTER_NOT_FOUND, "\u627e\u4e0d\u5230\u6253\u5370\u673a\u201c{0}\u201d" },
		{ Message.TUI_E_WRONG_INPUT_FORM_ERR, "\u7a0b\u5e8f {0} \u9700\u8981\u6587\u672c\u683c\u5f0f {1}\uff0c\u4f46\u662f\u5728 show \u8bed\u53e5\u4e2d\u5df2\u4e3a\u5b83\u63d0\u4f9b\u6587\u672c\u683c\u5f0f {2}\u3002" },
		{ Message.TUI_I_PRINTPREVIEW_STR_NEXT, "\u4e0b\u4e00\u9875" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PAGE, "\u7b2c {0} \u9875\uff08\u5171 {1} \u9875\uff09" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PREV, "\u4e0a\u4e00\u9875" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT, "\u6253\u5370" },
		{ Message.TUI_I_PRINTPREVIEW_STR_PRINT_PREVIEW, "\u6253\u5370\u9884\u89c8 \uff0d {0}" },
		{ Message.TUI_I_PRINTPREVIEW_STR_SAVE, "\u4fdd\u5b58" },
		{ Message.TUI_I_PRINTTOFILE_STR_SAVE_PRINTJOB, "\u4fdd\u5b58\u6253\u5370\u4f5c\u4e1a \uff0d {0}" },
		{ Message.TUI_I_PRINTTOFILE_STR_PRINTING_TO_FILE, "\u6253\u5370\u81f3\u6587\u4ef6 {0} \u65f6\u51fa\u9519" },
		{ Message.TUI_I_PRINTTOPRINTER_STR_PRINTING_TO_PRINTER, "\u6253\u5370\u81f3\u6253\u5370\u673a {0} \u65f6\u51fa\u9519" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_SETTING_EZEMNO, "\u8bbe\u7f6e EZEMNO" },
		{ Message.TUI_I_TERMINALEMULATOR_STR_VALIDATING_FIELD, "\u9a8c\u8bc1\u5b57\u6bb5\u201c{0}\u201d" },
		{ Message.TUI_I_TEXTFORM_STR_VALIDATING_TEXTFORM, "\u9a8c\u8bc1\u6587\u672c\u683c\u5f0f" },
		{ Message.TUI_I_TEXTFORM_STR_RUNNING_VALIDATOR, "\u9a8c\u8bc1\u6587\u672c\u683c\u5f0f \uff0d \u8fd0\u884c\u9a8c\u8bc1\u5668\u51fd\u6570\u201c{0}\u201d" },
		
		{ Message.LOG_E_UTILITY_CREATING_LOGWRITER, "\u4e0d\u80fd\u521b\u5efa\u65e5\u5fd7\u7f16\u5199\u5668\u3002" },
		{ Message.LOG_W_UTILITY_SETTING_LOG_PARAM_TOO_LATE, "\u5728\u542f\u52a8\u4e4b\u540e\u4e0d\u80fd\u8bbe\u7f6e\u8bb0\u5f55\u53c2\u6570\u201c{0}\u201d\u3002" },
		{ Message.LOG_E_UTILITY_LOGDIR_DOES_NOT_EXIST, "\u65e5\u5fd7\u76ee\u5f55\u201c{0}\u201d\u4e0d\u5b58\u5728\u3002" },
		{ Message.LOG_E_UTILITY_LOGDIR_NOT_WRITABLE, "\u4e0d\u80fd\u5199\u81f3\u65e5\u5fd7\u76ee\u5f55\u201c{0}\u201d\u3002" },
		{ Message.LOG_E_UTILITY_CREATING_LOGFILE, "\u4e0d\u80fd\u521b\u5efa\u65e5\u5fd7\u6587\u4ef6\u201c{0}\u201d\u3002" },
		{ Message.LOG_E_UTILITY_LOGFILE_NOT_WRITABLE, "\u4e0d\u80fd\u5199\u81f3\u65e5\u5fd7\u6587\u4ef6\u201c{0}\u201d\u3002" },
		
		{ Message.SOA_E_LOAD_SERVICE, "\u88c5\u5165\u7ec4\u4ef6/\u5916\u90e8\u670d\u52a1 {0} \u7684\u670d\u52a1\u65f6\u51fa\u73b0\u95ee\u9898\u3002" },
		{ Message.SOA_E_WS_CREATE_CALL_OBJECT, "\u521b\u5efa\u4e0e Web Service \u64cd\u4f5c\u201c{0}\u201d\u7684\u8fde\u63a5\u65f6\u51fa\u9519\u3002{1}\u3002" },
		{ Message.SOA_E_WS_GET_OPERATION, "\u4ece WSDL \u6587\u4ef6\u201c{1}\u201d\u4e2d\u83b7\u53d6\u64cd\u4f5c\u201c{0}\u201d\u65f6\u51fa\u9519\u3002" },
		{ Message.SOA_E_WS_MALFORMED_URL, "Web Service \u64cd\u4f5c {1} \u7684\u76ee\u6807 URL \u65e0\u6548\u3002URL\uff1a{0}" },
		{ Message.SOA_E_LOAD_LOCAL_SERVICE, "\u88c5\u5165\u670d\u52a1 {0} \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u9519\u8bef\uff1a{1}\u3002" },
		{ Message.SOA_E_LOAD_WEB_PROXY, "\u5c1d\u8bd5\u88c5\u5165 Web Service \u65f6\u53d1\u751f\u9519\u8bef\u3002\u672a\u80fd\u89e3\u6790\u5916\u90e8\u670d\u52a1 {0} \u7684 WSDL \u7aef\u53e3\u3002" },
		{ Message.SOA_E_MISSING_REQUIRED_PROPERTY, "\u7ec4\u4ef6 {0} \u7f3a\u5c11\u5b9e\u73b0\u670d\u52a1\u6240\u5fc5\u9700\u7684\u5c5e\u6027 {1}\u3002" },
		{ Message.SOA_E_MISSING_REFERENCE_TARGET, "\u7f3a\u5c11\u670d\u52a1\u5f15\u7528\u201c{0}\u201d\u6216\u8005\u5b83\u6ca1\u6709\u76ee\u6807\u503c\u3002" },
		{ Message.SOA_E_MISSING_BINDING, "\u90e8\u7f72\u63cf\u8ff0\u7b26\u201c{1}\u201d\u4e2d\u4e0d\u5b58\u5728\u670d\u52a1\u7ed1\u5b9a\u201c{0}\u201d\u3002" },
		{ Message.SOA_E_WS_TYPE_MAPPING_CONTAINER_REGISTER, "\u5c1d\u8bd5\u5c06\u8bb0\u5f55\u201c{0}\u201d\u8f6c\u6362\u4e3a SOAP \u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef\u3002\u5728\u8bb0\u5f55\u4e2d\u65e0\u6cd5\u627e\u5230\u5b57\u6bb5\u201c{1}\u201d\u3002" },
		{ Message.SOA_E_WS_TYPE_MAPPING_REGISTER, "\u5c1d\u8bd5\u5c06\u201c{0}\u201d\u8f6c\u6362\u4e3a SOAP \u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef\u3002"},
		{ Message.SOA_E_WS_JAVA_TYPE_INCOMPATIBLE_EGL, "\u5904\u7406\u6765\u81ea Web Service \u7684\u7ed1\u5165\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef\u3002Java \u7c7b\u578b\u4e0e EGL \u7c7b\u578b\u4e0d\u517c\u5bb9\u3002" },
		{ Message.SOA_E_WS_EGL_TYPE_INCOMPATIBLE_JAVA, "\u5904\u7406\u6765\u81ea Web Service \u7684\u7ed1\u51fa\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef\u3002EGL \u7c7b\u578b\u4e0e Java \u7c7b\u578b\u4e0d\u517c\u5bb9\u3002" },
		{ Message.SOA_E_WS_FIXED_RECORD_INITIALIZATION, "\u65e0\u6cd5\u521d\u59cb\u5316\u8bb0\u5f55\u201c{0}\u201d\u3002" },
		{ Message.SOA_E_WS_INVALID_CALENDAR_VALUE, "\u4e0d\u80fd\u5c06\u503c\u201c{0}\u201d\u8f6c\u6362\u4e3a Calendar \u503c\u3002" },
		{ Message.SOA_E_WS_INVALID_BOOLEAN_VALUE, "\u4e0d\u80fd\u5c06\u503c\u201c{0}\u201d\u8f6c\u6362\u4e3a boolean \u503c\u3002" },
		{ Message.SOA_E_WS_INVALID_BYTE_VALUE, "\u4e0d\u80fd\u5c06\u503c\u201c{0}\u201d\u8f6c\u6362\u4e3a Byte \u503c\u3002" },
		{ Message.SOA_E_WS_INVALID_SHORT_VALUE, "\u4e0d\u80fd\u5c06\u503c\u201c{0}\u201d\u8f6c\u6362\u4e3a short \u503c\u3002" },
		{ Message.SOA_E_WS_INVALID_URI_VALUE, "\u4e0d\u80fd\u5c06\u503c\u201c{0}\u201d\u8f6c\u6362\u4e3a URI\u3002" },
		{ Message.SOA_E_WS_UNSUPPORTED_EGL_TYPE, "\u4e0d\u652f\u6301\u5c06 EGL \u7c7b\u578b\u7528\u4f5c Web Service \u53c2\u6570\u3002" },
		{ Message.SOA_E_WS_CONTAINER_ARRAY_FAILED, "\u5c1d\u8bd5\u521b\u5efa\u8bb0\u5f55\u6570\u7ec4\u65f6\u53d1\u751f\u9519\u8bef\u3002{0}\u3002" },
		{ Message.SOA_E_METHOD_NOT_FOUND, "\u5728\u670d\u52a1 {1} \u4e2d\u65e0\u6cd5\u627e\u5230\u65b9\u6cd5 {0}\u3002" },
		{ Message.SOA_E_NOT_WEB_SERVICE, "\u670d\u52a1\u4e0d\u662f Web Service\u3002" },
		{ Message.SOA_E_WEB_SERVICE_INVOCATION, "\u5c1d\u8bd5\u5bf9 WebService {1} \u8c03\u7528\u51fd\u6570 {0} \u65f6\u53d1\u751f\u9519\u8bef\u3002" },
		{ Message.SOA_E_EGL_SERVICE_INVOCATION, "\u5c1d\u8bd5\u5bf9 EGL \u670d\u52a1 {1} \u8c03\u7528\u51fd\u6570 {0} \u65f6\u53d1\u751f\u9519\u8bef\u3002" },
		{ Message.SOA_E_EGL_TCPIP_SERVICE_INVOCATION, "\u5c1d\u8bd5\u4f7f\u7528 {2}:{3} \u6765\u5bf9 EGL \u670d\u52a1 {1} \u8c03\u7528\u51fd\u6570 {0} \u65f6\u53d1\u751f\u9519\u8bef\u3002" },
		{ Message.SOA_E_NOT_TCPIP_SERVICE, "\u670d\u52a1\u4e0d\u662f TCP/IP \u670d\u52a1\u3002" },
		{ Message.SOA_E_EGL_TCPIP_REMOTE_SERVICE_INVOCATION, "\u5c1d\u8bd5\u5bf9\u5165\u53e3\u70b9 {1} \u8c03\u7528\u51fd\u6570 {0} \u65f6\u53d1\u751f\u9519\u8bef\u3002" },
		{ Message.SOA_E_SERVICE_BINDING_ERROR, "\u5c1d\u8bd5\u88c5\u5165\u670d\u52a1\u7ed1\u5b9a\u6587\u4ef6 {0} \u65f6\u53d1\u751f\u9519\u8bef\u3002{1}" },
		{ Message.SOA_E_CICS_SERVICE_INVOCATION, "\u5c1d\u8bd5\u5bf9 CICS \u670d\u52a1 {1} \u8c03\u7528\u51fd\u6570 {0} \u65f6\u53d1\u751f\u9519\u8bef\u3002\u9519\u8bef\u4ee3\u7801\u4e3a {2} \u4e14\u6d88\u606f\u4e3a {3}" },
		{ Message.SOA_E_ISERIES_SERVICE_INVOCATION, "\u5c1d\u8bd5\u5bf9 iSeries \u670d\u52a1 {1} \u8c03\u7528\u51fd\u6570 {0} \u65f6\u53d1\u751f\u9519\u8bef\u3002\u9519\u8bef\u4ee3\u7801\u4e3a {2} \u4e14\u6d88\u606f\u4e3a {3}" },
		{ Message.SOA_E_NOT_CICS_SERVICE, "\u670d\u52a1\u4e0d\u662f CICS \u670d\u52a1\u3002" },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR, "\u7cfb\u7edf {3} \u4e0a\u7684\u8fdc\u7a0b\u670d\u52a1 {0} \u4e2d\u53d1\u751f\u9519\u8bef\uff0c\u65e5\u671f\u4e3a {1}\uff0c\u65f6\u95f4\u4e3a {2}\u3002" },
		{ Message.SOA_E_REMOTE_SERVICE_ERROR2, "\u7cfb\u7edf {1} \u4e0a\u7684\u8fdc\u7a0b\u670d\u52a1 {0} \u4e2d\u53d1\u751f\u9519\u8bef\u3002" },
		{ Message.SOA_E_AS400_APPLICATION_ERROR, "\u7531\u4e8e\u5c1d\u8bd5\u8c03\u7528\u670d\u52a1 {1} \u65f6\u7cfb\u7edf {0} \u4e0a\u53d1\u751f\u5e94\u7528\u7a0b\u5e8f\u9519\u8bef\uff0c\u6240\u4ee5\u8fd0\u884c\u5355\u5143\u5df2\u7ed3\u675f\u3002\u6d88\u606f\uff1a{2}" },
		{ Message.SOA_E_AS400_EXCEPTION_CAUGHT, "\u5728\u7cfb\u7edf {3} \u4e0a\u8c03\u7528\u670d\u52a1 {2} \u65f6\u51fa\u73b0 AS400Toolbox \u6267\u884c\u9519\u8bef\uff1a{0} \u548c {1}\u3002" },
		{ Message.SOA_E_WEBSPHERE_BINDING_ERROR, "\u670d\u52a1\u5ba2\u6237\u673a\u7ed1\u5b9a\u4e0d\u53d7\u652f\u6301\u3002\u5df2\u9488\u5bf9 Websphere \u751f\u6210 {0}\uff0c\u4f46\u662f\u5b83\u6b63\u5728\u88ab\u4ece\u975e J2EE \u73af\u5883\u8c03\u7528\u3002\u8bf7\u91cd\u65b0\u751f\u6210\u5230\u975e J2EE \u9879\u76ee\u4e2d\u3002" },
		{ Message.SOA_E_USER_ID_NOT_SET, "\u5728\u8c03\u7528 WebService:{0} function:{1} \u4e4b\u524d\uff0c\u5fc5\u987b\u8bbe\u7f6e\u8fdc\u7a0b\u7528\u6237\u6807\u8bc6\u548c\u5bc6\u7801\u3002" },
		{ Message.SOA_E_WS_PROXY_UNIDENTIFIED, "\u8c03\u7528\u670d\u52a1\u65f6\u53d1\u751f\u5f02\u5e38\u3002" },
		{ Message.SOA_E_WS_PROXY_COMMUNICATION, "\u4e0e\u670d\u52a1\u8fdb\u884c\u901a\u4fe1\u65f6\u53d1\u751f\u5f02\u5e38\u3002URL\uff1a{0}" },
		{ Message.SOA_E_WS_PROXY_REST, "\u8c03\u7528 REST \u670d\u52a1\u65f6\u53d1\u751f\u5f02\u5e38\u3002\u7ed1\u5b9a\uff1a{0}\uff0c\u64cd\u4f5c\uff1a{0}" },
		{ Message.SOA_E_WS_PROXY_SOAP, "\u8c03\u7528 SOAP \u670d\u52a1\u65f6\u53d1\u751f\u5f02\u5e38\u3002\u7ed1\u5b9a\uff1a{0}\uff0c\u670d\u52a1\uff1a{1}\uff0c\u7aef\u53e3\uff1a{2}\uff0cWSDL \u4f4d\u7f6e\uff1a{3}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_JSON2EGL, "\u4ece JSON \u8fdb\u884c\u8f6c\u6362\u65f6\u53d1\u751f\u4e86\u5f02\u5e38\u3002\u53c2\u6570\uff1a{0}\uff0cjson\uff1a{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2JSON, "\u8f6c\u6362\u4e3a JSON \u65f6\u53d1\u751f\u4e86\u5f02\u5e38\u3002\u53c2\u6570\uff1a{0}\uff0c\u503c\uff1a{1}" },
		{ Message.SOA_E_WS_REST_NO_SERVICE, "\u627e\u4e0d\u5230 REST-RPC \u670d\u52a1\u3002URL\uff1a{0}" },
		{ Message.SOA_E_WS_REST_NO_RESPONSE, "\u672a\u63a5\u6536\u5230\u6765\u81ea\u670d\u52a1\u7684\u54cd\u5e94\u3002URL\uff1a{0}" },
		{ Message.SOA_E_WS_REST_BAD_CONTENT, "\u672a\u80fd\u5c06\u8bf7\u6c42\u8f6c\u6362\u4e3a\u670d\u52a1\u8c03\u7528\u3002\u63a5\u6536\u5230\u7684\u8bf7\u6c42\u4e3a\u201c{0}\u201d\u3002" },
		{ Message.SOA_E_WS_PROXY_SERVICE_TIMEOUT, "\u670d\u52a1\u8c03\u7528\u8d85\u65f6\u3002\u5f02\u5e38\uff1a\u53d1\u751f\u4e86\u8fde\u63a5\u8bfb\u53d6\u8d85\u65f6\u9519\u8bef\u3002URL\uff1a{0}" },
		{ Message.SOA_E_NOT_REST_SERVICE, "\u8be5\u670d\u52a1\u4e0d\u662f REST \u670d\u52a1\u3002" },
		{ Message.SOA_E_REST_SERVICE, "\u5bf9 REST \u670d\u52a1\u8c03\u7528\u7684\u8c03\u7528\u5931\u8d25\u3002\u7ed1\u5b9a\uff1a{0}\uff0c\u64cd\u4f5c\uff1a{1}\uff0cHTTP \u65b9\u6cd5\uff1a{2}" },
		{ Message.SOA_E_REST_DATA_CONVERSION, "\u5c06\u6570\u636e\u8f6c\u6362\u4e3a EGL \u53c2\u6570\u65f6\u53d1\u751f\u5f02\u5e38\u3002\u7ed1\u5b9a\uff1a{0}\uff0c\u8981\u8f6c\u6362\u7684\u6570\u636e\uff1a{1}\uff0c\u5f02\u5e38\uff1a{2}" },
		{ Message.SOA_E_REST_UNSUPPORTED, "\u5df2\u5bf9\u975e REST \u670d\u52a1\u5f15\u7528\u8fdb\u884c REST \u670d\u52a1\u8c03\u7528\u3002\u670d\u52a1\u5f15\u7528\uff1a{0}\uff0c\u64cd\u4f5c\uff1a{1}\uff0cHTTP \u65b9\u6cd5\uff1a{2}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML_MISSING, "\u4ece XML \u8fdb\u884c\u8f6c\u6362\u65f6\u53d1\u751f\u5f02\u5e38\u3002\u7f3a\u5c11\u5fc5\u9700\u5143\u7d20 {0}\u3002" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_XML2EGL, "\u4ece XML \u8fdb\u884c\u8f6c\u6362\u65f6\u53d1\u751f\u5f02\u5e38\u3002\u53c2\u6570\uff1a{0}\uff0cXML\uff1a{1}" },
		{ Message.SOA_E_WS_PROXY_PARMETERS_EGL2XML, "\u8f6c\u6362\u4e3a XML \u65f6\u53d1\u751f\u5f02\u5e38\u3002\u53c2\u6570\uff1a{0}\uff0c\u503c\uff1a{1}" },
		{ Message.SOA_E_WS_PROXY_XML_PARSE_EXCEPTION, "\u5c06 {0} \u4ece XML \u8fdb\u884c\u8f6c\u6362\u65f6\u53d1\u751f XML \u89e3\u6790\u5f02\u5e38\u3002" },
		{ Message.SOA_E_WS_PROXY_XML_CONVERT_EXCEPTION, "\u5c06 {0} \u8f6c\u6362\u4e3a XML \u65f6\u53d1\u751f XML \u8f6c\u6362\u5f02\u5e38\u3002" },
		{ Message.SOA_E_WS_PROXY_INVALID_HTTP_EXCEPTION, "\u7528\u6765\u8c03\u7528\u670d\u52a1\u7684 URL\u201c{0}\u201d\u65e0\u6548\u3002\u5b83\u672a\u5305\u542b http:// \u534f\u8bae\u3002" },
		{ Message.SOA_E_WS_PROXY_INVALID_URL_EXCEPTION, "\u7528\u6765\u8c03\u7528\u670d\u52a1\u7684 URL\u201c{0}\u201d\u65e0\u6548\u3002{1}" },
		{ Message.SOA_E_WS_PROXY_EMPTY_URL_EXCEPTION, "\u7528\u6765\u8c03\u7528\u670d\u52a1\u7684 URL \u4e3a\u7a7a\u767d\u3002\u8bf7\u6307\u5b9a\u6307\u5411\u670d\u52a1\u7684 URL\u3002" },
			
		//Reporting errors.
		{ Message.REPORT_E_FILL_WITH_CONNECTION_ERROR, "\u672a\u80fd\u4f7f\u7528\u8fde\u63a5 {0} \u6765\u586b\u5145\u62a5\u544a"},
		{ Message.REPORT_E_FILL_WITH_SQL_ERROR, "\u672a\u80fd\u4f7f\u7528 sql \u8bed\u53e5 {0} \u6765\u586b\u5145\u62a5\u544a"},
		{ Message.REPORT_E_FILL_WITH_DATA_ERROR, "\u672a\u80fd\u4f7f\u7528\u52a8\u6001\u6570\u7ec4 {0} \u6765\u586b\u5145\u62a5\u544a"},
		{ Message.REPORT_E_FILL_ERROR , "\u672a\u80fd\u586b\u5145\u62a5\u544a {0}"},
		{ Message.REPORT_E_EXPORT_ERROR, "\u672a\u80fd\u5bfc\u51fa\u62a5\u544a {0}" },
		{ Message.REPORT_E_EGL_TO_JAVA_CONVERSION_ERROR, "\u672a\u80fd\u5728 EGL {0} \u7c7b\u578b\u4e0e Java {1} \u7c7b\u578b\u4e4b\u95f4\u8f6c\u6362" },
		{ Message.REPORT_E_JAVA_TO_EGL_CONVERSION_ERROR, "\u672a\u80fd\u5728 Java {0} \u7c7b\u578b\u4e0e EGL {1} \u7c7b\u578b\u4e4b\u95f4\u8f6c\u6362" },
		{ Message.REPORT_E_ADD_REPORT_PARAMETER_ERROR, "\u672a\u80fd\u6dfb\u52a0\u62a5\u544a\u53c2\u6570" },
		{ Message.REPORT_E_RESET_REPORT_PARAMETER_ERROR, "\u672a\u80fd\u91cd\u65b0\u8bbe\u7f6e\u62a5\u544a\u53c2\u6570\u5217\u8868" },
		{ Message.REPORT_E_FIELD_NAME_ERROR , "\u5b57\u6bb5\u540d\u79f0 {0} \u4e0d\u6b63\u786e" },
		{ Message.REPORT_E_SUBREPORT_NAME_ERROR, "\u5b50\u62a5\u544a\u540d\u79f0 {0} \u4e0d\u6b63\u786e" },
		{ Message.REPORT_E_UNSUPPORTED_EGL_TYPE_ERROR, "\u5728\u62a5\u544a\u4e2d\u4f7f\u7528\u7684\u7c7b\u578b\u4e0d\u53d7\u652f\u6301" },
		{ Message.REPORT_E_COMPLEX_TYPE_ERROR, "\u4e0d\u80fd\u5c06\u590d\u6742\u7c7b\u578b\u4f20\u9012\u81f3\u6b64\u51fd\u6570" },
		
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_NO_FILE_ERROR, "\u5728\u8c03\u7528 getParameterDefaultValue() \u51fd\u6570\u4e4b\u524d\uff0c\u5e94\u8be5\u5148\u8bbe\u7f6e\u8bbe\u8ba1\u6587\u4ef6\u540d\u3002" },
		{ Message.BIRT_GET_PARAMETER_DEFAULT_VALUE_ERROR, "\u672a\u80fd\u83b7\u53d6\u53c2\u6570 {0} \u7684\u7f3a\u7701\u503c\u3002{1}" },
		{ Message.BIRT_REPORT_PARAMETER_DOES_NOT_EXIST_ERROR, "\u540d\u4e3a {0} \u7684\u62a5\u544a\u53c2\u6570\u4e0d\u5b58\u5728\u3002" },
		{ Message.BIRT_DESIGN_FILE_NOT_SPECIFIED_ERROR, "\u5728\u8c03\u7528 createReportFromDesign() \u6216 createDocument() \u51fd\u6570\u4e4b\u524d\uff0c\u5e94\u8be5\u5148\u8bbe\u7f6e\u8bbe\u8ba1\u6587\u4ef6\u540d\u3002" },
		{ Message.BIRT_DOCUMENT_FILE_NOT_SPECIFIED_ERROR, "\u5728\u8c03\u7528 createReportFromDocument() \u51fd\u6570\u4e4b\u524d\uff0c\u5e94\u8be5\u5148\u8bbe\u7f6e\u6587\u6863\u6587\u4ef6\u540d\u3002" },
		{ Message.BIRT_CREATE_DOCUMENT_ERROR, "\u672a\u80fd\u521b\u5efa\u62a5\u544a\u6587\u6863\u6587\u4ef6\u3002{0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DESIGN_ERROR, "\u672a\u80fd\u4ece\u8bbe\u8ba1\u6587\u4ef6\u521b\u5efa\u62a5\u544a\u3002{0}" },
		{ Message.BIRT_CREATE_REPORT_FROM_DOCUMENT_ERROR, "\u672a\u80fd\u4ece\u6587\u6863\u6587\u4ef6\u521b\u5efa\u62a5\u544a\u3002{0}" },
		{ Message.BIRT_HANDLER_TYPE_ERROR, "\u4e3a BirtReport \u6307\u5b9a\u7684\u5904\u7406\u7a0b\u5e8f\u5bf9\u8c61\u7684\u7c7b\u578b\u5fc5\u987b\u4e3a BirtHandler\u3002" },
		{ Message.BIRT_ELEMENT_NOT_FOUND_ERROR, "\u62a5\u544a\u8bbe\u8ba1\u4e2d\u4e0d\u5b58\u5728\u5143\u7d20 {0}\uff0c\u6216\u8005\u8be5\u5143\u7d20\u4e0d\u662f\u6307\u5b9a\u7684\u7c7b\u578b\u3002" },
		{ Message.BIRT_TABLE_ROW_NOT_FOUND_ERROR, "\u8868 {2} \u4e2d\u4e0d\u5b58\u5728 {0} \u884c\u53f7 {1}\u3002" },
		{ Message.BIRT_GRID_ROW_NOT_FOUND_ERROR, "\u7f51\u683c\u5143\u7d20 {1} \u4e2d\u4e0d\u5b58\u5728\u884c\u53f7 {0}\u3002" },
		{ Message.BIRT_GROUP_NOT_FOUND_ERROR, "\u8868 {1} \u4e2d\u4e0d\u5b58\u5728\u7ec4 {0}\u3002" },
		{ Message.BIRT_GROUP_ROW_NOT_FOUND_ERROR, "\u8868 {3} \u7684\u7ec4 {2} \u4e2d\u4e0d\u5b58\u5728 {0} \u884c\u53f7 {1}\u3002" },
		{ Message.BIRT_TABLE_COLUMN_NOT_FOUND_ERROR, "\u8868 {2} \u7684\u884c {1} \u4e2d\u4e0d\u5b58\u5728\u5217\u53f7 {0}\u3002" },
		{ Message.BIRT_GRID_COLUMN_NOT_FOUND_ERROR, "\u7f51\u683c {1} \u4e2d\u4e0d\u5b58\u5728\u5217\u53f7 {0}\u3002" },
		{ Message.BIRT_GROUP_COLUMN_NOT_FOUND_ERROR, "\u8868 {3} \u7684\u7ec4 {2} \u7684\u884c {1} \u4e2d\u4e0d\u5b58\u5728\u5217\u53f7 {0}\u3002" },
		{ Message.BIRT_ROW_TYPE_NOT_SPECIFIED_ERROR, "\u5fc5\u987b\u4e3a\u8868 {0} \u4e2d\u7684\u884c\u6216\u5355\u5143\u683c\u7684\u4e8b\u4ef6\u5904\u7406\u7a0b\u5e8f\u51fd\u6570\u6307\u5b9a\u201cRowType\u201d\u5c5e\u6027\u3002" },
		{ Message.BIRT_JAVA_TO_EGL_CONVERSION_ERROR, "\u672a\u80fd\u5c06 Java \u7c7b\u578b {0} \u8f6c\u6362\u4e3a EGL \u7c7b\u578b\u3002" },
		{ Message.BIRT_EGL_TO_JAVA_CONVERSION_ERROR, "\u672a\u80fd\u5c06 EGL \u7c7b\u578b {0} \u8f6c\u6362\u4e3a Java \u7c7b\u578b\u3002" },
		{ Message.BIRT_DATA_SET_NOT_FOUND_ERROR, "\u62a5\u544a\u8bbe\u8ba1\u4e2d\u4e0d\u5b58\u5728\u6570\u636e\u96c6 {0}\u3002" },
		{ Message.BIRT_SCRIPTED_DATA_SET_ERROR, "\u6570\u636e\u96c6 {0} \u662f\u4e00\u4e2a\u5e26\u6709\u811a\u672c\u7684\u6570\u636e\u96c6\uff0c\u4f46\u662f\u672a\u5904\u7406\u4e0b\u5217\u4efb\u4f55\u4e8b\u4ef6\u7c7b\u578b\uff1aopenEvent\u3001fetchEvent \u548c closeEvent\u3002" },
		{ Message.BIRT_DATA_SOURCE_NOT_FOUND_ERROR, "\u62a5\u544a\u8bbe\u8ba1\u4e2d\u4e0d\u5b58\u5728\u6570\u636e\u6e90 {0}\u3002" },
		{ Message.BIRT_SCRIPTED_DATA_SOURCE_ERROR, "\u6570\u636e\u6e90 {0} \u662f\u4e00\u4e2a\u5e26\u6709\u811a\u672c\u7684\u6570\u636e\u6e90\uff0c\u4f46\u662f\u672a\u5904\u7406\u4e0b\u5217\u4efb\u4f55\u4e8b\u4ef6\u7c7b\u578b\uff1aopenEvent \u548c closeEvent\u3002" },
		{ Message.BIRT_DATA_SET_COLUMN_NUMBER_ERROR, "\u6570\u636e\u96c6 {1} \u4e2d\u4e0d\u5b58\u5728\u5217\u53f7 {0}\u3002" },
		{ Message.BIRT_DATA_SET_ROW_GET_COLUMN_ERROR, "\u4ece\u6570\u636e\u96c6 {1} \u4e2d\u83b7\u53d6\u5217 {0} \u65f6\u53d1\u751f\u4e86\u5f02\u5e38\u3002{2}" },
		{ Message.BIRT_UPDATABLE_DATA_SET_ROW_SET_COLUMN_ERROR, "\u8bbe\u7f6e\u5e26\u6709\u811a\u672c\u7684\u6570\u636e\u96c6 {1} \u7684\u5217 {0} \u65f6\u53d1\u751f\u4e86\u5f02\u5e38\u3002{2}" },
		{ Message.BIRT_GET_BINDING_ERROR, "\u83b7\u53d6\u5217\u7ed1\u5b9a {0} \u65f6\u53d1\u751f\u4e86\u5f02\u5e38\u3002{1}" },
		
		//CInterface errors.
		{ Message.CINTERFACE_E_NATIVELIB_ERROR, "\u672a\u6307\u5b9a\u5c5e\u6027 vgj.defaultI4GLNativeLibrary" },
		{ Message.CINTERFACE_E_NATIVELIBLOAD_ERROR, "\u5e93 {0} \u88c5\u5165\u5931\u8d25 {1}" },
		{ Message.CINTERFACE_E_PARAMCOUNT_ERROR, "\u8fd4\u56de\u7684\u53c2\u6570\u4e0e\u51fd\u6570\u4e0d\u5339\u914d" },
		{ Message.CINTERFACE_E_MEMORY_ALLOCATION_ERROR, "\u672a\u80fd\u5206\u914d\u5185\u5b58"},
		{ Message.CINTERFACE_E_CONVERSION_ERROR, "\u672a\u80fd\u5728\u7c7b\u578b\u4e4b\u95f4\u8f6c\u6362"},
		{ Message.CINTERFACE_E_INVALID_PRECISION_ERROR, "\u65e5\u671f\u65f6\u95f4\u6216\u65f6\u95f4\u95f4\u9694\u7cbe\u5ea6\u65e0\u6548"},
		{ Message.CINTERFACE_E_CHAR_TOO_SHORT, "\u5b57\u7b26\u4e3b\u53d8\u91cf\u5bf9\u4e8e\u6570\u636e\u6765\u8bf4\u592a\u77ed"},
		{ Message.CINTERFACE_E_FUNCTION_NOT_FOUND, "\u5728\u7b26\u53f7\u8868\u4e2d\u65e0\u6cd5\u627e\u5230\u51fd\u6570"},
		{ Message.CINTERFACE_E_IMPROPER_LOC, "\u5fc5\u987b\u5728\u6b64\u4e0a\u4e0b\u6587\u4e2d\u63d0\u4f9b TEXT \u6216 BYTE \u6570\u636e\u7c7b\u578b\u3002"},
		{ Message.CINTERFACE_E_CONVERSION_TO_VALUE, "\u672a\u80fd\u5c06\u5806\u6808\u4e0a\u7684\u503c\u8f6c\u6362\u4e3a\u503c\u7c7b\u578b"},
		{ Message.CINTERFACE_E_CONVERSION_TO_ANY, "\u672a\u80fd\u5c06\u5806\u6808\u4e0a\u7684\u503c\u8f6c\u6362\u4e3a ANY"},
		{ Message.CINTERFACE_E_POP_ERROR, "\u672a\u80fd\u5c06\u7c7b\u578b\u4e3a {0} \u7684\u503c\u5f39\u51fa\u5806\u6808"},
		{ Message.CINTERFACE_E_PUSH_ERROR, "\u672a\u80fd\u5c06\u7c7b\u578b\u4e3a {1} \u7684\u503c\u63a8\u5165\u5806\u6808"},
		{ Message.CINTERFACE_E_PUSH_POP_ERROR, "\u6ca1\u6709\u9700\u8981\u63a8\u5165/\u5f39\u51fa\u7684\u5185\u5bb9"},
		{ Message.CINTERFACE_E_POP_LOCATOR_ERROR, "\u672a\u80fd\u5c06 Locator \u5f39\u51fa\u5806\u6808"},
		{ Message.CINTERFACE_E_STACK_EMPTY_ERROR, "\u5806\u6808\u4e3a\u7a7a"},
		{ Message.CINTERFACE_E_LOC_COPY_ERROR, "\u672a\u80fd\u590d\u5236\u5b9a\u4f4d\u5668"},
		{ Message.CINTERFACE_E_NULL_REF_ERROR, "\u5c06\u7a7a\u5f15\u7528\u63a8\u5165\u4e86\u5806\u6808\u3002"},
		{ Message.CINTERFACE_E_PUSH_ANY_ERROR, "\u672a\u80fd\u5c06 Any \u63a8\u5165\u5806\u6808"},
		{ Message.CINTERFACE_E_ASSIGN_ANY_ERROR, "\u672a\u80fd\u5c06\u5806\u6808\u5143\u7d20\u6307\u5b9a\u7ed9 Any \u7c7b\u578b"},
		{ Message.DELEGATE_E_RETURN_TYPE_MISMATCH, "\u8fd4\u56de\u7c7b\u578b\u4e0d\u5339\u914d"},
		{ Message.DELEGATE_E_PARAM_TYPE_MISMATCH, "\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d"},
		
		{ Message.DEBUG_SOURCE_NOT_FOUND, "\u627e\u4e0d\u5230 EGL \u6e90\u6587\u4ef6 {0}\u3002\u5c06\u6539\u4e3a\u8fd0\u884c\u751f\u6210\u7684\u4ee3\u7801\u3002" },
		{ Message.DEBUG_WEBTRANS_SOURCE_NOT_FOUND, "\u627e\u4e0d\u5230\u540d\u4e3a {0} \u7684 Web \u4e8b\u52a1\u7684 EGL \u6e90\u6587\u4ef6\u3002" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_TITLE, "\u5f53\u663e\u793a\u8868\u5355\u201c{1}\u201d\u65f6\uff0c\u5b57\u6bb5\u201c{0}\u201d\u4e0a\u53d1\u751f\u4ee5\u4e0b\u683c\u5f0f\u5316\u95ee\u9898\uff1a" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_INTERNAL_MESSAGE, "{0}\n\n\u8be5\u5b57\u6bb5\u7684\u6240\u9700\u5185\u90e8\u683c\u5f0f\u4e3a\u201c{1}\u201d\u3002\u8bf7\u68c0\u67e5\u8c03\u8bd5\u6784\u5efa\u63cf\u8ff0\u7b26\u5185\u201cEGL Java \u8fd0\u884c\u65f6\u201d\u5c5e\u6027\u4e2d\u7684\u65e5\u671f\u683c\u5f0f\u5c5e\u6027\u6216\u5f71\u54cd\u6570\u636e\u683c\u5f0f\u7684 JDBC \u5c5e\u6027\u3002" },
		{ Message.DEBUG_FORMFIELD_FORMATTING_ERROR_EXTERNAL_MESSAGE, "{0}\n\n\u8be5\u5b57\u6bb5\u7684\u663e\u793a\u683c\u5f0f\u4e3a\u201c{1}\u201d\u3002\u8bf7\u68c0\u67e5\u8868\u5355\u5b57\u6bb5\u7684\u201c{2}\u201d\u5c5e\u6027\u3002" },
		
		{ Message.WEBTRANS_E_PROGRAM_NOT_WEBTRANS, "\u65e0\u6cd5\u5c06\u7a0b\u5e8f {0} \u4f5c\u4e3a Web \u4e8b\u52a1\u8fd0\u884c\u3002" },
		{ Message.WEBTRANS_E_WRONG_FIRST_UI, "Web \u4e8b\u52a1\u662f\u7ed9\u5b9a\u7684\u8f93\u5165\u7528\u6237\u754c\u9762\u8bb0\u5f55 {0}\uff0c\u4f46\u662f\uff0c\u5b83\u662f\u901a\u8fc7\u8f93\u5165\u7528\u6237\u754c\u9762\u8bb0\u5f55 {1} \u6765\u5b9a\u4e49\u7684\u3002" },
		{ Message.WEBTRANS_E_INVALID_BOOLEAN_INPUT, "\u5bf9\u4e8e\u5e03\u5c14\u503c\u5b57\u6bb5\uff0c\u8f93\u5165\u65e0\u6548\u3002" },
		{ Message.WEBTRANS_E_INACTIVITY_TIMEOUT, "\u56e0\u4e3a\u4e0d\u6d3b\u52a8\uff0c\u7a0b\u5e8f {0} \u4e2d\u53d1\u751f\u8d85\u65f6\u3002" },
		{ Message.WEBTRANS_E_UI_TOO_LARGE, "\u7528\u6237\u754c\u9762\u8bb0\u5f55 {0} \u5305\u542b\u592a\u591a\u8981\u53d1\u9001\u81f3\u7f51\u5173 servlet \u7684\u6570\u636e\u3002" },
		{ Message.WEBTRANS_E_UI_VERIFY_FAILED, "\u8be5\u7a0b\u5e8f\u65e0\u6cd5\u9a8c\u8bc1\u6765\u81ea\u7f51\u5173 servlet \u7684\u6570\u636e\u3002\u6570\u636e\u6807\u8bc6\u4e3a {0}\u3002" },
		
		{ Message.WRAPPER_ARRAY_EXPAND_BEYOND_MAX, "\u6269\u5c55\u6570\u7ec4\u5305\u88c5\u5668 {0} \u65f6\u4e0d\u80fd\u8d85\u51fa\u5176\u6700\u5927\u5927\u5c0f\u3002\u65b9\u6cd5 {1} \u4e2d\u53d1\u751f\u9519\u8bef\u3002" },
		{ Message.WRAPPER_ARRAY_INVALID_INDEX, "{0} \u5bf9\u4e8e\u6570\u7ec4\u5305\u88c5\u5668 {1} \u662f\u65e0\u6548\u4e0b\u6807\u3002\u6700\u5927\u5927\u5c0f\uff1a{2}\u3002\u5f53\u524d\u5927\u5c0f\uff1a{3}" },
		{ Message.WRAPPER_ARRAY_INVALID_MAX_SIZE, "{0} \u5bf9\u4e8e\u6570\u7ec4\u5305\u88c5\u5668 {1} \u4e0d\u662f\u6709\u6548\u6700\u5927\u5927\u5c0f\u3002" },
		{ Message.WRAPPER_ARRAY_INVALID_OBJECT_TYPE, "{0} \u662f\u65e0\u6548\u5bf9\u8c61\u7c7b\u578b\uff0c\u4e0d\u80fd\u6dfb\u52a0\u81f3\u7c7b\u578b\u4e3a {1} \u7684\u6570\u7ec4\u5305\u88c5\u5668\u3002" },
		
		{ Message.IMS_HOST_ABORT, "\u4ece\u8fdc\u7a0b\u4e3b\u673a\u63a5\u6536\u5230\u5e9f\u5f03\u5305\u3002"},
		{ Message.IMS_HOST_TCPIP_ERROR, "\u8fdc\u7a0b\u4e3b\u673a\u4e0a\u53d1\u751f TCPIP \u9519\u8bef\u3002\u90e8\u5206\uff1a{0} TCPIP \u64cd\u4f5c\uff1a{1} TCPIP \u8fd4\u56de\u7801\uff1a{2} TCPIP \u9519\u8bef\u53f7\uff1a{3}"},  
		{ Message.IMS_HOST_REMOTE_INITIALIZATION_ERROR, "\u8c03\u7528 {0} \u65f6\u4e3b\u673a\u4e0a\u53d1\u751f\u9519\u8bef"},
		{ Message.IMS_HOST_PACKET_ERROR, "\u4ece\u4e3b\u673a\u63a5\u6536\u5230\u9519\u8bef\u54cd\u5e94\u5305\u3002\u9700\u8981\uff1a{0} \u63a5\u6536\u5230\uff1a{1}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_IOEXCEPTION, "\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u65f6\u53d1\u751f IO \u9519\u8bef\u3002{0}"},
		{ Message.IMS_HOST_STORED_PROCEDURE_SQLEXCEPTION, "\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u65f6\u53d1\u751f SQL \u9519\u8bef\u3002{0}"},
		{ Message.IMS_HOST_FINALIZE_ERROR, "\u6267\u884c {0} \u65f6\u8fdc\u7a0b\u4e3b\u673a\u4e0a\u53d1\u751f\u9519\u8bef\uff0c\u8fd4\u56de\u7801\uff1a{1}\u201cDLI \u4ee3\u7406\u201d\u4f5c\u4e1a\u6807\u8bc6\uff1a{2}"},
		{ Message.IMS_HOST_DLI_ERROR, "\u8fdc\u7a0b\u4e3b\u673a\u4e0a\u53d1\u751f DLI \u9519\u8bef\u3002DLI \u51fd\u6570\uff1a{0} AIB \u8fd4\u56de\u7801\uff1a0x{1} AIB \u539f\u56e0\u7801\uff1a0x{2} \u72b6\u6001\u7801\uff1a{3}\u201cDLI \u4ee3\u7406\u201d\u4f5c\u4e1a\u6807\u8bc6\uff1a{4}"},
		{ Message.IMS_HOST_DLI_ERROR_EXTD, "\u8fdc\u7a0b\u4e3b\u673a\u4e0a\u53d1\u751f DLI \u9519\u8bef\u3002DLI \u51fd\u6570\uff1a{0} AIB \u8fd4\u56de\u7801\uff1a0x{1} AIB \u539f\u56e0\u7801\uff1a0x{2} DLIVar. \u72b6\u6001\u7801\uff1a{3} DLIVar. \u6570\u636e\u5e93\u540d\u79f0\uff1a{4} DLIVar. \u7247\u6bb5\u540d\u79f0\uff1a{5} DLIVar. \u7247\u6bb5\u7ea7\u522b\uff1a{6}\u201cDLI \u4ee3\u7406\u201d\u4f5c\u4e1a\u6807\u8bc6\uff1a{7}"},
		{ Message.IMS_HOST_DLI_PCB_ERROR, "AIB \u8fd4\u56de\u7801\u6307\u793a PCB \u72b6\u6001\u7801\uff0c\u4f46\u672a\u8fd4\u56de PCB\u3002AIB \u51fd\u6570\uff1a{0}"},
		{ Message.IMS_HOST_TCPIP_EXCEPTION, "\u8fdc\u7a0b\u4e3b\u673a\u4e0a\uff0c\u5728 CALL EZEDBTCP \u4e2d\u53d1\u751f\u5f02\u5e38\u3002\u90e8\u5206\uff1a{0} TCPIP \u64cd\u4f5c\uff1a{1} TCPIP \u8fd4\u56de\u7801\uff1a{2} TCPIP \u9519\u8bef\u53f7\uff1a{3}"},
		{ Message.IMS_HOST_ABEND_EXCEPTION, "\u8fdc\u7a0b\u4e3b\u673a\u4e0a\u53d1\u751f ABEND\u3002\u4f8b\u7a0b\uff1a{0} \u6d88\u606f\uff1a{1}"},
		{ Message.IMS_HOST_OTHER_EXCEPTION, "\u8fdc\u7a0b\u4e3b\u673a\u4e2d\u53d1\u751f\u5f02\u5e38\u3002\u8c03\u7528\uff1a{0}"},
		{ Message.IMS_HOST_UNSUPPORTED_OPERATION, "\u8c03\u8bd5\u5668\u4e0d\u652f\u6301 DLI \u51fd\u6570\u3002\u51fd\u6570\uff1a{0}"},
		{ Message.IMS_HOST_DLI_NO_IMSID_EXCEPTION, "\u6b63\u53d1\u51fa DL/I \u8c03\u7528\uff0c\u4f46\u672a\u5bf9 DL/I \u8bbf\u95ee\u914d\u7f6e\u6784\u5efa\u63cf\u8ff0\u7b26\u3002"},
		{ Message.IMS_HOST_CATCHER_EXCEPTION, "\u8fdc\u7a0b\u5f02\u5e38\uff1a{0}"},
		{ Message.IMS_EMPTY_PSBNAME_EXCEPTION, "\u5c1d\u8bd5\u5206\u914d PSB \u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002\u5df2\u8bbe\u7f6e IMSID \u4ee5\u6307\u793a\u5b58\u5728 DL/I \u8bbf\u95ee\uff0c\u4f46\u672a\u6307\u5b9a PSB"},
		{ Message.IMS_HOST_VERSION_EXCEPTION, "RBD \u5ba2\u6237\u673a\u4e0e\u4e3b\u673a\u7248\u672c\u4e0d\u517c\u5bb9\u3002RBD \u5ba2\u6237\u673a\u7248\u672c\uff1a{0} \u4e3b\u673a\u7248\u672c\uff1a{1}"},
		{ Message.IMS_CATCHER_CONVERSION_EXCEPTION, "\u68c0\u7d22\u4e3b\u673a\u7a0b\u5e8f\u8c03\u7528\u8fd4\u56de\u7684\u6570\u636e\u65f6\u53d1\u751f\u4e86\u9519\u8bef\u3002{0}"},
		{ Message.IMS_HOST_BAD_PCB_EXCEPTION, "\u68c0\u7d22 PCB \u540d\u79f0\u65f6\u53d1\u751f\u9519\u8bef\u3002PCB \u4e0b\u6807\uff1a{0}\uff0cPCB \u6570\u76ee\uff1a{1}"},
	};
	
	/**
	 * Returns the contents of this message bundle.
	 *
	 * @return the contents of this message bundle.
	 * @see #contents
	 * @see java.util.ListResourceBundle#getContents()
	 */
	protected Object[][] getContents()
	{
		return contents;
	}
}
